
#ifndef INC_CM_THREAD_H_
#define INC_CM_THREAD_H_

#include <pthread.h>
#include <cassert>
#include <string>

#include "mt_typelist.h"
#include "cm_thread_name_macro.h"

namespace cm {

template <typename Arg>
struct ThreadArg
{
    ThreadArg(const char* thread_name, Arg* argument)
        : name(thread_name), arg(argument), tid(0)
    {}

    std::string name;
    Arg* arg;
    pthread_t tid;
};

template <typename T, typename Arg = void>
class Thread
{
public:
    Thread(const char* name)
        : argument_(name, 0), attribute_()
    {
        pthread_attr_init(&attribute_);
    }

    void create(Arg* arg)
    {
        argument_.arg = arg;
        if (pthread_create(&argument_.tid, &attribute_,
                           &Thread::threadFunction, &argument_)) {
            assert(false);
        }
    }

    void create()
    {
        if (pthread_create(&argument_.tid, &attribute_,
                            &Thread::threadFunctionNoArg, &argument_)) {
            assert(false);
        }
    }

    void join()
    {
        pthread_join(argument_.tid, 0);
    }

private:
    static void* threadFunction(void * arg)
    {
        ThreadArg<Arg>* thread_arg = static_cast<ThreadArg<Arg>*>(arg);
        
        if (SETNAME(thread_arg->tid, thread_arg->name.c_str())) {
            assert(false);
        }
        T obj(thread_arg->arg);
        obj.run();
        pthread_exit(0);
    }

    static void* threadFunctionNoArg(void * arg)
    {
        ThreadArg<Arg>* thread_arg = static_cast<ThreadArg<Arg>*>(arg);
        if (SETNAME(thread_arg->tid, thread_arg->name.c_str())) {
            assert(false);
        }
        T obj;
        obj.run();
        pthread_exit(0);
    }

    // Non-copyable
    Thread(const Thread& rhs);
    Thread& operator=(const Thread& rhs);

    ThreadArg<Arg> argument_;
    pthread_t thread_id_;
    pthread_attr_t attribute_;
};

} // namespace cm

#endif // INC_CM_THREAD_H_

