
#ifndef INC_CM_MUTEX_H_
#define INC_CM_MUTEX_H_

#include <pthread.h>

namespace cm {

class Mutex
{
public:
	Mutex(bool is_shared_among_processes = false);

	class Lock
	{
	public:
		Lock(Mutex& mutex);
		~Lock();
	private:
		// Non-copyable
		Lock(const Lock& rhs);
		Lock& operator=(const Lock& rhs);
		static void* operator new(size_t);
		static void operator delete(void*);
		static void* operator new[] (size_t);
		static void operator delete[](void*);

		Mutex& mutex_;
	};

	friend class Lock;

private:
	// Non-copyable
	Mutex(const Mutex& rhs);
	Mutex& operator=(const Mutex& rhs);

	void lock() const;
	void unlock() const;

	mutable pthread_mutex_t mutex_;
};

} // namespace cm

#endif // INC_CM_MUTEX_H_

