
#include <iostream>
#include <string>

#include "gtest/gtest.h"
#include "cm_thread.h"

namespace cm {
namespace {

struct TestThreadArg
{
    unsigned long offset;
};

class TestThread
{
public:
    TestThread()
        : offset_()
    {}

    TestThread(TestThreadArg* arg)
        : offset_(arg->offset)
    {}

    void run()
    {
        for (unsigned int count = 0; count != 5; ++count) {
            std::cout << "Count " << (count + offset_) << std::endl;
            sleep(1);
        }
        
    }

private:
    unsigned int offset_;
};

class ThreadTest : public ::testing::Test
{
public:
    virtual void SetUp()
    {}

    virtual void TearDown()
    {}

private:
};

TEST_F(ThreadTest, test)
{
    Thread<TestThread> thread("thread_name_1");

    thread.create();

    thread.join();

}

TEST_F(ThreadTest, testWithArg)
{
    TestThreadArg arg;
    arg.offset = 5u;

    Thread<TestThread, TestThreadArg> thread("thread_name_2");
    thread.create(&arg);

    thread.join();
}

} // namespace
} // namespace cm

