
#include <pthread.h>

#include "cm_mutex.h"

namespace cm {

Mutex::Mutex(bool is_shared_among_processes)
    : mutex_()
{
    pthread_mutex_init(&mutex_, NULL);
    // TODO: Consider to support the case that the Mutex is used among
    // different processes
    (void) is_shared_among_processes;
}

void Mutex::lock() const
{
    pthread_mutex_lock(&mutex_);
}

void Mutex::unlock() const
{
    pthread_mutex_unlock(&mutex_);
}

Mutex::Lock::Lock(Mutex& mutex)
    : mutex_(mutex)
{
    mutex_.lock();
}

Mutex::Lock::~Lock()
{
    mutex_.unlock();
}

} // namespace cm
