
#include <unistd.h>
#include <errno.h>
#include <iostream>
#include "cm_thread_specific_data.h"
#include "cm_event_kqueue.h"

namespace cm {

Event& Event::tsdInstance()
{
    Event* event = new Event;
    ThreadSpecificData<Event>::set(event);
    return ThreadSpecificData<Event>::get();
}

Event::Event()
    : kqueue_(kqueue()), read_map_()
{
    if (kqueue_ < 0) {
        assert(false);
    }
}

Event::~Event()
{
    close(kqueue_);
}

void Event::pend()
{
    size_t number = read_map_.size();

    struct kevent kevs[MAX_NUMBER_OF_HANDLERS];

    int nevents = kevent(kqueue_, NULL, 0, kevs, number, NULL);

    if (nevents < 0) {
        std::cout << "kevent wait error " << strerror(errno) << std::endl;
        assert(false);
    }
    for (unsigned int i = 0; i != static_cast<unsigned int>(nevents); ++i) {
        int fd = kevs[i].ident;
        if (!read_map_[fd]->handleIt()) {
            break;
        }
    }
}

} // namespace cm
