/*
 * CAN/LIN/UART/PORT Checker for RL78/F14
 *
 * Target: QB-R5F10PPJ-TB (RL78/F14, 100pin, 256KB ROM, 20KB RAM)
 * Author: Yasushi Tanaka
 *
 * [ UARThCo ]
 */

#ifndef UART_H
#define UART_H

/*
 * UART
 * vf[^\
 */
typedef struct _uart_stat
{
	u2 tx_cnt[2];
									/* MoCg */
	u2 rx_cnt[2];
									/* MoCg */
	u2 ov_err;
									/* I[o[EG[o */
	u2 pe_err;
									/* peBEG[o */
	u2 fe_err;
									/* t[~OEG[o */
	u2 tx_isr;
									/* M荞݉ */
	u2 rx_isr;
									/* M荞݉ */
} uart_stat;

/*
 * UART
 * 
 */
void uart_init(u1 ch, u2 baudrate);

/*
 * UART
 * MJn
 *
 * Mobt@RAM̈܂ROM~[̈ɔzu邱
 */
u1 uart_tx_start(u1 ch, u1* buf, u1 len);

/*
 * UART
 * MJn
 *
 * 荞݋֎~ԂŌĂ΂
 */
void uart_rx_start(u1 ch);

/*
 * UART
 * MOobt@擾
 */
u1 uart_ring_get(u1 ch);

/*
 * UART
 * MOobt@擾
 */
u1 uart_ring_deque(u1 ch, u1* dst, u1 len1);

/*
 * UART
 * ACh
 */
void uart_idle(u1 ch);

/*
 * UART
 * vf[^擾
 */
void uart_get_stat(u1 ch, uart_stat* buf);

/*
 * UART
 * M荞
 *
 * DTC]ƁA̍ۂɐݒ肵ŏIf[^VtgWX^Ɉړۂ2񔭐
 */
void uart_tx_isr(u1 ch);

/*
 * UART
 * M荞
 */
void uart_rx_isr(u1 ch);

#endif /* UART_H */
