/*
 * CAN/LIN Checker for RL78/F13,F14
 *
 * Target: QB-R5F10PPJ-TB (RL78/F14, 100pin, 256KB ROM, 20KB RAM)
 * Author: Yasushi Tanaka
 *
 * [ CPU ]
 */

#ifdef __CA78K0R__
#pragma DI
#pragma EI
#pragma NOP
#endif /* __CA78K0R__ */

#include "common.h"
#include "cpu.h"

/*
 * PSW`
 */
#define PSW_IE					(0x80)
									/* 荞݋tO */

/*
 * CPU
 * 荞݋֎~(PSWԂ)
 */
u1 cpu_di(void)
{
#ifdef __CCRL__
	u1 psw;

	 /* 荞݋֎~OPSW擾 */
	psw = __get_psw();

	/* 荞݋֎~ */
	__DI();

	/* PSWԂ */
	return psw;
#endif /* __CCRL__ */
#ifdef __CA78K0R__
	u1 psw;

	/* AZuo̓t@CQƂƁAreturn pswLWX^ԂĂ */
	__asm(" mov a,psw");
	__asm(" mov l,a");

	return psw;
#endif /* __CA78K0R__ */
}

/*
 * CPU
 * 荞݋(PSW󂯎)
 */
void cpu_ei(u1 psw)
{
	/* 荞݋֎~OIEtO */
	if (0 != (psw & PSW_IE))
	{
		/* IE=1, Ȃ킿荞݋ł̂ŁA荞݋ɖ߂ */
#ifdef __CCRL__
		__EI();
#endif /* __CCRL__ */
#ifdef __CA78K0R__
		EI();
#endif /* __CA78K0R__ */
	}
}

/*
 * CPU
 * NOP߂s
 */
void cpu_nop(void)
{
#ifdef __CCRL__
	__nop();
#endif /* __CCRL__ */
#ifdef __CA78K0R__
	NOP();
#endif /* __CA78K0R__ */
}
