/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package textkeymatcher.ui.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import org.jdesktop.application.AbstractBean;
import textkeymatcher.entity.DisplayMode;

/**
 * メニューのチェックボックス付きメニューアイテムでディスプレイモード(RowFilter)を切り替えるのに便利なように
 * バインドをサポートします.<br>
 * setFoo(boolean)では、引数enableがtrueである場合のみ設定されます.<br>
 * 引数がfalseの場合は単に無視して解除しません.別のタイプがsetでenableされたときに変更されます.<br>
 * 
 * @author osabe_masashi
 */
public class DisplayModeBinder extends AbstractBean {
    
    /**
     * ロガー
     */
    private static final Logger logger = Logger.getLogger(DisplayModeBinder.class.getName());

    /**
     * キーマッチャをもつ実体オブジェクト
     */
    private DataViewTableModel tableModel;
    
    
    /**
     * 実体オブジェクトを設定します.<br>
     * プロパティ変更リスナーがセットアップされます.<br>
     * @param tableModel 
     */
    public void bindDataViewTableModel(DataViewTableModel tableModel) {
        if (tableModel == null) {
            throw new IllegalArgumentException();
        }
        this.tableModel = tableModel;
        this.tableModel.addPropertyChangeListener(new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent pce) {
                tableModelPropertyChanged(pce);
            }
        });
    }

    /**
     * キーマッチャが変更されたことを通知される.<br>
     * @param pce プロパティ変更イベント
     */
    protected void tableModelPropertyChanged(PropertyChangeEvent pce) {
        String propertyName = pce.getPropertyName();
        if (DataViewTableModel.PROPERTY_DISPLAY_MODE.equals(propertyName)) {
            changeDisplayMode(
                    (DisplayMode) pce.getOldValue(),
                    (DisplayMode) pce.getNewValue()
                    );
        }
    }
    
    protected DisplayMode getDisplayMode() {
        if (tableModel == null) {
            throw new IllegalStateException("先にsetDataViewTableModelで設定しておく必要があります.");
        }
        return tableModel.getDisplayMode();
    }
    
    protected void setDisplayMode(DisplayMode displayMode) {
        if (tableModel == null) {
            throw new IllegalStateException("先にsetDataViewTableModelで設定しておく必要があります.");
        }
        tableModel.setDisplayMode(displayMode); // thisにも変更通知がくることを想定
    }

    private void changeDisplayMode(DisplayMode oldValue, DisplayMode newValue) {
        boolean oldAll = oldValue == DisplayMode.ALL;
        boolean oldMatched = oldValue == DisplayMode.MATCHED;
        boolean oldUnmatched = oldValue == DisplayMode.UNMATCHED;
        boolean oldExistsFirst = oldValue == DisplayMode.EXISTS_FIRST_COLUMN;
        boolean oldMissingFirst = oldValue == DisplayMode.MISSING_FIRST_COLUMN;
        boolean oldUnique = oldValue == DisplayMode.UNIQUE;
        boolean oldUnunique = oldValue == DisplayMode.UNUNIQUE;
        boolean oldUniqueAll = oldValue == DisplayMode.UNIQUE_ALL;
        boolean oldUnuniqueAll = oldValue == DisplayMode.UNUNIQUE_ALL;

        boolean newAll = newValue == DisplayMode.ALL;
        boolean newMatched = newValue == DisplayMode.MATCHED;
        boolean newUnmatched = newValue == DisplayMode.UNMATCHED;
        boolean newExistsFirst = newValue == DisplayMode.EXISTS_FIRST_COLUMN;
        boolean newMissingFirst = newValue == DisplayMode.MISSING_FIRST_COLUMN;
        boolean newUnique = newValue == DisplayMode.UNIQUE;
        boolean newUnunique = newValue == DisplayMode.UNUNIQUE;
        boolean newUniqueAll = newValue == DisplayMode.UNIQUE_ALL;
        boolean newUnuniqueAll = newValue == DisplayMode.UNUNIQUE_ALL;

        firePropertyChange("all", oldAll, newAll);
        firePropertyChange("matched", oldMatched, newMatched);
        firePropertyChange("unmatched", oldUnmatched, newUnmatched);
        firePropertyChange("existsFirstColumn", oldExistsFirst, newExistsFirst);
        firePropertyChange("missingFirstColumn", oldMissingFirst, newMissingFirst);
        firePropertyChange("unique", oldUnique, newUnique);
        firePropertyChange("ununique", oldUnunique, newUnunique);
        firePropertyChange("uniqueAll", oldUniqueAll, newUniqueAll);
        firePropertyChange("ununiqueAll", oldUnuniqueAll, newUnuniqueAll);
    }
    
    public void setAll(boolean enable) {
        if (enable) {
            setDisplayMode(DisplayMode.ALL);
        }
    }
    
    public boolean isAll() {
        return getDisplayMode() == DisplayMode.ALL;
    }
    
    public void setMatched(boolean enable) {
        if (enable) {
            setDisplayMode(DisplayMode.MATCHED);
        }
    }

    public boolean isMatched() {
        return getDisplayMode() == DisplayMode.MATCHED;
    }

    public void setUnmatched(boolean enable) {
        if (enable) {
            setDisplayMode(DisplayMode.UNMATCHED);
        }
    }

    public boolean isUnmatched() {
        return getDisplayMode() == DisplayMode.UNMATCHED;
    }

    public void setExistsFirstColumn(boolean enable) {
        if (enable) {
            setDisplayMode(DisplayMode.EXISTS_FIRST_COLUMN);
        }
    }

    public boolean isExistsFirstColumn() {
        return getDisplayMode() == DisplayMode.EXISTS_FIRST_COLUMN;
    }

    public void setMissingFirstColumn(boolean enable) {
        if (enable) {
            setDisplayMode(DisplayMode.MISSING_FIRST_COLUMN);
        }
    }

    public boolean isMissingFirstColumn() {
        return getDisplayMode() == DisplayMode.MISSING_FIRST_COLUMN;
    }
    
    public void setUnique(boolean enable) {
        if (enable) {
            setDisplayMode(DisplayMode.UNIQUE);
        }
    }
    
    public boolean isUnique() {
        return getDisplayMode() == DisplayMode.UNIQUE;
    }
    
    public void setUnunique(boolean enable) {
        if (enable) {
            setDisplayMode(DisplayMode.UNUNIQUE);
        }
    }
    
    public boolean isUnunique() {
        return getDisplayMode() == DisplayMode.UNUNIQUE;
    }

    public void setUniqueAll(boolean enable) {
        if (enable) {
            setDisplayMode(DisplayMode.UNIQUE_ALL);
        }
    }
    
    public boolean isUniqueAll() {
        return getDisplayMode() == DisplayMode.UNIQUE_ALL;
    }
    
    public void setUnuniqueAll(boolean enable) {
        if (enable) {
            setDisplayMode(DisplayMode.UNUNIQUE_ALL);
        }
    }
    
    public boolean isUnuniqueAll() {
        return getDisplayMode() == DisplayMode.UNUNIQUE_ALL;
    }
}
