/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package textkeymatcher.io;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.Timestamp;
import textkeymatcher.entity.KeyMatchedRowMap;
import textkeymatcher.entity.KeyMatchedRowView;
import textkeymatcher.entity.LineData;
import textkeymatcher.entity.LineDataList;

/**
 * プロトコルバッファを用いてドキュメントを保存する.
 * @author seraphy
 */
public class ProtocolBuffersWriter implements TextKeyMatcherDoc {
    
    private TextKeyMatcherDoc source;
    
    public void setTextKetMatcherDoc(TextKeyMatcherDoc source) {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        this.source = source;
    }
    
    public TextKeyMatcherDoc getTextKeyMatcherDoc() {
        return source;
    }

    @Override
    public KeyMatchedRowMap getRowMap() {
        if (source == null) {
            throw new IllegalStateException("TextKeyMatcherDocを先に設定してください");
        }
        return source.getRowMap();
    }

    @Override
    public KeyMatchedRowView getRowView() {
        if (source == null) {
            throw new IllegalStateException("TextKeyMatcherDocを先に設定してください");
        }
        return source.getRowView();
    }
    
    
    /**
     * プロトコルバッファの形式にドキュメントを変換して返す
     * @return 変換されたドキュメント
     */
    public Persistent.TextKeyMatcherDoc createDoc() {
        KeyMatchedRowMap rowMap = getRowMap();
        KeyMatchedRowView rowView = getRowView();
        if (rowMap == null || rowView == null) {
            throw new IllegalStateException("rowMap, rowViewを先にセットしてください");
        }
        
        // ドキュメントオブジェクトの構築
        String creationDate = new Timestamp(System.currentTimeMillis()).toString();
        
        Persistent.TextKeyMatcherDoc.Builder docBuilder = Persistent.TextKeyMatcherDoc.newBuilder();
        docBuilder.setCreationDate(creationDate);
        
        // RowMapオブジェクトの構築
        
        Persistent.RowMap.Builder rowMapBuilder = Persistent.RowMap.newBuilder();
        
        Persistent.RowMap.KeyMatcherType keyMatchType = Persistent.RowMap.KeyMatcherType.TEXT;
        switch (rowMap.getKeyMatcher()) {
            case TEXT:
                keyMatchType = Persistent.RowMap.KeyMatcherType.TEXT;
                break;
            
            case TEXT_IGNORECASE:
                keyMatchType = Persistent.RowMap.KeyMatcherType.TEXT_IGNORE_CASE;
                break;
                
            case NUMERIC:
                keyMatchType = Persistent.RowMap.KeyMatcherType.NUMERIC;
                break;
        }
        rowMapBuilder.setKeyMatcherType(keyMatchType);
        
        int mx = rowMap.getNumOfLineDataLists();
        for (int idx = 0; idx < mx; idx++) {
            LineDataList lineDatas = rowMap.getLineDataList(idx);
            
            Persistent.LineDataList.Builder lstBuilder = Persistent.LineDataList.newBuilder();
            lstBuilder.setTitle(lineDatas.getTitle());
            
            for (LineData lineData : lineDatas) {
                Persistent.LineData.Builder lineBuilder = Persistent.LineData.newBuilder();
                lineBuilder.setKey(lineData.getKey());
                lineBuilder.setValue(lineData.getValue());
                lstBuilder.addLineDatas(lineBuilder);
            }
            
            rowMapBuilder.addDatas(lstBuilder);
        }
        
        docBuilder.setRowMap(rowMapBuilder);
        
        // RowViewオブジェクトの構築
        
        Persistent.RowView.Builder viewBuilder = Persistent.RowView.newBuilder();
        viewBuilder.setFilterType(Persistent.RowView.FilterType.ALL); // TODO: ビュータイプ
        
        docBuilder.setRowView(viewBuilder);
        
        // 結果の返却
        return docBuilder.build();
    }
    
    /**
     * プロトコルバッファの形式でストリームに書き込む
     * @param out 出力先
     * @throws IOException 失敗
     */
    public void write(OutputStream out) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException();
        }

        Persistent.TextKeyMatcherDoc doc = createDoc();
        
        doc.writeTo(out);
    }
}
