/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package textkeymatcher.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import textkeymatcher.entity.AbstractLineDataList;
import textkeymatcher.entity.KeyMatchedRowMap;
import textkeymatcher.entity.KeyMatchedRowView;
import textkeymatcher.entity.KeyMatcher;
import textkeymatcher.entity.LineData;

/**
 * プロトコルバッファを用いてドキュメントを復元する.
 * @author seraphy
 */
public class ProtocolBuffersReader implements TextKeyMatcherDoc {
    
    /**
     * ロガー｀
     */
    private static final Logger logger = Logger.getLogger(ProtocolBuffersReader.class.getName());

    /**
     * 復元されたドキュメントの保存日時
     */
    private String creationDate;
    
    /**
     * 復元されたrowMap
     */
    private KeyMatchedRowMap rowMap;
    
    /**
     * 復元されたrowView
     */
    private KeyMatchedRowView rowView;
    
    
    public String getCreationDate() {
        return creationDate;
    }
    
    @Override
    public KeyMatchedRowMap getRowMap() {
        return rowMap;
    }
    
    @Override
    public KeyMatchedRowView getRowView() {
        return rowView;
    }
    
    
    /**
     * 入力ストリームからドキュメントを復元する.
     * @param is
     * @throws IOException 
     */
    public void read(InputStream is) throws IOException {
        if (is == null) {
            throw new IllegalArgumentException();
        }
        
        Persistent.TextKeyMatcherDoc doc = Persistent.TextKeyMatcherDoc.parseFrom(is);
        parseDoc(doc);
    }

    /**
     * プロトコルバッファの形式のオブジェクトを変換し、このインスタンスに結果を格納する.
     * @param doc 変換するオブジェクト
     * @throws IOException 失敗
     */
    public void parseDoc(Persistent.TextKeyMatcherDoc doc) throws IOException {
        if (doc == null) {
            throw new IllegalArgumentException();
        }


        // ドキュメントの作成日時
        this.creationDate = doc.getCreationDate();
        logger.log(Level.INFO, "load doc: creationDate={0}", new Object[] {this.creationDate});
        
        // RowViewの復元
        Persistent.RowView pbRowView = doc.getRowView();
        this.rowView = new KeyMatchedRowView();

        Persistent.RowView.FilterType pbFilterType = pbRowView.getFilterType();
        
        
        // RowMapの復元
        Persistent.RowMap pbRowMap = doc.getRowMap();
        this.rowMap = new KeyMatchedRowMap();
        
        // RowMapのキーマッチタイプの復元
        Persistent.RowMap.KeyMatcherType keyMatchType = pbRowMap.getKeyMatcherType();
        KeyMatcher keyMatcher = KeyMatcher.TEXT;
        switch (keyMatchType) {
            case TEXT:
                keyMatcher = KeyMatcher.TEXT;
                break;
                
            case TEXT_IGNORE_CASE:
                keyMatcher = KeyMatcher.TEXT_IGNORECASE;
                break;
                
            case NUMERIC:
                keyMatcher = KeyMatcher.NUMERIC;
                break;
        }
        
        rowMap.setKeyMatcher(keyMatcher);
        
        // RowMapのデータソースリストの復元
        for (Persistent.LineDataList pbLineDataList : pbRowMap.getDatasList()) {
            final String title = pbLineDataList.getTitle();
            logger.log(Level.INFO, "restore linedatas: title={0}", new Object[] {title});
            
            final List<LineData> lineDatas = new ArrayList<LineData>();

            for (Persistent.LineData pbLineData : pbLineDataList.getLineDatasList()) {
                String key = pbLineData.getKey();
                String value = pbLineData.getValue();
             
                LineData lineData = new LineData(key, value);
                lineDatas.add(lineData);
            }
            
            rowMap.addLineDataList(new AbstractLineDataList() {

                @Override
                public String getTitle() {
                    return title;
                }

                @Override
                public int size() {
                    return lineDatas.size();
                }

                @Override
                public LineData get(int i) {
                    return lineDatas.get(i);
                }
            });
        }
        
        logger.info("restore succeeded.");
    }
    
}
