/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package textkeymatcher.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * ドキュメントをアーカイブするための戦略
 * @author seraphy
 */
public interface DocArchiveStrategy {
    
    /**
     * ドキュメントを具体的な出力ストリームに変換します.
     * @param os 出力先
     * @param rowMap 変換するデータソース
     * @param rowView 変換するデータビュー
     * @throws IOException 出力に失敗
     */
    void write(OutputStream os, TextKeyMatcherDoc doc) throws IOException;
    
    
    /**
     * ドキュメントを入力ストリームから復元します
     * @param is 入力ストリーム
     * @return ドキュメント
     * @throws IOException 入力に失敗
     */
    TextKeyMatcherDoc load(InputStream is) throws IOException;
}
