/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package textkeymatcher.entity;

/**
 * 行のキー表現.<br>
 *
 * @author seraphy
 */
public class RowKey implements Comparable<RowKey> {
    
    /**
     * キー判定方法
     */
    private final KeyMatcher keyMatcher;

    /**
     * キーの生データ
     */
    private final String key;

    public RowKey(KeyMatcher keyMatcher, String key) {
        if (keyMatcher == null) {
            throw new IllegalArgumentException();
        }
        this.keyMatcher = keyMatcher;
        this.key = key;
    }

    public String getKey() {
        return key;
    }

    @Override
    public int compareTo(RowKey t) {
        String okey = t.key;
        return keyMatcher.compare(key, okey);
    }

    @Override
    public int hashCode() {
        return keyMatcher.hashCode(key);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj instanceof RowKey) {
            RowKey rk = (RowKey) obj;
            if (rk.keyMatcher != keyMatcher) {
                return false;
            }
            return keyMatcher.compare(key, rk.key) == 0;
        }
        return false;
    }

    /**
     * キーのマッチング法に従った文字列表現
     * @return 文字列表現
     */
    @Override
    public String toString() {
        return keyMatcher.getNormalize(key);
    }
    
}
