/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package textkeymatcher.service;

import textkeymatcher.ui.model.ImportDataDialogModel;

/**
 *
 * @author seraphy
 */
public class ColumnSplitterFactory {

    public ColumnSplitter createColumnSplitter(ImportDataDialogModel dlgModel) {
        if (dlgModel == null) {
            throw new IllegalArgumentException();
        }
        if (dlgModel.isRegExp()) {
            String strPat = dlgModel.getRegExpText();
            return new RegularExpColumnSplitter(strPat);
        }
        if (dlgModel.isSimpleSplit()) {
            PredefinedSimpleSplitCharColumnSplitter typ = dlgModel.getSimpleSplitType();
            return typ.getParser();
        }
        throw new IllegalArgumentException("undecided parser." + dlgModel);
    }
    
}
