/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package textkeymatcher.io;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.Timestamp;
import textkeymatcher.entity.KeyMatchedRowMap;
import textkeymatcher.entity.LineData;
import textkeymatcher.entity.LineDataList;

/**
 *
 * @author seraphy
 */
public class DocOutputStream extends OutputStream {

    private OutputStream out;
    
    public DocOutputStream(OutputStream out) {
        if (out == null) {
            throw new IllegalArgumentException();
        }

        this.out = out;
    }
    
    public void write(KeyMatchedRowMap rowMap) throws IOException {
        if (rowMap == null) {
            throw new IllegalArgumentException();
        }
        
        String creationDate = new Timestamp(System.currentTimeMillis()).toString();
        
        Persistent.TextKeyMatcherDoc.Builder docBuilder = Persistent.TextKeyMatcherDoc.newBuilder();
        docBuilder.setCreationDate(creationDate);
        
        Persistent.RowMap.Builder rowMapBuilder = Persistent.RowMap.newBuilder();
        
        Persistent.RowMap.KeyMatcherType keyMatchType = Persistent.RowMap.KeyMatcherType.TEXT;
        switch (rowMap.getKeyMatcher()) {
            case TEXT:
                keyMatchType = Persistent.RowMap.KeyMatcherType.TEXT;
                break;
            
            case TEXT_IGNORECASE:
                keyMatchType = Persistent.RowMap.KeyMatcherType.TEXT_IGNORE_CASE;
                break;
                
            case NUMERIC:
                keyMatchType = Persistent.RowMap.KeyMatcherType.NUMERIC;
                break;
        }
        rowMapBuilder.setKeyMatcherType(keyMatchType);
        
        int mx = rowMap.getNumOfLineDataLists();
        for (int idx = 0; idx < mx; idx++) {
            LineDataList lineDatas = rowMap.getLineDataList(idx);
            
            Persistent.LineDataList.Builder lstBuilder = Persistent.LineDataList.newBuilder();
            lstBuilder.setTitle(lineDatas.getTitle());
            
            for (LineData lineData : lineDatas) {
                Persistent.LineData.Builder lineBuilder = Persistent.LineData.newBuilder();
                lineBuilder.setKey(lineData.getKey());
                lineBuilder.setValue(lineData.getValue());
                lstBuilder.addLineDatas(lineBuilder);
            }
            
            rowMapBuilder.addDatas(lstBuilder);
        }
        
        docBuilder.setRowMap(rowMapBuilder);
        
        Persistent.RowView.Builder viewBuilder = Persistent.RowView.newBuilder();
        viewBuilder.setFilterType(Persistent.RowView.FilterType.ALL);
        
        docBuilder.setRowView(viewBuilder);
        
        Persistent.TextKeyMatcherDoc doc = docBuilder.build();

        doc.writeTo(out);
    }

    @Override
    public void write(int i) throws IOException {
        this.out.write(i);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }
    
    @Override
    public void close() throws IOException {
        out.close();
    }
    
}
