/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package textkeymatcher.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import textkeymatcher.entity.KeyMatchedRowMap;
import textkeymatcher.entity.KeyMatchedRowView;

/**
 *
 * @author seraphy
 */
public final class DocArchive {
    
    private DocArchive() {
        super();
    }

    public static void write(
            File file,
            KeyMatchedRowMap rowMap,
            KeyMatchedRowView rowView
            ) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        
        FileOutputStream fos = new FileOutputStream(file);
        try {
            write(fos, rowMap, rowView);
            
        } finally {
            fos.close();
        }
    }
    
    public static void write(
            OutputStream os,
            KeyMatchedRowMap rowMap,
            KeyMatchedRowView rowView
            ) throws IOException {
        if (os == null) {
            throw new IllegalArgumentException();
        }
        os.write("TextKeyMatcher:1.0".getBytes("UTF-8"));
        
        GZIPOutputStream gzipOutStm = new GZIPOutputStream(os);
        try {
            DocOutputStream docOutStm = new DocOutputStream(gzipOutStm);
            docOutStm.write(rowMap);
            docOutStm.flush();
            
        } finally {
            gzipOutStm.close();
        }
    }
    
}
