/*
 * The MIT License
 *
 * Copyright 2013 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package com.example.hello.android.actionmode_hello;

import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.view.ActionMode;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;

public class MainActivity extends Activity
	implements View.OnLongClickListener
{

	private static final String LOG_TAG = "XXX";
	private ActionModeCallback actionModeCallback = new ActionModeCallback();
	private ActionMode actionMode = null;
	private TextView helloTextView;
	private TextView goodbyeTextView;
	private TextView currentTextView;

	@Override
	public void onCreate(Bundle savedInstanceState)
	{
		Log.v(LOG_TAG, "onCreate() : Hello");

		super.onCreate(savedInstanceState);
		setContentView(R.layout.main_activity);

		helloTextView = (TextView) findViewById(R.id.hello_textview);
		helloTextView.setOnLongClickListener(this);
		goodbyeTextView = (TextView) findViewById(R.id.goodbye_textview);
		goodbyeTextView.setOnLongClickListener(this);

		Log.v(LOG_TAG, "onCreate() : Bye");
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu)
	{
		MenuInflater menuInflater = getMenuInflater();
		menuInflater.inflate(R.menu.quit_menu, menu);

		return true;
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item)
	{
		boolean result;
		int itemId = item.getItemId();
		switch (itemId)
		{
			case R.id.quit_menuitem:
				finish();
				result = true;
				break;
			default:
				result = super.onOptionsItemSelected(item);
		}
		return result;
	}

	@Override
	public boolean onLongClick(View view)
	{
		boolean result = false;
		Log.v(LOG_TAG, "onLongClick() : Hello");

		if (actionMode == null)
		{
			actionMode = startActionMode(actionModeCallback);
			currentTextView = (TextView) view;
			result = true;
		}

		Log.v(LOG_TAG, "onLongClick() : Bye");
		return result;
	}

	private void deleteCurrentItem()
	{
		if (currentTextView != null)
		{
			String message = currentTextView.getText().toString();
			Toast.makeText(this, "Delete : " + message, Toast.LENGTH_SHORT).show();
		}
	}

	private void shareCurrentItem()
	{
		if (currentTextView != null)
		{
			String message = currentTextView.getText().toString();
			Toast.makeText(this, "Share : " + message, Toast.LENGTH_SHORT).show();
		}
	}

	private class ActionModeCallback implements ActionMode.Callback
	{

		/**
		 * このアクションモードに入った際に呼ばれるコールバック。
		 *
		 * ここでアクションアイテムの作成やタイトルの設定などを行う。 ここで作成したメニューアイテムはこのアクションモード専用のものとなる。
		 *
		 * @param mode
		 * @param menu
		 * @return
		 */
		public boolean onCreateActionMode(ActionMode mode, Menu menu)
		{
			Log.v(LOG_TAG, "onCreateActionMode() : Hello");

			MenuInflater menuInflater = getMenuInflater();
			menuInflater.inflate(R.menu.delete_menu, menu);

			mode.setTitle(R.string.action_mode_title);
			mode.setSubtitle(R.string.action_mode_sub_title);

			Log.v(LOG_TAG, "onCreateActionMode() : Bye");
			return true;
		}

		/**
		 * このアクションモードになる直前に呼ばれるコールバック。
		 *
		 * onCreateActionMode() より後でり、アクションアイテムなどの 各種ビューが初期化完了している事が期待できる。
		 *
		 * @param mode
		 * @param menu
		 * @return mode や menu が更新されたら true を返す
		 */
		public boolean onPrepareActionMode(ActionMode mode, Menu menu)
		{
			Log.v(LOG_TAG, "onPrepareActionMode() : Hello");
			Log.v(LOG_TAG, "onPrepareActionMode() : Bye");
			return false;
		}

		/**
		 * アクションアイテムがクリックされた際のコールバック。
		 *
		 * @param mode
		 * @param item
		 * @return
		 */
		public boolean onActionItemClicked(ActionMode mode, MenuItem item)
		{
			Log.v(LOG_TAG, "onActionItemClicked() : Hello");
			int itemId = item.getItemId();
			switch (itemId)
			{
				case R.id.delete_menuitem:
					Log.v(LOG_TAG, "onActionItemClicked() : delete_menuitem is clicked.");
					deleteCurrentItem();
					mode.finish();
					break;
				case R.id.share_menuitem:
					Log.v(LOG_TAG, "onActionItemClicked() : share_menuitem is clicked.");
					shareCurrentItem();
					mode.finish();
					break;
			}
			Log.v(LOG_TAG, "onActionItemClicked() : Bye");
			return true;
		}

		/**
		 * アクションモード終了時のコールバック。
		 *
		 * ActionMode#finish() を呼び出したり、左上の「×」をクリックして アクションモードが終了したときに呼ばれる。
		 *
		 * @param mode
		 */
		public void onDestroyActionMode(ActionMode mode)
		{
			Log.v(LOG_TAG, "onDestroyActionMode() : Hello");
			actionMode = null;
			currentTextView = null;
			Log.v(LOG_TAG, "onDestroyActionMode() : Bye");
		}
	}
}
