package com.example.hello.android.google_play_service_plus_one;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.Toast;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.common.SignInButton;
import com.google.android.gms.plus.PlusClient;
import com.google.android.gms.plus.PlusOneButton;

public class MainActivity extends Activity
	implements GooglePlayServicesClient.ConnectionCallbacks,
	GooglePlayServicesClient.OnConnectionFailedListener, View.OnClickListener, PlusClient.OnAccessRevokedListener
{

	private static final String LOG_TAG = "XXX";
	private static int REQUEST_CODE_RESOLVE_ERROR = 101;
	private static int REQUEST_CODE_PLUS_ONE = 102;
	private ProgressDialog connectionProgressDialog;
	private PlusClient plusClient;
	private PlusOneButton plusOneButton;
	private ConnectionResult connectionResult;

	@Override
	public void onConnected(Bundle bundle)
	{
		Log.v(LOG_TAG, "onConnected() : Hello");

		String accountName = plusClient.getAccountName();
		Toast.makeText(this, "accountName => " + accountName, Toast.LENGTH_LONG).show();
		connectionProgressDialog.dismiss();

		SignInButton signInButton = (SignInButton) findViewById(R.id.sign_in_button);
		signInButton.setEnabled(false);

		Log.v(LOG_TAG, "onConnected() : Bye");
	}

	@Override
	public void onDisconnected()
	{
		Log.v(LOG_TAG, "onDisconnected() : Hello");


		Log.v(LOG_TAG, "onDisconnected() : Bye");
	}

	@Override
	public void onConnectionFailed(ConnectionResult cr)
	{
		Log.v(LOG_TAG, "onConnectionFailed() : Hello");

		if (connectionProgressDialog.isShowing())
		{
			if (cr.hasResolution())
			{
				try
				{
					cr.startResolutionForResult(this, REQUEST_CODE_RESOLVE_ERROR);
				}
				catch (IntentSender.SendIntentException ex)
				{
					Log.e(LOG_TAG, "ConnectionResult#startResolutionForResult() Failed.", ex);
					plusClient.connect();
				}
			}
		}
		connectionResult = cr;

		Log.v(LOG_TAG, "onConnectionFailed() : Bye");
	}

	@Override
	public void onAccessRevoked(ConnectionResult cr)
	{
		Log.v(LOG_TAG, "onAccessRevoked() : Hello");

		Toast.makeText(this, "Access Revoked", Toast.LENGTH_LONG).show();

		Log.v(LOG_TAG, "onAccessRevoked() : Bye");
	}

	@Override
	public void onClick(View view)
	{
		Log.v(LOG_TAG, "onClick() : Hello");
		if (view.getId() == R.id.sign_in_button)
		{
			Log.d(LOG_TAG, "onClick() : sign_in_button is clicked.");
			signIn();
		}

		Log.v(LOG_TAG, "onClick() : Bye");
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu)
	{
		MenuInflater menuInflater = getMenuInflater();
		menuInflater.inflate(R.menu.sign_out_menuitem, menu);
		menuInflater.inflate(R.menu.revoke_access_menuitem, menu);
		menuInflater.inflate(R.menu.quit_menuitem, menu);

		return true;
	}

	@Override
	public boolean onPrepareOptionsMenu(Menu menu)
	{
		Log.v(LOG_TAG, "onPrepareOptionsMenu() : Hello");

		MenuItem signOutMenuItem = menu.findItem(R.id.sign_out_menuitem);
		MenuItem revokeAccessMenuItem = menu.findItem(R.id.revoke_access_menuitem);
		if (plusClient.isConnected())
		{
			signOutMenuItem.setEnabled(true);
			revokeAccessMenuItem.setEnabled(true);
		}
		else
		{
			signOutMenuItem.setEnabled(false);
			revokeAccessMenuItem.setEnabled(false);
		}

		Log.v(LOG_TAG, "onPrepareOptionsMenu() : Bye");
		return super.onPrepareOptionsMenu(menu);
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item)
	{
		boolean result = true;
		Log.v(LOG_TAG, "onOptionsItemSelected() : Hello");

		switch (item.getItemId())
		{
			case R.id.sign_out_menuitem:
				signOut();
				break;
			case R.id.revoke_access_menuitem:
				revokeAccess();
				break;
			case R.id.quit_menuitem:
				finish();
				break;
			default:
				result = super.onOptionsItemSelected(item);
		}

		Log.v(LOG_TAG, "onOptionsItemSelected() : Bye");
		return result;
	}

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		Log.v(LOG_TAG, "onCreate() : Hello");
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main_activity);

		PlusClient.Builder builder = new PlusClient.Builder(this, this, this);
		builder.setVisibleActivities("http://schemas.google.com/AddActivity", "http://schemas.google.com/BuyActivity");
		plusClient = builder.build();

		connectionProgressDialog = new ProgressDialog(this);
		connectionProgressDialog.setMessage("Signing in...");

		SignInButton signInButton = (SignInButton) findViewById(R.id.sign_in_button);
		signInButton.setOnClickListener(this);

		plusOneButton = (PlusOneButton) findViewById(R.id.plus_one_button);

		Log.v(LOG_TAG, "onCreate() : Bye");
	}

	@Override
	protected void onStart()
	{
		Log.v(LOG_TAG, "onStart() : Hello");
		super.onStart();
		plusClient.connect();
		Log.v(LOG_TAG, "onStart() : Bye");
	}

	@Override
	protected void onStop()
	{
		Log.v(LOG_TAG, "onStop() : Hello");
		super.onStop();
		plusClient.disconnect();
		Log.v(LOG_TAG, "onStop() : Bye");
	}

	@Override
	protected void onResume()
	{
		super.onResume();
		plusOneButton.initialize(plusClient, "http://www.example.com/", REQUEST_CODE_PLUS_ONE);
	}

	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data)
	{
		Log.v(LOG_TAG, "onActivityResult() : Hello");
		if (requestCode == REQUEST_CODE_RESOLVE_ERROR && resultCode == RESULT_OK)
		{
			Log.d(LOG_TAG, "onActivityResult() : requestCode => REQUEST_CODE_RESOLVE_ERROR");
			connectionResult = null;
			plusClient.connect();
		}
		else if (requestCode == REQUEST_CODE_PLUS_ONE)
		{
			Log.d(LOG_TAG, "onActivityResult() : requestCode => REQUEST_CODE_PLUS_ONE");
		}
		Log.v(LOG_TAG, "onActivityResult() : Bye");
	}

	private void signIn()
	{
		if (plusClient.isConnected() == false)
		{
			SignInButton signInButton = (SignInButton) findViewById(R.id.sign_in_button);
			signInButton.setEnabled(false);

			if (connectionResult == null)
			{
				connectionProgressDialog.show();
			}
			else
			{
				try
				{
					connectionResult.startResolutionForResult(this, REQUEST_CODE_RESOLVE_ERROR);
				}
				catch (IntentSender.SendIntentException ex)
				{
					Log.e(LOG_TAG, "ConnectionResult#startResolutionForResult() Failed.", ex);
					plusClient.connect();
				}
			}
		}
	}

	private void signOut()
	{
		Log.v(LOG_TAG, "signOut() : Hello");

		if (plusClient.isConnected())
		{
			Log.d(LOG_TAG, "signOut() : public.isConnected()");
			plusClient.clearDefaultAccount();
			plusClient.disconnect();
			plusClient.connect();

			SignInButton signInButton = (SignInButton) findViewById(R.id.sign_in_button);
			signInButton.setEnabled(true);
		}

		Log.v(LOG_TAG, "signOut() : Bye");
	}

	private void revokeAccess()
	{
		if (plusClient.isConnected())
		{
			plusClient.clearDefaultAccount();
			plusClient.revokeAccessAndDisconnect(this);
		}
	}
}
