package com.example.hello.android.actionbar_nav_mode_list;

import android.app.ActionBar;
import android.app.Activity;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.widget.ArrayAdapter;
import android.widget.TextView;

public class MainActivity extends Activity
	implements ActionBar.OnNavigationListener
{

	private String[] names;

	/**
	 * Called when the activity is first created.
	 */
	@Override
	public void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main_activity);

		ActionBar actionBar = getActionBar();
		if (actionBar != null)
		{
			names = getResources().getStringArray(R.array.names);
			ArrayAdapter<String> adapter = new ArrayAdapter<String>(this,
				android.R.layout.simple_spinner_dropdown_item, names);
			actionBar.setNavigationMode(ActionBar.NAVIGATION_MODE_LIST);
			actionBar.setListNavigationCallbacks(adapter, this);
			actionBar.setDisplayShowTitleEnabled(false);
		}
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu)
	{
		MenuInflater menuInflater = getMenuInflater();
		menuInflater.inflate(R.menu.main_activity_option_menu, menu);
		return true;
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item)
	{
		switch (item.getItemId())
		{
			case R.id.quit_menuitem:
				finish();
				break;
		}
		return super.onOptionsItemSelected(item);
	}

	public boolean onNavigationItemSelected(int position, long id)
	{
		boolean result = false;

		String name = names[position];
		TextView nameTextView = (TextView) findViewById(R.id.name_textview);
		nameTextView.setText(name);

		return result;
	}
}
