/*
 * The MIT License
 *
 * Copyright 2012-2013 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package com.example.hello.android.actionbar_actionview_class;

import android.app.Activity;
import android.os.AsyncTask;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.widget.ProgressBar;

public class MainActivity extends Activity
{

	private static final String LOG_TAG = "XXX";
	private MenuItem uploadMenuItem;
	private ProgressBar uploadProgressBar;

	/**
	 * Called when the activity is first created.
	 */
	@Override
	public void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main_activity);
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu)
	{
		MenuInflater menuInflater = getMenuInflater();
		menuInflater.inflate(R.menu.main_activity_option_menu, menu);

		uploadMenuItem = menu.findItem(R.id.upload_menuitem);
		uploadProgressBar = (ProgressBar) uploadMenuItem.getActionView();
		uploadProgressBar.setMax(100);
		uploadProgressBar.setProgress(0);

		return true;
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item)
	{
		switch (item.getItemId())
		{
			case R.id.upload_menuitem:
				startUploadTask();
				break;
			case R.id.quit_menuitem:
				finish();
				break;
		}
		return super.onOptionsItemSelected(item);
	}

	private void startUploadTask()
	{
		DummyUploadAsyncTask uploadAsyncTask = new DummyUploadAsyncTask();
		uploadAsyncTask.execute();
	}

	class DummyUploadAsyncTask extends AsyncTask<Void, Integer, Integer>
	{

		@Override
		protected Integer doInBackground(Void... params)
		{
			int result = -1;

			for (int i = 0; i <= 100; i++)
			{
				if (isCancelled())
				{
					Log.d(LOG_TAG, "Cancelled!");
					result = i;
					break;
				}

				publishProgress(i);
				try
				{
					Thread.sleep(10);
				}
				catch (InterruptedException ex)
				{
					Log.e(LOG_TAG, "InterruptedException in UploadAsyncTask.", ex);
					result = i;
					break;
				}

			}

			return result;
		}

		@Override
		protected void onProgressUpdate(Integer... values)
		{
			if (uploadProgressBar != null)
			{
				uploadProgressBar.setProgress(values[0]);
			}
		}

		@Override
		protected void onPostExecute(Integer result)
		{
			// 処理が終わったらアクションビューをたたむ
			if (uploadMenuItem != null)
			{
				uploadMenuItem.collapseActionView();
			}
		}
	}
}
