/*
 *  The MIT License
 *
 *  Copyright 2011-2012 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */
package org.routine_work.simple_battery_logger.service;

import android.app.IntentService;
import android.content.Intent;
import android.os.Environment;
import java.io.File;
import java.util.Date;
import org.routine_work.simple_battery_logger.db.DBConstants;
import org.routine_work.simple_battery_logger.util.CsvFilenameFilter;
import org.routine_work.utils.Log;
import org.routine_work.simple_battery_logger.util.PreferenceUtils;

/**
 *
 * @author sawai
 */
public class DeleteAllCsvFileService extends IntentService
	implements DBConstants
{

	private static final String LOG_TAG = "simple-battery-logger";

	public DeleteAllCsvFileService(String name)
	{
		super(name);
	}

	public DeleteAllCsvFileService()
	{
		this("DeleteAllCsvFileService");
	}

	@Override
	protected void onHandleIntent(Intent intent)
	{
		Log.i(LOG_TAG, "DeleteAllCsvFileService  : Start at " + new Date());

		boolean result = deleteAllCsvFile();
		Log.i(LOG_TAG, "DeleteAllCsvFileService  : result =>  " + result);

		// send broadcast intent
		Intent broadcastIntent = new Intent();
		broadcastIntent.setAction(DeleteAllCsvFileCompletedReceiver.DELETE_ALL_CSV_FILE_COMPLETED_ACTION);
		broadcastIntent.putExtra(DeleteAllCsvFileCompletedReceiver.EXTRA_RESULT, result);
		sendBroadcast(broadcastIntent);

		Log.i(LOG_TAG, "DeleteAllCsvFileService : End at " + new Date());
	}

	private boolean deleteAllCsvFile()
	{
		boolean result = false;
		Log.v(LOG_TAG, "Hello");

		String externalStorageState = Environment.getExternalStorageState();
		if (externalStorageState.equalsIgnoreCase(Environment.MEDIA_MOUNTED))
		{
			String csvExportDirectoryName = PreferenceUtils.getCsvExportDirectoryName(this);
			Log.i(LOG_TAG, "csvExportDirectoryName => " + csvExportDirectoryName);

			File externalStorageDirectory = Environment.getExternalStorageDirectory();
			File exportDir = new File(externalStorageDirectory, csvExportDirectoryName);
			if (exportDir.exists())
			{
				File[] csvFiles = exportDir.listFiles(new CsvFilenameFilter());
				for (File csvFile : csvFiles)
				{
					boolean rc = csvFile.delete();
					Log.d(LOG_TAG, "DeleteAllCsvFileService : delete " + csvFile + " => " + rc);
				}
				result = true;
				Log.d(LOG_TAG, "DeleteAllCsvFileService : delete " + csvFiles.length + " file(s).");
			}
		}
		else
		{
			Log.i(LOG_TAG, "DeleteAllCsvFileService : CSV file deleting is canceled. SD card is not mounted.");
		}

		Log.v(LOG_TAG, "Bye");
		return result;
	}
}
