/*
 *  The MIT License
 * 
 *  Copyright 2011 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 * 
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 * 
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 * 
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */
package org.routine_work.simple_battery_logger;

import android.os.BatteryManager;
import java.util.HashMap;
import java.util.Map;

/**
 *
 * @author Masahiko, SAWAI <masahiko.sawai@gmail.com>
 */
public class BatteryUtils
{
	public static final Map<Integer, Integer> STATUS_CODE_AND_RESOURCE_MAP = new HashMap<Integer, Integer>();
	public static final Map<Integer, Integer> HEALTH_CODE_AND_RESOURCE_MAP = new HashMap<Integer, Integer>();
	public static final Map<Integer, Integer> PLUGGED_CODE_AND_RESOURCE_MAP = new HashMap<Integer, Integer>();
	static
	{
		// STATUS_CODE_AND_RESOURCE_MAP
		STATUS_CODE_AND_RESOURCE_MAP.put(BatteryManager.BATTERY_STATUS_UNKNOWN, R.string.status_unknown);
		STATUS_CODE_AND_RESOURCE_MAP.put(BatteryManager.BATTERY_STATUS_CHARGING, R.string.status_charging);
		STATUS_CODE_AND_RESOURCE_MAP.put(BatteryManager.BATTERY_STATUS_DISCHARGING, R.string.status_discharging);
		STATUS_CODE_AND_RESOURCE_MAP.put(BatteryManager.BATTERY_STATUS_NOT_CHARGING, R.string.status_not_charging);
		STATUS_CODE_AND_RESOURCE_MAP.put(BatteryManager.BATTERY_STATUS_FULL, R.string.status_full);
		// HEALTH_CODE_AND_RESOURCE_MAP
		HEALTH_CODE_AND_RESOURCE_MAP.put(BatteryManager.BATTERY_HEALTH_UNKNOWN, R.string.health_unknown);
		HEALTH_CODE_AND_RESOURCE_MAP.put(BatteryManager.BATTERY_HEALTH_GOOD, R.string.health_good);
		HEALTH_CODE_AND_RESOURCE_MAP.put(BatteryManager.BATTERY_HEALTH_OVERHEAT, R.string.health_overheat);
		HEALTH_CODE_AND_RESOURCE_MAP.put(BatteryManager.BATTERY_HEALTH_DEAD, R.string.health_dead);
		HEALTH_CODE_AND_RESOURCE_MAP.put(BatteryManager.BATTERY_HEALTH_OVER_VOLTAGE, R.string.health_over_voltage);
		HEALTH_CODE_AND_RESOURCE_MAP.put(BatteryManager.BATTERY_HEALTH_UNSPECIFIED_FAILURE, R.string.health_unspecified_failure);
		// PLUGGED_CODE_AND_RESOURCE_MAP
		PLUGGED_CODE_AND_RESOURCE_MAP.put(0, R.string.plugged_none);
		PLUGGED_CODE_AND_RESOURCE_MAP.put(BatteryManager.BATTERY_PLUGGED_AC, R.string.plugged_ac);
		PLUGGED_CODE_AND_RESOURCE_MAP.put(BatteryManager.BATTERY_PLUGGED_USB, R.string.plugged_usb);

	}
}
