/****************************************************
 * R a y  S p e e d e r                             *
 * Copyright (C) SatisFactory. All rights reserved. *
 ****************************************************/

#include "_Global.h"

#include "Speeder.hpp"

#define m g_main
#define g g_main->g

/**
 * RXgN^
 */
Speeder::Speeder() {
}

/**
 * 
 */
void Speeder::init(BOOL jiki, int type, int speed, int x) {
	_jiki      = jiki;
	_type      = type;
	_auto      = AUTO_INERTIA;
	_distance  = 0.0;
	_speed     = (double)speed;
	_x         = (double)(x - 24);
	_out       = FALSE;
	_direction = 0.0;
	_shield    = 0;
}

/**
 * ړ
 */
void Speeder::left() {
	switch ( _type ) {
	case SPEEDER1: _direction -= 0.25; break;
	case SPEEDER2: _direction -= 0.25; break;
	case SPEEDER3: _direction -= 0.5 ; break;
	case SPEEDER4: _direction -= 0.25; break;
	case SPEEDER5: _direction -= 0.25; break;
	}
	if ( _direction < -30.0 ) _direction = -30.0;
	_x += _direction / 2.0;
}

/**
 * Eړ
 */
void Speeder::right() {
	switch ( _type ) {
	case SPEEDER1: _direction += 0.25; break;
	case SPEEDER2: _direction += 0.25; break;
	case SPEEDER3: _direction += 0.5 ; break;
	case SPEEDER4: _direction += 0.25; break;
	case SPEEDER5: _direction += 0.25; break;
	}
	if ( _direction > 30.0 ) _direction = 30.0;
	_x += _direction / 2.0;
}

/**
 * ړ
 */
void Speeder::inertia(BOOL neutral) {
	if ( neutral ) {
		if ( _direction > 0.0 ) {
			_direction -= 0.125;
		} else if ( _direction < 0.0 ) {
			_direction += 0.125;
		}
	}
	_x += _direction / 2.0;
}

/**
 *
 */
void Speeder::set_direction(int target) {
	if ( _direction < (double)target ) {
		right();
	} else if ( _direction > (double)target ) {
		left();
	}
}

void Speeder::slide_left() { _x -= 0.5; }
void Speeder::slide_right() { _x += 0.5; }

void Speeder::out(int bar_x) {
	off_x = _x - (double)bar_x;
	_out = TRUE;
}
void Speeder::in(int bar_x) {
	if      ( off_x <   0 ) off_x =   0;
	else if ( off_x > 352 ) off_x = 352;
	_x = (double)bar_x + off_x;
	_out = FALSE;
	if ( !_jiki ) {
		_direction = (double)(m->stage->move_x() * 15) / 24.0;
	}
}
BOOL Speeder::out() { return _out; }

int Speeder::type() { return _type; }

// ړ̎ނύX
void Speeder::__auto(int type) { _auto = type; }

// ړ̎ނmF
int Speeder::__auto() { return _auto; }

// sύX
void Speeder::add_distance(int val) { _distance += (double)val / 4.0; }

// smF
int Speeder::distance() { return (int)_distance; }

/**
 * Xs[hグ
 */
void Speeder::speed_up(int val) {
	_speed += (double)val / 4.0;
	if ( _speed > 999.0 ) _speed = 999.0;
}
void Speeder::speed_up() {
	switch ( _type ) {
	case SPEEDER1:
	case SPEEDER4:
	case SPEEDER5:
		speed_up(10);
		break;
	case SPEEDER2:
		speed_up(8);
		break;
	case SPEEDER3:
		speed_up(6);
		break;
	}
}

/**
 * Xs[h𗎂Ƃ
 */
void Speeder::speed_down(int val) {
	_speed -= (double)val / 4.0;
	if ( _speed < 0.0 ) _speed = 0.0;
}
void Speeder::speed_down() {
	switch ( _type ) {
	case SPEEDER1:
	case SPEEDER4:
	case SPEEDER5:
		speed_down(40);
		break;
	case SPEEDER2:
		speed_down(30);
		break;
	case SPEEDER3:
		speed_down(35);
		break;
	}
}

/**
 * Xs[h𐧌
 */
void Speeder::speed_limit(int val) {
	if ( _speed > (double)val ) _speed = (double)val;
}

// Xs[hmF
int Speeder::speed() { return (int)_speed; }

// V[h̏ԂύX
void Speeder::shield(int col) {
	_shield = col;
	if ( _jiki && (m->_elapse_s > 0) && (_shield == m->stage->col()) ) {
		if ( m->_elapse_s <= WAIT_1 ) {
			m->shield_lag[m->shield_index] = (m->shield_lag[m->shield_index] + m->_elapse_s) / 2;
			m->shield_index++; if ( m->shield_index > 1 ) m->shield_index = 0;
		}
		m->_elapse_s = 0;
	}
}

// V[h̏ԂmF
int Speeder::shield() { return _shield; }

// ʒumF
int Speeder::x() { return (int)_x; }
int Speeder::dsp_x() { return _jiki ? 296 : (296 + ((int)_x - m->speeder[0]->x())); }
int Speeder::dsp_y() { return _jiki ? 384 : (384 - ((int)_distance - m->speeder[0]->distance()) / 5); }

// ړ̏ԂmF
int Speeder::direction() { return (int)_direction; }

/**
 * `
 */
void Speeder::draw(BOOL ready) {
	int i;
	int x = dsp_x();
	int y = dsp_y();
	if ( y <= -96 ) {
		return;
	}
	double tmp_d = _direction / 10.0;
	double tmp_s = _speed / 50.0;
	if ( _jiki && ((m->_elapse - m->_elapse_b) < WAIT_BOOST) ) {
		g->setAlpha(127);
		for ( i = 1; i < 10; i++ ) {
			g->drawImage(m->use_image(DATA_SHIELD), x - (int)(tmp_d * (double)i), y + (int)(tmp_s * (double)i), 48 * _shield, 0, 48, 96);
		}
		g->setAlpha(255);
	} else if ( !ready && ((m->elapse() % 4) < 2) ) {
//		g->drawImage(m->use_image(DATA_SHIELD), x -  (int)_direction     , y + (int)(_speed /  5.0), 48 * _shield, 192, 48, 96);
//		g->drawImage(m->use_image(DATA_SHIELD), x - ((int)_direction / 2), y + (int)(_speed / 10.0), 48 * _shield, 96, 48, 96);
		g->setAlpha(127);
		g->drawImage(m->use_image(DATA_SHIELD), x -  (int)_direction     , y + (int)(_speed /  5.0), 48 * _shield, 0, 48, 96);
		g->setAlpha(192);
		g->drawImage(m->use_image(DATA_SHIELD), x - ((int)_direction / 2), y + (int)(_speed / 10.0), 48 * _shield, 0, 48, 96);
		g->setAlpha(255);
	}
	g->drawImage(m->use_image(DATA_SHIELD), x, y, 48 * _shield, 0, 48, 96);
	int d;
	for ( i = 0; i < 10; i++ ) {
		d = (int)(_direction * 3.0);
		if ( d == 0 ) {
			switch ( _type ) {
			case SPEEDER1:
				g->drawImage(m->use_image(DATA_SPEEDER1_1), x + 24 - (_SPEEDER1_W / 2) - (int)(tmp_d * (double)i), y + 6 + (int)(tmp_s * (double)i));
				break;
			case SPEEDER2:
			case SPEEDER4:
				g->drawImage(m->use_image(DATA_SPEEDER2_1), x + 24 - (_SPEEDER2_W / 2) - (int)(tmp_d * (double)i), y + 6 + (int)(tmp_s * (double)i));
				break;
			case SPEEDER3:
			case SPEEDER5:
				g->drawImage(m->use_image(DATA_SPEEDER3_1), x + 24 - (_SPEEDER3_W / 2) - (int)(tmp_d * (double)i), y + 6 + (int)(tmp_s * (double)i));
				break;
			}
		} else if ( d > 0 ) {
			if ( d > 45 ) d = 45;
			d--;
			switch ( _type ) {
			case SPEEDER1:
				g->drawImage(m->use_image(DATA_SPEEDER1_2), x + 24 - (_SPEEDER1_W / 2) - (int)(tmp_d * (double)i), y + 6 + (int)(tmp_s * (double)i),
					_SPEEDER1_W * (d % 15),
					_SPEEDER1_H * (d / 15),
					_SPEEDER1_W,
					_SPEEDER1_H
					);
				break;
			case SPEEDER2:
			case SPEEDER4:
				g->drawImage(m->use_image(DATA_SPEEDER2_2), x + 24 - (_SPEEDER2_W / 2) - (int)(tmp_d * (double)i), y + 6 + (int)(tmp_s * (double)i),
					_SPEEDER2_W * (d % 15),
					_SPEEDER2_H * (d / 15),
					_SPEEDER2_W,
					_SPEEDER2_H
					);
				break;
			case SPEEDER3:
			case SPEEDER5:
				g->drawImage(m->use_image(DATA_SPEEDER3_2), x + 24 - (_SPEEDER3_W / 2) - (int)(tmp_d * (double)i), y + 6 + (int)(tmp_s * (double)i),
					_SPEEDER3_W * (d % 15),
					_SPEEDER3_H * (d / 15),
					_SPEEDER3_W,
					_SPEEDER3_H
					);
				break;
			}
		} else {
			if ( d < -45 ) d = -45;
			d = 0 - d - 1;
			switch ( _type ) {
			case SPEEDER1:
				g->drawImage(m->use_image(DATA_SPEEDER1_3), x + 24 - (_SPEEDER1_W / 2) - (int)(tmp_d * (double)i), y + 6 + (int)(tmp_s * (double)i),
					_SPEEDER1_W * (d % 15),
					_SPEEDER1_H * (d / 15),
					_SPEEDER1_W,
					_SPEEDER1_H
					);
				break;
			case SPEEDER2:
			case SPEEDER4:
				g->drawImage(m->use_image(DATA_SPEEDER2_3), x + 24 - (_SPEEDER2_W / 2) - (int)(tmp_d * (double)i), y + 6 + (int)(tmp_s * (double)i),
					_SPEEDER2_W * (d % 15),
					_SPEEDER2_H * (d / 15),
					_SPEEDER2_W,
					_SPEEDER2_H
					);
				break;
			case SPEEDER3:
			case SPEEDER5:
				g->drawImage(m->use_image(DATA_SPEEDER3_3), x + 24 - (_SPEEDER3_W / 2) - (int)(tmp_d * (double)i), y + 6 + (int)(tmp_s * (double)i),
					_SPEEDER3_W * (d % 15),
					_SPEEDER3_H * (d / 15),
					_SPEEDER3_W,
					_SPEEDER3_H
					);
				break;
			}
		}
		if ( !_jiki || ((m->_elapse - m->_elapse_b) >= WAIT_BOOST) ) {
			break;
		}
		g->setAlpha(127);
	}
	g->setAlpha(255);
}
