/****************************************************
 * R a y  S p e e d e r                             *
 * Copyright (C) SatisFactory. All rights reserved. *
 ****************************************************/

#ifndef MAIN_HPP
#define MAIN_HPP

#include <windows.h>

#include <tchar.h>

#include "_Main.hpp"

#include "_Graphics.hpp"
#include "_Image.hpp"
#include "_Memory.hpp"
#include "_Random.hpp"
#include "_SoundData.hpp"
#include "Speeder.hpp"
#include "Stage.hpp"
#include "System.hpp"
#include "Wave.hpp"

#include "MyDefine.h"

#define VERSION					"Ver.1.0"

// Z[uf[^o[W
#define CONFIG_VERSION			"0001"

// S[܂ł̋
#define DISTANCE				1000000

// Av̏
#define STATE_LAUNCH			0
#define STATE_TITLE				1
#define STATE_TITLE_LOADING		2
#define STATE_SELECT			3
#define STATE_SELECT_LOADING	4
#define STATE_READY				5
#define STATE_PLAY				6
#define STATE_CLEAR				7
#define STATE_STOP				8

// 1t[̎(~b)
#define FRAME_TIME				16

// ҂t[
#define WAIT_COUNTER			10
#define WAIT_BOOST				30
#define WAIT_H					30
#define WAIT_1					60
#define WAIT_2					120
#define WAIT_4					240

// \[X̎
#include "data.h"

#define IMAGE_NUM				DATA_NUM	// 摜̐

#define BGM_SPEEDY				0
#define BGM_SLOWLY				5
#define BGM_SELECT				10
#define BGM_NUM					11

#define SE_CURSOR				0
#define SE_SELECT				1
#define SE_CANCEL				2
#define SE_READY				3
#define SE_START				4
#define SE_COUNTER				5
#define SE_BOOST				6
#define SE_NUM					7

// ^CgʃeLXg
#define TEXT_NEUTRAL_X			0
#define TEXT_NEUTRAL_Y			24
#define TEXT_NEUTRAL_W			148
#define TEXT_NEUTRAL_H			20
#define TEXT_ON_X				0
#define TEXT_ON_Y				44
#define TEXT_ON_W				40
#define TEXT_ON_H				20
#define TEXT_OFF_X				44
#define TEXT_OFF_Y				44
#define TEXT_OFF_W				56
#define TEXT_OFF_H				20
#define TEXT_RACE_X				0
#define TEXT_RACE_Y				64
#define TEXT_RACE_W				76
#define TEXT_RACE_H				20
#define TEXT_FREE_X				80
#define TEXT_FREE_Y				64
#define TEXT_FREE_W				76
#define TEXT_FREE_H				20
#define TEXT_TRAINING_X			160
#define TEXT_TRAINING_Y			64
#define TEXT_TRAINING_W			160
#define TEXT_TRAINING_H			20
#define TEXT_EASY_X				0
#define TEXT_EASY_Y				84
#define TEXT_EASY_W				80
#define TEXT_EASY_H				20
#define TEXT_HARD_X				84
#define TEXT_HARD_Y				84
#define TEXT_HARD_W				80
#define TEXT_HARD_H				20
#define TEXT_1_X				168
#define TEXT_1_Y				84
#define TEXT_1_W				16
#define TEXT_1_H				20
#define TEXT_2_X				188
#define TEXT_2_Y				84
#define TEXT_2_W				16
#define TEXT_2_H				20
#define TEXT_OMAKE_X			208
#define TEXT_OMAKE_Y			84
#define TEXT_OMAKE_W			104
#define TEXT_OMAKE_H			20
#define TEXT_BESTTIME_X			0
#define TEXT_BESTTIME_Y			104
#define TEXT_BESTTIME_W			180
#define TEXT_BESTTIME_H			20
#define TEXT_DISTANCE_X			0
#define TEXT_DISTANCE_Y			124
#define TEXT_DISTANCE_W			160
#define TEXT_DISTANCE_H			20
#define TEXT_PRESS_X			0
#define TEXT_PRESS_Y			144
#define TEXT_PRESS_W			96
#define TEXT_PRESS_H			20
#define TEXT_KEY_X				100
#define TEXT_KEY_Y				144
#define TEXT_KEY_W				60
#define TEXT_KEY_H				20
#define TEXT_ENTER_X			0
#define TEXT_ENTER_Y			164
#define TEXT_ENTER_W			104
#define TEXT_ENTER_H			20
#define TEXT_SELECT_X			108
#define TEXT_SELECT_Y			164
#define TEXT_SELECT_W			120
#define TEXT_SELECT_H			20
#define TEXT_LOADING_X			0
#define TEXT_LOADING_Y			184
#define TEXT_LOADING_W			172
#define TEXT_LOADING_H			20
#define TEXT_COPYRIGHT_X		0
#define TEXT_COPYRIGHT_Y		404
#define TEXT_COPYRIGHT_W		360
#define TEXT_COPYRIGHT_H		15
#define TEXT_SELECTCHAR_X		0
#define TEXT_SELECTCHAR_Y		244
#define TEXT_SELECTCHAR_W		320
#define TEXT_SELECTCHAR_H		20
#define TEXT_RAY_X				0
#define TEXT_RAY_Y				264
#define TEXT_RAY_W				60
#define TEXT_RAY_H				20
#define TEXT_RAX_X				64
#define TEXT_RAX_Y				264
#define TEXT_RAX_W				60
#define TEXT_RAX_H				20
#define TEXT_COM_X				128
#define TEXT_COM_Y				264
#define TEXT_COM_W				64
#define TEXT_COM_H				20
#define TEXT_ACCELERATION_X		0
#define TEXT_ACCELERATION_Y		284
#define TEXT_ACCELERATION_W		240
#define TEXT_ACCELERATION_H		20
#define TEXT_FAST_X				0
#define TEXT_FAST_Y				304
#define TEXT_FAST_W				80
#define TEXT_FAST_H				20
#define TEXT_MIDDLE_X			84
#define TEXT_MIDDLE_Y			304
#define TEXT_MIDDLE_W			120
#define TEXT_MIDDLE_H			20
#define TEXT_SLOW_X				208
#define TEXT_SLOW_Y				304
#define TEXT_SLOW_W				84
#define TEXT_SLOW_H				20
#define TEXT_SLOWDOWN_X			0
#define TEXT_SLOWDOWN_Y			324
#define TEXT_SLOWDOWN_W			176
#define TEXT_SLOWDOWN_H			20
#define TEXT_NORMAL_X			0
#define TEXT_NORMAL_Y			344
#define TEXT_NORMAL_W			128
#define TEXT_NORMAL_H			20
#define TEXT_SLIGHT_X			132
#define TEXT_SLIGHT_Y			344
#define TEXT_SLIGHT_W			120
#define TEXT_SLIGHT_H			20
#define TEXT_STEERING_X			0
#define TEXT_STEERING_Y			364
#define TEXT_STEERING_W			160
#define TEXT_STEERING_H			20
#define TEXT_QUICK_X			0
#define TEXT_QUICK_Y			384
#define TEXT_QUICK_W			100
#define TEXT_QUICK_H			20

// Xe[^XeLXg
#define TEXT_READY_X			0
#define TEXT_READY_Y			148
#define TEXT_READY_W			202
#define TEXT_READY_H			42
#define TEXT_START_X			0
#define TEXT_START_Y			190
#define TEXT_START_W			238
#define TEXT_START_H			42
#define TEXT_FINISH_X			0
#define TEXT_FINISH_Y			232
#define TEXT_FINISH_W			262
#define TEXT_FINISH_H			42
#define TEXT_STOP_X				0
#define TEXT_STOP_Y				274
#define TEXT_STOP_W				162
#define TEXT_STOP_H				42
#define TEXT_PED_X				0
#define TEXT_PED_Y				316
#define TEXT_PED_W				142
#define TEXT_PED_H				42
#define TEXT_1ST_X				142
#define TEXT_1ST_Y				316
#define TEXT_1ST_W				104
#define TEXT_1ST_H				62
#define TEXT_2ND_X				0
#define TEXT_2ND_Y				378
#define TEXT_2ND_W				116
#define TEXT_2ND_H				62
#define TEXT_3RD_X				116
#define TEXT_3RD_Y				378
#define TEXT_3RD_W				110
#define TEXT_3RD_H				62
#define TEXT_PAUSE_X			0
#define TEXT_PAUSE_Y			440
#define TEXT_PAUSE_W			102
#define TEXT_PAUSE_H			22
#define TEXT_NEWRECORD_X		0
#define TEXT_NEWRECORD_Y		462
#define TEXT_NEWRECORD_W		218
#define TEXT_NEWRECORD_H		22
#define TEXT_AUTOSTEERING_X		0
#define TEXT_AUTOSTEERING_Y		484
#define TEXT_AUTOSTEERING_W		262
#define TEXT_AUTOSTEERING_H		22
#define TEXT_AUTOSHIELD_X		0
#define TEXT_AUTOSHIELD_Y		506
#define TEXT_AUTOSHIELD_W		218
#define TEXT_AUTOSHIELD_H		22
#define TEXT_GAME_X				0
#define TEXT_GAME_Y				528
#define TEXT_GAME_W				86
#define TEXT_GAME_H				22
#define TEXT_TITLE_X			0
#define TEXT_TITLE_Y			550
#define TEXT_TITLE_W			102
#define TEXT_TITLE_H			22
#define TEXT_BOOSTOK_X			0
#define TEXT_BOOSTOK_Y			572
#define TEXT_BOOSTOK_W			170
#define TEXT_BOOSTOK_H			22

// Xs[_[̎
#define SPEEDER1				0
#define SPEEDER2				1
#define SPEEDER3				2
#define SPEEDER4				3
#define SPEEDER5				4

// ړ̎
#define AUTO_INERTIA			0
#define AUTO_NEUTRAL			1
#define AUTO_MOVED_INERTIA		2
#define AUTO_MOVED_NEUTRAL		3

#define _SPEEDER1_W				47
#define _SPEEDER1_H				85

#define _SPEEDER2_W				49
#define _SPEEDER2_H				82

#define _SPEEDER3_W				46
#define _SPEEDER3_H				85

/**
 * C
 */
class Main : public _Main {
public:
	int width() { return 640; }
	int height() { return 480; }
	int frameTime() { return FRAME_TIME; }
	LPCTSTR logFile() { return sys_data.bWriteLog ? "speeder.log" : ""; }
	BOOL isCheckActive() { return sys_data.bCheckActive; }
	BOOL isWindow() { return sys_data.bWindow; }
	BOOL showCursor() { return sys_data.bWindow ? TRUE : FALSE; }
	BOOL isFullFrame() { return sys_data.bFullFrame; }
	int volumeMusic() { return sys_data.volumeMusic; }
	int volumeSound() { return sys_data.volumeSound; }
	void start();
	void destroy();
	void resume();
	void paint();
	void processEvent(UINT type, UINT param);

public:
	BOOL lock_dispose_image;

	SystemData sys_data;
	UINT button[4];

	unsigned char* pak_data;

	_Graphics* g;

	_Random* _rand;
	Stage* stage;
	Wave* wave;
	Speeder* speeder[3];

	// 悭gF
	D3DCOLOR COLOR_C;
	D3DCOLOR COLOR_M;
	D3DCOLOR COLOR_Y;
	D3DCOLOR COLOR_K;
	D3DCOLOR COLOR_W;

	int launch_step;		//

	int state;				// Av̏
	int _elapse;			// oߎ
	int _elapse_p;			// |[Y̌oߎ
	int _elapse_s;			// V[h؂ւx
	BOOL pause;				// |[Yǂ
	BOOL pause2;			//
	int shield_lag[2];
	int shield_index;
	int shield_wait[2];
	int shield_col[2];

	int change_col;

	int select_pause;

	BOOL neutral;			// L[Ńj[gɂ邩ǂ
	int level;				// x
	int player;				// gpLN^

	BOOL first;				// 킩ǂ

	int time[10];			// ̃^C
	int best_time[7][10];	// xXg^C
	int win[3][3];			// PʂɂȂ
	int ranking;			// 
	BOOL new_time;			// L^XVǂ

	int best_distance;		// xXgs
	int old_distance;		//
	BOOL new_distance;		// L^XVǂ

	int _elapse_l;			// v|Cgʉߎ̎
	int lap;				// bv
	int lap_time;			// bv^C̍
	BOOL dsp_lap;			// bv^C̍\邩ǂ
	BOOL finish;			// tBjbVCǂ

	BOOL boost;				// u[Xg\ǂ
	int _elapse_b;			// u[Xggp̎

	int old_y[2];
	int new_y[2];

	_Image main_img[IMAGE_NUM];
	_SoundData main_music[BGM_NUM];
	_SoundData main_sound[SE_NUM];

public:
	Main();
	void load_config();
	void save_config();
	_Memory* read_data(int id);
	void create_image(int id);
	void dispose_image(int id);
	void dispose_image();
	_Image* use_image(int id);
	void create_sound(int id);
	void dispose_sound(int id);
	void dispose_sound();
	_SoundData* use_sound(int id);
	BOOL create_music(int id);
	void dispose_music(int id);
	void dispose_music();
	void play_music(int id);
	void play_sound(int id);
	void stop_sound(int id);
	int elapse();
	BOOL omake1();
	BOOL omake2();
	int level_max();
	int index_b();
	int index_w();
	void set_state(int new_state);
	int drawImage2(_Image* img, int x0, int y0, int x, int y, int w, int h);
	void drawStatus(BOOL ready);
};

#endif // MAIN_HPP
