/****************************************************
 * ނ`                                       *
 * Copyright (C) SatisFactory. All rights reserved. *
 ****************************************************
 * ADFݒ                                          *
 * AppClass  FMain                                 *
 * AppName   Fނ`                           *
 * SPsize    F204800                               *
 * UseNetworkFhttp                                 *
 ****************************************************/

import com.nttdocomo.io.*;
import com.nttdocomo.ui.*;
import com.nttdocomo.util.*;
import javax.microedition.io.*;
import java.io.*;
import java.lang.*;
import java.util.*;

#define RESOURCE_NAME		"data."
#define RESOURCE_TOP		512

// Xg[ǂݍ݃ubNTCY
#define DATA_SIZE			256

// Xe[W
#define STAGE_NUM			2

// tHg̎
#define FONT_TINY			0
#define FONT_SMALL			1
#define FONT_MEDIUM			2

// 摜̎
#define IMAGE_BACK			0
#define IMAGE_LOGO			1
#define IMAGE_MASK			2
#define IMAGE_STAGE_1		3
#define IMAGE_STAGE_2		4
#define IMAGE_JIKI_1		5
#define IMAGE_SHIELD		6
#define IMAGE_SHOT			7
#define IMAGE_BAKU			8
#define IMAGE_AWA			9
#define IMAGE_ZAKO_1		10
#define IMAGE_ZAKO_2_1		11
#define IMAGE_ZAKO_2_2		12
#define IMAGE_ZAKO_3_1		13
#define IMAGE_ZAKO_3_2		14
#define IMAGE_ZAKO_4		15
#define IMAGE_ZAKO_5		16
#define IMAGE_BOSS_1		17
#define IMAGE_BOSS_2		18
#define IMAGE_RAY_3			19
#define IMAGE_RAX_2			20
#define IMAGE_BACK_1_1		21
#define IMAGE_BACK_1_2		22
#define IMAGE_BACK_2		23
#define IMAGE_BACK_3		24
#define IMAGE_FORE_1		25
#define IMAGE_FORE_2		26
#define IMAGE_FORE_3		27
#define IMAGE_RAY			28
#define IMAGE_RAX			29

#define IMAGE_JIKI_2		30
#define IMAGE_JIKI_2_1		IMAGE_JIKI_2
#define IMAGE_JIKI_2_2		31

#define IMAGE_JIKI_3		32
#define IMAGE_JIKI_3_1		IMAGE_JIKI_3
#define IMAGE_JIKI_3_2		33

#define IMAGE_JIKI_4		34

#define IMAGE_RAY_1			35
#define IMAGE_RAY_1_1		IMAGE_RAY_1
#define IMAGE_RAY_1_2		36

#define IMAGE_RAY_2			37

#define IMAGE_RAX_1			38

#define IMAGE_NUM			39	// 摜̐

// \[X̎
#define RESOURCE_BACK		0
#define RESOURCE_LOGO		1
#define RESOURCE_MASK		2
#define RESOURCE_STAGE_1	3
#define RESOURCE_STAGE_2	4
#define RESOURCE_JIKI_1		5
#define RESOURCE_JIKI_2_1	6
#define RESOURCE_JIKI_2_2	7
#define RESOURCE_JIKI_3_1	8
#define RESOURCE_JIKI_3_2	9
#define RESOURCE_JIKI_4		10
#define RESOURCE_SHIELD		11
#define RESOURCE_SHOT		12
#define RESOURCE_BAKU		13
#define RESOURCE_AWA		14
#define RESOURCE_ZAKO_1		15
#define RESOURCE_ZAKO_2_1	16
#define RESOURCE_ZAKO_2_2	17
#define RESOURCE_ZAKO_3_1	18
#define RESOURCE_ZAKO_3_2	19
#define RESOURCE_ZAKO_4		20
#define RESOURCE_ZAKO_5		21
#define RESOURCE_BOSS_1		22
#define RESOURCE_BOSS_2		23
#define RESOURCE_RAY_1_1	24
#define RESOURCE_RAY_1_2	25
#define RESOURCE_RAY_2		26
#define RESOURCE_RAY_3		27
#define RESOURCE_RAX_1		28
#define RESOURCE_RAX_2		29
#define RESOURCE_BACK_1_1	30
#define RESOURCE_BACK_1_2	31
#define RESOURCE_BACK_2		32
#define RESOURCE_BACK_3		33
#define RESOURCE_FORE_1		34
#define RESOURCE_FORE_2		35
#define RESOURCE_FORE_3		36
#define RESOURCE_RAY		37
#define RESOURCE_RAX		38
#define RESOURCE_STAGE		39
#define RESOURCE_NUM		(RESOURCE_STAGE + STAGE_NUM * 2)	// \[X̐

// Av̏
#define STATE_DOWNLOAD		-3
#define STATE_DOWNLOADERROR	-2
#define STATE_LAUNCH		-1
#define STATE_TITLE			0
#define STATE_HELP			1
#define STATE_SELECTSTAGE	2
#define STATE_SELECTSTAGE2	3
#define STATE_PLAY_LOAD		4
#define STATE_PLAY_MAIN		5
#define STATE_PLAY_BOSS		6
#define STATE_PLAY_LOAD2	7
#define STATE_PLAY_MAIN2	8
#define STATE_PLAY_BOSS2	9
#define STATE_PLAY_CLEAR	10
#define STATE_PLAY_GAMEOVER	11

// 1t[̎(~b)
#define FRAME_TIME			80

// ҂t[
#define WAIT_H				6
#define WAIT_1				12
#define WAIT_2				24
#define WAIT_4				48

#define JIKI_LIFE_MAX		10
#define SPECIAL_POWER_MAX	10

// e̎
#define JSHOT_NORMAL		0
#define JSHOT_SPECIAL		1
#define JSHOT_SWORD_F		2
#define JSHOT_SWORD_B		3

// Ge̎
#define ESHOT_NORMAL		0
#define ESHOT_SMALL			1
#define ESHOT_LARGE			2

// G̎
#define ENEMY_ZAKO_1		0
#define ENEMY_ZAKO_2		1
#define ENEMY_ZAKO_3		2
#define ENEMY_ZAKO_4		3
#define ENEMY_ZAKO_5		4
#define ENEMY_BOSS_1		5
#define ENEMY_BOSS_2		6
#define ENEMY_RAY			7
#define ENEMY_RAX			8

/**
 * C
 */
public class Main extends IApplication {
	public static MainCanvas canvas;
	public static Graphics g;

	public static Random rand;
	public static Vector jshot;
	public static Vector eshot;
	public static Vector spark;
	public static Vector awa;
	public static Vector burst;
	public static Jiki jiki;
	public static Vector enemy;

	public static int[] scroll_sy;
	public static int[] scroll_h;
	public static int[] scroll_step;
	public static int[] scroll_dx;

	// 悭gF
	public static final int COLOR_C = Graphics.getColorOfRGB(  0, 255, 255);
	public static final int COLOR_M = Graphics.getColorOfRGB(255,   0, 255);
	public static final int COLOR_Y = Graphics.getColorOfRGB(255, 255,   0);
	public static final int COLOR_B = Graphics.getColorOfRGB( 44,  84, 228);
	public static final int COLOR_K = Graphics.getColorOfRGB(  0,   0,   0);
	public static final int COLOR_W = Graphics.getColorOfRGB(255, 255, 255);

	// 悭gtHg
	public static Font[] font;

	public static final int[] CIRCLE_X = {
		 120,  118,  114,  106,   97,   84,   70,   54,   37,   18,
		   0,  -18,  -37,  -54,  -70,  -84,  -97, -106, -114, -118,
		-120, -118, -114, -106,  -97,  -84,  -70,  -54,  -37,  -18,
		   0,   18,   37,   54,   70,   84,   97,  106,  114,  118,
		 120
	};
	public static final int[] CIRCLE_Y = {
		   0,   18,   37,   54,   70,   84,   97,  106,  114,  118,
		 120,  118,  114,  106,   97,   84,   70,   54,   37,   18,
		   0,  -18,  -37,  -54,  -70,  -84,  -97, -106, -114, -118,
		-120, -118, -114, -106,  -97,  -84,  -70,  -54,  -37,  -18,
		   0
	};
	public int pattern(int x0, int y0, int x1, int y1) {
		int i, j;
		int w, h;
		int dist = 320000/*400 * 400 + 400 * 400*/;
		int tmp_d;
		x1 -= x0;
		y1 -= y0;
		j = -1;
		for ( i = 0; i < 40; i++ ) {
			w = x1 - CIRCLE_X[i];
			h = y1 - CIRCLE_Y[i];
			tmp_d = w * w + h * h;
			if ( tmp_d < dist ) {
				j = i;
				dist = tmp_d;
			}
		}
		return j;
	}

	int load_cnt;				// [hς݃f[^

	int state = STATE_LAUNCH;	// Av̏
	int help;					// wv̎
	int m_elapse;				// oߎ
	int m_elapse_p;				// |[Y̌oߎ
	boolean pause = false;		// |[Yǂ
	boolean disp_score;			//

	int level;					// x
	int st_index;				// Xe[Wԍ
	int st_step;				//
	int st_coef, st_coef_dist;	//

	boolean first;

	int _target;
	int _target_x;
	int _target_y;

	int score;					// XRA
	int[][] hi_score;			// nCXRA
	int score_d;				// \p

	boolean[][] clear;			//

	MediaImage[] main_mimg;
	Image[] main_img;

	ByteArrayInputStream script_in;
	StreamReader script_reader = null;
	String script_tmp;
	int script_frame;

	int key = 0;

	boolean need_gc = false;

	// L[͂ƕ`Ƃ̔rp
	boolean _lock_state = false;
	boolean _wait_state = false;
	public void lock_state() {
		_wait_state = true;
		while ( _lock_state ) {
			try {
				Thread.sleep(FRAME_TIME);
			} catch ( Exception e ) {
			}
		}
		_lock_state = true;
		_wait_state = false;
	}
	public void unlock_state() {
		_lock_state = false;
		while ( _wait_state ) {
			try {
				Thread.sleep(FRAME_TIME);
			} catch ( Exception e ) {
			}
		}
	}

	// L[͎̃RtNg}p
	boolean processingEvent = false;

	public int read_int(int pos) {
		int val = -1;
		try {
			DataInputStream in = Connector.openDataInputStream("scratchpad:///0;pos=" + pos);
			try {
				val = in.readInt();
			} catch ( Exception e ) {
			}
			in.close();
		} catch ( Exception e ) {
		}
		return val;
	}
	public void write_int(int pos, int val) {
		try {
			DataOutputStream out = Connector.openDataOutputStream("scratchpad:///0;pos=" + pos);
			try {
				out.writeInt(val);
			} catch ( Exception e ) {
			}
			out.close();
		} catch ( Exception e ) {
		}
	}

	/**
	 * Q[f[^_E[hς݂ǂ`FbN
	 */
	public boolean download_check() {
		int cnt = read_int(RESOURCE_TOP);
		if ( cnt >= 0 ) {
			load_cnt = cnt;
			if ( load_cnt != RESOURCE_NUM ) {
				return false;
			}
		} else {
			return false;
		}
		return true;
	}

	/**
	 * Q[f[^_E[h
	 */
	public boolean download() {
		HttpConnection con = null;
		try {
			byte buff[];
			buff = new byte[1024];
			int pos = 0;
			if ( load_cnt > 0 ) {
				pos = read_int(RESOURCE_TOP + 4 + (4 * (load_cnt - 1)));
			} else {
				pos = RESOURCE_TOP + 4 + (4 * (RESOURCE_NUM + 1));
				write_int(RESOURCE_TOP + 4, pos);
			}
			while ( true ) {
				String file = new String("");
				file = IApplication.getCurrentApp().getSourceURL() + RESOURCE_NAME + load_cnt;
System.out.println(file);
				con = (HttpConnection)Connector.open(
					file,
					Connector.READ,
					true
					);
				con.setRequestMethod(HttpConnection.GET);
				con.connect();
				int    rCode = con.getResponseCode();
				String rMsg  = con.getResponseMessage();
				if ( rMsg.equals("OK") == false ) {
					break;
				}
				long len = con.getLength();
				write_int(RESOURCE_TOP + 4 + (4 * (load_cnt + 1)), pos + (int)len);
				InputStream  in  = con.openInputStream();
				OutputStream out = Connector.openOutputStream("scratchpad:///0;pos=" + pos);
				pos += len;
				while ( (len = in.read(buff)) > 0 ) {
					out.write(buff, 0, (int)len);
				}
				out.close();
				in.close();
				con.close();
				con = null;
				load_cnt++;
				write_int(RESOURCE_TOP, load_cnt);
				if ( load_cnt >= RESOURCE_NUM ) {
					break;
				}
			}
		} catch ( Exception e ) {
		}
		try {
			if ( con != null ) {
				con.close();
			}
		} catch ( Exception e ) {
		}
		if ( load_cnt < RESOURCE_NUM ) {
			return false;
		}
		return true;
	}

	/**
	 * \[Xo
	 */
	byte[] resource_data = null;
	public byte[] resource(int id) {
		free_resource();
		try {
			int pos = read_int(RESOURCE_TOP + 4 + (4 * id));
			int size = read_int(RESOURCE_TOP + 4 + (4 * (id + 1))) - pos;
			InputStream in = Connector.openInputStream("scratchpad:///0;pos=" + pos);
			resource_data = new byte[size];
			in.read(resource_data);
			in.close();
		} catch ( Exception e ) {
		}
		return resource_data;
	}
	public void free_resource() {
		if ( resource_data != null ) {
			resource_data = null;
			need_gc = true;
		}
	}

	/**
	 * ݒ̓ǂݍ
	 */
	public void load_config() {
		int i;

		// ftHgl
		for ( i = 0; i < STAGE_NUM; i++ ) {
			hi_score[0][i] = 0;
			hi_score[1][i] = 0;
			hi_score[2][i] = 0;
			hi_score[3][i] = 0;
			hi_score[4][i] = 0;
			hi_score[5][i] = 0;
			clear[0][i] = false;
			clear[1][i] = false;
		}
		level = 0;
		st_index = 0;

		try {
			InputStream tmp;

			// XNb`pbhɊɃf[^邩ǂ`FbN
			int size = -1;
			tmp = Connector.openInputStream("scratchpad:///0;pos=0");
			try {
				size = tmp.read();
			} catch ( Exception e ) {
			}
			tmp.close();

			// f[^̂œǂݏo
			if ( size > 0 ) {
				tmp = Connector.openInputStream("scratchpad:///0;pos=0");
				StreamReader reader = new StreamReader();
				reader.begin(tmp);
				String str = new String("");
				for ( i = 0; i < 2; i++ ) {
					str = reader.read(); if ( str.length() > 0 ) hi_score[0][i] = Integer.parseInt(str);
				}
				for ( i = 0; i < 2; i++ ) {
					str = reader.read(); if ( str.length() > 0 ) hi_score[1][i] = Integer.parseInt(str);
				}
				str = reader.read(); if ( str.length() > 0 ) level = Integer.parseInt(str);
				str = reader.read(); if ( str.length() > 0 ) st_index = Integer.parseInt(str);
				for ( i = 0; i < 2; i++ ) {
					str = reader.read(); if ( str.length() > 0 ) hi_score[2][i] = Integer.parseInt(str);
				}
				for ( i = 0; i < 2; i++ ) {
					str = reader.read(); if ( str.length() > 0 ) clear[0][i] = (Integer.parseInt(str) == 1) ? true : false;
				}
				for ( i = 0; i < 2; i++ ) {
					str = reader.read(); if ( str.length() > 0 ) clear[1][i] = (Integer.parseInt(str) == 1) ? true : false;
				}
				for ( i = 0; i < 2; i++ ) {
					str = reader.read(); if ( str.length() > 0 ) hi_score[3][i] = Integer.parseInt(str);
				}
				for ( i = 0; i < 2; i++ ) {
					str = reader.read(); if ( str.length() > 0 ) hi_score[4][i] = Integer.parseInt(str);
				}
				for ( i = 0; i < 2; i++ ) {
					str = reader.read(); if ( str.length() > 0 ) hi_score[5][i] = Integer.parseInt(str);
				}
				reader.end();
				tmp.close();
			}
		} catch ( Exception e ) {
e.printStackTrace();
		}
	}

	/**
	 * ݒ̏o
	 */
	public void save_config() {
		int i;
		String str = new String("");
		for ( i = 0; i < 2; i++ ) {
			str = str + hi_score[0][i] + ",";
		}
		for ( i = 0; i < 2; i++ ) {
			str = str + hi_score[1][i] + ",";
		}
		str = str + level + ",";
		str = str + st_index + ",";
		for ( i = 0; i < 2; i++ ) {
			str = str + hi_score[2][i] + ",";
		}
		for ( i = 0; i < 2; i++ ) {
			str = str + (clear[0][i] ? "1" : "0") + ",";
		}
		for ( i = 0; i < 2; i++ ) {
			str = str + (clear[1][i] ? "1" : "0") + ",";
		}
		for ( i = 0; i < 2; i++ ) {
			str = str + hi_score[3][i] + ",";
		}
		for ( i = 0; i < 2; i++ ) {
			str = str + hi_score[4][i] + ",";
		}
		for ( i = 0; i < 2; i++ ) {
			str = str + hi_score[5][i] + ",";
		}
		byte[] data = str.getBytes();
		try {
			DataOutputStream out = Connector.openDataOutputStream("scratchpad:///0;pos=0");
			out.write(data, 0, data.length);
			out.close();
		} catch ( Exception e ) {
		}
	}

	/**
	 * C[Wǂݍ
	 */
	public void create_image(int id) {
		if ( main_img[id] == null ) {
			try {
				int res_id = 0;
				switch ( id ) {
				case IMAGE_BACK    : res_id = RESOURCE_BACK    ; break;
				case IMAGE_LOGO    : res_id = RESOURCE_LOGO    ; break;
				case IMAGE_MASK    : res_id = RESOURCE_MASK    ; break;
				case IMAGE_STAGE_1 : res_id = RESOURCE_STAGE_1 ; break;
				case IMAGE_STAGE_2 : res_id = RESOURCE_STAGE_2 ; break;
				case IMAGE_JIKI_1  : res_id = RESOURCE_JIKI_1  ; break;
				case IMAGE_JIKI_2_1: res_id = RESOURCE_JIKI_2_1; break;
				case IMAGE_JIKI_2_2: res_id = RESOURCE_JIKI_2_2; break;
				case IMAGE_JIKI_3_1: res_id = RESOURCE_JIKI_3_1; break;
				case IMAGE_JIKI_3_2: res_id = RESOURCE_JIKI_3_2; break;
				case IMAGE_JIKI_4  : res_id = RESOURCE_JIKI_4  ; break;
				case IMAGE_SHIELD  : res_id = RESOURCE_SHIELD  ; break;
				case IMAGE_SHOT    : res_id = RESOURCE_SHOT    ; break;
				case IMAGE_BAKU    : res_id = RESOURCE_BAKU    ; break;
				case IMAGE_AWA     : res_id = RESOURCE_AWA     ; break;
				case IMAGE_ZAKO_1  : res_id = RESOURCE_ZAKO_1  ; break;
				case IMAGE_ZAKO_2_1: res_id = RESOURCE_ZAKO_2_1; break;
				case IMAGE_ZAKO_2_2: res_id = RESOURCE_ZAKO_2_2; break;
				case IMAGE_ZAKO_3_1: res_id = RESOURCE_ZAKO_3_1; break;
				case IMAGE_ZAKO_3_2: res_id = RESOURCE_ZAKO_3_2; break;
				case IMAGE_ZAKO_4  : res_id = RESOURCE_ZAKO_4  ; break;
				case IMAGE_ZAKO_5  : res_id = RESOURCE_ZAKO_5  ; break;
				case IMAGE_BOSS_1  : res_id = RESOURCE_BOSS_1  ; break;
				case IMAGE_BOSS_2  : res_id = RESOURCE_BOSS_2  ; break;
				case IMAGE_RAY_1_1 : res_id = RESOURCE_RAY_1_1 ; break;
				case IMAGE_RAY_1_2 : res_id = RESOURCE_RAY_1_2 ; break;
				case IMAGE_RAY_2   : res_id = RESOURCE_RAY_2   ; break;
				case IMAGE_RAY_3   : res_id = RESOURCE_RAY_3   ; break;
				case IMAGE_RAX_1   : res_id = RESOURCE_RAX_1   ; break;
				case IMAGE_RAX_2   : res_id = RESOURCE_RAX_2   ; break;
				case IMAGE_BACK_1_1: res_id = RESOURCE_BACK_1_1; break;
				case IMAGE_BACK_1_2: res_id = RESOURCE_BACK_1_2; break;
				case IMAGE_BACK_2  : res_id = RESOURCE_BACK_2  ; break;
				case IMAGE_BACK_3  : res_id = RESOURCE_BACK_3  ; break;
				case IMAGE_FORE_1  : res_id = RESOURCE_FORE_1  ; break;
				case IMAGE_FORE_2  : res_id = RESOURCE_FORE_2  ; break;
				case IMAGE_FORE_3  : res_id = RESOURCE_FORE_3  ; break;
				case IMAGE_RAY     : res_id = RESOURCE_RAY     ; break;
				case IMAGE_RAX     : res_id = RESOURCE_RAX     ; break;
				}
				main_mimg[id] = MediaManager.getImage(resource(res_id)); free_resource();
				main_mimg[id].use();
				main_img[id] = main_mimg[id].getImage();
			} catch ( Exception e ) {
			}
		}
	}
	public void dispose_image(int id) {
		if ( main_img[id] != null ) {
			main_img[id].dispose();
			main_mimg[id].dispose();
			main_img[id] = null;
			need_gc = true;
		}
	}
	public void dispose_image() {
		for ( int i = 0; i < IMAGE_NUM; i++ ) {
			if ( main_img[i] != null ) {
				main_img[i].dispose();
				main_mimg[i].dispose();
				main_img[i] = null;
			}
		}
		need_gc = true;
	}
	public Image use_image(int id) {
		create_image(id);
		return main_img[id];
	}

	// oߎԂmF
	public int elapse() { return pause ? m_elapse_p : m_elapse; }

	/**
	 * Av̏ԂύX
	 */
	public void set_state(int new_state) {
		int i;

		int old_state = state;
		state = new_state;
		m_elapse = 0;

		switch ( old_state ) {
		case STATE_TITLE:
			dispose_image(IMAGE_LOGO);
			break;
		case STATE_SELECTSTAGE2:
			dispose_image();
			break;
		case STATE_PLAY_MAIN:
		case STATE_PLAY_MAIN2:
			dispose_image(IMAGE_ZAKO_1  );
			dispose_image(IMAGE_ZAKO_2_1);
			dispose_image(IMAGE_ZAKO_2_2);
			dispose_image(IMAGE_ZAKO_3_1);
			dispose_image(IMAGE_ZAKO_3_2);
			dispose_image(IMAGE_ZAKO_4  );
			dispose_image(IMAGE_ZAKO_5  );
			break;
		case STATE_PLAY_BOSS:
			switch ( st_index ) {
			case 0: dispose_image(IMAGE_BOSS_1); break;
			case 1: dispose_image(IMAGE_BOSS_2); break;
			}
			break;
		case STATE_PLAY_BOSS2:
			switch ( st_index ) {
			case 0:
				dispose_image(IMAGE_RAY_1_1);
				dispose_image(IMAGE_RAY_1_2);
				dispose_image(IMAGE_RAY_2);
				dispose_image(IMAGE_RAY_3);
				break;
			case 1:
				dispose_image(IMAGE_RAX_1);
				dispose_image(IMAGE_RAX_2);
				break;
			}
			break;
		}

		canvas.setSoftLabel(Frame.SOFT_KEY_1, "");
		canvas.setSoftLabel(Frame.SOFT_KEY_2, "");

		switch ( state ) {
		case STATE_DOWNLOAD:
			load_cnt = 0;
			break;
		case STATE_DOWNLOADERROR:
			canvas.setSoftLabel(Frame.SOFT_KEY_2, "I");
			break;
		case STATE_TITLE:
			dispose_image();
			pause = false;
			canvas.setSoftLabel(Frame.SOFT_KEY_1, "HELP");
			canvas.setSoftLabel(Frame.SOFT_KEY_2, "EXIT");
			break;
		case STATE_HELP:
			canvas.setSoftLabel(Frame.SOFT_KEY_1, "TITLE");
			canvas.setSoftLabel(Frame.SOFT_KEY_2, "EXIT");
			help = 0;
			break;
		case STATE_SELECTSTAGE2:
			canvas.setSoftLabel(Frame.SOFT_KEY_1, "TITLE");
			canvas.setSoftLabel(Frame.SOFT_KEY_2, "EXIT");
			break;
		case STATE_PLAY_LOAD:
			use_image(IMAGE_JIKI_1);
			use_image(IMAGE_JIKI_2_1);
			use_image(IMAGE_JIKI_2_2);
			use_image(IMAGE_JIKI_3_1);
			use_image(IMAGE_JIKI_3_2);
			use_image(IMAGE_JIKI_4);
			use_image(IMAGE_SHIELD);
			use_image(IMAGE_SHOT);
			use_image(IMAGE_BAKU);
			// ̂܂܉ɗ
		case STATE_PLAY_LOAD2:
			if ( script_reader != null ) {
				try {
					script_reader.end();
					script_in.close();
					script_reader = null;
				} catch ( Exception e ) {
				}
			}
			try {
				if ( state == STATE_PLAY_LOAD ) {
					script_in = new ByteArrayInputStream(resource(RESOURCE_STAGE + st_index * 2    ));
				} else {
					script_in = new ByteArrayInputStream(resource(RESOURCE_STAGE + st_index * 2 + 1));
				}
				script_reader = new StreamReader();
				script_reader.begin(script_in);
			} catch ( Exception e ) {
			}
			while ( true ) {
				script_tmp = script_reader.read();
				if ( script_tmp.charAt(0) == 'U' ) {
					switch ( script_reader.read_val() ) {
					case ENEMY_ZAKO_1:
						use_image(IMAGE_ZAKO_1);
						break;
					case ENEMY_ZAKO_2:
						use_image(IMAGE_ZAKO_2_1);
						use_image(IMAGE_ZAKO_2_2);
						break;
					case ENEMY_ZAKO_3:
						use_image(IMAGE_ZAKO_3_1);
						use_image(IMAGE_ZAKO_3_2);
						break;
					case ENEMY_ZAKO_4:
						use_image(IMAGE_ZAKO_4);
						break;
					case ENEMY_ZAKO_5:
						use_image(IMAGE_ZAKO_5);
						break;
					}
				} else {
					script_frame = Integer.parseInt(script_tmp);
					break;
				}
			}
			break;
		case STATE_PLAY_MAIN:
			_target = 0;

			score = 0;

			switch ( st_index ) {
			case 0:
				scroll_sy   = new int[10];
				scroll_h    = new int[10];
				scroll_step = new int[10];
				scroll_dx   = new int[10];
				for ( i = 0; i < 10; i++ ) {
					scroll_sy  [i] = 24 * i;
					scroll_h   [i] = 24;
					scroll_step[i] = 10;//i + 1;
					scroll_dx  [i] = 0;
				}
				break;
			case 1:
				scroll_sy   = new int[10];
				scroll_h    = new int[10];
				scroll_step = new int[10];
				scroll_dx   = new int[10];
				for ( i = 0; i < 5; i++ ) {
					scroll_sy  [i    ] = 48 * i;
					scroll_h   [i    ] = 48;
					scroll_step[i    ] = (i + 1) * 2;
					scroll_dx  [i    ] = 0;
					scroll_sy  [i + 5] = 24 * i;
					scroll_h   [i + 5] = 24;
					scroll_step[i + 5] = (5 - i) * 2;
					scroll_dx  [i + 5] = 0;
				}
				break;
			}

			jshot = new Vector();
			eshot = new Vector();
			spark = new Vector();
			awa   = new Vector();
			burst = new Vector();
			enemy = new Vector();

			jiki = new Jiki();

			st_step = 0;
			st_coef = ((jiki.x() / 2 + (208 - jiki.y()) / 2) * 100) / 208;
			st_coef_dist = st_coef;

			break;
		case STATE_PLAY_BOSS:
			switch ( st_index ) {
			case 0:
				enemy.addElement(new Enemy(ENEMY_BOSS_1, 240, 80, (rand.nextInt() % 2) + 1, 500));
				use_image(IMAGE_BOSS_1);
				break;
			case 1:
				enemy.addElement(new Enemy(ENEMY_BOSS_2, 80, -80, (rand.nextInt() % 2) + 1, 500));
				use_image(IMAGE_BOSS_2);
				break;
			}
			break;
//		case STATE_PLAY_MAIN2:
//			break;
		case STATE_PLAY_BOSS2:
			switch ( st_index ) {
			case 0:
				enemy.addElement(new Enemy(ENEMY_RAY, -40, 100, (rand.nextInt() % 2) + 1, 500));
				use_image(IMAGE_RAY_1_1);
				use_image(IMAGE_RAY_1_2);
				use_image(IMAGE_RAY_2);
				use_image(IMAGE_RAY_3);
				break;
			case 1:
				enemy.addElement(new Enemy(ENEMY_RAX, 88, 240, (rand.nextInt() % 2) + 1, 500));
				use_image(IMAGE_RAX_1);
				use_image(IMAGE_RAX_2);
				break;
			}
			break;
		case STATE_PLAY_CLEAR:
			dispose_image();

			clear[level][st_index] = true;

			score_d = score;
			if ( jiki._life > 0 ) {
				add_score(jiki._life * 100);
			}
			save_config();

			disp_score = true;

			break;
		case STATE_PLAY_GAMEOVER:
			dispose_image();
			save_config();
			break;
		}
	}

	/**
	 * `ɎgpFݒ
	 */
	public void setCMYColor(int col) {
		switch ( col ) {
		case 0: g.setColor(COLOR_C); break;
		case 1: g.setColor(COLOR_M); break;
		case 2: g.setColor(COLOR_Y); break;
		}
	}

	int stringWidth(int type, String str) {
		return font[type].stringWidth(str);
	}
	int fontHeight(int type) {
		return font[type].getHeight();
	}
	void drawImage(Graphics g, Image img, int x0, int y0, int x, int y, int w, int h) {
		g.drawImage(img, x0, y0, x, y, w, h);
	}
	void drawImage(Graphics g, Image img, int x0, int y0) {
		g.drawImage(img, x0, y0);
	}

	/**
	 * XN[XV
	 */
	public void scroll_update(int i) {
		scroll_dx[i] -= scroll_step[i];
		if ( scroll_dx[i] <= -120 ) {
			scroll_dx[i] = 0;
		}
	}

	/**
	 * XN[`
	 */
	public void scroll_draw(int i, int id, int dy) {
		drawImage(g, use_image(id), scroll_dx[i]      , dy, 0, scroll_sy[i], 120, scroll_h[i]);
		drawImage(g, use_image(id), scroll_dx[i] + 120, dy, 0, scroll_sy[i], 120, scroll_h[i]);
		drawImage(g, use_image(id), scroll_dx[i] + 240, dy, 0, scroll_sy[i], 120, scroll_h[i]);
	}

	/**
	 * start
	 */
	public void start() {
		rand = new Random(System.currentTimeMillis());

		// 悭gtHg
		font = new Font[3];
		font[FONT_TINY  ] = Font.getFont(Font.FACE_SYSTEM | Font.STYLE_PLAIN | Font.SIZE_TINY  );
		font[FONT_SMALL ] = Font.getFont(Font.FACE_SYSTEM | Font.STYLE_PLAIN | Font.SIZE_SMALL );
		font[FONT_MEDIUM] = Font.getFont(Font.FACE_SYSTEM | Font.STYLE_PLAIN | Font.SIZE_MEDIUM);

		canvas = new MainCanvas();

		// Q[f[^̃_E[h
		if ( (getLaunchType() == LAUNCHED_AFTER_DOWNLOAD) || !download_check() ) {
			lock_state();
			set_state(STATE_DOWNLOAD);
			unlock_state();

			Display.setCurrent(canvas);

			// Xbhł̕`Jn
			DrawThread runner = new DrawThread();
			runner.start();

			if ( !download() ) {
				lock_state();
				set_state(STATE_DOWNLOADERROR);
				unlock_state();
				return;
			}

			// Xbhł̕`I
			runner.end();
			try {
				runner.join();
			} catch ( Exception e ) {
			}
		}

		{
			lock_state();
			set_state(STATE_LAUNCH);
			unlock_state();

			Display.setCurrent(canvas);

			// Xbhł̕`Jn
			DrawThread runner = new DrawThread();
			runner.start();

			hi_score = new int[6][STAGE_NUM];
			clear = new boolean[6][STAGE_NUM];

			main_mimg = new MediaImage[IMAGE_NUM];
			main_img = new Image[IMAGE_NUM];
			for ( int i = 0; i < IMAGE_NUM; i++ ) {
				main_img[i] = null;
			}

			script_tmp = new String("");

			load_config();

			// Xbhł̕`I
			runner.end();
			try {
				runner.join();
			} catch ( Exception e ) {
			}
		}

		lock_state();
		set_state(STATE_TITLE);
		unlock_state();

		long start_time;
		long sleep_time;
		while ( true ) {
			start_time = System.currentTimeMillis();
			canvas.paint(g);
			sleep_time = FRAME_TIME - (System.currentTimeMillis() - start_time);
			if ( sleep_time > 0 ) {
				try {
					Thread.sleep(sleep_time);
				} catch ( Exception e ) {
				}
			}
		}
	}

	/**
	 * resume
	 */
	public void resume() {
		switch ( state ) {
		case STATE_PLAY_MAIN:
		case STATE_PLAY_BOSS:
		case STATE_PLAY_MAIN2:
		case STATE_PLAY_BOSS2:
			pause = true;
			m_elapse_p = 0;
			canvas.setSoftLabel(Frame.SOFT_KEY_2, "EXIT");
			break;
		}
	}

	int _move_x;
	int _move_y;
	public boolean move(int x0, int y0, int x1, int y1, int cnt) {
		if ( (x0 == x1) && (y0 == y1) ) {
			_move_x = x0 + cnt;
			_move_y = y0;
			return false;
		}
		boolean ret = true;
		int i;
		int e;
		int dx, dy, sx, sy;
		int w, h;
		int d = cnt * cnt;
		sx = (x1 > x0) ? 1 : -1;
		dx = (x1 > x0) ? x1 - x0 : x0 - x1;
		sy = (y1 > y0) ? 1 : -1;
		dy = (y1 > y0) ? y1 - y0 : y0 - y1;
		_move_x = x0;
		_move_y = y0;
		if ( dx >= dy ) {
			e = -dx;
			for ( i = 0; i <= cnt; i++ ) {
				_move_x += sx;
				e += 2 * dy;
				if ( e >= 0 ) {
					_move_y += sy;
					e -= 2 * dx;
				}
				if ( (_move_x == x1) && (_move_y == y1) ) {
					ret = false;
				}
				w = _move_x - x0;
				h = _move_y - y0;
				if ( (w * w + h * h) >= d ) {
					// ڕWɒBƔ(ɔԒe΂߂ɔԒexɂȂ)
					break;
				}
			}
		} else {
			e = -dy;
			for ( i = 0; i <= cnt; i++ ) {
				_move_y += sy;
				e += 2 * dx;
				if ( e >= 0 ) {
					_move_x += sx;
					e -= 2 * dy;
				}
				if ( (_move_x == x1) && (_move_y == y1) ) {
					ret = false;
				}
				w = _move_x - x0;
				h = _move_y - y0;
				if ( (w * w + h * h) >= d ) {
					// ڕWɒBƔ(ɔԒe΂߂ɔԒexɂȂ)
					break;
				}
			}
		}
		return ret;
	}
	public int move_x() { return _move_x; }
	public int move_y() { return _move_y; }

	/**
	 * GNXgI\ǂ
	 */
	boolean extra() {
		int i, j;
		for ( i = 0; i < 2; i++ ) {
			for ( j = 0; j < STAGE_NUM; j++ ) {
				if ( !(clear[i][j]) ) {
					return false;
				}
			}
		}
		return true;
	}

	/**
	 * XRAZ
	 */
	public void add_score(int point) {
		score += point * 10;
		if ( score > hi_score[level][st_index] ) hi_score[level][st_index] = score;
	}

	public void lock_enemy() {
		int i, j;
		int jx = jiki.cx();
		int jy = jiki.cy();
		int ex, ey;
		int w, h;
		int dist = 115200/*240 * 240 + 240 * 240*/;
		int tmp_d;
		j = -1;
		for ( i = enemy.size() - 1; i >= 0; i-- ) {
			Enemy tmp = (Enemy)enemy.elementAt(i);
			if ( !(tmp.destroyed()) ) {
				ex = tmp.cx();
				ey = tmp.cy();
				w = jx - ex;
				h = jy - ey;
				tmp_d = w * w + h * h;
				if ( tmp_d < dist ) {
					j = i;
					dist = tmp_d;
				}
			}
		}
		if ( j >= 0 ) {
			Enemy tmp = (Enemy)enemy.elementAt(j);
			tmp._lock = true;
		}
	}

	/**
	 * `XbhōsNX
	 */
	class DrawThread extends Thread {
		private boolean _run = true;
		public void run() {
			while ( _run ) {
				canvas.repaint();
				try {
					Thread.sleep(FRAME_TIME);
				} catch ( Exception e ) {
				}
			}
		}
		public void end() { _run = false; }
	}

	/**
	 * Xg[R}؂̕ǂݏoNX
	 */
	class StreamReader {
		char[] data;
		int data_size;
		int data_index;
		char[] word;
		InputStreamReader reader;
		StreamReader() {
			data = new char[DATA_SIZE];
			word = new char[16];
		}
		public void begin(InputStream in) {
			reader = new InputStreamReader(in);
			begin();
		}
		public void end() {
			try {
				reader.close();
			} catch ( IOException e ) {
			}
		}
		private int begin() {
			try {
				data_size = reader.read(data, 0, DATA_SIZE);
			} catch ( IOException e ) {
			}
			data_index = 0;
			return data_size;
		}
		private int read_chr() {
			if ( data_index >= data_size ) {
				if ( begin() <= 0 ) return -1;
			}
			int chr = data[data_index];
			data_index++;
			return chr;
		}
		public String read() {
			int word_index = 0;
			try {
				int chr = 0;

				// ݈ʒuɉsR[h̏ꍇɓǂݔ΂
				while ( true ) {
					chr = read_chr();
					if ( chr <= 0 ) break;
					if ( (chr != '\r') && (chr != '\n') ) {
						if ( chr != ' ' ) {
							word[word_index] = (char)chr;
							word_index++;
						}
						break;
					}
				}
				if ( chr != ',' ) {
					while ( true ) {
						chr = read_chr();
						if ( (chr <= 0) || (chr == ',') || (chr == '\r') || (chr == '\n') ) break;
						if ( chr != ' ' ) {
							word[word_index] = (char)chr;
							word_index++;
						}
					}
				}
			} catch ( Exception e ) {
			}
			String str = new String(word, 0, word_index);
			return str;
		}
		public int read_val() {
			return Integer.parseInt(read());
		}
	}

	/**
	 * LoX
	 */
	class MainCanvas extends Canvas {
		/**
		 * RXgN^
		 */
		MainCanvas() {
			PhoneSystem.setAttribute(
				PhoneSystem.DEV_BACKLIGHT,
				PhoneSystem.ATTR_BACKLIGHT_ON
				);
			setSoftLabel(Frame.SOFT_KEY_1, "");
			setSoftLabel(Frame.SOFT_KEY_2, "");

			g = getGraphics();
			g.setOrigin((getWidth() - 240) / 2, (getHeight() - 240) / 2);
			g.setClip(0, 0, 240, 240);
		}

		/**
		 * `
		 */
		private void drawString(String str, int x, int y) {
			g.drawString(str, x    , y);
			g.drawString(str, x + 1, y);
		}

		/**
		 * `
		 */
		private void drawString(String str, int type, int x, int y) {
			g.setFont(font[type]);
			if ( x < 0 ) {
				drawString(str,
					240 + x - stringWidth(type, str),
					y
					);
			} else {
				drawString(str, x, y);
			}
		}

		/**
		 * Z^O`
		 */
		private void centerDrawString(String str, int type, int y) {
			g.setFont(font[type]);
			drawString(str,
				(240 - stringWidth(type, str)) / 2,
				y + fontHeight(type) / 2
				);
		}

		/**
		 * ܂Ԃ`
		 */
		private int drawStringTurn(String str, int x, int y, int width) {
			int len = str.length();
			char data[] = new char[len];
			str.getChars(0, len, data, 0);
			int start = 0;
			int end = 0;
			int h = font[FONT_SMALL].getHeight();
			boolean line_break;
			while ( len > 0 ) {
				end = font[FONT_SMALL].getLineBreak(str, start, len, width);

				// s֑
				line_break = false;
				while ( true ) {
					if ( end < str.length() ) {
						switch ( str.charAt(end) ) {
						case '!':
						case ')':
						case ',':
						case '.':
						case '':
						case '':
							end++;
							break;
						default:
							line_break = true;
							break;
						}
					} else {
						line_break = true;
					}
					if ( line_break ) {
						break;
					}
				}

				// s֑
				line_break = false;
				while ( true ) {
					if ( end > (start + 1) ) {
						switch ( str.charAt(end - 1) ) {
						case '(':
							end--;
							break;
						default:
							line_break = true;
							break;
						}
					} else {
						line_break = true;
					}
					if ( line_break ) {
						break;
					}
				}

				g.drawChars(data, x    , y, start, end - start);
				g.drawChars(data, x + 1, y, start, end - start);
				len -= (end - start);
				start = end;
				y += h;
			}
			return y;
		}

		/**
		 * paint
		 */
		public void paint(Graphics _g) {
			int i, j;

			lock_state();

			key = canvas.getKeypadState();

			need_gc = false;

			switch ( state ) {
			case STATE_DOWNLOAD:
				g.lock();
				g.setColor(COLOR_C);
				g.fillRect(0, 0, 240, 240);
				g.setColor(COLOR_M);
				centerDrawString("Q[f[^", FONT_SMALL, 100);
				centerDrawString("`ǒł", FONT_SMALL, 120);
				g.setColor(COLOR_W);
				g.drawRect(40, 140, 160, 4);
				g.fillRect(41, 141, 159 * load_cnt / RESOURCE_NUM, 3);
				g.unlock(true);
				break;
			case STATE_DOWNLOADERROR:
				g.lock();
				g.setColor(COLOR_C);
				g.fillRect(0, 0, 240, 240);
				g.setFont(font[FONT_SMALL]);
				g.setColor(COLOR_M);
				drawStringTurn("޳۰ނɎs܂.ʐMŋNĂȂꍇ,UI,ʐMŋNĂ.܂,ȯܰ̒q\܂.\󂲂܂,UI,oĂNĂ݂Ă.", 10, 30, 220);
				g.unlock(true);
				break;
			case STATE_LAUNCH:
				g.lock();
				g.setColor(COLOR_C);
				g.fillRect(0, 0, 240, 240);
				g.setColor(COLOR_M);
				centerDrawString("Now Loading...", FONT_SMALL, 120);
				g.unlock(true);
				break;
			case STATE_TITLE:
				g.lock();
				drawImage(g, use_image(IMAGE_BACK), 0, 0);
				drawImage(g, use_image(IMAGE_LOGO), 0, 0);
				if ( level > 2 ) {
					g.setColor(COLOR_M);
				} else {
					g.setColor(COLOR_W);
				}
				switch ( level % 3 ) {
				case 0: drawString("Normal      ", FONT_SMALL, -10, 175); break;
				case 1: drawString("Hard      "  , FONT_SMALL, -10, 175); break;
				case 2: drawString("Extra      "  , FONT_SMALL, -10, 175); break;
				}
				g.setColor(COLOR_Y);
				drawString("Level", FONT_SMALL, -10, 175);
				if ( ((m_elapse / WAIT_H) % 2) == 0 ) {
					drawString("Press Select Key", FONT_SMALL, -10, 205);
				}
				drawString("Copyright (C) SatisKia", FONT_TINY, -10, 237);
				g.unlock(true);
				break;
			case STATE_HELP:
				g.lock();
				drawImage(g, use_image(IMAGE_BACK), 0, 0);
				g.setFont(font[FONT_SMALL]);
				g.setColor(COLOR_W);
				switch ( help ) {
				case 0:
					drawImage(g, use_image(IMAGE_MASK), 0, 0);
					{
						int y = 55;
						y = drawStringTurn("ްт͂PðނƂɓƗڲ܂.eðނ޽|θرł.", 5, y + 10, 230);
						y = drawStringTurn("ނƈقȂF܂ׯĂGeɐGƂgo܂.G{̂͐GĂvł.", 5, y + 10, 230);
						y = drawStringTurn("@goȂȂƹްѵްł.", 5, y + 10, 230);
					}
					if ( ((m_elapse / WAIT_H) % 2) == 0 ) {
						centerDrawString("", FONT_SMALL, 215);
					}
					break;
				case 1:
					drawImage(g, use_image(IMAGE_MASK), 0, 0);
					if ( ((m_elapse / WAIT_H) % 2) == 0 ) {
						centerDrawString("", FONT_SMALL, 30);
					}
					{
						int y = 55;
						y = drawStringTurn("ۯ݂,ł߂GɎōs܂.", 5, y + 10, 230);
						y = drawStringTurn("G̐FƓF̍U,U͂{ɂȂ܂.", 5, y + 10, 230);
						y = drawStringTurn("G̒e͓F̼ނőłƂł,̎,߼ٹްނ܂.", 5, y + 10, 230);
					}
					if ( ((m_elapse / WAIT_H) % 2) == 0 ) {
						centerDrawString("", FONT_SMALL, 215);
					}
					break;
				case 2:
					drawImage(g, use_image(IMAGE_MASK), 0, 0);
					if ( ((m_elapse / WAIT_H) % 2) == 0 ) {
						centerDrawString("", FONT_SMALL, 30);
					}
					{
						int y = 55;
						y = drawStringTurn("߼ٹްނق̎,ްނ_ł܂.̎,݂̼ނƓF̼ސ؂ւ݂ƽ߼ٍUł܂.", 5, y + 10, 230);
						y = drawStringTurn("߼ٍU͖GɂȂ܂.,UIシɖGԂ̂,ӂKvł.", 5, y + 10, 230);
					}
					if ( ((m_elapse / WAIT_H) % 2) == 0 ) {
						centerDrawString("", FONT_SMALL, 215);
					}
					break;
				case 3:
					drawImage(g, use_image(IMAGE_MASK), 0, 0);
					if ( ((m_elapse / WAIT_H) % 2) == 0 ) {
						centerDrawString("", FONT_SMALL, 30);
					}
					{
						int y = 55;
						y = drawStringTurn("ۯݒ̓Gɐڋ߂,ϰԂȂ܂.̎,݂̼ނƓF̼ސ؂ւ݂ƿލUł܂.", 5, y + 10, 230);
						y = drawStringTurn("ގc͓G̒eł܂.,c,莞,@̑삪łȂȂ̂,ӂKvł.", 5, y + 10, 230);
					}
					if ( ((m_elapse / WAIT_H) % 2) == 0 ) {
						centerDrawString("", FONT_SMALL, 215);
					}
					break;
				case 4:
					drawImage(g, use_image(IMAGE_MASK), 0, 0);
					if ( ((m_elapse / WAIT_H) % 2) == 0 ) {
						centerDrawString("", FONT_SMALL, 30);
					}
					centerDrawString("ىʂł̑", FONT_SMALL, 60);
					drawString("", FONT_SMALL, -145, 95);
					drawString("[1]", 105, 95);
					drawString("؏I", FONT_SMALL, -145, 120);
					drawString("[2]", 105, 120);
					drawString("ّI", FONT_SMALL, -145, 145);
					drawString("[][]", 105, 145);
					drawString("ðޑI", FONT_SMALL, -145, 170);
					drawString("[]", 105, 170);
					if ( ((m_elapse / WAIT_H) % 2) == 0 ) {
						centerDrawString("", FONT_SMALL, 215);
					}
					break;
				case 5:
					drawImage(g, use_image(IMAGE_MASK), 0, 0);
					if ( ((m_elapse / WAIT_H) % 2) == 0 ) {
						centerDrawString("", FONT_SMALL, 30);
					}
					centerDrawString("ðޑIʂł̑", FONT_SMALL, 60);
					drawString("ðޑI", FONT_SMALL, -145, 95);
					drawString("[][]", 105, 95);
					drawString("ްъJn", FONT_SMALL, -145, 120);
					drawString("[]", 105, 120);
					drawString("قɖ߂", FONT_SMALL, -145, 145);
					drawString("[1]", 105, 145);
					drawString("؏I", FONT_SMALL, -145, 170);
					drawString("[2]", 105, 170);
					if ( ((m_elapse / WAIT_H) % 2) == 0 ) {
						centerDrawString("", FONT_SMALL, 215);
					}
					break;
				case 6:
					drawImage(g, use_image(IMAGE_MASK), 0, 0);
					if ( ((m_elapse / WAIT_H) % 2) == 0 ) {
						centerDrawString("", FONT_SMALL, 30);
					}
					centerDrawString("ڲ̑", FONT_SMALL, 60);
					drawString("@̈ړ", FONT_SMALL, -145, 95);
					drawString("[][][][]", 105, 95);
					drawString("F", FONT_SMALL, -145, 120);
					drawString("[1][4][7]", 105, 120);
					drawString("ԐF", FONT_SMALL, -145, 145);
					drawString("[][5][8]", 105, 145);
					drawString("F", FONT_SMALL, -145, 170);
					drawString("[2][6][9]", 105, 170);
					drawString("߰", FONT_SMALL, -145, 195);
					drawString("[1]", 105, 195);
					drawString("ۯ", FONT_SMALL, -145, 220);
					drawString("[2][3][*][0][#]", 105, 220);
					break;
				case 7:
					break;
				}
				g.unlock(true);
				break;
			case STATE_SELECTSTAGE:
				if ( key == 0 ) {
					set_state(STATE_SELECTSTAGE2);
				}
				break;
			case STATE_SELECTSTAGE2:
				g.lock();
				drawImage(g, use_image(IMAGE_BACK), 0, 0);
				drawImage(g, use_image(IMAGE_MASK), 0, 0);
				g.setColor(COLOR_Y);
				g.fillRect(16 + (110 * st_index), 41, 98, 98);
				drawImage(g, use_image(IMAGE_STAGE_1), 20, 45);
				drawImage(g, use_image(IMAGE_STAGE_2), 130, 45);
				centerDrawString("rdkdbs rs`fd", FONT_SMALL, 20);
				if ( (key & (1 << Display.KEY_SELECT)) != 0 ) {
					centerDrawString("Loading...", FONT_SMALL, 210);
				} else {
					centerDrawString("[][]L[őI", FONT_SMALL, 200);
					centerDrawString("[]L[ŃX^[g!", FONT_SMALL, 220);
				}
				g.setColor(COLOR_W);
				centerDrawString("Hi-Score", FONT_SMALL, 155);
				if ( hi_score[level][st_index] == 0 ) {
					centerDrawString("---", FONT_SMALL, 175);
					first = true;
				} else {
					centerDrawString("" + hi_score[level][st_index], FONT_SMALL, 175);
					first = false;
				}
				g.unlock(true);

				if ( (key & (1 << Display.KEY_SELECT)) != 0 ) {
					set_state(STATE_PLAY_LOAD);
				}
				break;
			case STATE_PLAY_LOAD:
				set_state(STATE_PLAY_MAIN);
				break;
			case STATE_PLAY_LOAD2:
				set_state(STATE_PLAY_MAIN2);
				break;
			case STATE_PLAY_MAIN:
			case STATE_PLAY_BOSS:
			case STATE_PLAY_MAIN2:
			case STATE_PLAY_BOSS2:
if ( !pause ) {
				if ( (script_reader != null) && (m_elapse == script_frame) ) {
					int t, x, y, c, l;
					while ( true ) {
						script_tmp = script_reader.read();
						if ( script_tmp.length() <= 0 ) {
							try {
								script_reader.end();
								script_in.close();
								script_reader = null;
							} catch ( Exception e ) {
							}
							break;
						}
						if ( script_tmp.charAt(0) == 'S' ) {
							st_step++;
							if ( st_step == 4 ) {
								awa.removeAllElements();
								need_gc = true;
								dispose_image(IMAGE_AWA);
							}
						} else if ( script_tmp.charAt(0) == 'E' ) {
							t = script_reader.read_val();
							x = script_reader.read_val();
							y = script_reader.read_val();
							c = script_reader.read_val();
							l = 0;
							switch ( t ) {
							case ENEMY_ZAKO_1: l = 10; break;
							case ENEMY_ZAKO_2: l = 10; break;
							case ENEMY_ZAKO_3: l = 20; break;
							case ENEMY_ZAKO_4: l = 10; break;
							case ENEMY_ZAKO_5: l = 30; break;
							}
							enemy.addElement(new Enemy(t, x, y, c, l));
						} else {
							script_frame += Integer.parseInt(script_tmp);
							break;
						}
					}
				}

				if ( jiki._life < 0 ) {
					set_state(STATE_PLAY_GAMEOVER);
					break;
				}

				// @̈ړ
				if ( (key & (1 << Display.KEY_DOWN )) != 0 ) jiki.down ();
				if ( (key & (1 << Display.KEY_LEFT )) != 0 ) jiki.left ();
				if ( (key & (1 << Display.KEY_RIGHT)) != 0 ) jiki.right();
				if ( (key & (1 << Display.KEY_UP   )) != 0 ) jiki.up   ();

				if ( (jiki._life > 0) && !(jiki.check_special()) ) {
					// e
					if ( _target > 0 ) {
						if ( (m_elapse % 2) == 0 ) {
							jshot.addElement(new JikiShot(JSHOT_NORMAL, _target_x, _target_y));
						}
//					} else {
//						add_score(1);
					}
				}

				// XV
				boolean need_gc = false;
				switch ( st_index ) {
				case 0:
					for ( i = 0; i < 10; i++ ) {
						scroll_update(i);
					}
					if ( jiki._life > 0 ) {
						if ( (_target == 0) || (state == STATE_PLAY_BOSS) ) {
							st_coef_dist = ((jiki.x() / 2 + (208 - jiki.y()) / 2) * 100) / 208;
						} else {
							st_coef_dist = (((_target_x - 16) / 2 + (_target_y - 16) / 2) * 100) / 208;
						}
						if ( st_coef < st_coef_dist ) {
							if ( state == STATE_PLAY_BOSS2 ) {
								st_coef += 2;
							} else {
								st_coef++;
							}
						}
						if ( st_coef > st_coef_dist ) {
							if ( state == STATE_PLAY_BOSS2 ) {
								st_coef -= 2;
							} else {
								st_coef--;
							}
						}
						if ( st_coef < 0 ) {
							st_coef = 0;
						} else if ( st_coef > 100 ) {
							st_coef = 100;
						}
					}
					break;
				case 1:
					for ( i = 0; i < 10; i++ ) {
						scroll_update(i);
					}
					switch ( st_step ) {
					case 0:
						st_coef = 50;
						break;
					case 1:
						st_coef += 2;
						if ( st_coef > 100 ) {
							st_coef = 100;
						}
						if ( st_coef == 100 ) {
							st_step++;
							dispose_image(IMAGE_BACK_2);
							need_gc = true;
						}
						break;
					case 2:
						if ( (m_elapse % 2) == 0 ) {
							awa.addElement(new Awa(jiki.cx(), jiki.cy()));
						}
						st_coef -= 10;
						if ( st_coef < 0 ) {
							st_coef = 0;
						}
						if ( st_coef == 0 ) {
							st_step++;
							dispose_image(IMAGE_FORE_2);
							need_gc = true;
						}
						break;
					case 3:
						st_coef = 0;
						if ( (m_elapse % 2) == 0 ) {
							if ( (rand.nextInt() % 2) != 0 ) {
								awa.addElement(new Awa(jiki.cx(), jiki.cy()));
							}
						}
						break;
					case 4:
						st_coef += 10;
						if ( st_coef > 100 ) {
							st_coef = 100;
						}
						if ( st_coef == 100 ) {
							st_step++;
							dispose_image(IMAGE_BACK_3);
							dispose_image(IMAGE_FORE_3);
							need_gc = true;
						}
						break;
					case 5:
						st_coef -= 1;
						if ( st_coef < 50 ) {
							st_coef = 50;
						}
						if ( st_coef == 50 ) {
							st_step = 0;
						}
						break;
					}
					break;
				}
				jiki.update();
				for ( i = jshot.size() - 1; i >= 0; i-- ) {
					JikiShot tmp = (JikiShot)jshot.elementAt(i);
					if ( !(tmp.update()) ) {
						jshot.removeElementAt(i);
						need_gc = true;
					}
				}
				for ( i = eshot.size() - 1; i >= 0; i-- ) {
					EnemyShot tmp = (EnemyShot)eshot.elementAt(i);
					if ( !(tmp.update()) ) {
						eshot.removeElementAt(i);
						need_gc = true;
					}
				}
				for ( i = spark.size() - 1; i >= 0; i-- ) {
					Spark tmp = (Spark)spark.elementAt(i);
					if ( !(tmp.update()) ) {
						spark.removeElementAt(i);
						need_gc = true;
					}
				}
				for ( i = awa.size() - 1; i >= 0; i-- ) {
					Awa tmp = (Awa)awa.elementAt(i);
					if ( !(tmp.update()) ) {
						awa.removeElementAt(i);
						need_gc = true;
					}
				}
				for ( i = burst.size() - 1; i >= 0; i-- ) {
					Burst tmp = (Burst)burst.elementAt(i);
					if ( !(tmp.update()) ) {
						burst.removeElementAt(i);
						need_gc = true;
					}
				}
				for ( i = enemy.size() - 1; i >= 0; i-- ) {
					Enemy tmp = (Enemy)enemy.elementAt(i);
					if ( tmp.update() ) {
						switch ( tmp._type ) {
						case ENEMY_BOSS_1:
						case ENEMY_BOSS_2:
						case ENEMY_RAY:
						case ENEMY_RAX:
							break;
						default:
							add_score(1);
							break;
						}
					} else {
						enemy.removeElementAt(i);
						need_gc = true;
					}
				}

				// bNĂG𒲂ׂ
				_target = 0;
				for ( i = enemy.size() - 1; i >= 0; i-- ) {
					Enemy tmp = (Enemy)enemy.elementAt(i);
					if ( tmp._lock ) {
						break;
					}
				}
				if ( (i < 0) && !(jiki.check_special()) ) {
					lock_enemy();
				}
				for ( i = enemy.size() - 1; i >= 0; i-- ) {
					Enemy tmp = (Enemy)enemy.elementAt(i);
					if ( tmp._lock ) {
						_target_x = tmp.cx();
						_target_y = tmp.cy();
						int w = _target_x - jiki.cx();
						int h = _target_y - jiki.cy();
						if ( (level < 3) && ((w * w + h * h) < 3200/*40 * 40 + 40 * 40*/) ) {
							_target = 2;
						} else {
							_target = 1;
						}
						break;
					}
				}
}

				g.lock();

				// wi̕`
				switch ( st_index ) {
				case 0:
					g.setColor(COLOR_B);
					g.fillRect(0, 0, 240, 240);
					drawImage(g, use_image(IMAGE_BACK_1_1), 0, 0 - (st_coef * 240) / 100);
					for ( i = 0; i < 10; i++ ) {
						scroll_draw(i, IMAGE_FORE_1, 24 * i + 24 * (10 - i) * (100 - st_coef) / 100);
					}
					if ( st_coef < 10 ) {
						int coef = 200 + st_coef * 2;
						drawImage(g, use_image(IMAGE_BACK_1_2),
							((-70 + 10 * coef / 25) / 2) * 2,
							((-80 + 10 * coef / 19) / 2) * 2,
							0, 0, 15, 15
							);
						drawImage(g, use_image(IMAGE_BACK_1_2),
							((-146 + 20 * coef / 25) / 2) * 2 + 1,
							((-160 + 20 * coef / 19) / 2) * 2,
							0, 15, 10, 10
							);
						drawImage(g, use_image(IMAGE_BACK_1_2),
							((-164 + 22 * coef / 25) / 2) * 2,
							((-176 + 22 * coef / 19) / 2) * 2,
							0, 25, 20, 20
							);
						drawImage(g, use_image(IMAGE_BACK_1_2),
							((-305 + 40 * coef / 25) / 2) * 2 + 1,
							((-320 + 40 * coef / 19) / 2) * 2,
							20, 0, 40, 40
							);
					}
					break;
				case 1:
					switch ( st_step ) {
					case 0:
					case 1:
					case 5:
						drawImage(g, use_image(IMAGE_BACK_2), 0, 0 - ((st_coef * 240) / 100 - 120));
						for ( i = 0; i < 5; i++ ) {
							scroll_draw(i, IMAGE_FORE_2, 20 + 48 * i + 48 * (5 - i) * (100 - st_coef) / 100);
						}
						break;
					case 2:
					case 3:
					case 4:
						drawImage(g, use_image(IMAGE_BACK_3), 0, 120);
						for ( i = 0; i < 5; i++ ) {
							scroll_draw(i + 5, IMAGE_FORE_3, 24 * i);
						}
						if ( st_step != 3 ) {
							for ( i = 0; i < 5; i++ ) {
								scroll_draw(i, IMAGE_FORE_2, -48 + 48 * i + 48 * (5 - i) * (100 - st_coef) / 100 - ((100 - st_coef) * 240) / 100);
							}
						}
						break;
					}
					break;
				}

				for ( i = awa.size() - 1; i >= 0; i-- ) {
					Awa tmp = (Awa)awa.elementAt(i);
					tmp.draw();
				}
				for ( i = burst.size() - 1; i >= 0; i-- ) {
					Burst tmp = (Burst)burst.elementAt(i);
					tmp.draw();
				}
				for ( i = enemy.size() - 1; i >= 0; i-- ) {
					Enemy tmp = (Enemy)enemy.elementAt(i);
					tmp.draw();
				}
				if ( (jiki._life > 0) && (_target > 0) ) {
					if ( level > 2 ) {
						drawImage(g, use_image(IMAGE_SHOT), _target_x - 16, _target_y - 16, 96, 9, 32, 32);
					} else {
						drawImage(g, use_image(IMAGE_SHOT), _target_x - 16, _target_y - 16, 96 + ((_target - 1) * 32), 9, 32, 32);
					}
				}
				jiki.draw();
				for ( i = jshot.size() - 1; i >= 0; i-- ) {
					JikiShot tmp = (JikiShot)jshot.elementAt(i);
					tmp.draw_back();
				}
				for ( i = jshot.size() - 1; i >= 0; i-- ) {
					JikiShot tmp = (JikiShot)jshot.elementAt(i);
					tmp.draw_fore();
				}
				for ( i = spark.size() - 1; i >= 0; i-- ) {
					Spark tmp = (Spark)spark.elementAt(i);
					tmp.draw();
				}
				for ( i = eshot.size() - 1; i >= 0; i-- ) {
					EnemyShot tmp = (EnemyShot)eshot.elementAt(i);
					if ( tmp._color < 3 ) {
						tmp.draw();
					}
				}
				for ( i = eshot.size() - 1; i >= 0; i-- ) {
					EnemyShot tmp = (EnemyShot)eshot.elementAt(i);
					if ( tmp._color == 3 ) {
						tmp.draw();
					}
				}

				// XRA`
				{
					boolean top = true;
					if ( jiki.cy() < 120 ) {
						top = false;
					}
					g.setColor(COLOR_W);
					drawString("Score", FONT_TINY, 0, top ? 12 : 240);
					drawString("" + score, FONT_TINY, -120, top ? 12 : 240);
					g.drawRect(0, top ? 13 : 222, 121, 4);
					g.drawRect(0, top ? 20 : 215, 121, 4);
					if ( jiki._life > 0 ) {
						g.setColor(COLOR_C);
						g.fillRect(1, top ? 14 : 223, 120 * jiki._life / JIKI_LIFE_MAX, 3);
					}
					if ( jiki._special_power > 0 ) {
						if ( (jiki._special_power == SPECIAL_POWER_MAX) || jiki._special ) {
							setCMYColor(elapse() % 3);
						} else {
							g.setColor(COLOR_M);
						}
						g.fillRect(1, top ? 21 : 216, 120 * jiki._special_power / SPECIAL_POWER_MAX, 3);
					}
					if ( (state == STATE_PLAY_BOSS) || (state == STATE_PLAY_BOSS2) ) {
						if ( state == STATE_PLAY_BOSS2 ) {
							g.setColor(COLOR_W);
							switch ( st_index ) {
							case 0:
								drawString("Ray", FONT_TINY, -1, top ? 12 : 240);
								break;
							case 1:
								drawString("Rax", FONT_TINY, -1, top ? 12 : 240);
								break;
							}
						}
						if ( (state == STATE_PLAY_BOSS2) || (enemy.size() > 0) ) {
							g.setColor(COLOR_W);
							g.drawRect(138, top ? 13 : 222, 101, 4);
						}
						if ( enemy.size() > 0 ) {
							Enemy tmp = (Enemy)enemy.elementAt(0);
							if ( tmp._life > 0 ) {
								g.setColor(COLOR_Y);
								g.fillRect(139, top ? 14 : 223, 100 * tmp._life / tmp._life_max, 3);
							}
						}
					}
				}

				// |[Y̕`
				if ( pause ) {
					if ( ((m_elapse_p / WAIT_H) % 2) == 0 ) {
						g.setColor(COLOR_Y);
						centerDrawString("o`trd", FONT_SMALL, 110);
						centerDrawString("[1]L[ōĊJ", FONT_SMALL, 170);
						centerDrawString("[3]L[Œf", FONT_SMALL, 190);
					}
				}

				g.unlock(true);

if ( !pause ) {
				for ( i = jshot.size() - 1; i >= 0; i-- ) {
					JikiShot tmp_s = (JikiShot)jshot.elementAt(i);

					// eƓGeƂ̓蔻
					if ( (tmp_s._type == JSHOT_SPECIAL) || (tmp_s._type == JSHOT_SWORD_F) || (tmp_s._type == JSHOT_SWORD_B) ) {
						for ( j = eshot.size() - 1; j >= 0; j-- ) {
							EnemyShot tmp_e = (EnemyShot)eshot.elementAt(j);
							if (
							(tmp_s.left  () <= tmp_e.right ()) &&
							(tmp_s.top   () <= tmp_e.bottom()) &&
							(tmp_s.right () >= tmp_e.left  ()) &&
							(tmp_s.bottom() >= tmp_e.top   ())
							) {
								eshot.removeElementAt(j);
								need_gc = true;
							}
						}
					}

					// eƓGƂ̓蔻
					for ( int k = 0; k < 2; k++ ) {
						for ( j = enemy.size() - 1; j >= 0; j-- ) {
							Enemy tmp_e = (Enemy)enemy.elementAt(j);
							if ( !(tmp_e.destroyed()) ) {
								if (
								((k == 0) &&   tmp_e._lock ) ||
								((k == 1) && !(tmp_e._lock))
								) {
									if (
									(tmp_s.left  () <= tmp_e.right ()) &&
									(tmp_s.top   () <= tmp_e.bottom()) &&
									(tmp_s.right () >= tmp_e.left  ()) &&
									(tmp_s.bottom() >= tmp_e.top   ())
									) {
										if ( tmp_s._color == tmp_e._color ) {
											tmp_e.damage(tmp_s._power * 2);
											if ( tmp_s._type == JSHOT_SPECIAL ) {
												add_score(tmp_s._power * 20);
											} else {
												add_score(tmp_s._power * 2);
											}
										} else {
											tmp_e.damage(tmp_s._power);
											if ( tmp_s._type == JSHOT_SPECIAL ) {
												add_score(tmp_s._power * 10);
											} else {
												add_score(tmp_s._power);
											}
										}
										if ( !(tmp_e.destroyed()) ) {
											spark.addElement(new Spark((tmp_s.left() + tmp_s.right()) / 2, (tmp_s.top() + tmp_s.bottom()) / 2, tmp_s._color));
										} else if ( state != STATE_PLAY_BOSS2 ) {
											burst.addElement(new Burst(tmp_e.cx(), tmp_e.cy()));
											enemy.removeElementAt(j);
											need_gc = true;
										}
										if ( (tmp_s._type != JSHOT_SWORD_F) && (tmp_s._type != JSHOT_SWORD_B) ) {
											jshot.removeElementAt(i);
											need_gc = true;
											break;
										}
									}
								}
							}
						}
						if ( j >= 0 ) {
							break;
						}
					}
				}

				// @ƓGeƂ̓蔻
				if ( jiki._life > 0 ) {
					for ( i = eshot.size() - 1; i >= 0; i-- ) {
						EnemyShot tmp_e = (EnemyShot)eshot.elementAt(i);
						if (
						(jiki.h_left  () <= tmp_e.right ()) &&
						(jiki.h_top   () <= tmp_e.bottom()) &&
						(jiki.h_right () >= tmp_e.left  ()) &&
						(jiki.h_bottom() >= tmp_e.top   ())
						) {
							if ( jiki._color == tmp_e._color ) {
								jiki.add_special_power();
							} else {
								spark.addElement(new Spark(jiki.cx(), jiki.cy(), tmp_e._color));
								if ( !jiki.check_muteki() ) {
									jiki.damage(tmp_e.cx(), tmp_e.cy());
								}
							}
							eshot.removeElementAt(i);
							need_gc = true;
							break;
						}
					}
				}

				if (
				(script_reader == null) &&
				(enemy.size() == 0) &&
				(eshot.size() == 0) &&
				(burst.size() == 0)
				) {
					switch ( state ) {
					case STATE_PLAY_MAIN:
						set_state(STATE_PLAY_BOSS);
						break;
					case STATE_PLAY_BOSS:
						set_state(STATE_PLAY_LOAD2);
						break;
					case STATE_PLAY_MAIN2:
						set_state(STATE_PLAY_BOSS2);
						break;
					case STATE_PLAY_BOSS2:
						set_state(STATE_PLAY_CLEAR);
						break;
					}
				}
}
				break;
			case STATE_PLAY_CLEAR:
				g.lock();
				switch ( st_index ) {
				case 0:
					drawImage(g, use_image(IMAGE_RAY), 0, 0);
					break;
				case 1:
					drawImage(g, use_image(IMAGE_RAX), 0, 0);
					break;
				}
				if ( disp_score ) {
					drawImage(g, use_image(IMAGE_MASK), 0, 0);
					setCMYColor(elapse() % 3);
					centerDrawString("r@b", FONT_SMALL, 60);
					g.setColor(COLOR_W);
					drawString("XRA", FONT_SMALL, -100, 110);
					drawString("" + score_d, FONT_SMALL, -40, 110);
					drawString("Ct{[iX", FONT_SMALL, -100, 130);
					if ( jiki._life > 0 ) {
						drawString("" + (jiki._life * 1000), FONT_SMALL, -40, 130);
					} else {
						drawString("0", FONT_SMALL, -40, 130);
					}
					g.setColor(COLOR_Y);
					drawString("g[^", FONT_SMALL, -100, 150);
					drawString("" + score, FONT_SMALL, -40, 150);
					if ( !first && (score == hi_score[level][st_index]) ) {
						centerDrawString("nCXRAXV!", FONT_SMALL, 175);
					}
					centerDrawString("[1]L[Ă", FONT_TINY, 220);
				}
				g.unlock(true);
				break;
			case STATE_PLAY_GAMEOVER:
				g.lock();
				g.setColor(COLOR_K);
				g.fillRect(0, 0, 240, 240);
				g.setColor(COLOR_Y);
				centerDrawString("f@n", FONT_SMALL, 60);
				g.setColor(COLOR_W);
				centerDrawString("XRA@" + score, FONT_SMALL, 110);
				g.setColor(COLOR_Y);
				if ( !first && (score == hi_score[level][st_index]) ) {
					centerDrawString("nCXRAXV!", FONT_SMALL, 135);
				}
				centerDrawString("[1]L[Ă", FONT_TINY, 220);
				g.unlock(true);
				break;
			}

			if ( need_gc ) {
				System.gc();
			}

			if ( pause ) {
				m_elapse_p++;
			} else {
				m_elapse++;
			}

			unlock_state();
		}

		/**
		 * L[͏
		 */
		public void processEvent(int type, int param) {
			if ( processingEvent ) return;
			processingEvent = true;

			if( type == Display.KEY_PRESSED_EVENT ) {
				switch ( state ) {
				case STATE_DOWNLOAD:
					break;
				case STATE_DOWNLOADERROR:
					switch ( param ) {
					case Display.KEY_SOFT2:
						IApplication.getCurrentApp().terminate();
						break;
					}
					break;
				case STATE_LAUNCH:
					break;
				case STATE_TITLE:
					switch ( param ) {
					case Display.KEY_SOFT1:
						lock_state();
						set_state(STATE_HELP);
						unlock_state();
						break;
					case Display.KEY_SOFT2:
						IApplication.getCurrentApp().terminate();
						break;
					case Display.KEY_LEFT:
						level--; if ( level < 0 ) level = extra() ? 5 : 1;
						break;
					case Display.KEY_RIGHT:
						level++; if ( level > (extra() ? 5 : 1) ) level = 0;
						break;
					case Display.KEY_SELECT:
						lock_state();
						set_state(STATE_SELECTSTAGE);
						unlock_state();
						break;
					}
					break;
				case STATE_HELP:
					switch ( param ) {
					case Display.KEY_SOFT1:
						lock_state();
						set_state(STATE_TITLE);
						unlock_state();
						break;
					case Display.KEY_SOFT2:
						IApplication.getCurrentApp().terminate();
						break;
					case Display.KEY_UP:
						help--; if ( help < 0 ) help = 0;
						break;
					case Display.KEY_DOWN:
						help++; if ( help > 7 ) help = 7;
						break;
					}
					break;
				case STATE_SELECTSTAGE2:
					switch ( param ) {
					case Display.KEY_SOFT1:
						lock_state();
						set_state(STATE_TITLE);
						unlock_state();
						break;
					case Display.KEY_SOFT2:
						IApplication.getCurrentApp().terminate();
						break;
					case Display.KEY_LEFT:
						st_index--; if ( st_index < 0 ) st_index = 0;
						break;
					case Display.KEY_RIGHT:
						st_index++; if ( st_index >= STAGE_NUM ) st_index = STAGE_NUM - 1;
						break;
					}
					break;
				case STATE_PLAY_MAIN:
				case STATE_PLAY_BOSS:
				case STATE_PLAY_MAIN2:
				case STATE_PLAY_BOSS2:
					switch ( param ) {
					case Display.KEY_1:
						lock_state();
						pause = pause ? false : true;
						unlock_state();
						if ( pause ) {
							m_elapse_p = 0;
						}
						canvas.setSoftLabel(Frame.SOFT_KEY_2, pause ? "EXIT" : "");
						break;
					case Display.KEY_3:
						if ( pause ) {
							lock_state();
							dispose_image();
							save_config();
							set_state(STATE_TITLE);
							unlock_state();
							break;
						}
						// ̂܂܉ɗ
					case Display.KEY_2:
					case Display.KEY_ASTERISK:
					case Display.KEY_0:
					case Display.KEY_POUND:
						if ( !pause ) {
							_target = 0;
							for ( int i = enemy.size() - 1; i >= 0; i-- ) {
								Enemy tmp = (Enemy)enemy.elementAt(i);
								if ( tmp._lock ) {
									tmp._lock = false;
									break;
								}
							}
							if ( !(jiki.check_special()) ) {
								lock_enemy();
							}
						}
						break;
					case Display.KEY_SOFT1:
					case Display.KEY_4:
					case Display.KEY_7:
						if ( !pause ) {
							if ( jiki._color == 0 ) {
								jiki.special();
							} else {
								jiki.color(0);
							}
						}
						break;
					case Display.KEY_SELECT:
					case Display.KEY_5:
					case Display.KEY_8:
						if ( !pause ) {
							if ( jiki._color == 1 ) {
								jiki.special();
							} else {
								jiki.color(1);
							}
						}
						break;
					case Display.KEY_SOFT2:
						if ( pause ) {
							dispose_image();
							save_config();
							IApplication.getCurrentApp().terminate();
							break;
						}
						// ̂܂܉ɗ
					case Display.KEY_6:
					case Display.KEY_9:
						if ( !pause ) {
							if ( jiki._color == 2 ) {
								jiki.special();
							} else {
								jiki.color(2);
							}
						}
						break;
					}
					break;
				case STATE_PLAY_CLEAR:
				case STATE_PLAY_GAMEOVER:
					switch ( param ) {
					case Display.KEY_1:
						lock_state();
						set_state(STATE_TITLE);
						unlock_state();
						break;
					case Display.KEY_3:
						disp_score = disp_score ? false : true;
						break;
					}
					break;
				}
			}

			processingEvent = false;
		}
	}

	/**
	 * e
	 */
	public class JikiShot extends Object {
		int _type;
		int _x0, _y0;	// ˈʒu
		int _x1, _y1;	// ڕWʒu
		int _x, _y;		// ݈ʒu
		int _color;		// F
		int _power;		// U
		int _elapse;	// oߎ
		JikiShot(int type, int x, int y) {
			_type = type;
			switch ( _type ) {
			case JSHOT_NORMAL:
				_x0 = jiki.cx() - 6;
				_y0 = jiki.cy() - 6;
				_x1 = x - 6;
				_y1 = y - 6;
				_power = 1;
				break;
			case JSHOT_SPECIAL:
				_x0 = jiki.cx() - 12;
				_y0 = jiki.cy() - 12;
				_x1 = x - 12;
				_y1 = y - 12;
				_power = 5;
				break;
			case JSHOT_SWORD_F:
				_x0 = jiki.cx() - 15;
				_y0 = jiki.cy() - 20;
				_x1 = _x0;
				_y1 = _y0;
				_power = 5;
				break;
			case JSHOT_SWORD_B:
				_x0 = jiki.cx() - 25;
				_y0 = jiki.cy() - 20;
				_x1 = _x0;
				_y1 = _y0;
				_power = 5;
				break;
			}
			_x = _x0;
			_y = _y0;
			_color = jiki._color;
			_elapse = 0;
		}
		public int left() {
			switch ( _type ) {
			case JSHOT_NORMAL : return _x;
			case JSHOT_SPECIAL: return _x - 4;
			case JSHOT_SWORD_F:
			case JSHOT_SWORD_B:
				return _x - 2;
			}
			return 0;
		}
		public int top() {
			switch ( _type ) {
			case JSHOT_NORMAL : return _y;
			case JSHOT_SPECIAL: return _y - 4;
			case JSHOT_SWORD_F:
			case JSHOT_SWORD_B:
				return _y - 2;
			}
			return 0;
		}
		public int right() {
			switch ( _type ) {
			case JSHOT_NORMAL : return _x + 11;
			case JSHOT_SPECIAL: return _x + 27;
			case JSHOT_SWORD_F:
			case JSHOT_SWORD_B:
				return _x + 41;
			}
			return 0;
		}
		public int bottom() {
			switch ( _type ) {
			case JSHOT_NORMAL : return _y + 11;
			case JSHOT_SPECIAL: return _y + 27;
			case JSHOT_SWORD_F:
			case JSHOT_SWORD_B:
				return _y + 41;
			}
			return 0;
		}
		public boolean update() {
			_elapse++;
			switch ( _type ) {
			case JSHOT_NORMAL:
				move(_x0, _y0, _x1, _y1, _elapse * 24);
				_x = move_x();
				_y = move_y();
				if ( (_x < -12) || (_x > 240) || (_y < -12) || (_y > 240) ) {
					return false;
				}
				if ( _elapse == 1 ) {
					spark.addElement(new Spark(_x + 6, _y + 6, _color));
				}
				break;
			case JSHOT_SPECIAL:
				move(_x0, _y0, _x1, _y1, _elapse * 24);
				_x = move_x();
				_y = move_y();
				if ( (_x < -24) || (_x > 240) || (_y < -24) || (_y > 240) ) {
					return false;
				}
				if ( _elapse == 1 ) {
					spark.addElement(new Spark(_x + 12, _y + 12, _color));
				}
				break;
			case JSHOT_SWORD_F:
			case JSHOT_SWORD_B:
				if ( _elapse > 2 ) {
					return false;
				}
				break;
			}
			return true;
		}
		public void draw_back() {
			switch ( _type ) {
			case JSHOT_NORMAL:
				drawImage(g, use_image(IMAGE_SHOT), _x, _y, ((_elapse / 2) % 2) * 36 + 12 * _color, 0, 12, 12);
				break;
			case JSHOT_SPECIAL:
				drawImage(g, use_image(IMAGE_SHOT), _x, _y, 24 * _color, 12, 24, 24);
				move(_x0, _y0, _x1, _y1, _elapse * 24 + 12);
				drawImage(g, use_image(IMAGE_SHOT), move_x(), move_y(), 24 * _color, 12, 24, 24);
				break;
			case JSHOT_SWORD_F:
				drawImage(g, use_image(IMAGE_SHOT), _x, _y, 40 * _color, 48 + (_elapse - 1) * 40, 40, 40);
				break;
			case JSHOT_SWORD_B:
				drawImage(g, use_image(IMAGE_SHOT), _x, _y, 40 * _color, 128 + (_elapse - 1) * 40, 40, 40);
				break;
			}
		}
		public void draw_fore() {
			if ( _type == JSHOT_SPECIAL ) {
				drawImage(g, use_image(IMAGE_SHOT), _x, _y, 72, 12, 24, 24);
				move(_x0, _y0, _x1, _y1, _elapse * 24 + 12);
				drawImage(g, use_image(IMAGE_SHOT), move_x(), move_y(), 72, 12, 24, 24);
			}
#ifdef DEBUG
			g.setColor(COLOR_Y);
			g.drawRect(left(), top(), right() - left(), bottom() - top());
#endif // DEBUG
		}
	}

	/**
	 * Ge
	 */
	public class EnemyShot extends Object {
		int _type;
		int _x0, _y0;	// ˈʒu
		int _x1, _y1;	// ڕWʒu
		int _x, _y;		// ݈ʒu
		int _color;		// F
		int _speed;		// 
		int _elapse;	// oߎ
		EnemyShot(int type, int x0, int y0, int x1, int y1, int color, int speed) {
			_type = type;
			switch ( _type ) {
			case ESHOT_NORMAL:
				_x0 = x0 - 4;
				_y0 = y0 - 4;
				_x1 = x1 - 4;
				_y1 = y1 - 4;
				_color = 3;
				break;
			case ESHOT_SMALL:
				_x0 = x0 - 6;
				_y0 = y0 - 6;
				_x1 = x1 - 6;
				_y1 = y1 - 6;
				_color = color;
				break;
			case ESHOT_LARGE:
				_x0 = x0 - 12;
				_y0 = y0 - 12;
				_x1 = x1 - 12;
				_y1 = y1 - 12;
				_color = color;
				break;
			}
			_x = _x0;
			_y = _y0;
			_speed = speed;
			_elapse = 0;
		}
		public int left() {
			switch ( _type ) {
			case ESHOT_NORMAL: return _x;
			case ESHOT_SMALL : return _x;
			case ESHOT_LARGE : return _x;
			}
			return 0;
		}
		public int top() {
			switch ( _type ) {
			case ESHOT_NORMAL: return _y;
			case ESHOT_SMALL : return _y;
			case ESHOT_LARGE : return _y;
			}
			return 0;
		}
		public int right() {
			switch ( _type ) {
			case ESHOT_NORMAL: return _x + 7;
			case ESHOT_SMALL : return _x + 11;
			case ESHOT_LARGE : return _x + 23;
			}
			return 0;
		}
		public int bottom() {
			switch ( _type ) {
			case ESHOT_NORMAL: return _y + 7;
			case ESHOT_SMALL : return _y + 11;
			case ESHOT_LARGE : return _y + 23;
			}
			return 0;
		}
		public int cx() { return (left() + right()) / 2; }
		public int cy() { return (top() + bottom()) / 2; }
		public boolean update() {
			_elapse++;
			move(_x0, _y0, _x1, _y1, _elapse * _speed);
			_x = move_x();
			_y = move_y();
			switch ( _type ) {
			case ESHOT_NORMAL:
				if ( (_x < -28) || (_x > 260) || (_y < -28) || (_y > 260) ) {
					return false;
				}
				break;
			case ESHOT_SMALL:
				if ( (_x < -32) || (_x > 260) || (_y < -32) || (_y > 260) ) {
					return false;
				}
				break;
			case ESHOT_LARGE:
				if ( (_x < -44) || (_x > 260) || (_y < -44) || (_y > 260) ) {
					return false;
				}
				break;
			}
			return true;
		}
		public void draw() {
			switch ( _type ) {
			case ESHOT_NORMAL:
				drawImage(g, use_image(IMAGE_SHOT), _x, _y, 36 + 8 * (elapse() % 3), 36, 8, 8);
				break;
			case ESHOT_SMALL:
				drawImage(g, use_image(IMAGE_SHOT), _x, _y, 12 * _color, 36, 12, 12);
				break;
			case ESHOT_LARGE:
				drawImage(g, use_image(IMAGE_SHOT), _x, _y, 24 * _color, 12, 24, 24);
				break;
			}
#ifdef DEBUG
			g.setColor(COLOR_Y);
			g.drawRect(left(), top(), right() - left(), bottom() - top());
#endif // DEBUG
		}
	}

	/**
	 * Ή
	 */
	class Spark extends Object {
		int _x0, _y0;	// ˈʒu
		int _x1, _y1;	// ڕWʒu
		int _x, _y;		// ݈ʒu
		int _color;		// F
		int _elapse;	// oߎ
		Spark(int x0, int y0, int color) {
			_x0 = x0;
			_y0 = y0;
			_x1 = 120 + (rand.nextInt() % 120);
			_y1 = 120 + (rand.nextInt() % 120);
			_x = _x0;
			_y = _y0;
			_color = color;
			_elapse = 0;
			if ( _color > 2 ) {
				_color = (rand.nextInt() % 2) + 1;
			}
		}
		public boolean update() {
			_elapse++;
			if ( _elapse > 6 ) {
				return false;
			}
			move(_x0, _y0, _x1, _y1, _elapse * 5);
			_x = move_x();
			_y = move_y();
			return true;
		}
		public void draw() {
			switch ( _elapse ) {
			case 1:
			case 2:
				drawImage(g, use_image(IMAGE_SHOT), _x - 5, _y - 5,  72 + 9 * _color, 0, 9, 9);
				break;
			case 3:
			case 4:
				drawImage(g, use_image(IMAGE_SHOT), _x - 3, _y - 3,  99 + 6 * _color, 0, 6, 6);
				break;
			case 5:
			case 6:
				drawImage(g, use_image(IMAGE_SHOT), _x - 1, _y - 1, 117 + 3 * _color, 0, 3, 3);
				break;
			}
		}
	}

	/**
	 * A
	 */
	class Awa extends Object {
		int _x0, _y0;	// ˈʒu
		int _x1, _y1;	// ڕWʒu
		int _x, _y;		// ݈ʒu
		int _elapse;	// oߎ
		Awa(int x0, int y0) {
			y0 += rand.nextInt() % 12;
			_x0 = x0;
			_y0 = y0;
			_x1 = (rand.nextInt() % 60) - 120;
			_y1 = (rand.nextInt() % 60) - 120;
			_x = _x0;
			_y = _y0;
			_elapse = 0;
		}
		public boolean update() {
			_elapse++;
			move(_x0, _y0, _x1, _y1, _elapse * 20);
			_x = move_x();
			_y = move_y();
			if ( (_x < -12) || (_y < -12) ) {
				return false;
			}
			return true;
		}
		public void draw() {
			if ( _elapse < 5 ) {
				drawImage(g, use_image(IMAGE_AWA), _x - 12, _y - 12, 0, 0, 24, 24);
			} else if ( _elapse < 10 ) {
				drawImage(g, use_image(IMAGE_AWA), _x - 12, _y - 12, 24, 0, 24, 24);
			} else {
				drawImage(g, use_image(IMAGE_AWA), _x - 12, _y - 12, 48, 0, 24, 24);
			}
		}
	}

	/**
	 * 
	 */
	class Burst extends Object {
		int _x, _y;
		int _elapse;
		Burst(int x, int y) {
			_x = x - 30;
			_y = y - 30;
			_elapse = -1;
		}
		public boolean update() {
			_elapse++;
			if ( _elapse > 5 ) {
				return false;
			}
			return true;
		}
		public void draw() {
			drawImage(g, use_image(IMAGE_BAKU), _x, _y, 60 * (_elapse / 2), 0, 60, 60);
		}
	}

	/**
	 * @
	 */
	class Jiki {
		boolean _first;
		int _x0, _y0;
		int _x1, _y1;
		int _x, _y;		// ʒu
		int _color;
		int _life;
		int _muteki;
		boolean _damage;
		int _elapse;
		int _special_power;
		boolean _special;
		boolean _special2;
		int _special_x, _special_y;

		/**
		 * RXgN^
		 */
		Jiki() {
			_first = true;
			_x = -32;
			_y = 104;
			_color = 0;
			_life = JIKI_LIFE_MAX;
			_muteki = WAIT_1;
			_damage = false;
			_special_power = 0;
			_special = false;
			_special2 = false;
		}

		/**
		 * ړ
		 */
		public void down() {
			if ( !_first && !_special && !_special2 && !_damage ) {
				_y += 8; if ( _y > 208 ) _y = 208;
			}
		}

		/**
		 * ړ
		 */
		public void left() {
			if ( !_first && !_special && !_special2 && !_damage ) {
				_x -= 8; if ( _x < 0 ) _x = 0;
			}
		}

		/**
		 * Eړ
		 */
		public void right() {
			if ( !_first && !_special && !_special2 && !_damage ) {
				_x += 8; if ( _x > 208 ) _x = 208;
			}
		}

		/**
		 * ړ
		 */
		public void up() {
			if ( !_first && !_special && !_special2 && !_damage ) {
				_y -= 8; if ( _y < 0 ) _y = 0;
			}
		}

		/**
		 * Fݒ肷
		 */
		public void color(int col) {
			if ( !_special && !_special2 ) {
				_color = col;
			}
		}

		/**
		 * XV
		 */
		public void update() {
			if ( _first ) {
				_x += _muteki;
				_muteki--;
				if ( _muteki == 0 ) {
					_first = false;
				}
			} else {
				// XyVU...
				if ( _special ) {
					jshot.addElement(new JikiShot(JSHOT_SPECIAL, _special_x, _special_y));
					_special_power--;
					if ( _special_power <= 0 ) {
						_special = false;
					}
				} else if ( _special2 ) {
					_elapse++;
					if ( _elapse <= 3 ) {
						move(_x0, _y0, _special_x, _special_y, _elapse * 10);
						_x = move_x() - 16;
						_y = move_y() - 16;
						if ( _x <   0 ) _x =   0;
						if ( _x > 208 ) _x = 208;
						if ( _y <   0 ) _y =   0;
						if ( _y > 208 ) _y = 208;
					}
					if ( _elapse == 3 ) {
						if ( cx() < _special_x ) {
							jshot.addElement(new JikiShot(JSHOT_SWORD_F, _special_x, _special_y));
						} else {
							jshot.addElement(new JikiShot(JSHOT_SWORD_B, _special_x, _special_y));
						}
					}
					if ( _elapse >= 6 ) {
						_special2 = false;
					}
				}

				// _[W̏ꍇ...
				if ( _damage ) {
					if ( _life == 0 ) {
						_elapse++;
						move(_x0, _y0, _x1, _y1, _elapse * 5);
						_x = move_x();
						_y = move_y();
						if ( _x < -32 ) {
							_life--;
						}
					} else {
						_elapse++;
						move(_x0, _y0, _x1, _y1, _elapse * 10);
						_x = move_x();
						_y = move_y();
						if ( _x <   0 ) _x =   0;
						if ( _x > 208 ) _x = 208;
						if ( _y <   0 ) _y =   0;
						if ( _y > 208 ) _y = 208;
						if ( _elapse > 2 ) {
							_damage = false;

							// GԂɂ
							muteki();
						}
					}
				}

				// G̏ꍇ...
				if ( _muteki > 0 ) {
					_muteki--;
				}
			}
		}

		// Gǂ`FbN
		public boolean check_muteki() { return ((_muteki > 0) || _special) ? true : false; }

		// XyVUǂ`FbN
		public boolean check_special() { return (_special || _special2) ? true : false; }

		// 蔻̈擾
		public int h_left  () { return _x +  8; }
		public int h_top   () { return _y +  8; }
		public int h_right () { return _x + 23; }
		public int h_bottom() { return _y + 23; }

		// ʒumF
		public int x () { return _x; }
		public int y () { return _y; }
		public int cx() { return _x + 16; }
		public int cy() { return _y + 16; }

		/**
		 * _[W̃gK[
		 */
		public void damage(int sx, int sy) {
			if ( _damage || (_muteki > 0) ) return;
#ifndef DEBUG
			_life--;
#endif // DEBUG
			_x0 = _x;
			_y0 = _y;
			if ( _life > 0 ) {
				_x1 = _x0 - (sx - cx());
				_y1 = _y0 - (sy - cy());
			} else {
				_x1 = -120;
				_y1 = (rand.nextInt() % 120) + 120;
			}
			_elapse = 0;
			_damage = true;
			_special2 = false;
		}

		/**
		 * G̃gK[
		 */
		public void muteki() {
			_muteki = WAIT_1;
		}

		public void add_special_power() {
			_special_power++;
			if ( _special_power > SPECIAL_POWER_MAX ) {
				_special_power = SPECIAL_POWER_MAX;
			}
		}

		/**
		 * XyVŨgK[
		 */
		public void special() {
			if ( (_life == 0) || _special || _special2 || (_target == 0) ) return;

			if ( _target == 2 ) {
				_special2 = true;
				_x0 = _x + 16;
				_y0 = _y + 16;
				_elapse = 0;
			} else {
				if ( _special_power < SPECIAL_POWER_MAX ) {
					return;
				}
				_special = true;
			}
			_special_x = _target_x;
			_special_y = _target_y;

			_muteki = 0;
			_damage = false;
		}

		/**
		 * `
		 */
		public void draw(int p, int i) {
			if ( p <= 9 ) {
				drawImage(g, use_image(i), _x, _y, 32 * p, 0, 32, 32);
			} else if ( p == 10 ) {
				g.setFlipMode(Graphics.FLIP_ROTATE_RIGHT);
				drawImage(g, use_image(i), _x, _y, 0, 0, 32, 32);
				g.setFlipMode(Graphics.FLIP_NONE);
			} else if ( p <= 20 ) {
				drawImage(g, use_image(i + 1), _x, _y, 32 * (p - 11), 0, 32, 32);
			} else if ( p <= 30 ) {
				g.setFlipMode(Graphics.FLIP_ROTATE_RIGHT);
				drawImage(g, use_image(i + 1), _x, _y, 32 * (p - 21), 0, 32, 32);
				g.setFlipMode(Graphics.FLIP_NONE);
			} else {
				g.setFlipMode(Graphics.FLIP_ROTATE_LEFT);
				drawImage(g, use_image(i), _x, _y, 32 * (p - 30), 0, 32, 32);
				g.setFlipMode(Graphics.FLIP_NONE);
			}
		}
		public void draw() {
			// V[h̕\
			drawImage(g, use_image(IMAGE_SHIELD), _x, _y, 32 * _color, 0, 32, 32);

			if ( (_muteki == 0) || ((elapse() % 2) > 0) ) {
				if ( _special ) {
					draw(pattern(cx(), cy(), _special_x, _special_y), IMAGE_JIKI_3);
				} else if ( _special2 ) {
					if ( cx() < _special_x ) {
						switch ( _elapse ) {
						case 1 : drawImage(g, use_image(IMAGE_JIKI_4), _x, _y - 14,  0, 0, 32, 50); break;
						case 2 : drawImage(g, use_image(IMAGE_JIKI_4), _x, _y - 14, 32, 0, 32, 50); break;
						default: drawImage(g, use_image(IMAGE_JIKI_4), _x, _y - 14, 64, 0, 32, 50); break;
						}
					} else {
						g.setFlipMode(Graphics.FLIP_HORIZONTAL);
						switch ( _elapse ) {
						case 1 : drawImage(g, use_image(IMAGE_JIKI_4), _x, _y - 14,  0, 0, 32, 50); break;
						case 2 : drawImage(g, use_image(IMAGE_JIKI_4), _x, _y - 14, 32, 0, 32, 50); break;
						default: drawImage(g, use_image(IMAGE_JIKI_4), _x, _y - 14, 64, 0, 32, 50); break;
						}
						g.setFlipMode(Graphics.FLIP_NONE);
					}
				} else if ( _life == 0 ) {
					switch ( _elapse % 4 ) {
					case 0: break;
					case 1: g.setFlipMode(Graphics.FLIP_ROTATE_LEFT ); break;
					case 2: g.setFlipMode(Graphics.FLIP_ROTATE      ); break;
					case 3: g.setFlipMode(Graphics.FLIP_ROTATE_RIGHT); break;
					}
					drawImage(g, use_image(IMAGE_JIKI_1), _x, _y, 64, 0, 32, 32);
					g.setFlipMode(Graphics.FLIP_NONE);
				} else if ( _target > 0 ) {
					draw(pattern(cx(), cy(), _target_x, _target_y), IMAGE_JIKI_2);
				} else {
					drawImage(g, use_image(IMAGE_JIKI_1), _x, _y, 32 * (elapse() % 2), 0, 32, 32);
				}
			}

#ifdef DEBUG
			g.setColor(COLOR_Y);
			g.drawRect(h_left(), h_top(), h_right() - h_left(), h_bottom() - h_top());
#endif // DEBUG
		}
	}

	/**
	 * G
	 */
	public class Enemy extends Object {
		// ʂ̕ϐ
		int _type;
		int _step;
		int _x0, _y0;
		int _x, _y;
		int _color;
		int _life_max, _life;
		int _elapse;
		int _elapse2;
		int _elapse3;
		boolean _lock;

		// ʂ̕ϐ
		int xx, yy;
		int x1, y1;
		boolean clockwise;
		int p0, p;
		int old_step;
		int shot;
		int sx0, sy0;
		int sx1, sy1;

		Enemy(int type, int x0, int y0, int color, int life) {
			_type = type;
			_step = 0;
			_x0 = x0;
			_y0 = y0;
			_x = _x0;
			_y = _y0;
			_color = color;
			_life_max = life;
			_life = _life_max;
			_elapse = 0;
			_elapse2 = 0;
			_elapse3 = 0;
			_lock = false;

			switch ( _type ) {
			case ENEMY_ZAKO_4:
				x1 = 120;
				y1 = y0;
				break;
			case ENEMY_BOSS_1:
				clockwise = (rand.nextInt() > 0) ? true : false;
				break;
			case ENEMY_RAX:
				shot = 0;
				break;
			}
		}
		public void next_step() {
			_step++;
			_elapse = 0;
		}
		public int left() {
			switch ( _type ) {
			case ENEMY_ZAKO_1: return _x;
			case ENEMY_ZAKO_2: return (_x0 < 0) ? _x : (_x + 32);
			case ENEMY_ZAKO_3: return _x;
			case ENEMY_ZAKO_4: return (_x0 > x1) ? _x : (_x + 8);
			case ENEMY_ZAKO_5: return _x;
			case ENEMY_BOSS_1: return _x + 20;
			case ENEMY_BOSS_2: return _x + 20;
			case ENEMY_RAY   : return _x + 10;
			case ENEMY_RAX   : return _x + 10;
			}
			return 0;
		}
		public int top() {
			switch ( _type ) {
			case ENEMY_ZAKO_1: return _y;
			case ENEMY_ZAKO_2: return _y;
			case ENEMY_ZAKO_3: return _y;
			case ENEMY_ZAKO_4: return _y;
			case ENEMY_ZAKO_5: return _y;
			case ENEMY_BOSS_1: return _y + 20;
			case ENEMY_BOSS_2: return _y + 20;
			case ENEMY_RAY   : return _y + 10;
			case ENEMY_RAX   : return _y + 10;
			}
			return 0;
		}
		public int right() {
			switch ( _type ) {
			case ENEMY_ZAKO_1: return _x + 31;
			case ENEMY_ZAKO_2: return _x + ((_x0 < 0) ? 31 : 63);
			case ENEMY_ZAKO_3: return _x + (((_x0 >= 0) && (_x0 < 240)) ? 15 : 79);
			case ENEMY_ZAKO_4: return _x + ((_x0 > x1) ? 31 : 39);
			case ENEMY_ZAKO_5: return _x + 39;
			case ENEMY_BOSS_1: return _x + 59;
			case ENEMY_BOSS_2: return _x + 59;
			case ENEMY_RAY   : return _x + 29;
			case ENEMY_RAX   : return _x + 53;
			}
			return 0;
		}
		public int bottom() {
			switch ( _type ) {
			case ENEMY_ZAKO_1: return _y + 31;
			case ENEMY_ZAKO_2: return _y + 31;
			case ENEMY_ZAKO_3: return _y + (((_x0 >= 0) && (_x0 < 240)) ? 79 : 15);
			case ENEMY_ZAKO_4: return _y + 31;
			case ENEMY_ZAKO_5: return _y + 49;
			case ENEMY_BOSS_1: return _y + 59;
			case ENEMY_BOSS_2: return _y + 59;
			case ENEMY_RAY   : return _y + 29;
			case ENEMY_RAX   : return _y + 53;
			}
			return 0;
		}
		public int cx() { return (left() + right()) / 2; }
		public int cy() { return (top() + bottom()) / 2; }
		public void damage(int cnt) {
			_life -= cnt;
			if ( _life <= 0 ) {
				_lock = false;
				add_score(_life_max);
			}
		}
		public boolean destroyed() { return (_life <= 0) ? true : false; }
		public boolean update() {
			_elapse++;
			switch ( _type ) {
			case ENEMY_ZAKO_1/*H`*/:
				if ( (level % 3) == 2 ) {
					_elapse2 += 2;
					if ( _elapse2 > 39 ) {
						_elapse2 -= 40;
					}
					eshot.addElement(new EnemyShot(ESHOT_SMALL, cx(), cy(), cx() + CIRCLE_X[_elapse2], cy() + CIRCLE_Y[_elapse2], _color, 8));
				}
				switch ( _step ) {
				case 0:
					if ( (_x0 >= 0) && (_x0 < 240) ) {
						if ( _y0 < 0 ) {
							_y += 6;
							if ( _y >= 28 ) {
								next_step();
							}
						} else {
							_y -= 6;
							if ( _y <= 180 ) {
								next_step();
							}
						}
					} else {
						if ( _x0 < 0 ) {
							_x += 6;
							if ( _x >= 28 ) {
								next_step();
							}
						} else {
							_x -= 6;
							if ( _x <= 180 ) {
								next_step();
							}
						}
					}
					break;
				case 1:
					if ( (_elapse % 10) == 1 ) {
						if ( (level % 3) < 2 ) {
							eshot.addElement(new EnemyShot(ESHOT_SMALL, cx(), cy(), jiki.cx(), jiki.cy(), _color, 12));
						}
						if ( (level % 3) >= 1 ) {
							eshot.addElement(new EnemyShot(ESHOT_NORMAL, cx(), cy(), jiki.cx(), jiki.cy(), 3, 6));
						}
					}
					if ( _elapse > 30 ) {
						next_step();
					}
					break;
				case 2:
					if ( (_x0 >= 0) && (_x0 < 240) ) {
						if ( _y0 < 0 ) {
							_y += 3;
							if ( _y >= 240 ) {
								return false;
							}
						} else {
							_y -= 3;
							if ( _y < -32 ) {
								return false;
							}
						}
					} else {
						if ( _x0 < 0 ) {
							_x += 3;
							if ( _x >= 240 ) {
								return false;
							}
						} else {
							_x -= 3;
							if ( _x < -32 ) {
								return false;
							}
						}
					}
					break;
				}
				break;
			case ENEMY_ZAKO_2/*Op*/:
				switch ( _step ) {
				case 0:
					if ( _x0 < 0 ) {
						_x += 12;
						if ( _x >= 176 ) {
							_step++;
						}
					} else {
						_x -= 12;
						if ( _x <= 0 ) {
							_step++;
						}
					}
					if ( (_elapse % 2) == 1 ) {
						if ( ((level % 3) == 2) && ((_elapse % 4) == 1) ) {
							eshot.addElement(new EnemyShot(ESHOT_NORMAL, cx(), cy(), cx(), -10, 3, 12));
							eshot.addElement(new EnemyShot(ESHOT_NORMAL, cx(), cy(), cx(), 250, 3, 12));
						} else {
							eshot.addElement(new EnemyShot(ESHOT_SMALL, cx(), cy(), cx(), -10, _color, 12));
							eshot.addElement(new EnemyShot(ESHOT_SMALL, cx(), cy(), cx(), 250, _color, 12));
						}
					}
					break;
				case 1:
					xx = jiki.cx();
					yy = jiki.cy();
					next_step();
					// ̂܂܉ɗ
				case 2:
					if ( (_elapse % 2) == 1 ) {
						if ( (level % 3) >= 1 ) {
							eshot.addElement(new EnemyShot(ESHOT_NORMAL, cx(), cy(), jiki.cx(), jiki.cy(), 3, 12));
						} else {
							eshot.addElement(new EnemyShot(ESHOT_NORMAL, cx(), cy(), xx, yy, 3, 12));
						}
					}
					if ( _elapse > 10 ) {
						next_step();
					}
					break;
				case 3:
					if ( _y0 < 104 ) {
						_y += 3;
						if ( _y >= 240 ) {
							return false;
						}
					} else {
						_y -= 3;
						if ( _y < -32 ) {
							return false;
						}
					}
					break;
				}
				break;
			case ENEMY_ZAKO_3/*˂炵*/:
				if ( (level % 3) == 2 ) {
					_elapse2++;
					if ( (_elapse2 % 3) == 1 ) {
						eshot.addElement(new EnemyShot(ESHOT_NORMAL, cx(), cy(), (rand.nextInt() % 120) + 120, (rand.nextInt() % 120) + 120, 3, 5));
					} else {
						eshot.addElement(new EnemyShot(ESHOT_SMALL, cx(), cy(), (rand.nextInt() % 120) + 120, (rand.nextInt() % 120) + 120, _color, 8));
					}
				}
				switch ( _step ) {
				case 0:
					if ( (_x0 >= 0) && (_x0 < 240) ) {
						if ( _y0 < 0 ) {
							_y += 12;
							if ( _y >= 160 ) {
								next_step();
							}
						} else {
							_y -= 12;
							if ( _y <= 0 ) {
								next_step();
							}
						}
					} else {
						if ( _x0 < 0 ) {
							_x += 12;
							if ( _x >= 160 ) {
								next_step();
							}
						} else {
							_x -= 12;
							if ( _x <= 0 ) {
								next_step();
							}
						}
					}
					break;
				case 1:
					if ( (level % 3) < 2 ) {
						if ( (_elapse % 3) == 1 ) {
							eshot.addElement(new EnemyShot(ESHOT_NORMAL, cx(), cy(), (rand.nextInt() % 120) + 120, (rand.nextInt() % 120) + 120, 3, 5));
						} else {
							eshot.addElement(new EnemyShot(ESHOT_SMALL, cx(), cy(), (rand.nextInt() % 120) + 120, (rand.nextInt() % 120) + 120, _color, 8));
						}
						if ( (level % 3) == 1 ) {
							if ( (_elapse % 4) == 1 ) {
								eshot.addElement(new EnemyShot(ESHOT_NORMAL, cx(), cy(), (rand.nextInt() % 120) + 120, (rand.nextInt() % 120) + 120, 3, 3));
							}
						}
					}
					if ( _elapse > 30 ) {
						next_step();
					}
					break;
				case 2:
					if ( (_x0 >= 0) && (_x0 < 240) ) {
						if ( _y0 < 0 ) {
							_y -= 12;
							if ( _y <= -80 ) {
								return false;
							}
						} else {
							_y += 12;
							if ( _y >= 240 ) {
								return false;
							}
						}
					} else {
						if ( _x0 < 0 ) {
							_x -= 12;
							if ( _x <= -80 ) {
								return false;
							}
						} else {
							_x += 12;
							if ( _x >= 240 ) {
								return false;
							}
						}
					}
					break;
				}
				break;
			case ENEMY_ZAKO_4/**/:
				if ( (level % 3) == 2 ) {
					_elapse2++;
					if ( (_elapse2 % 10) == 1 ) {
						eshot.addElement(new EnemyShot(ESHOT_NORMAL, cx(), cy(), jiki.cx(), jiki.cy(), 3, 8));
					}
				}
				switch ( _step ) {
				case 0:
					move(_x0, _y0, x1, y1, _elapse * 10);
					_x = move_x();
					_y = move_y();
					if ( _elapse > 6 ) {
						next_step();
					}
					break;
				case 1:
				case 3:
				case 5:
					if ( (_elapse % 10) == 1 ) {
						eshot.addElement(new EnemyShot(ESHOT_SMALL, cx(), cy(), jiki.cx(), jiki.cy(), _color, 12));
						if ( (level % 3) == 1 ) {
							eshot.addElement(new EnemyShot(ESHOT_NORMAL, cx(), cy(), jiki.cx(), jiki.cy(), 3, 6));
						}
					}
					if ( _elapse > 9 ) {
						_x0 = _x;
						_y0 = _y;
						x1 = jiki.cx();
						y1 = jiki.cy();
						next_step();
					}
					break;
				case 2:
				case 4:
					move(_x0, _y0, x1, y1, _elapse * 10);
					_x = move_x();
					_y = move_y();
					if ( _elapse > 10 ) {
						next_step();
					}
					break;
				case 6:
					move(_x0, _y0, x1, y1, _elapse * 10);
					_x = move_x();
					_y = move_y();
					if ( (_x < -40) || (_x > 240) || (_y < -40) || (_y > 240) ) {
						return false;
					}
					break;
				}
				break;
			case ENEMY_ZAKO_5/*lp*/:
				if ( (level % 3) == 2 ) {
					_elapse2++;
					if ( (_elapse2 % 3) == 1 ) {
						int x = cx();
						int y = cy();
						int dx = jiki.cx();
						int dy = jiki.cy();
						int w = (dx - x) / 10;
						int h = (dy - y) / 10;
						eshot.addElement(new EnemyShot(ESHOT_NORMAL, x, y, dx + h * 6, dy - w * 6, 3, 10));
						eshot.addElement(new EnemyShot(ESHOT_NORMAL, x, y, dx - h * 6, dy + w * 6, 3, 10));
					}
				}
				switch ( _step ) {
				case 0:
					if ( _x0 < 0 ) {
						_x += 3;
						if ( _x >= 5 ) {
							next_step();
						}
					} else {
						_x -= 3;
						if ( _x <= 195 ) {
							next_step();
						}
					}
					break;
				case 1:
					switch ( _elapse % 35 ) {
					case 1:
						xx = jiki.cx();
						yy = jiki.cy();
						// ̂܂܉ɗ
					case 3:
					case 5:
					case 7:
						eshot.addElement(new EnemyShot(ESHOT_SMALL, cx(), cy(), xx, yy, _color, 10));
						break;
					}
					if ( (level % 3) < 2 ) {
						if ( (_elapse % 45) == 1 ) {
							int x = cx();
							int y = cy();
							int dx = jiki.cx();
							int dy = jiki.cy();
							int w = (dx - x) / 10;
							int h = (dy - y) / 10;
							eshot.addElement(new EnemyShot(ESHOT_NORMAL, x, y, dx + h *  4, dy - w *  4, 3, 5));
							eshot.addElement(new EnemyShot(ESHOT_NORMAL, x, y, dx + h * 17, dy - w * 17, 3, 5));
							eshot.addElement(new EnemyShot(ESHOT_NORMAL, x, y, dx - h *  4, dy + w *  4, 3, 5));
							eshot.addElement(new EnemyShot(ESHOT_NORMAL, x, y, dx - h * 17, dy + w * 17, 3, 5));
							if ( (level % 3) == 1 ) {
								eshot.addElement(new EnemyShot(ESHOT_NORMAL, x, y, dx + h *  4, dy - w *  4, 3, 8));
								eshot.addElement(new EnemyShot(ESHOT_NORMAL, x, y, dx + h * 17, dy - w * 17, 3, 8));
								eshot.addElement(new EnemyShot(ESHOT_NORMAL, x, y, dx - h *  4, dy + w *  4, 3, 8));
								eshot.addElement(new EnemyShot(ESHOT_NORMAL, x, y, dx - h * 17, dy + w * 17, 3, 8));
							}
						}
					}
					if ( _elapse >= 100 ) {
						next_step();
					}
					break;
				case 2:
					if ( _x0 < 0 ) {
						_x -= 3;
						if ( _x <= -40 ) {
							return false;
						}
					} else {
						_x += 3;
						if ( _x >= 240 ) {
							return false;
						}
					}
					break;
				}
				break;
			case ENEMY_BOSS_1/*{XP*/:
				switch ( _step ) {
				case 0:
					_x -= 5;
					if ( _x <= 80 ) {
						next_step();
					}
					break;
				case 1:
					if ( _elapse > 10 ) {
						next_step();
					}
					break;
				case 2:
					if ( (_elapse % 2) == 1 ) {
						if ( clockwise ) {
							_elapse2++;
							if ( _elapse2 > 39 ) {
								_elapse2 -= 40;
							}
							if ( (level % 3) == 2 ) {
								_elapse3--;
								if ( _elapse3 < 0 ) {
									_elapse3 += 40;
								}
							}
						} else {
							_elapse2--;
							if ( _elapse2 < 0 ) {
								_elapse2 += 40;
							}
							if ( (level % 3) == 2 ) {
								_elapse3++;
								if ( _elapse3 > 39 ) {
									_elapse3 -= 40;
								}
							}
						}
						if ( (level % 3) == 2 ) {
							int a =  _elapse2           ;
							int b = (_elapse2 + 13) % 40;
							int c = (_elapse2 + 26) % 40;
							eshot.addElement(new EnemyShot(ESHOT_LARGE, 120 + CIRCLE_X[a] / 4, 120 + CIRCLE_Y[a] / 4, 120 + CIRCLE_X[a], 120 + CIRCLE_Y[a], _color, 6));
							eshot.addElement(new EnemyShot(ESHOT_LARGE, 120 + CIRCLE_X[b] / 4, 120 + CIRCLE_Y[b] / 4, 120 + CIRCLE_X[b], 120 + CIRCLE_Y[b], _color, 6));
							eshot.addElement(new EnemyShot(ESHOT_LARGE, 120 + CIRCLE_X[c] / 4, 120 + CIRCLE_Y[c] / 4, 120 + CIRCLE_X[c], 120 + CIRCLE_Y[c], _color, 6));
							a = (_elapse3 +  7) % 40;
							b = (_elapse3 + 20) % 40;
							c = (_elapse3 + 33) % 40;
							eshot.addElement(new EnemyShot(ESHOT_LARGE, 120 + CIRCLE_X[a] / 4, 120 + CIRCLE_Y[a] / 4, 120 + CIRCLE_X[a], 120 + CIRCLE_Y[a], _color, 6));
							eshot.addElement(new EnemyShot(ESHOT_LARGE, 120 + CIRCLE_X[b] / 4, 120 + CIRCLE_Y[b] / 4, 120 + CIRCLE_X[b], 120 + CIRCLE_Y[b], _color, 6));
							eshot.addElement(new EnemyShot(ESHOT_LARGE, 120 + CIRCLE_X[c] / 4, 120 + CIRCLE_Y[c] / 4, 120 + CIRCLE_X[c], 120 + CIRCLE_Y[c], _color, 6));
						} else {
							int a =  _elapse2           ;
							int b = (_elapse2 + 10) % 40;
							int c = (_elapse2 + 20) % 40;
							int d = (_elapse2 + 30) % 40;
							eshot.addElement(new EnemyShot(ESHOT_LARGE, 120 + CIRCLE_X[a] / 4, 120 + CIRCLE_Y[a] / 4, 120 + CIRCLE_X[a], 120 + CIRCLE_Y[a], _color, 6));
							eshot.addElement(new EnemyShot(ESHOT_LARGE, 120 + CIRCLE_X[b] / 4, 120 + CIRCLE_Y[b] / 4, 120 + CIRCLE_X[b], 120 + CIRCLE_Y[b], _color, 6));
							eshot.addElement(new EnemyShot(ESHOT_LARGE, 120 + CIRCLE_X[c] / 4, 120 + CIRCLE_Y[c] / 4, 120 + CIRCLE_X[c], 120 + CIRCLE_Y[c], _color, 6));
							eshot.addElement(new EnemyShot(ESHOT_LARGE, 120 + CIRCLE_X[d] / 4, 120 + CIRCLE_Y[d] / 4, 120 + CIRCLE_X[d], 120 + CIRCLE_Y[d], _color, 6));
						}
					}
					if ( (_elapse % 20) == 15 ) {
						int dx = jiki.cx();
						int dy = jiki.cy();
						int w = dx - 120;
						int h = dy - 120;
						if ( (level % 3) == 2 ) {
							eshot.addElement(new EnemyShot(ESHOT_NORMAL, 120, 120, dx    , dy    , 3, 4));
							eshot.addElement(new EnemyShot(ESHOT_NORMAL, 120, 120, dx + h, dy - w, 3, 4));
							eshot.addElement(new EnemyShot(ESHOT_NORMAL, 120, 120, dx - h, dy + w, 3, 4));
							eshot.addElement(new EnemyShot(ESHOT_NORMAL, 120, 120, dx    , dy    , 3, 8));
							eshot.addElement(new EnemyShot(ESHOT_NORMAL, 120, 120, dx + h, dy - w, 3, 8));
							eshot.addElement(new EnemyShot(ESHOT_NORMAL, 120, 120, dx - h, dy + w, 3, 8));
						} else {
							eshot.addElement(new EnemyShot(ESHOT_NORMAL, 120, 120, dx    , dy    , 3, 3));
							eshot.addElement(new EnemyShot(ESHOT_NORMAL, 120, 120, dx + h, dy - w, 3, 3));
							eshot.addElement(new EnemyShot(ESHOT_NORMAL, 120, 120, dx - h, dy + w, 3, 3));
							if ( (level % 3) >= 1 ) {
								eshot.addElement(new EnemyShot(ESHOT_NORMAL, 120, 120, dx    , dy    , 3, 6));
								eshot.addElement(new EnemyShot(ESHOT_NORMAL, 120, 120, dx + h, dy - w, 3, 6));
								eshot.addElement(new EnemyShot(ESHOT_NORMAL, 120, 120, dx - h, dy + w, 3, 6));
							}
						}
					}
					if ( (_elapse % 30) == 29 ) {
						int tmp;
						while ( true ) {
							tmp = (rand.nextInt() % 2) + 1;
							if ( tmp != _color ) {
								_color = tmp;
								break;
							}
						}
					}
					if ( (_elapse % 60) == 59 ) {
						clockwise = (rand.nextInt() > 0) ? true : false;
					}
					break;
				}
				break;
			case ENEMY_BOSS_2/*{XQ*/:
				if ( (level % 3) == 2 ) {
					_color = _elapse % 3;
				}
				switch ( _step ) {
				case 0:
					_y += 5;
					if ( _y >= 80 ) {
						next_step();
					}
					break;
				case 1:
					if ( ((level % 3) == 2) || ((_elapse % 2) == 1) ) {
						eshot.addElement(new EnemyShot(ESHOT_LARGE, 120, 120, 120 + (rand.nextInt() % 120), 120 + (rand.nextInt() % 120), _color, 6));
					}
					if ( (_elapse % 4) == 1 ) {
						eshot.addElement(new EnemyShot(ESHOT_NORMAL, 120, 80, 120 + (rand.nextInt() % 60), 0, 3, 8));
					}
					if ( (_elapse > 20) && ((_elapse % 8) == 1) ) {
						int xx = (10 + (rand.nextInt() % 10)) * 12;
						eshot.addElement(new EnemyShot(ESHOT_NORMAL, xx, -4, xx, 240, 3, 3));
					}
					if ( (level % 3) >= 1 ) {
						if ( (_elapse % 10) == 1 ) {
							eshot.addElement(new EnemyShot(ESHOT_NORMAL, 120, 120, jiki.cx(), jiki.cy(), 3, 5));
						}
					}
					if ( ((level % 3) < 2) && ((_elapse % 30) == 29) ) {
						int tmp;
						while ( true ) {
							tmp = (rand.nextInt() % 2) + 1;
							if ( tmp != _color ) {
								_color = tmp;
								break;
							}
						}
					}
					break;
				}
				break;
			case ENEMY_RAY/*C*/:
				if ( (_life <= 0) && (_step < 5) ) {
					_step = 5;
				}
				switch ( _step ) {
				case 0:
					_x += 12;
					if ( _x >= 200 ) {
						next_step();
					}
					if ( (level % 3) == 2 ) {
						if ( (_elapse % 2) == 1 ) {
							eshot.addElement(new EnemyShot(ESHOT_NORMAL, cx(), cy(), jiki.cx(), jiki.cy(), 3, 10));
						}
					}
					break;
				case 1:
					if ( _elapse >= 10 ) {
						_x0 = cx();
						_y0 = cy();
						x1 = (rand.nextInt() % 60) + 120;
						y1 = (rand.nextInt() % 60) + 120;
						p = pattern(_x0, _y0, x1, y1);
						next_step();
					}
					break;
				case 2:
					move(_x0, _y0, x1, y1, _elapse * 12);
					_x = move_x() - 20;
					_y = move_y() - 20;
					if ( (_elapse % 2) == 1 ) {
						eshot.addElement(new EnemyShot(ESHOT_NORMAL, cx(), cy(), jiki.cx(), jiki.cy(), 3, 10));
					}
					if ( (_x >= 10) && (_x <= 190) && (_y >= 10) && (_y <= 190) ) {
						_step++;
					}
					break;
				case 3:
					move(_x0, _y0, x1, y1, _elapse * 12);
					_x = move_x() - 20;
					_y = move_y() - 20;
					if ( (_elapse % 2) == 1 ) {
						eshot.addElement(new EnemyShot(ESHOT_NORMAL, cx(), cy(), jiki.cx(), jiki.cy(), 3, 10));
					}
					if ( (_x < 10) || (_x > 190) || (_y < 10) || (_y > 190) ) {
						p0 = pattern(cx(), cy(), jiki.cx(), jiki.cy());
						p = p0;
						next_step();
					}
					break;
				case 4:
					if ( ((_elapse % 20) > 5) && ((_elapse % 20) <= 15) ) {
						p0++;
					} else {
						p0--;
					}
					if ( p0 < 0 ) {
						p = p0 + 40;
					} else if ( p0 >= 40 ) {
						p = p0 - 40;
					} else {
						p = p0;
					}
					eshot.addElement(new EnemyShot(ESHOT_LARGE, cx() + CIRCLE_X[p] / 4, cy() + CIRCLE_Y[p] / 4, cx() + CIRCLE_X[p], cy() + CIRCLE_Y[p], _color, 6));
					switch ( level % 3 ) {
					case 1:
						if ( (_elapse % 10) == 1 ) {
							eshot.addElement(new EnemyShot(ESHOT_NORMAL, cx(), cy(), jiki.cx(), jiki.cy(), 3, 5));
						}
						break;
					case 2:
						if ( (_elapse % 5) == 1 ) {
							eshot.addElement(new EnemyShot(ESHOT_NORMAL, cx(), cy(), jiki.cx(), jiki.cy(), 3, 10));
						}
						break;
					}
					if ( (_elapse % 20) == 14 ) {
						int tmp;
						while ( true ) {
							tmp = (rand.nextInt() % 2) + 1;
							if ( tmp != _color ) {
								_color = tmp;
								break;
							}
						}
					}
					if ( _elapse > 40 ) {
						_step = 1;
						_elapse = 0;
					}
					break;
				case 5:
					_x0 = cx();
					_y0 = cy();
					x1 = -120;
					y1 = (rand.nextInt() % 120) + 120;
					next_step();
					break;
				case 6:
					move(_x0, _y0, x1, y1, _elapse * 5);
					_x = move_x() - 20;
					_y = move_y() - 20;
					if ( _x < -40 ) {
						return false;
					}
					break;
				}
				break;
			case ENEMY_RAX/*NX*/:
				if ( (_life <= 0) && (_step < 50) ) {
					_step = 50;
				}
				if ( (_step >= 10) && (_step < 50) ) {
					if ( (level % 3) == 2 ) {
						if ( (_elapse % 3) == 1 ) {
							shot = 1;
							sx0 = cx();
							sy0 = cy();
							sx1 = jiki.cx();
							sy1 = jiki.cy();
						}
					} else {
						if ( (_elapse % 5) == 1 ) {
							shot = 1;
							sx0 = cx();
							sy0 = cy();
							sx1 = jiki.cx();
							sy1 = jiki.cy();
						}
					}
				}
				if ( shot > 0 ) {
					eshot.addElement(new EnemyShot(ESHOT_NORMAL, sx0, sy0, sx1, sy1, 3, 12));
					shot++;
					if ( shot > 3 ) {
						shot = 0;
					}
				}
				switch ( _step ) {
				case 0:
					_y -= 8;
					if ( _y <= 176 ) {
						next_step();
					}
					break;
				case 1:
					if ( _elapse >= 10 ) {
						if ( rand.nextInt() < 0 ) {
							_x = 80;
							_step = 10;
						} else {
							_x = 96;
							_step = 11;
						}
						_elapse = 0;
					}
					break;
				case 2:
					{
						int tmp;
						while ( true ) {
							tmp = (rand.nextInt() % 2) + 1;
							if ( tmp != _color ) {
								_color = tmp;
								break;
							}
						}
					}
					next_step();
					// ̂܂܉ɗ
				case 3:
					if ( (level % 3) == 2 ) {
						if ( (_elapse % 3) == 1 ) {
							eshot.addElement(new EnemyShot(ESHOT_NORMAL, cx(), cy(), (rand.nextInt() % 120) + 120, (rand.nextInt() % 120) + 120, 3, 8));
						} else {
							eshot.addElement(new EnemyShot(ESHOT_SMALL, cx(), cy(), (rand.nextInt() % 120) + 120, (rand.nextInt() % 120) + 120, _color, 12));
						}
						if ( (level % 3) >= 1 ) {
							if ( (_elapse % 4) == 1 ) {
								eshot.addElement(new EnemyShot(ESHOT_NORMAL, cx(), cy(), (rand.nextInt() % 120) + 120, (rand.nextInt() % 120) + 120, 3, 5));
							}
						}
					} else {
						if ( _elapse < 20 ) {
							if ( (_elapse % 3) == 1 ) {
								eshot.addElement(new EnemyShot(ESHOT_NORMAL, cx(), cy(), (rand.nextInt() % 120) + 120, (rand.nextInt() % 120) + 120, 3, 5));
							} else {
								eshot.addElement(new EnemyShot(ESHOT_SMALL, cx(), cy(), (rand.nextInt() % 120) + 120, (rand.nextInt() % 120) + 120, _color, 8));
							}
							if ( (level % 3) >= 1 ) {
								if ( (_elapse % 4) == 1 ) {
									eshot.addElement(new EnemyShot(ESHOT_NORMAL, cx(), cy(), (rand.nextInt() % 120) + 120, (rand.nextInt() % 120) + 120, 3, 3));
								}
							}
						}
					}
					if ( _elapse > 30 ) {
						if ( rand.nextInt() < 0 ) {
							_step = ((old_step % 10) == 0) ? (old_step + 1) : (old_step - 1);
						} else {
							switch ( old_step ) {
							case 10:
							case 20:
							case 30:
								_step = old_step + 10;
								break;
							case 40:
								_step = 10;
								break;
							case 11:
								_step = 41;
								break;
							case 21:
							case 31:
							case 41:
								_step = old_step - 10;
								break;
							}
						}
						_elapse = 0;
					}
					break;
				case 10:
				case 31:
					_x -= 16;
					if ( _x <= 0 ) {
						old_step = _step;
						_step = 2;
					}
					break;
				case 11:
				case 30:
					_x += 16;
					if ( _x >= 176 ) {
						old_step = _step;
						_step = 2;
					}
					break;
				case 20:
				case 41:
					_y -= 16;
					if ( _y <= 0 ) {
						old_step = _step;
						_step = 2;
					}
					break;
				case 21:
				case 40:
					_y += 16;
					if ( _y >= 176 ) {
						old_step = _step;
						_step = 2;
					}
					break;
				case 50:
					_x0 = cx();
					_y0 = cy();
					x1 = -120;
					y1 = (rand.nextInt() % 120) + 120;
					next_step();
					break;
				case 51:
					move(_x0, _y0, x1, y1, _elapse * 5);
					_x = move_x() - 20;
					_y = move_y() - 20;
					if ( _x < -64 ) {
						return false;
					}
					break;
				}
				break;
			}
			return true;
		}
		public void draw() {
			switch ( _type ) {
			case ENEMY_ZAKO_1:
				drawImage(g, use_image(IMAGE_ZAKO_1), _x, _y, 32 * (m_elapse % 4), 32 * _color, 32, 32);
				break;
			case ENEMY_ZAKO_2:
				drawImage(g, use_image((_x0 < 0) ? IMAGE_ZAKO_2_2 : IMAGE_ZAKO_2_1), _x, _y, 64 * _color, 32 * (m_elapse % 4), 64, 32);
				break;
			case ENEMY_ZAKO_3:
				if ( (_x0 >= 0) && (_x0 < 240) ) {
					drawImage(g, use_image(IMAGE_ZAKO_3_2), _x, _y, 16 * (m_elapse % 4), 80 * _color, 16, 80);
					drawImage(g, use_image(IMAGE_ZAKO_3_2), _x + 6, (_y0 < 0) ? (_y - 236) : (_y + 76), 64 + _color * 4, 0, 4, 240);
				} else {
					drawImage(g, use_image(IMAGE_ZAKO_3_1), _x, _y, 80 * _color, 16 * (m_elapse % 4), 80, 16);
					drawImage(g, use_image(IMAGE_ZAKO_3_1), (_x0 < 0) ? (_x - 236) : (_x + 76), _y + 6, 0, 64 + _color * 4, 240, 4);
				}
				break;
			case ENEMY_ZAKO_4:
				xx = 0;
				switch ( m_elapse % 4 ) {
				case 0:
					xx = (_x0 > x1) ? 0 : 120;
					break;
				case 1:
				case 3:
					xx = (_x0 > x1) ? 40 : 160;
					break;
				case 2:
					xx = (_x0 > x1) ? 80 : 200;
					break;
				}
				drawImage(g, use_image(IMAGE_ZAKO_4), _x, _y, xx, 32 * _color, 40, 32);
				break;
			case ENEMY_ZAKO_5:
				drawImage(g, use_image(IMAGE_ZAKO_5), _x, _y, 40 * (m_elapse % 6), 50 * _color, 40, 50);
				break;
			case ENEMY_BOSS_1:
				drawImage(g, use_image(IMAGE_BOSS_1), _x, _y, 80 * (m_elapse % 3), 80 * _color, 80, 80);
				break;
			case ENEMY_BOSS_2:
				drawImage(g, use_image(IMAGE_BOSS_2), _x, _y, 80 * (m_elapse % 3), 80 * _color, 80, 80);
				break;
			case ENEMY_RAY:
				switch ( _step ) {
				case 0:
				case 1:
					drawImage(g, use_image(IMAGE_RAY_1), _x, _y, 0, 0, 40, 40);
					break;
				case 2:
				case 3:
					if ( p <= 4 ) {
						drawImage(g, use_image(IMAGE_RAY_1), _x, _y, 40 * p, 0, 40, 40);
					} else if ( p <= 9 ) {
						drawImage(g, use_image(IMAGE_RAY_1), _x, _y, 40 * (p - 5), 40, 40, 40);
					} else if ( p == 10 ) {
						g.setFlipMode(Graphics.FLIP_ROTATE_RIGHT);
						drawImage(g, use_image(IMAGE_RAY_1), _x, _y, 0, 0, 40, 40);
						g.setFlipMode(Graphics.FLIP_NONE);
					} else if ( p <= 15 ) {
						drawImage(g, use_image(IMAGE_RAY_1 + 1), _x, _y, 40 * (p - 11), 40, 40, 40);
					} else if ( p <= 20 ) {
						drawImage(g, use_image(IMAGE_RAY_1 + 1), _x, _y, 40 * (p - 16), 0, 40, 40);
					} else if ( p <= 25 ) {
						g.setFlipMode(Graphics.FLIP_ROTATE_RIGHT);
						drawImage(g, use_image(IMAGE_RAY_1 + 1), _x, _y, 40 * (p - 21), 40, 40, 40);
						g.setFlipMode(Graphics.FLIP_NONE);
					} else if ( p <= 30 ) {
						g.setFlipMode(Graphics.FLIP_ROTATE_RIGHT);
						drawImage(g, use_image(IMAGE_RAY_1 + 1), _x, _y, 40 * (p - 26), 0, 40, 40);
						g.setFlipMode(Graphics.FLIP_NONE);
					} else if ( p <= 34 ) {
						g.setFlipMode(Graphics.FLIP_ROTATE_LEFT);
						drawImage(g, use_image(IMAGE_RAY_1), _x, _y, 40 * (p - 30), 0, 40, 40);
						g.setFlipMode(Graphics.FLIP_NONE);
					} else {
						g.setFlipMode(Graphics.FLIP_ROTATE_LEFT);
						drawImage(g, use_image(IMAGE_RAY_1), _x, _y, 40 * (p - 35), 40, 40, 40);
						g.setFlipMode(Graphics.FLIP_NONE);
					}
					break;
				case 4:
					switch ( p / 10 ) {
					case 0: break;
					case 1: g.setFlipMode(Graphics.FLIP_ROTATE_RIGHT); break;
					case 2: g.setFlipMode(Graphics.FLIP_ROTATE      ); break;
					case 3: g.setFlipMode(Graphics.FLIP_ROTATE_LEFT ); break;
					}
					if ( (p % 10) < 5 ) {
						drawImage(g, use_image(IMAGE_RAY_2), _x, _y, 40 * (p % 5), 0, 40, 40);
					} else {
						drawImage(g, use_image(IMAGE_RAY_2), _x, _y, 40 * (p % 5), 40, 40, 40);
					}
					g.setFlipMode(Graphics.FLIP_NONE);
					break;
				case 5:
				case 6:
					switch ( _elapse % 4 ) {
					case 0: break;
					case 1: g.setFlipMode(Graphics.FLIP_ROTATE_LEFT ); break;
					case 2: g.setFlipMode(Graphics.FLIP_ROTATE      ); break;
					case 3: g.setFlipMode(Graphics.FLIP_ROTATE_RIGHT); break;
					}
					drawImage(g, use_image(IMAGE_RAY_3), _x, _y, 0, 0, 40, 40);
					g.setFlipMode(Graphics.FLIP_NONE);
					break;
				}
				break;
			case ENEMY_RAX:
				switch ( _step ) {
				case 0:
				case 1:
					g.setFlipMode(Graphics.FLIP_ROTATE_LEFT);
					drawImage(g, use_image(IMAGE_RAX_1), _x, _y, 0, 0, 64, 64);
					g.setFlipMode(Graphics.FLIP_NONE);
					break;
				case 50:
				case 51:
					switch ( _elapse % 4 ) {
					case 0: break;
					case 1: g.setFlipMode(Graphics.FLIP_ROTATE_LEFT ); break;
					case 2: g.setFlipMode(Graphics.FLIP_ROTATE      ); break;
					case 3: g.setFlipMode(Graphics.FLIP_ROTATE_RIGHT); break;
					}
					drawImage(g, use_image(IMAGE_RAX_2), _x, _y, 0, 0, 64, 64);
					g.setFlipMode(Graphics.FLIP_NONE);
					break;
				default:
					p = pattern(120, 120, cx(), cy());
					switch ( p / 10 ) {
					case 0: break;
					case 1: g.setFlipMode(Graphics.FLIP_ROTATE_RIGHT); break;
					case 2: g.setFlipMode(Graphics.FLIP_ROTATE      ); break;
					case 3: g.setFlipMode(Graphics.FLIP_ROTATE_LEFT ); break;
					}
					if ( (p % 10) < 5 ) {
						drawImage(g, use_image(IMAGE_RAX_1), _x, _y, 64 * (p % 5), 0, 64, 64);
					} else {
						drawImage(g, use_image(IMAGE_RAX_1), _x, _y, 64 * (p % 5), 64, 64, 64);
					}
					g.setFlipMode(Graphics.FLIP_NONE);
					break;
				}
				break;
			}
#ifdef DEBUG
			g.setColor(COLOR_Y);
			g.drawRect(left(), top(), right() - left(), bottom() - top());
#endif // DEBUG
		}
	}
}
