/****************************************************
 * ނ`                                       *
 * Copyright (C) SatisFactory. All rights reserved. *
 ****************************************************/

#ifndef MAIN_HPP
#define MAIN_HPP

#include <windows.h>

#include <tchar.h>

#include "_Main.hpp"

#include "_Graphics.hpp"
#include "_Image.hpp"
#include "_Memory.hpp"
#include "_Random.hpp"
#include "_SoundData.hpp"
#include "_String.hpp"
#include "_Vector.hpp"
#include "Replay.hpp"
#include "ReplayData.hpp"
#include "Awa.hpp"
#include "Burst.hpp"
#include "Enemy.hpp"
#include "EnemyShot.hpp"
#include "Jiki.hpp"
#include "JikiShot.hpp"
#include "Spark.hpp"
#include "StreamReader.hpp"
#include "System.hpp"
#include "Tame.hpp"

#include "MyDefine.h"

#define VERSION					"Ver.1.0"

// Z[uf[^o[W
#define CONFIG_VERSION			"0001"

// vCf[^o[W
#define REPLAY_VERSION			"0001"

// Xg[ǂݍ݃ubNTCY
#define DATA_SIZE				256

// x
#define LEVEL_NUM				9

// Xe[W
#define STAGE_NUM				3

// \[X̎
#include "data.h"

#define IMAGE_NUM				(DATA_NUM - (STAGE_NUM * 2))	// 摜̐

#define BGM_TITLE				0
#define BGM_STAGE1				1
#define BGM_STAGE2				2
#define BGM_STAGE3				3
#define BGM_BOSS1				4
#define BGM_BOSS2				5
#define BGM_BOSS3				6
#define BGM_RAY					7
#define BGM_RAX					8
#define BGM_EXE					9
#define BGM_NUM					10

#define SE_CURSOR				0	// J[\ړ
#define SE_SELECT				1	// I
#define SE_CANCEL				2	// LZ
#define SE_LOCKON				3	// bNI
#define SE_SHOT					4	// e
#define SE_SPECIAL				5	// XyV
#define SE_SWORD				6	// \[h
#define SE_HIT					7	// eqbg
#define SE_DAMAGE				8	// _[W
#define SE_POWER				9	// p[Abv
#define SE_BURST				10	// 
#define SE_DIVE					11	// 
#define SE_SURFACE				12	// 
#define SE_AWA					13	// A
#define SE_DOWN					14	// _E
#define SE_BEAM					15	// r[
#define SE_DASH					16	// _bV
#define SE_NUM					17

// Av̏
#define STATE_LAUNCH			0
#define STATE_TITLE				1
#define STATE_SELECTSTAGE		2
#define STATE_SELECTSTAGE2		3
#define STATE_SELECTREPLAY		4
#define STATE_SELECTREPLAY2		5
#define STATE_PLAY_LOAD			6
#define STATE_PLAY_MAIN			7
#define STATE_PLAY_BOSS			8
#define STATE_PLAY_LOAD2		9
#define STATE_PLAY_MAIN2		10
#define STATE_PLAY_BOSS2		11
#define STATE_PLAY_CLEAR		12
#define STATE_PLAY_CLEAR2		13
#define STATE_PLAY_GAMEOVER		14
#define STATE_PLAY_GAMEOVER2	15
#define STATE_SCORE				16
#define STATE_SCORE2			17
#define STATE_EXIT				18
#define STATE_EXIT2				19

// 1t[̎(~b)
#define FRAME_TIME				16

// ҂t[
#define WAIT_Q					15
#define WAIT_H					30
#define WAIT_1					60
#define WAIT_2					120
#define WAIT_4					240

#define JIKI_LIFE_MAX			10
#define SPECIAL_POWER_MAX		50
#define DASH_POWER_MAX			400

#define DASH_POWER				5
#define DASH_ZANZOU				2

// e̎
#define JSHOT_NORMAL			0
#define JSHOT_SPECIAL			1
#define JSHOT_SWORD				2

// Ge̎
#define ESHOT_NORMAL			0
#define ESHOT_SMALL				1
#define ESHOT_LARGE				2
#define ESHOT_BEAM				3

// G̎
#define ENEMY_ZAKO_1			0
#define ENEMY_ZAKO_2			1
#define ENEMY_ZAKO_3			2
#define ENEMY_ZAKO_4			3
#define ENEMY_ZAKO_5			4
#define ENEMY_ZAKO_6_1			5
#define ENEMY_ZAKO_6_2			6
#define ENEMY_BOSS_1			7
#define ENEMY_BOSS_2			8
#define ENEMY_BOSS_3_1			9
#define ENEMY_BOSS_3_2			10
#define ENEMY_RAY				11
#define ENEMY_RAX				12
#define ENEMY_EXE				13

// eLXg
#define FONT_L_H				36
#define FONT_L_STAGECLEAR_X		0
#define FONT_L_STAGECLEAR_W		279
#define FONT_L_GAMEOVER_X		286
#define FONT_L_GAMEOVER_W		251
#define FONT_L_0_X				543
#define FONT_L_0_W				22
#define FONT_L_1_X				574
#define FONT_L_1_W				15
#define FONT_L_2_X				601
#define FONT_L_2_W				22
#define FONT_L_3_X				630
#define FONT_L_3_W				22
#define FONT_L_4_X				659
#define FONT_L_4_W				22
#define FONT_L_5_X				689
#define FONT_L_5_W				21
#define FONT_L_6_X				718
#define FONT_L_6_W				20
#define FONT_L_7_X				747
#define FONT_L_7_W				20
#define FONT_L_8_X				775
#define FONT_L_8_W				22
#define FONT_L_9_X				805
#define FONT_L_9_W				20

#define FONT_M_H				34
#define FONT_M_SCORE_X			0
#define FONT_M_SCORE_W			82
#define FONT_M_LIFE_X			87
#define FONT_M_LIFE_W			190
#define FONT_M_TOTAL_X			284
#define FONT_M_TOTAL_W			104
#define FONT_M_HISCORE_X		393
#define FONT_M_HISCORE_W		215

#define FONT_S_H				27
#define FONT_S_SCORE_X			0
#define FONT_S_SCORE_W			61
#define FONT_S_RAY_X			67
#define FONT_S_RAY_W			40
#define FONT_S_RAX_X			112
#define FONT_S_RAX_W			40
#define FONT_S_EXE_X			157
#define FONT_S_EXE_W			38
#define FONT_S_0_X				200
#define FONT_S_0_W				15
#define FONT_S_1_X				221
#define FONT_S_1_W				9
#define FONT_S_2_X				239
#define FONT_S_2_W				14
#define FONT_S_3_X				258
#define FONT_S_3_W				14
#define FONT_S_4_X				277
#define FONT_S_4_W				15
#define FONT_S_5_X				297
#define FONT_S_5_W				14
#define FONT_S_6_X				316
#define FONT_S_6_W				14
#define FONT_S_7_X				336
#define FONT_S_7_W				13
#define FONT_S_8_X				355
#define FONT_S_8_W				14
#define FONT_S_9_X				374
#define FONT_S_9_W				14
#define FONT_S_HISCORE_X		394
#define FONT_S_HISCORE_W		93
#define FONT_S_NULL_X			491
#define FONT_S_NULL_W			40
#define FONT_S_PAUSE_X			536
#define FONT_S_PAUSE_W			75
#define FONT_S_GAME_X			616
#define FONT_S_GAME_W			119
#define FONT_S_TITLE_X			741
#define FONT_S_TITLE_W			147
#define FONT_S_STAGE_X			894
#define FONT_S_STAGE_W			59
#define FONT_S_PAGE1_X			958
#define FONT_S_PAGE1_W			52

#define FONT_S_REPLAY_X			0
#define FONT_S_REPLAY_W			255
#define FONT_S_HAI_X			266
#define FONT_S_HAI_W			47
#define FONT_S_IIE_X			320
#define FONT_S_IIE_W			68
#define FONT_S_SAIKAI_X			393
#define FONT_S_SAIKAI_W			50
#define FONT_S_CYUUDAN_X		450
#define FONT_S_CYUUDAN_W		49
#define FONT_S_REPLAYNAI_X		505
#define FONT_S_REPLAYNAI_W		278
#define FONT_S_REPLAYERR_X		791
#define FONT_S_REPLAYERR_W		67
#define FONT_S_REPLAYSEP_X		867
#define FONT_S_REPLAYSEP_W		15
#define FONT_S_PAGE2_X			886
#define FONT_S_PAGE2_W			70

#define FONT_LEV_H				36
#define FONT_LEV_NORMAL_X		0
#define FONT_LEV_NORMAL_W		107
#define FONT_LEV_HARD_X			116
#define FONT_LEV_HARD_W			73
#define FONT_LEV_EXTRA_X		198
#define FONT_LEV_EXTRA_W		82
#define FONT_LEV_LEVEL_X		288
#define FONT_LEV_LEVEL_W		82
#define FONT_LEV_SETSU_X		370
#define FONT_LEV_2_SETSU_W		115
#define FONT_LEV_3_SETSU_W		101
#define FONT_LEV_SCORE_X		379
#define FONT_LEV_SCORE_W		91
#define FONT_LEV_REPLAY_X		478
#define FONT_LEV_REPLAY_W		105
#define FONT_LEV_EXIT_X			590
#define FONT_LEV_EXIT_W			61

#define FONT_LEV_S_H			23
#define FONT_LEV_S_NORMAL_X		0
#define FONT_LEV_S_NORMAL_W		74
#define FONT_LEV_S_HARD_X		78
#define FONT_LEV_S_HARD_W		51
#define FONT_LEV_S_EXTRA_X		132
#define FONT_LEV_S_EXTRA_W		57

/**
 * C
 */
class Main : public _Main {
public:
	int width() { return 640; }
	int height() { return 480; }
	int frameTime() { return FRAME_TIME; }
	LPCTSTR logFile() { return sys_data.bWriteLog ? "comshoot.log" : ""; }
	BOOL isCheckActive() { return sys_data.bCheckActive; }
	BOOL isWindow() { return sys_data.bWindow; }
	BOOL showCursor() { return sys_data.bWindow ? TRUE : FALSE; }
	BOOL isFullFrame() { return sys_data.bFullFrame; }
	int volumeMusic() { return sys_data.volumeMusic; }
	int volumeSound() { return sys_data.volumeSound; }
	void start();
	void destroy();
	void resume();
	void paint();
	void processEvent(UINT type, UINT param);

public:
	BOOL lock_dispose_image;

	SystemData sys_data;
	UINT button[6];

	unsigned char* pak_data;

	_Graphics* g;

	_Random* _rand;
	Replay* _replay;
	_Vector* replay_data;
	_Vector* jshot;
	_Vector* eshot;
	_Vector* spark;
	_Vector* tame;
	_Vector* awa;
	_Vector* burst;
	Jiki* jiki;
	_Vector* enemy;

	int scroll_w;
	int scroll_sy[480 + 240 + 2];
	int scroll_h[480 + 240 + 2];
	double scroll_step[480 + 240 + 2];
	double scroll_dx[480 + 240 + 2];

	// 悭gF
	D3DCOLOR COLOR_M;
	D3DCOLOR COLOR_W;
	D3DCOLOR COLOR_K;

	int launch_step;					//

	int state, old_state;				// Av̏
	int help;							// wv̎
	int m_elapse;						// oߎ
	int m_elapse_p;						// |[Y̌oߎ
	int m_elapse_r;						// u^Cg֖߂voߎ
	BOOL pause;							// |[Yǂ
	BOOL pause2;						//

	int select_title;					//
	int select_pause;					//
	int select_replay;					//

	BOOL replay_white;					//

	BOOL replay;

	BOOL request_lock;
	BOOL request_color_0;
	BOOL request_color_1;
	BOOL request_color_2;
	BOOL request_dash;

	int level;							// x
	int st_index;						// Xe[Wԍ
	int st_step;						//
	int st_coef, st_coef_dist;			//

	int save_level;						//
	int save_st_index;					//
	BOOL save_replay;					//

	int exe_x, exe_y;					//
	int exe_color;						//
	double exe_r;						//

	int enemy_color;					//

	BOOL first;

	int _target, _target_old;
	int _target_x;
	int _target_y;

	int score;							// XRA
	int hi_score[LEVEL_NUM][STAGE_NUM];	// nCXRA
	int score_d;						// \p
	BOOL score_lock;

	BOOL clear[LEVEL_NUM][STAGE_NUM];	//

	_Image main_img[IMAGE_NUM];
	_SoundData main_music[BGM_NUM];
	_SoundData main_sound[SE_NUM];

	char* script_in;
	StreamReader* script_reader;
	_String* script_tmp;
	int script_frame;

	int _move_x;
	int _move_y;

public:
	Main();
	int rand();
	void next_color(int* color);
	int pattern(int x0, int y0, int x1, int y1);
	void load_config();
	void save_config();
	_Memory* read_data(int id);
	void create_image(int id);
	void dispose_image(int id);
	void dispose_image();
	_Image* use_image(int id);
	void create_sound(int id);
	void dispose_sound(int id);
	void dispose_sound();
	_SoundData* use_sound(int id);
	BOOL create_music(int id);
	void dispose_music(int id);
	void dispose_music();
	void play_music(int id);
	void play_sound(int id);
	void stop_sound(int id);
	int elapse();
	void set_state(int new_state);
	void scroll_update(int i);
	void scroll_draw(int i, int id, int dy);
	BOOL move(int x0, int y0, int x1, int y1, int cnt);
	int move_x();
	int move_y();
	BOOL extra();
	void add_score(int point);
	void lock_enemy();
	void drawScoreS(int score, int x, int y);
	void centerDrawScoreS(int score, int y);
	void drawScoreL(int score, int x, int y);
	void drawTitleBack();
	BOOL create_replay_data();
#ifdef SHOW_AREA
	void drawArea(int x, int y, int w, int h);
#endif // SHOW_AREA
};

#endif // MAIN_HPP
