/*
 * D2DX
 * Copyright (C) SatisKia. All rights reserved.
 */

#ifndef _MAIN_HPP
#define _MAIN_HPP

#include <windows.h>

#include <d3dx9.h>

// OQ
class _Graphics;
class _Memory;
class _SoundData;

class _Main
{
private:
	_Graphics* _g;

public:
	_Main();
	virtual ~_Main();

	void writeLog( LPCTSTR str );

	void terminate();

	void setBackColor( D3DCOLOR col );

	void setKeyAssign( int key, UINT key_type );
	void setKey( UINT key_z, UINT key_x, UINT key_c, UINT key_v );
	BOOL checkKey( int key );
	UINT getKeypadState();

	int getMouseX();
	int getMouseY();

	_Graphics* getGraphics();

	BOOL createSound( _SoundData* sound, _Memory* data, int type );
	BOOL createSound( _SoundData* sound, char* file, int type );
	void disposeSound( _SoundData* sound );

private:
	void PlayMusic( BOOL loop );
public:
	void playMusic( _Memory* data, int type, BOOL loop );
	void playMusic( char* file, int type, BOOL loop );
	void playMusic( _SoundData* sound, BOOL loop );
	void stopMusic();
	void setVolumeMusic( int volume );

	void setVolumeSound( int volume );
	void playSound( _SoundData* sound );
	void stopSound( _SoundData* sound );

	virtual int width(){ return 640; }
	virtual int height(){ return 480; }
	virtual int frameTime(){ return 16/*1000 / 60*/; }
	virtual LPCTSTR logFile(){ return ""; }
	virtual BOOL isCheckActive(){ return TRUE; }
	virtual BOOL isWindow(){ return TRUE; }
	virtual BOOL showCursor(){ return TRUE; }
	virtual BOOL isFullFrame(){ return TRUE; }
	virtual int volumeMusic(){ return 100; }
	virtual int volumeSound(){ return 85; }
	virtual void start(){}
	virtual void destroy(){}
	virtual void resume(){}
	virtual void paint(){}
	virtual void processEvent( UINT /*type*/, UINT /*param*/ ){}
};

#endif // _MAIN_HPP
