#pragma once

#include "ofMain.h"
#include "ofxStk.h"
#include "ofxSimpleButton.h"

class testApp : public ofBaseApp, ofxSimpleButtonListener {

public:
	void setup();
	void update();
	void draw();

	void keyPressed(int key);
	void keyReleased(int key);
	void mouseMoved(int x, int y );
	void mouseDragged(int x, int y, int button);
	void mousePressed(int x, int y, int button);
	void mouseReleased(int x, int y, int button);
	void windowResized(int w, int h);
	void dragEvent(ofDragInfo dragInfo);
	void gotMessage(ofMessage msg);

	void audioOut(float * output, int size, int channels);

	void buttonNotify(ofxSimpleButtonEvent event);

private:
	int sigAreaX, sigAreaY, sigAreaW, sigAreaH;
	int buttonX, buttonY, buttonSize;
	
    vector<float> lrAudio;
	vector<ofxSimpleButton> buttons;
	vector<stk::Instrmnt*> insts;
	
	stk::Clarinet mClarinet;
    stk::Moog mMoog;
	stk::Saxofony mSax;
    stk::Rhodey mRhodey; //storange noise?
    stk::Flute mFlute;
//	stk::TubeBell mBell; //storange noise?
//	stk::Brass mBrass; // small sound?
};
