#include "testApp.h"

#define AUDIO_BUFFER_SIZE 1024
#define NUM_BUTTONS 5

static const string buttonName[NUM_BUTTONS] = {
	"Clarinet",
	"Moog",
	"Sax",
	"Rhodey",
	"Flute",
//	"Bell",
//	"Brass",
};

//--------------------------------------------------------------
void testApp::setup(){
	// init parameter
	sigAreaX = (int)(0.3 * ofGetWidth());
	sigAreaY = (int)(0.05 * ofGetHeight());
	sigAreaW = (int)(0.65 * ofGetWidth());
	sigAreaH = (int)(0.90 * ofGetHeight());

	buttonX = (int)(0.05 * ofGetWidth());
	buttonY = (int)(0.05 * ofGetHeight());
	buttonSize = (int)(0.05 * ofGetHeight());
	
	// setup of
    ofBackground(50, 50, 50);

	// setup buttons
	buttons.resize(NUM_BUTTONS);
	for(int i = 0; i < NUM_BUTTONS; i++) {
		buttons[i].setup(buttonX, buttonY + (buttonSize << 1) * i,
						 buttonSize, buttonSize, true);
		buttons[i].addListener(this);
	}
    
    // audio setup
    ofSoundStreamSetup(2, 0, this, 44100, AUDIO_BUFFER_SIZE, 4);
	lrAudio.assign(AUDIO_BUFFER_SIZE, 0.0);
    
    // STK
    insts.resize(NUM_BUTTONS);
    insts[0] = &mClarinet;
    insts[1] = &mMoog;
    insts[2] = &mSax;
    insts[3] = &mRhodey;
    insts[4] = &mFlute;
}

//--------------------------------------------------------------
void testApp::update(){

}

//--------------------------------------------------------------
void testApp::draw(){
	ofPushStyle();
	ofNoFill();

	// draw buttons
	{
		for(int i = 0; i < NUM_BUTTONS; i++) {
			ofDrawBitmapString(buttonName[i],
							   buttonX + (buttonSize << 1),
							   buttonY + (buttonSize * 0.8) + (buttonSize << 1) *i);
		}
	}
	
	// draw rect
	{
		ofColor(100, 100, 100); 
		ofRect(sigAreaX, sigAreaY, sigAreaW, sigAreaH);
	}

	// draw signal
	{
		int hh = sigAreaH >> 1;
		ofPushMatrix();
		ofTranslate(sigAreaX, sigAreaY);
		ofColor(150, 150, 10);
		ofBeginShape();
		for(int i = 0; i < AUDIO_BUFFER_SIZE; i++)
		{
			double x = ofMap(i, 0, AUDIO_BUFFER_SIZE, 0, sigAreaW);
			double y = hh + (sigAreaH * lrAudio[i]);
			ofVertex(x, y);
		}
		ofEndShape();
		ofPopMatrix();
	}
	
	ofPopStyle();
}

void testApp::audioOut(float *output, int size, int channels)
{
    for(int i = 0; i < size; i++) {
        double v = 0.0;
		for(int i = 0; i < NUM_BUTTONS; i++) {
			v += insts[i]->tick();
		}
        output[i * channels] = v;
        output[i * channels + 1] = v;

		lrAudio[i] = v;
    }
}

void testApp::buttonNotify(ofxSimpleButtonEvent event)
{
	for(int i = 0; i < NUM_BUTTONS; i++) {
		if(event.button == &buttons[i]) {
			if(event.type == BUTTON_PRESSED) {
				insts[i]->noteOn(220, 0.5);
			} else if(event.type == BUTTON_RELEASED) {
				insts[i]->noteOff(0.5);
			}
		}
	}
}

//--------------------------------------------------------------
void testApp::keyPressed(int key){

}

//--------------------------------------------------------------
void testApp::keyReleased(int key){

}

//--------------------------------------------------------------
void testApp::mouseMoved(int x, int y ){

}

//--------------------------------------------------------------
void testApp::mouseDragged(int x, int y, int button){

}

//--------------------------------------------------------------
void testApp::mousePressed(int x, int y, int button){

}

//--------------------------------------------------------------
void testApp::mouseReleased(int x, int y, int button){

}

//--------------------------------------------------------------
void testApp::windowResized(int w, int h){

}

//--------------------------------------------------------------
void testApp::gotMessage(ofMessage msg){

}

//--------------------------------------------------------------
void testApp::dragEvent(ofDragInfo dragInfo){ 

}
