unit Round;

interface

uses
	Windows, Classes, Controls, Forms, StdCtrls, ComCtrls, Menus,
	SysUtils, ImgList, ExtCtrls, GikoSystem, GikoUtil;

type
	TRoundDialog = class(TForm)
    RoundPopupMenu: TPopupMenu;
    C1: TMenuItem;
    P1: TMenuItem;
		N1: TMenuItem;
    D1: TMenuItem;
		ItemIcon16: TImageList;
    Panel1: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    RoundNameComboBox: TComboBox;
    Panel2: TPanel;
    Panel3: TPanel;
    AllSelectButton: TButton;
    AllCancelButton: TButton;
    RoundDeleteButton: TButton;
    Panel4: TPanel;
    Button1: TButton;
    RoundButton: TButton;
    StatusBar1: TStatusBar;
    RoundListView: TListView;
		procedure RoundButtonClick(Sender: TObject);
		procedure FormCreate(Sender: TObject);
		procedure RoundListViewChange(Sender: TObject; Item: TListItem;
			Change: TItemChange);
		procedure AllSelectButtonClick(Sender: TObject);
		procedure AllCancelButtonClick(Sender: TObject);
		procedure RoundNameComboBoxChange(Sender: TObject);
		procedure RoundDeleteButtonClick(Sender: TObject);
	private
		{ Private 錾 }
		function GetRoundCount: Integer;
		procedure SetRoundItem(RoundName: string);
		function CompareTime(Time1: TDateTime; Time2: TDateTime; MarginMin: Integer): Boolean;
	public
		{ Public 錾 }
	end;

//var
//	RoundDialog: TRoundDialog;

implementation

uses
	Giko, BoardGroup, RoundData;

{$R *.DFM}

procedure TRoundDialog.RoundButtonClick(Sender: TObject);
var
	i: Integer;
	cnt: Integer;
	msg: string;
	Board: TBoard;
	ThreadItem: TThreadItem;
	RoundItem: TRoundItem;
begin
//	if CompareTime(GikoForm.LastRoundTime, Now, 5) then begin
//		msg := 'x񂷂ƂTԏ͏o܂';
//		GikoSys.MsgBox(msg, 'G[', MB_OK or MB_ICONSTOP);
//		Exit;
//	end;

	if not Giko.GikoForm.LoginAction.Checked then begin
		msg := 'OCȂƏ͏o܂' + #13#10
				 + 'Ȃl̓MRirXbhŕĂ';
		MsgBox(Handle, msg, 'G[', MB_OK or MB_ICONSTOP);
		Exit;
	end;

	cnt := GetRoundCount;
	if cnt = 0 then begin
		msg := '񂵂ڂɂPȏ`FbNĂ';
		MsgBox(Handle, msg, 'G[', MB_OK or MB_ICONSTOP);
		Exit;
	end;

	for i := 0 to RoundList.Count[grtBoard] - 1 do begin
		RoundItem := RoundList.Items[i, grtBoard];
		if not RoundItem.BoolData then Continue;
		if not Giko.GikoForm.LoginAction.Checked then Exit;
		if RoundItem.RoundType = grtBoard then begin
			Board := BBS2ch.FindBBSID(RoundItem.BBSID);
			if Board <> nil then begin
				if not Board.IsThreadDatRead then
					GikoSys.ReadSubjectFile(Board);
				GikoForm.DownloadList(Board);
			end;
		end;
	end;
	for i := 0 to RoundList.Count[grtItem] - 1 do begin
		RoundItem := RoundList.Items[i, grtItem];
		if not RoundItem.BoolData then Continue;
		if not Giko.GikoForm.LoginAction.Checked then Exit;
		Board := BBS2ch.FindBBSID(RoundItem.BBSID);
		if Board <> nil then begin
			if not Board.IsThreadDatRead then
				GikoSys.ReadSubjectFile(Board);
			ThreadItem := BBS2ch.FindThreadItem(RoundItem.BBSID, RoundItem.FileName);
			if ThreadItem <> nil then begin
//				GikoForm.AddMessageList('debug2:' + IntToStr(i), nil);
				GikoForm.DownloadContent(ThreadItem);
			end;
		end;
	end;
//	GikoForm.LastRoundTime := Now;
	Close;
end;

function TRoundDialog.GetRoundCount: Integer;
var
	i: Integer;
	RoundItem: TRoundItem;
begin
	Result := 0;
	for i := 0 to RoundList.Count[grtBoard] - 1 do begin
		RoundItem := RoundList.Items[i, grtBoard];
		if RoundItem.BoolData then
			Result := Result + 1;
	end;
	for i := 0 to RoundList.Count[grtItem] - 1 do begin
		RoundItem := RoundList.Items[i, grtItem];
		if RoundItem.BoolData then
			Result := Result + 1;
	end;
end;

function TRoundDialog.CompareTime(Time1: TDateTime; Time2: TDateTime; MarginMin: Integer): Boolean;
const
	AMin: Double = (1 / 24 / 60);
var
	d: TDateTime;
begin
	d := Time1 + (AMin * MarginMin);
	Result := Time2 < d;
end;

procedure TRoundDialog.FormCreate(Sender: TObject);
var
	i: Integer;
begin
	RoundNameComboBox.Items.Add('iׂāj');
	for i := 0 to RoundList.RoundNameList.Count - 1 do
		RoundNameComboBox.Items.Add(RoundList.RoundNameList[i]);
	for i := 0 to RoundList.Count[grtBoard] - 1 do
		RoundList.Items[i, grtBoard].BoolData := False;
	for i := 0 to RoundList.Count[grtItem] - 1 do
		RoundList.Items[i, grtItem].BoolData := False;
	RoundNameComboBox.ItemIndex := 0;
	SetRoundItem('');
end;

procedure TRoundDialog.RoundListViewChange(Sender: TObject;
	Item: TListItem; Change: TItemChange);
var
	RoundItem: TRoundItem;
begin
	if TObject(Item.Data) is TRoundItem then begin
		RoundItem := TRoundItem(Item.Data);
		RoundItem.BoolData := Item.Checked;
	end;
end;

procedure TRoundDialog.AllSelectButtonClick(Sender: TObject);
var
	i: Integer;
	RoundItem: TRoundItem;
	ListChangeEvent: TLVChangeEvent;
begin
	ListChangeEvent := RoundListView.OnChange;
	RoundListView.OnChange := nil;
	try
		for i := 0 to RoundListView.Items.Count - 1 do begin
			if TObject(RoundListView.Items[i].Data) is TRoundItem then begin
				RoundItem := TRoundItem(RoundListView.Items[i].Data);
				RoundItem.BoolData := True;
				RoundListView.Items[i].Checked := True;
			end;
		end;
	finally
		RoundListView.OnChange := ListChangeEvent;
	end;
end;

procedure TRoundDialog.AllCancelButtonClick(Sender: TObject);
var
	i: Integer;
	RoundItem: TRoundItem;
	ListChangeEvent: TLVChangeEvent;
begin
	ListChangeEvent := RoundListView.OnChange;
	RoundListView.OnChange := nil;
	try
		for i := 0 to RoundListView.Items.Count - 1 do begin
			if TObject(RoundListView.Items[i].Data) is TRoundItem then begin
				RoundItem := TRoundItem(RoundListView.Items[i].Data);
				RoundItem.BoolData := False;
				RoundListView.Items[i].Checked := False;
			end;
		end;
	finally
		RoundListView.OnChange := ListChangeEvent;
	end;
end;

procedure TRoundDialog.RoundNameComboBoxChange(Sender: TObject);
begin
	if RoundNameComboBox.ItemIndex = 0 then
		SetRoundItem('')
	else
		SetRoundItem(RoundNameComboBox.Items[RoundNameComboBox.itemIndex]);
end;

procedure TRoundDialog.SetRoundItem(RoundName: string);
var
	ListItem: TListItem;
	i: Integer;
	ListChangeEvent: TLVChangeEvent;
begin
	ListChangeEvent := RoundListView.OnChange;
	RoundListView.OnChange := nil;
	try
		RoundListView.Clear;
		for i := 0 to RoundList.Count[grtBoard] - 1 do begin
			if (RoundList.Items[i, grtBoard].RoundName = RoundName) or (RoundName = '') then begin
				ListItem := RoundListView.Items.Add;
				ListItem.Data := RoundList.Items[i, grtBoard];
				ListItem.Caption := RoundList.Items[i, grtBoard].RoundName;
				ListItem.SubItems.Add(RoundList.Items[i, grtBoard].BoardTitle);
				ListItem.SubItems.Add('-');
				ListItem.Checked := RoundList.Items[i, grtBoard].BoolData;
				ListItem.ImageIndex := 0;
			end;
		end;
		for i := 0 to RoundList.Count[grtItem] - 1 do begin
			if (RoundList.Items[i, grtItem].RoundName = RoundName) or (RoundName = '') then begin
				ListItem := RoundListView.Items.Add;
				ListItem.Data := RoundList.Items[i, grtItem];
				ListItem.Caption := RoundList.Items[i, grtItem].RoundName;
				ListItem.SubItems.Add(RoundList.Items[i, grtItem].BoardTitle);
				ListItem.SubItems.Add(RoundList.Items[i, grtItem].ThreadTitle);
				ListItem.Checked := RoundList.Items[i, grtItem].BoolData;
				ListItem.ImageIndex := 1;
			end;
		end;
	finally
		RoundListView.OnChange := ListChangeEvent;
	end;
end;

procedure TRoundDialog.RoundDeleteButtonClick(Sender: TObject);
var
	Board: TBoard;
	ThreadItem: TThreadItem;
	RoundItem: TRoundItem;
	ListChangeEvent: TLVChangeEvent;
begin
	ListChangeEvent := RoundListView.OnChange;
	RoundListView.OnChange := nil;
	try
		if RoundListView.Selected = nil then
			Exit;
		if TObject(RoundListView.Selected.Data) is TRoundItem then begin
			RoundItem := TRoundItem(RoundListView.Selected.Data);
			Board := BBS2ch.FindBBSID(RoundItem.BBSID);
			if RoundItem.RoundType = grtBoard then begin
				RoundList.Delete(Board);
				Board.Round := False;
				Board.RoundName := '';
			end else begin
				if not Board.IsThreadDatRead then
					GikoSys.ReadSubjectFile(Board);
				ThreadItem := BBS2ch.FindThreadItem(RoundItem.BBSID, RoundItem.FileName);
				RoundList.Delete(ThreadItem);
				ThreadItem.Round := False;
				ThreadItem.RoundName := '';
			end;
			GikoForm.ListView.Refresh;
		end;
		RoundListView.Selected.Delete;
	finally
		RoundListView.OnChange := ListChangeEvent;
	end;
end;

end.
