unit NewBoard;

interface

uses
	Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
	Dialogs, IdAntiFreezeBase, IdAntiFreeze, IdBaseComponent, IdComponent,
	IdTCPConnection, IdTCPClient, IdHTTP, IDException, StdCtrls, IniFiles,
	GikoSystem, BoardGroup;

type
	TNewBoardItem = record
		FResponseCode: Integer;
		FContent: string;
	end;

	TNewBoardDialog = class(TForm)
		Label1: TLabel;
		MessageMemo: TMemo;
		UpdateButton: TButton;
    CloseButton: TButton;
		Indy: TIdHTTP;
		IdAntiFreeze: TIdAntiFreeze;
		StopButton: TButton;
		Label2: TLabel;
		procedure UpdateButtonClick(Sender: TObject);
		procedure StopButtonClick(Sender: TObject);
		procedure CloseButtonClick(Sender: TObject);
		procedure FormCreate(Sender: TObject);
	private
		{ Private 錾 }
		FAbort: Boolean;
		function BoardDownload: TNewBoardItem;
		procedure UpdateURL(s: string);
	public
		{ Public 錾 }
	end;

var
	NewBoardDialog: TNewBoardDialog;

implementation

uses Giko, IdHeaderList;

{$R *.dfm}

procedure TNewBoardDialog.UpdateButtonClick(Sender: TObject);
var
	Item: TNewBoardItem;
begin
	try
		FAbort := False;
		UpdateButton.Enabled := False;
		StopButton.Enabled := True;
		CloseButton.Enabled := False;
		Item := BoardDownload;
		StopButton.Enabled := False;
		if FAbort then
			Exit;
		if Item.FContent <> '' then begin
			UpdateURL(Item.FContent);
			GikoForm.ReloadBBS;
		end else
			MessageMemo.Lines.Add('_E[hs܂[' + IntToStr(Item.FResponseCode) + ']');
	finally
		UpdateButton.Enabled := True;
		StopButton.Enabled := False;
		CloseButton.Enabled := True;
	end;
end;

procedure TNewBoardDialog.StopButtonClick(Sender: TObject);
begin
	FAbort := True;
	Indy.DisconnectSocket;
end;

procedure TNewBoardDialog.CloseButtonClick(Sender: TObject);
begin
	Close;
end;

function TNewBoardDialog.BoardDownload: TNewBoardItem;
var
	URL: string;
	Stream: TMemoryStream;
	s: string;
	i: Integer;
begin
	MessageMemo.Clear;
	Indy.Request.Clear;
	Indy.RecvBufferSize := Gikosys.Setting.RecvBufferSize;
	Indy.ProxyParams.BasicAuthentication := False;
	if GikoSys.Setting.ReadProxy then begin
		if GikoSys.Setting.ProxyProtocol then
			Indy.ProtocolVersion := pv1_1
		else
			Indy.ProtocolVersion := pv1_0;
		Indy.ProxyParams.ProxyServer := GikoSys.Setting.ReadProxyAddress;
		Indy.ProxyParams.ProxyPort := GikoSys.Setting.ReadProxyPort;
		Indy.ProxyParams.ProxyUsername := GikoSys.Setting.ReadProxyUserID;
		Indy.ProxyParams.ProxyPassword := GikoSys.Setting.ReadProxyPassword;
		if GikoSys.Setting.ReadProxyUserID <> '' then
			Indy.ProxyParams.BasicAuthentication := True;
	end else begin
		if GikoSys.Setting.Protocol then
			Indy.ProtocolVersion := pv1_1
		else
			Indy.ProtocolVersion := pv1_0;
		Indy.ProxyParams.ProxyServer := '';
		Indy.ProxyParams.ProxyPort := 80;
		Indy.ProxyParams.ProxyUsername := '';
		Indy.ProxyParams.ProxyPassword := '';
	end;
	URL := GikoSys.Setting.BoardURL2ch;
	Indy.Request.UserAgent := GikoSys.GetUserAgent;
	Indy.Request.Referer := '';
	Indy.Request.AcceptEncoding := 'gzip';

	Indy.Request.CacheControl := 'no-cache';
	Indy.Request.CustomHeaders.Add('Pragma: no-cache');

//	s := '';
	Stream := TMemoryStream.Create;
	try
		try
			MessageMemo.Lines.Add('ȉ̏ꏊ擾܂');
			MessageMemo.Lines.Add(GikoSys.Setting.BoardURL2ch);
			MessageMemo.Lines.Add('_E[hJn܂');
			Indy.Get(URL, Stream);
			Result.FContent := GikoSys.GzipDecompress(Stream, Indy.Response.ContentEncoding);
			MessageMemo.Lines.Add('_E[h܂');
		except
			on E: EIdConnectException do begin
				MessageMemo.Lines.Add('');
				MessageMemo.Lines.Add('ڑs܂ vLVAFW̏Ԃ𒲂ׂĂ');
				MessageMemo.Lines.Add('FWĂl͐ݒmFĂ');
				MessageMemo.Lines.Add('NECPC̏ꍇPC GATEĂ\ł');
				MessageMemo.Lines.Add('Message: ' + E.Message);
			end;
			on E: Exception do begin
				if FAbort then
					MessageMemo.Lines.Add('_E[h𒆒f܂')
				else begin
					MessageMemo.Lines.Add('_E[hs܂');
					MessageMemo.Lines.Add('ResponseCode: ' + IntToStr(Indy.ResponseCode));
					MessageMemo.Lines.Add('Message: ' + E.Message);
					MessageMemo.Lines.Add('------------------------');
					for i := 0 to Indy.Response.RawHeaders.Count - 1 do begin
						s := Indy.Response.RawHeaders.Names[i];
						s := s + ': ' + Indy.Response.RawHeaders.Values[s];
						MessageMemo.Lines.Add(s);
					end;
					MessageMemo.Lines.Add('------------------------');
				end;
			end;
		end;
		Result.FResponseCode := Indy.ResponseCode;
	finally
		Stream.Free;
	end;
end;

procedure TNewBoardDialog.UpdateURL(s: string);
var
	i: Integer;
	idx: Integer;
	idx1: Integer;
	idx2: Integer;
	tmp: string;
	URL: string;
	Title: string;
	cate: string;
	Board: TBoard;
	Change: Boolean;
	ini: TMemIniFile;
begin
	Change := False;
	MessageMemo.Lines.Add('VAURLύX`FbNJn܂');
	MessageMemo.Lines.Add('');
	s := StringReplace(s, '<B>', '<b>', [rfReplaceAll, rfIgnoreCase]);
	s := StringReplace(s, '<BR>', '<br>', [rfReplaceAll, rfIgnoreCase]);
	s := StringReplace(s, '</B>', '</b>', [rfReplaceAll, rfIgnoreCase]);
	s := StringReplace(s, '<A HREF', '<a href', [rfReplaceAll, rfIgnoreCase]);
	s := StringReplace(s, '</A', '</a', [rfReplaceAll, rfIgnoreCase]);
	cate := '';
	GikoSys.ForceDirectoriesEx(GikoSys.GetConfigDir);
	ini := TMemIniFile.Create(GikoSys.GetBoardFileName);
	try
		//
		//폜IvVIĂꍇ̓NA

		ini.Clear;
		while True do begin
			idx1 := AnsiPos('<b>', s);
			idx2 := AnsiPos('<a', s);
			if (idx1 = 0) and (idx2 = 0) then Break;

			if idx1 < idx2 then begin
				//<br>
				idx := AnsiPos('</b>', s);
				if idx = 0 then begin
					s := Copy(s, idx1 + 4, Length(s));
					continue;
				end;
				tmp := Copy(s, idx1, (idx - idx1) + 4);
				tmp := StringReplace(tmp, '<b>', '', [rfReplaceAll]);
				tmp := StringReplace(tmp, '</b>', '', [rfReplaceAll]);

				if (tmp = '') or
					 (tmp = 'ʊ') or
					 (tmp = '܂aar') or
					 (tmp = '`bg') or
					 (tmp = 'G') or
					 (tmp = '^c') or
					 (tmp = 'c[') or
					 (tmp = '̃TCg') then begin
					cate := '';
					s := Copy(s, idx + 5, Length(s));
					Continue;
				end;
				s := Copy(s, idx + 5, Length(s));
				cate := tmp;
			end else begin
				//<a href=
				if cate = '' then begin
					s := Copy(s, idx2 + 2, Length(s));
				end else begin
					idx := AnsiPos('</a>', s);
					tmp := Copy(s, idx2, (idx - idx2) + 4);
					tmp := StringReplace(tmp, '<a href=', '', [rfReplaceAll]);
					tmp := StringReplace(tmp, '</a>', '', [rfReplaceAll]);
					i := AnsiPos('>', tmp);
					if i <> 0 then begin
						URL := Copy(tmp, 1, i - 1);
						Title := Copy(tmp, i + 1, Length(tmp));
						Board := BBS2ch.FindBoardFromTitle(Title);
						if Board = nil then begin
							MessageMemo.Lines.Add('Vǉu' + Title + '(' + URL + ')v');
							ini.WriteString(cate, Title, URL);
							Change := True;
						end else begin
							if Board.URL <> URL then begin
								MessageMemo.Lines.Add('URLύXu' + Board.Title + '(' + URL +')v');
								ini.WriteString(cate, Title, URL);
								Change := True;
							end else begin
								ini.WriteString(cate, Title, URL);
							end;
						end;
					end else begin
						s := Copy(s, idx2 + 2, Length(s));
						Continue;
					end;
					s := Copy(s, idx + 5, Length(s));
				end;
			end;
		end;
	finally
		if Change then
			ini.UpdateFile;
		ini.Free;
	end;
	MessageMemo.Lines.Add('');
	if Change then begin
		MessageMemo.Lines.Add('VAURLύX`FbN܂');
		MessageMemo.Lines.Add('uv{^Ă');
	end else
		MessageMemo.Lines.Add('VAURLύX ܂ł');
end;

procedure TNewBoardDialog.FormCreate(Sender: TObject);
begin
	StopButton.Enabled := False;
end;

end.
