unit AbonUnit;

interface
uses
    Windows,Messages, ShellAPI, SysUtils, Classes,StdCtrls,StrUtils;

type
  TAbon = class(TObject)
  private
    { Private 錾 }
    Froot : String;
    Flistpath : String;
    FNGwordpath : String;
    Ftokens : array of array of string;
    FAbonString : String;
    FCutoffNum : Integer; //̐ȏA铯pNG[hƂ
    FDeleterlo : Boolean; //&rlo;邩
    FReplaceul :Boolean ; //<ul>^O<br>^Oɒu邩
    FReverse : Boolean ;  //NG[hł̂ځ`̌ʂ𔽓]邩
    FAbonPopupRes : Boolean; //X|bvAbv̎ɂځ[񂷂邩
    FCreateNGwordFile : Boolean; //w肳ꂽpathNG[htxtƂɎIɐ邩
    FNGwordFileIndex : Integer; //ݓǂݍłNG[hlist̉sڂ
    FNGwordname : String; //ݓǂݍłNG[h̕\
    procedure SetTokens(index: integer ; argline:String);
    function Getlistpath() : String;
    procedure Setlistpath(const Value : String);
    function LoadListFile(path :String;listStringList : TStringList) : Boolean;
    function ReadNGwordslist(line : Integer) : Boolean;
  public
    { Public 錾 }
    constructor Create; // RXgN^
    destructor Destroy; override; // fXgN^
    property Deleterlo: Boolean read FDeleterlo write FDeleterlo  default false;
    property Replaceul: Boolean read FReplaceul write FReplaceul  default false;
    property Reverse: Boolean read FReverse write FReverse  default false;
    property CreateNGwordFile: Boolean read FCreateNGwordFile write FCreateNGwordFile;
    property AbonString : String read FAbonString write FAbonString;
    property  AbonPopupRes : Boolean read FAbonPopupRes write FAbonPopupRes default false;
    property listpath : String read Getlistpath write Setlistpath;
    property NGwordFileIndex : Integer read FNGwordFileIndex write FNGwordFileIndex default 0;
    property NGwordname : String read FNGwordname write FNGwordname;
    procedure Setroot(root :String);
    function Getroot() : String;

    function Getfullpath(argpath : String) : String;
    procedure SetNGwordpath(path :String);
    function GetNGwordpath() : String;
    function LoadFromNGwordFile(path :String) : Boolean;
    function ReLoadFromNGwordFile() : Boolean;
    procedure LoadFromStringList( bufstl : TStringList );
    function CheckAbonPopupRes(line : String) :Boolean;
    function FindNGwords(line : String) : Boolean; //1CpB
    function Cutoff(line : String) : Boolean; //CutOfflȏ̓płtrue
    //ځ`񏈗
    procedure Execute(var ThreadStrings : TStringList); overload;
    procedure Execute(var ThreadStrings : TStringList; NGwords : TStringList); overload;
    procedure Execute(var ThreadStrings : TStringList; NGwords : TStrings); overload;
    //--
    function ExecuteFile(datfilepath : String; NGwordpath : String) : Boolean; overload;//DATt@C𒼂ɂ
    function ExecuteFile(datfilepath : String; resnum : Integer) : Boolean; overload; //DATt@C𒼂ɂ
    function ExecuteFile(datfilepath : String; firstres : Integer; count : Integer) : Boolean; overload; //DATt@C𒼂ɂ
    function ReverseExecuteFile(datfilepath : String) : Boolean; overload; //DATt@C𒼂ɂ
    function ReverseExecuteFile(datfilepath : String; resnum : Integer) : Boolean; overload; //DATt@C𒼂ɂ
    function ReverseExecuteFile(datfilepath : String; firstres : Integer; count : Integer) : Boolean; overload; //DATt@C𒼂ɂ
    //--
    procedure EditNGwords();  //NGword.txtJB
    function ShowAllTokens() : String;  //fobOp
    //--
    procedure GoHome();//List̂Psڂǂ
    function GoForward() : Boolean; //LisẗNG[ht@Cǂݍ
    function GoBack() : Boolean; //LisẗONG[ht@Cǂݍ
  end;
var
    Abon1 :TAbon;
const
    NGwordListFileName : String = 'NGwords.list';

implementation

constructor TAbon.Create;
begin
    // 
    FAbonString := '&nbsp;<>&nbsp;<>&nbsp;<>&nbsp;&nbsp;<><>';
    FCreateNGwordFile := true;
end;

destructor TAbon.Destroy;
begin
    inherited;
end;
//rootExe\config\NGwordstH_
procedure TAbon.Setroot(root :String);
var
    bufStringList : TStringList;
begin
    bufStringList := TStringList.Create;
    try
        if not DirectoryExists(root) then begin
            CreateDir(root);
        end;
        if root[Length(root)] <> '\' then begin
            root := root + '\';
        end;
        Flistpath := root + NGwordListFileName;
        LoadListFile(Flistpath, bufStringList);
    finally
        bufStringList.Free;
    end;
    Froot := root;
end;
function TAbon.Getroot() : String;
begin
    Result := Froot;
end;
//NGwordpathNGword.txt̃tpX
procedure TAbon.SetNGwordpath(path :String);
begin
    FNGwordpath := Getfullpath(path);
    LoadFromNGwordFile(FNGwordpath);
end;
function TAbon.GetNGwordpath() : String;
begin
    Result :=  FNGwordpath;
end;
//tpXłȂ΃tpXɂĕԂB
function TAbon.Getfullpath(argpath : String) : String;
begin
    if AnsiPos(':\',argpath) <> 2 then begin  //hCũtpX
        if Getroot() = '' then begin
            Result := '';    //rootpXݒ肳ĂȂɂ
        end else begin
            if (Froot[Length(Froot)] = '\') and (argpath[1] = '\') then begin  //擪\폜
                Delete(argpath,1,1);
            end;
            Insert( Getroot(), argpath , 1);//rootpX}
            Result := argpath;
        end;
    end else begin
        Result := argpath;
    end;

end;
//NGwordt@C̓ǂݍ
function TAbon.LoadFromNGwordFile(path :String) : boolean;
var
    bufstl : TStringList;
begin
    path := Getfullpath(path);
    if path = '' then begin
        Result := false;
    end else begin
        bufstl := TStringList.Create;
        try
            try
                bufstl.LoadFromFile(path);
                LoadFromStringList( bufstl );
                Result := true;
            except
                if CreateNGwordFile = true then begin
                    bufstl.SaveToFile(path);
                end;
                Result := false;
            end;
        finally
            bufstl.Free;
        end;
    end;

end;
//NGwordXgǂݍ
procedure TAbon.LoadFromStringList( bufstl : TStringList );
var
    i : integer;
begin
    try
        for i := bufstl.Count -1  downto 0 do begin
            if bufstl.Strings[i] = '' then begin
                bufstl.Delete(i);
            end;
        end;
        SetLength(Ftokens,bufstl.Count);
        for i := 0  to bufstl.Count -1 do begin
            SetTokens(i , bufstl.Strings[i]);
        end;

    except
        Exit;
    end;
end;
//NGwordpathɐݒ肳ĂƂ̃[hp֐
function TAbon.ReLoadFromNGwordFile() : boolean;
begin
    if GetNGwordpath() ='' then begin
        Result := false;
    end else begin
        Result := LoadFromNGwordFile( GetNGwordpath() );
    end;
end;
function TAbon.Getlistpath() : String;
begin
    Result := Flistpath;
end;
procedure TAbon.Setlistpath(const Value : String);
begin
    Flistpath := Getfullpath(Value);
end;
//s̒̃g[N؂蕪ăZbg
procedure TAbon.SetTokens(index: integer ; argline : String);
var
    ret : Integer;
    bufstl : TStringList;
    i : Integer;
begin
    bufstl := TStringList.Create;
    bufstl.Delimiter := #9;  //؂qf^ufɐݒ
    bufstl.DelimitedText := argline;
    ret := bufstl.Count;
    SetLength(Ftokens[index],ret);
    for i := 0 to bufstl.Count - 1  do begin
        Ftokens[index][i] := bufstl.Strings[i];
    end;
    bufstl.Free;

end;
//DebugpNG[hEĂ邩
function TAbon.ShowAllTokens() : String;
var
    i : Integer;
    j : Integer;
    ret : String;
begin
    for i := 0 to High(Ftokens) do begin
        for j := 0 to High(Ftokens[i]) do begin
            ret := ret + Ftokens[i][j];
        end;
    end;
    Result := ret;



end;

//****************************************************************************//
//NG[h܂܂ĂtrueԂB
function TAbon.FindNGwords(line : String) : Boolean;
var
    i : Integer;
    j : Integer;
    hit : Boolean;
begin
    hit := false;
    if AnsiPos(FAbonString,line) <> 1 then begin
        for i := 0 to High(Ftokens) do begin
            hit := true;
            for j := 0 to High(Ftokens[i]) do begin
                if AnsiPos(Ftokens[i][j],line) = 0 then begin
                    hit := false;
                    break;
                end else begin
                    Delete(line,AnsiPos(Ftokens[i][j],line),Length(Ftokens[i][j]));
                end;
            end;
            if hit = true then begin
                break;
            end;
        end;
    end;
    Result := hit;

end;
//CutOfflȏ̓płtrue
function TAbon.Cutoff(line : String) : Boolean;
var
    i : Integer;
    sheed : AnsiChar;
    buf : String;
    ret : Bool;
begin
    ret := false;
    if FCutoffNum <> 0 then begin
        for i := 65 to 90 do begin
            sheed := Chr(i);
            buf := DupeString(sheed, FCutoffNum);
            if AnsiContainsText(line, buf) = true then begin
                ret := true;
                break;
            end;
        end;
    end;
    Result := ret;
end;
//̃u[ltrueƁANG[h܂ނ̂ԂB
procedure TAbon.Execute(var ThreadStrings : TStringList);
var
    i : Integer;
    bufline : String;
begin
    //FRetStrings.Clear;

    for i:=0 to ThreadStrings.Count - 1 do begin
        if FindNGwords(ThreadStrings.Strings[i]) <> Reverse  then begin
            ThreadStrings.Strings[i] := FAbonString;
        end else begin
            bufline := ThreadStrings.Strings[i];
            if Deleterlo = true then begin
                bufline := AnsiReplaceText( bufline,'&rlo;','' );
            end;
            if Replaceul = true then begin
                bufline := AnsiReplaceText( bufline,'<ul>','<br>' );
                bufline := AnsiReplaceText( bufline,'</ul>','<br>' );
            end;
            ThreadStrings.Strings[i] := bufline;
        end;
    end;

end;
procedure TAbon.Execute(var ThreadStrings : TStringList; NGwords : TStringList);
var
    i : Integer;
begin
    SetLength(Ftokens,NGwords.Count);
    for i := 0  to NGwords.Count -1 do begin
        SetTokens(i , NGwords.Strings[i]);
    end;
    Execute(ThreadStrings);

end;
procedure TAbon.Execute(var ThreadStrings : TStringList; NGwords : TStrings);
var
    i : Integer;
    buf : TStringList;
begin
    buf := TStringList.Create;
    buf.AddStrings(NGwords);
    SetLength(Ftokens,buf.Count);
    for i := 0  to buf.Count -1 do begin
        SetTokens(i , buf.Strings[i]);
    end;
    Execute(ThreadStrings);
    buf.Free;
end;


//****************************************************************************//
//DAT𒼂ɂz===========================================================
//NG[h܂ރX̐擪ɂځ[}
function TAbon.ExecuteFile(datfilepath : String; NGwordpath : String) : Boolean; //DATt@C𒼂ɂ
var
    datstl : TStringList;
    ret : Boolean;
    i : Integer;
begin
    datstl := TStringList.Create;
    ret := true;
    try
        try
            datstl.LoadFromFile(datfilepath);
            for i := 0 to datstl.Count -1 do begin
                if FindNGwords(datstl.Strings[i]) = true  then begin
                    datstl.Strings[i] := FAbonString + datstl.Strings[i]
                end;
            end;

            datstl.SaveToFile(datfilepath);
        except
            ret := false;
        end;
    finally
        datstl.Free;
    end;
    Result := ret;

end;
//w肳ꂽXԂ̐擪ɂځ[}
function TAbon.ExecuteFile(datfilepath : String; resnum : Integer) : Boolean; //DATt@C𒼂ɂ
var
    datstl : TStringList;
    ret : Boolean;
begin
    ret := true;
    datstl := TStringList.Create;
    try
        try
            datstl.LoadFromFile(datfilepath);
            if (resnum > 0) and (resnum <= datstl.Count) then begin
                if AnsiPos(FAbonString, datstl.Strings[resnum-1]) <> 1 then begin
                    datstl.Strings[resnum-1] := FAbonString + datstl.Strings[resnum-1];
                end;
            end;
            datstl.SaveToFile(datfilepath);
        except
            ret := false;
        end;
    finally
        datstl.Free;
    end;
    Result := ret;
end;
//firstrescount̃X̐擪ɂځ[}
function TAbon.ExecuteFile(datfilepath : String; firstres : Integer; count : Integer) : Boolean; //DATt@C𒼂ɂ
var
    datstl : TStringList;
    i : Integer;
    endnum : Integer; //ĨX
    ret : Boolean;
begin
    ret := true;
    datstl := TStringList.Create;
    try
        try
            datstl.LoadFromFile(datfilepath);
            if (firstres > 0) and (firstres <= datstl.Count) then begin
                if firstres + count -1 > datstl.Count then begin
                    endnum := datstl.Count;
                end else if count <= 0 then begin
                    endnum := firstres + 1;
                end else begin
                    endnum := firstres + count -1;
                end;

                for i := firstres to endnum do begin
                    if AnsiPos(FAbonString, datstl.Strings[i-1]) <> 1 then begin
                        datstl.Strings[i-1] := FAbonString + datstl.Strings[i-1];
                    end;
                end;
            end;
            datstl.SaveToFile(datfilepath);
        except
            ret := false;
        end;
    finally
        datstl.Free;
    end;
    Result := ret;
end;
//DAT𒼂ɂz==========܂=========================================

//ɖ߂z==================================================================
function TAbon.ReverseExecuteFile(datfilepath : String) : Boolean; //DATt@C𒼂ɂ
var
    datstl : TStringList;
    i : Integer;
    buf : String;
    ret : Boolean;
begin
    ret := true;
    datstl := TStringList.Create;
    try
        try
            datstl.LoadFromFile(datfilepath);
            for i:=0 to datstl.Count -1  do begin
                if AnsiPos(FAbonString, datstl.Strings[i]) = 1 then begin
                    buf := datstl.Strings[i];
                    Delete(buf,1,Length(FAbonString));
                    datstl.Strings[i] := buf;
                end;
            end;
            datstl.SaveToFile(datfilepath);
        except
            ret := false;
        end;
    finally
        datstl.Free;
    end;
    Result := ret;

end;
function TAbon.ReverseExecuteFile(datfilepath : String; resnum : Integer) : Boolean; //DATt@C𒼂ɂ
var
    datstl : TStringList;
    buf : String;
    ret : Boolean;
begin
    ret := true;
    datstl := TStringList.Create;
    try
        try
            datstl.LoadFromFile(datfilepath);
            if (resnum > 0) and (resnum <= datstl.Count) then begin
                if AnsiPos(FAbonString, datstl.Strings[resnum-1]) = 1 then begin
                    buf := datstl.Strings[resnum-1];
                    Delete(buf,1,Length(FAbonString));
                    datstl.Strings[resnum-1] := buf;
                end;
            end;
            datstl.SaveToFile(datfilepath);
        except
            ret := false;
        end;
    finally
        datstl.Free;
    end;
    Result := ret;

end;
function TAbon.ReverseExecuteFile(datfilepath : String; firstres : Integer; count : Integer) : Boolean;//DATt@C𒼂ɂ
var
    datstl : TStringList;
    i : Integer;
    endnum : Integer; //ĨX
    buf : String;
    ret : Boolean;
begin
    ret := true;
    datstl := TStringList.Create;
    try
        try
            datstl.LoadFromFile(datfilepath);
            if (firstres > 0) and (firstres <= datstl.Count) then begin
                if firstres + count -1 > datstl.Count then begin
                    endnum := datstl.Count;
                end else if count <= 0 then begin
                    endnum := firstres + 1;
                end else begin
                    endnum := firstres + count -1;
                end;
                for i := firstres to endnum do begin
                    if AnsiPos(FAbonString, datstl.Strings[i-1]) = 1 then begin
                        buf := datstl.Strings[i-1];
                        Delete(buf,1,Length(FAbonString));
                        datstl.Strings[i-1] := buf;
                    end;
                end;
            end;
            datstl.SaveToFile(datfilepath);
        except
            ret := false;
        end;
    finally
        datstl.Free;
    end;
    Result := ret;
end;
//ɖ߂z=================܂=========================================
//݃ZbgĂNGword.txtJ
procedure TAbon.EditNGwords();
begin
    ShellExecute(0 ,nil,PChar(FNGwordpath),nil,nil,SW_SHOW);
end;
function TAbon.CheckAbonPopupRes(line : String) :Boolean;
begin
    if AbonPopupRes = true then begin
        Result := FindNGwords(line);
    end else begin
        Result := false;
    end;
end;
//NG[heLXgǂݍ==============================================
//Listt@Cǂݍ
function TAbon.LoadListFile(path :String; listStringList : TStringList) : Boolean;
begin
    try
        listStringList.LoadFromFile(path);
        Result := true;
    except
        listStringList.Append('=NGword.txt');
        listStringList.SaveToFile(path);
        Result := false;
    end;
end;
//LisẗNG[ht@Cǂݍ
function TAbon.GoForward() : Boolean;
begin
    FNGwordFileIndex := FNGwordFileIndex + 1;
    Result := ReadNGwordslist(FNGwordFileIndex);
end;
//LisẗONG[ht@Cǂݍ
function TAbon.GoBack() : Boolean;
begin
    FNGwordFileIndex := FNGwordFileIndex -1;
    Result := ReadNGwordslist(FNGwordFileIndex);
end;
//List̂Psڂǂ
procedure TAbon.GoHome();
begin
    FNGwordFileIndex := 0;
    ReadNGwordslist(FNGwordFileIndex);
end;
//Listlinesڂǂ
function TAbon.ReadNGwordslist(line : Integer) : Boolean;
var
    liststl : TStringList;
    linebuf : String;
begin
    liststl := TStringList.Create;
    try
        if LoadListFile(Flistpath,liststl) = true then begin
            if line < 0 then begin
                line := liststl.Count - 1;
                FNGwordFileIndex := liststl.Count - 1;
            end else if line > liststl.Count - 1 then begin
                line := 0;
                FNGwordFileIndex := 0;
            end;
            linebuf := liststl.Strings[line];
            FNGwordname := Copy(linebuf,1,AnsiPos('=',linebuf)-1);
            Delete(linebuf,1,AnsiPos('=',linebuf));
            SetNGwordpath(linebuf);
            Result := true;
        end else begin
            Result := false;
        end
    finally
        liststl.Free;
    end;

end;
//NG[heLXgǂݍ=====܂=================================
end.

