library ShitarabaJBBSPlugIn;

{
	ShitarabaJBBSPlugIn
	Ώjbg
	$Id: ShitarabaJBBSPlugIn.dpr,v 1.22 2004/04/12 15:47:22 h677 Exp $
}

uses
	Windows, SysUtils, Classes, Math, DateUtils, Dialogs,
	IdURI,
	PlugInMain in 'PlugInMain.pas',
	ThreadItem in 'ThreadItem.pas',
	BoardItem in 'BoardItem.pas',
	FilePath in 'FilePath.pas',
	Y_TextConverter in 'Y_TextConverter.pas',
	MojuUtils in '..\..\MojuUtils.pas';

{$R *.res}

type
	// =========================================================================
	// TShitarabaThreadItem
	// =========================================================================
	TShitarabaThreadItem = class(TThreadItem)
	private
		FIsTemporary	: Boolean;
		FDat					: TStringList;

	public
		constructor	Create( inInstance : DWORD );
		destructor	Destroy; override;

	private
		function	Download : TDownloadState;
		function	Write( inName : string; inMail : string; inMessage : string ) : TDownloadState;
		function	GetRes( inNo : Integer ) : string;
		function	GetDat( inNo : Integer ) : string;
		function	GetHeader( inOptionalHeader : string ) : string;
		function	GetFooter( inOptionalFooter : string ) : string;
		function	GetBoardURL : string;
		procedure	ArrangeDownloadData( start: Integer;var Data: TStringList);
		procedure	LoadDat;
		procedure	FreeDat;
		function	BrowsableURL : string;
		function	ReadURL : string;
		function	WriteURL : string;
	end;

	// =========================================================================
	// TShitarabaBoardItem
	// =========================================================================
	TShitarabaBoardItem = class(TBoardItem)
	private
		FIsTemporary	: Boolean;
		FDat					: TStringList;

	public
		constructor	Create( inInstance : DWORD );
		destructor	Destroy; override;

	private
		function	Download : TDownloadState;
		function	CreateThread( inSubject : string; inName : string; inMail : string; inMessage : string ) : TDownloadState;
		function	ToThreadURL( inFileName : string ) : string;
		procedure	EnumThread( inCallBack : TBoardItemEnumThreadCallBack );

		function	SubjectURL : string;
	end;

const
	LOG_DIR						= 'ShitarabaJBBS\';
	SUBJECT_NAME			= 'subject.txt';

	PLUGIN_NAME				= 'ShitarabaJBBS';
	MAJOR_VERSION			= 1;
	MINOR_VERSION			= 1;
	RELEASE_VERSION		= 'alpha';
	REVISION_VERSION	= 2;

	SYNCRONIZE_MENU_CAPTION	= 'JBBSXV';

var
	SyncronizeMenu		: HMENU;

// =========================================================================
// Gp֐
// =========================================================================

// *************************************************************************
// e|ȃpX̎擾
// *************************************************************************
function TemporaryFile : string;
var
	tempPath : array [0..MAX_PATH] of	char;
begin

	GetTempPath( SizeOf(tempPath), tempPath );
	repeat
		Result := tempPath + IntToStr( Random( $7fffffff ) );
	until not FileExists( Result );

end;

// *************************************************************************
// ΗpOtH_擾
// *************************************************************************
function MyLogFolder : string;
var
	folder : PChar;
begin

	folder := LogFolder;
	if Length( folder ) = 0 then
		Result := ''
	else
		Result := folder + LOG_DIR;
    DisposeResultString(folder);

end;

(*************************************************************************
 *fBNg݂邩`FbN
 *************************************************************************)
function DirectoryExistsEx(const Name: string): Boolean;
var
	Code: Integer;
begin
	Code := GetFileAttributes(PChar(Name));
	Result := (Code <> -1) and (FILE_ATTRIBUTE_DIRECTORY and Code <> 0);
end;

(*************************************************************************
 *fBNg쐬iKwΉj
 *************************************************************************)
function ForceDirectoriesEx(Dir: string): Boolean;
begin
	Result := True;
	if Length(Dir) = 0 then
		raise Exception.Create('tH_쐬o܂');
	Dir := ExcludeTrailingPathDelimiter(Dir);
	if (Length(Dir) < 3) or DirectoryExistsEx(Dir)
		or (ExtractFilePath(Dir) = Dir) then Exit; // avoid 'xyz:\' problem.
	Result := ForceDirectoriesEx(ExtractFilePath(Dir)) and CreateDir(Dir);
end;

// Ƃ肠̑piȂ̂ chrWhite lĂȂƂɒӁIII
procedure ExtractHttpFields(
	const chrSep : TSysCharSet;
	const chrWhite : TSysCharSet;
	const strValue : string;
	var strResult : TStringList;
	unknownFlag : boolean = false
);
var
	last, p, strLen : Integer;
begin

	strLen := Length( strValue );
	p := 1;
	last := 1;

	while p <= strLen do
	begin

		if strValue[ p ] in chrSep then
		begin
			strResult.Add( Copy( strValue, last, p - last ) );
			last := p + 1;
		end;

		p := p + 1;

	end;

	if last <> p then
		strResult.Add( Copy( strValue, last, strLen - last + 1 ) );

end;


function HttpEncode(

	const strValue : string
) : string;
var
	i : Integer;
	strLen : Integer;
	strResult : string;
	b : Integer;
const
	kHexCode : array [0..15] of char = (
				'0', '1', '2', '3', '4', '5', '6', '7',
				'8', '9', 'A', 'B', 'C', 'D', 'E', 'F' );
begin

	strLen := Length( strValue );
	i := 1;

	while i <= strLen do
	begin

		case strValue[ i ] of
		'0' .. '9', 'a' .. 'z', 'A' .. 'Z', '*', '-', '.', '@', '_':
			begin
				strResult := strResult + strValue[ i ];
			end;
		else
			begin
				b := Integer( strValue[ i ] );
				strResult := strResult + '%'
								+ kHexCode[ b div $10 ]
								+ kHexCode[ b mod $10 ];
			end;
		end;

		i := i + 1;

	end;

	Result := strResult;

end;



// =========================================================================
// PlugIn
// =========================================================================

// *************************************************************************
// vOC()[hꂽ
// *************************************************************************
procedure OnLoad(
	inInstance : DWORD				// vOC̃CX^X
); stdcall;
begin

	// vOCj[ɒǉ
	SyncronizeMenu := AddPlugInMenu( inInstance, SYNCRONIZE_MENU_CAPTION );

end;

// *************************************************************************
// vOC̃o[Wvꂽ
// *************************************************************************
procedure OnVersionInfo(
	var outAgent		: PChar;	// o[W؊܂܂ȂȖ
	var outMajor		: DWORD;	// W[o[W
	var outMinor		: DWORD;	// }Ci[o[W
	var outRelease	: PChar;	// [XiK
	var outRevision	: DWORD		// rWio[
); stdcall;
begin

	try
		outAgent		:= CreateResultString( PChar( PLUGIN_NAME ) );
		outMajor		:= MAJOR_VERSION;
		outMinor		:= MINOR_VERSION;
		outRelease	:= CreateResultString( PChar( RELEASE_VERSION ) );
		outRevision	:= REVISION_VERSION;
	except
		outAgent		:= nil;
		outMajor		:= 0;
		outMinor		:= 0;
		outRelease	:= nil;
		outRevision	:= 0;
	end;

end;

// *************************************************************************
// w肵 URL ̃vOCŎ󂯕t邩ǂ
// *************************************************************************
function OnAcceptURL(
	inURL			: PChar				// fł URL
): TAcceptType; stdcall;	// URL ̎
var
	uri				: TIdURI;
	uriList		: TStringList;
	foundPos	: Integer;
const
	BBS_HOST	 	= 'jbbs.shitaraba.com';
	THREAD_MARK	= '/bbs/read.cgi';
begin

	try
		// zXg jbbs.shitaraba.com ŏIꍇ͎󂯕t悤ɂĂ
		uri			:= TIdURI.Create( inURL );
		uriList	:= TStringList.Create;
		try
	 		ExtractHttpFields( ['/'], [], uri.Path, uriList );
			foundPos := AnsiPos( BBS_HOST, uri.Host );
			if (foundPos > 0) and (Length( uri.Host ) - foundPos + 1 = Length( BBS_HOST )) then begin
				foundPos := ANsiPos( THREAD_MARK, inURL );
				if foundPos > 0 then
					Result := atThread
				else if uriList.Count > 2 then	// Ōオ '/' ŕ߂ĂȂ 4
					Result := atBoard
				else
					Result := atBBS;
			end else begin
				Result := atNoAccept;
			end;
		finally
			uri.Free;
			uriList.Free;
		end;
	except
		Result := atNoAccept;
	end;

end;

// *************************************************************************
// JBBSXV
// *************************************************************************
procedure OnBoardSyncronizeMenu(
	inHandle	: HMENU					// j[nh
); stdcall;
var
	category			: string;
	keyword				: string;
	savepath			: string;
	success				: Boolean;
	initdir				: string;
	filter				: string;

	agent					: PChar;
	major					: DWORD;
	minor					: DWORD;
	release				: PChar;
	revision			: DWORD;

	url						: string;
	modified	 		: Double;
	tmp						: PChar;
	downResult		: string;
	saveText			: TStringList;
	responseCode	: Longint;

	found					: Integer;
	found2				: Integer;
	board					: string;
const
	CATEGORY_INPUT	= 'JeS͂Ă';
	KEYWORD_INPUT		= '͂Ă';
	SAVEPATH_SELECT	= 'ۑt@C͂Ă';
	BBS_HOST	 	= 'http://jbbs.shitaraba.com/';
label
	NextBoard;
begin

	category := 'computer';
	success	:= InputQuery( SYNCRONIZE_MENU_CAPTION, CATEGORY_INPUT, category );
	if not success then
		Exit;
	keyword		:= InputBox( SYNCRONIZE_MENU_CAPTION, KEYWORD_INPUT, '' );
	if keyword = '' then
		Exit;

	VersionInfo( agent, major, minor, release, revision );
	try
		initdir	:= PreferencesFolder;
		filter	:= 'Ẵׂt@C (*.*)|*.*';
		if agent = 'gikoNavi' then begin
			if DirectoryExists( initdir + 'Board\' ) then
				initdir	:= initdir + 'Board\';
			filter	:= 't@C (*.txt)|*.txt';
		end;
	finally
		DisposeResultString( agent );
		DisposeResultString( release );
	end;
	savepath	:= keyword;
	success		:= PromptForFileName( savepath, filter, 'txt', SYNCRONIZE_MENU_CAPTION, initdir, True );
	if not success then
		Exit;

	InternalPrint( '擾ł' );
	try
		url :=
			'http://jbbs.shitaraba.com/bbs/left_menu.cgi?CATEGORY=' + category +
			'&WORD=' + HttpEncode( SJIStoEUC( keyword ) );

		responseCode := InternalDownload( PChar( url ), modified, tmp );
		try
			if (responseCode = 200) or (responseCode = 206) then begin
				saveText := TStringList.Create;
				saveText.Add( '[' + keyword + ']' );
				downResult := EUCtoSJIS( tmp );
				found := AnsiPos( '<a ', downResult );
				while found > 0 do begin
					downResult := Copy( downResult, found + 3, MaxInt );	// 3 = Length( '<a ' )
					found := AnsiPos( 'href=', downResult );
					if found = 0 then
						Break;

					if downResult[ found + 5 ] = '"' then begin // 5 = Length( 'href=' )
						downResult := Copy( downResult, found + 6, MaxInt );	// 6 = Length( 'href="' )
						found := AnsiPos( '"', downResult );
					end else begin
						downResult := Copy( downResult, found + 5, MaxInt );	// 5 = Length( 'href=' )
						found		:= AnsiPos( ' ', downResult );
						found2	:= AnsiPos( '>', downResult );
						if (found = 0) or (found2 = 0) then
							found := Max( found, found2 )
						else
							found := Min( found, found2 );
					end;
					board := Copy( downResult, 1, found - 1 );
					downResult := Copy( downResult, found, MaxInt );

					if board = BBS_HOST then
						goto NextBoard;
					if AnsiPos( '../', board ) = 1 then
						board := BBS_HOST + Copy( board, 1 + 3, MaxInt );	// 3 = Length( '../' )

					found := AnsiPos( '>', downResult );
					if found = 0 then
						Break;
					downResult := Copy( downResult, found + 1, MaxInt );	// 1 = Length( '>' )

					found := AnsiPos( '</a>', downResult );
					if found = 0 then
						Break;
					board := Copy( downResult, 1, found - 1 ) + '=' + board;
					downResult := Copy( downResult, found + 4, MaxInt );	// 4 = Length( '</a>' )

					saveText.Add( board );
NextBoard:
		 		 	found := AnsiPos( '<a ', downResult );
				end;
				saveText.SaveToFile( savepath );
				saveText.Free;
			end else begin
				InternalPrint( PChar( '̎擾Ɏs܂(' + IntToStr( responseCode ) + ')' ) );
			end;
		finally
			DisposeResultString( tmp );
		end;
		InternalPrint( '擾' );
	except
		InternalPrint( '̎擾Ɏs܂' );
	end;

end;

// j[nh
procedure OnPlugInMenu(
	inHandle : HMENU					// j[nh
); stdcall;
begin

	if inHandle = SyncronizeMenu then
		OnBoardSyncronizeMenu( inHandle );

end;

// =========================================================================
// TShitarabaThreadItem
// =========================================================================

// *************************************************************************
// RXgN^
// *************************************************************************
constructor TShitarabaThreadItem.Create(
	inInstance	: DWORD
);
var
	uri					: TIdURI;
	uriList			: TStringList;
begin

	inherited;

	OnDownload		:= Download;
	OnWrite				:= Write;
	OnGetRes			:= GetRes;
	OnGetDat			:= GetDat;
	OnGetHeader		:= GetHeader;
	OnGetFooter		:= GetFooter;
	OnGetBoardURL	:= GetBoardURL;

	FilePath			:= '';
	FIsTemporary	:= False;
	FDat					:= nil;
	URL						:= BrowsableURL;

	uri			:= TIdURI.Create( ReadURL );
	uriList := TStringList.Create;
	try
		ExtractHttpFields( ['/', '?'], [], uri.Path, uriList );
		FileName	:= uriList[ 5 ] + '.dat';
		FilePath	:= MyLogFolder + uriList[ 3 ] + '\' + uriList[ 4 ] + '\' + uriList[ 5 ] + '.dat';
		IsLogFile	:= FileExists( FilePath );
	finally
		uri.Free;
		uriList.Free;
	end;

end;

// *************************************************************************
// fXgN^
// *************************************************************************
destructor TShitarabaThreadItem.Destroy;
begin

	FreeDat;

	// ꎞt@C̏ꍇ͍폜
	if FIsTemporary then
		DeleteFile( FilePath );

	inherited;

end;

// *************************************************************************
// w肵 URL ̃Xbh̃_E[hwꂽ
// *************************************************************************
function TShitarabaThreadItem.Download : TDownloadState;
var
	modified			: Double;
	tmp						: PChar;
	downResult		: TStringList;
	responseCode	: Longint;
	logStream			: TFileStream;
	uri						: TIdURI;
	uriList				: TStringList;
	datURL				: string;
		tmpText: string;
begin

	Result := dsError;

	uri := TIdURI.Create( ReadURL );
	uriList := TStringList.Create;
	try
		ExtractHttpFields( ['/', '?'], [], uri.Path, uriList );
		FileName := uriList[ 5 ] + '.dat';
		// http://jbbs.shitaraba.com/bbs/rawmode.cgi/game/1578/1067968274/l100
		// protocol://host/1/2/3/4/5/uriList.Count - 1
		if MyLogFolder = '' then begin
			// ǂɕۑĂ̂Ȃ̂ňꎞt@Cɕۑ
			FilePath 			:= TemporaryFile;
			FIsTemporary	:= True;
		end else begin
			FilePath			:= MyLogFolder + uriList[ 3 ] + '\' + uriList[ 4 ] + '\' + uriList[ 5 ] + '.dat';
			FIsTemporary	:= False;
		end;
	finally
		uri.Free;
		uriList.Free;
	end;

	// ۑp̃fBNg@
	ForceDirectoriesEx( Copy( FilePath, 1, LastDelimiter( '\', FilePath ) ) );

	// ƎɃ_E[htB^OsȂꍇ
	// InternalDownload ɔC邱Ƃo
	modified	:= LastModified;
	datURL		:= ReadURL + IntToStr( Count + 1 ) + '-'; // V̂
	responseCode := InternalDownload( PChar( datURL ), modified, tmp, 0 );

	try
		if (responseCode = 200) or (responseCode = 206) then begin
			downResult := TStringList.Create;
			try
								tmpText := CustomStringReplace( string( tmp ), '', ',' );
				downResult.Text := EUCtoSJIS( tmpText );
								ArrangeDownloadData(Count, downResult);
				if downResult.Count > 0 then begin
					if FileExists( FilePath ) then
						logStream := TFileStream.Create( FilePath, fmOpenReadWrite or fmShareDenyWrite )
					else
						logStream := TFileStream.Create( FilePath, fmCreate or fmShareDenyWrite );
					try
						logStream.Position	:= logStream.Size;
						logStream.Write( PChar( downResult.Text )^, Length( downResult.Text ) );
					finally
						logStream.Free;
					end;

					if Count = 0 then
											// VK
						Result := dsComplete
					else
						// ǋL
						Result := dsDiffComplete;

										Size					:= Size + Length( downResult.Text );
					// CGI ͐tȂ̂Ō݂ɐݒ
					LastModified	:= Now;



					NewReceive		:= Count + 1;
					Count					:= Count + downResult.Count;
					NewResCount		:= downResult.Count;



				end else begin
					Result := dsNotModify;
				end;
			finally
				downResult.Free;
			end;
		end else if responseCode = 304 then begin
			Result := dsNotModify;
		end;
	finally
		DisposeResultString( tmp );
	end;

end;
// *************************************************************************
// downloadĂDat̂ځ[񂳂ꂽ[āA
// Xƈv悤ɂ
// *************************************************************************
procedure	TShitarabaThreadItem.ArrangeDownloadData(
	start: Integer;	// VKFO@ǋLFO܂ł̎擾
		var Data: TStringList	//Dat̃f[^
);
var
	i: Integer;
		n: Integer;
		tmp: string;
begin
	i := start;
		while i < Data.count + start do begin
			try
					tmp := Copy(Data[i - start], 1 , AnsiPos('<>', Data[ i - start ] )-1 );
						try
							n := StrToInt(tmp);
								if n > i + 1 then begin
									Data.Insert(i - start, Format('%d<><><><><><>', [i+1]));
								end;
								Inc(i);
						except
							Inc(i);
			end;
				except

				end;
		end;

end;


// *************************************************************************
// ݂wꂽ
// *************************************************************************
function	TShitarabaThreadItem.Write(
	inName				: string;	// O(nh)
	inMail				: string;	// [AhX
	inMessage			: string	// {
) : TDownloadState;				// ݂ǂ
var
	postData			: string;
	postResult		: PChar;
	uri						: TIdURI;
	uriList				: TStringList;
	responseCode	: Integer;
begin

	uri			:= TIdURI.Create( URL );
	uriList	:= TStringList.Create;
	try
		ExtractHttpFields( ['/', '?'], [], uri.Path, uriList );

		// http://jbbs.shitaraba.com/bbs/read.cgi/game/1578/1067968274/l100
		postData	:=
			'NAME='			+ HttpEncode( SJIStoEUC( inName ) ) +
			'&MAIL='		+ HttpEncode( SJIStoEUC( inMail ) ) +
			'&MESSAGE='	+ HttpEncode( SJIStoEUC( inMessage ) ) +
			'&BBS='			+ uriList[ 4 ] +
			'&KEY='			+ uriList[ 5 ] +
			'&DIR='			+ uriList[ 3 ] +
			'&TIME='		+ IntToStr( DateTimeToUnix( Now ) ) +
			'&submit='	+ HttpEncode( SJIStoEUC( '' ) );

		// ƎɒʐMȂꍇ InternalPost ɔC邱Ƃo
		responseCode := InternalPost( PChar( WriteURL ), PChar( postData ), postResult );
		try
			if (responseCode = 200) or
				((responseCode = 302) and (Length( Trim( postResult ) ) = 0)) then begin
				Result := dsComplete
			end else begin
				Result := dsError;
				if Assigned( InternalPrint ) then
					InternalPrint( postResult );
			end;
		finally
			DisposeResultString( postResult );
		end;
	finally
		uri.Free;
		uriList.Free;
	end;

end;

// *************************************************************************
// Xԍ inNo ɑ΂ html vꂽ
// *************************************************************************
function TShitarabaThreadItem.GetRes(
	inNo		: Integer		// vꂽXԍ
) : string;						// Ή HTML
var
	res		 	: string;
	tmp			: PChar;
begin

	// ƎɃtB^OsȂꍇ
	// InternalAbon  Dat2HTML ɔC邱Ƃo
		{
	LoadDat;
	if FDat = nil then begin
		// Oɑ݂Ȃ̂ł̂܂܏I
		Result := '';
		Exit;
	end;
	res := Copy( FDat[ inNo - 1 ], AnsiPos( '<>', FDat[ inNo - 1 ] ) + 2, MaxInt );
		}
		res := GetDat( inNo );
	tmp := InternalAbonForOne( PChar( res ), PChar( FilePath ),inNo );
	try
		Result := Dat2HTML( string( tmp ), inNo );
	finally
		DisposeResultString( tmp );
	end;

end;

// *************************************************************************
// Xԍ inNo ɑ΂ Dat vꂽ
// *************************************************************************
function TShitarabaThreadItem.GetDat(
	inNo		: Integer		// vꂽXԍ
) : string;						// Q˂Dat`
var
	res		 	: string;
	tmp			: array[1..5] of string;
	i			: Integer;
	pTmp		: PChar;
begin
	pTmp := nil;
	// ƎɃtB^OsȂꍇ
	// InternalAbon  Dat2HTML ɔC邱Ƃo
	LoadDat;
	if FDat = nil then begin
		// Oɑ݂Ȃ̂ł̂܂܏I
		Result := '';
		Exit;
	end;
	try
		res := Copy( FDat[ inNo - 1 ], AnsiPos( '<>', FDat[ inNo - 1 ] ) + 2, MaxInt );
		//ID\Ă̂ł𓊍êƂɓ
		// O<>[<>t<>{<>X^C<>ID
		for i := 0 to 4 do begin
			tmp[ i + 1 ] := Copy( res, 1, AnsiPos('<>', res) - 1 );
			Delete( res, 1, AnsiPos('<>', res) + 1 );
		end;
		// O<>[<>tID<>{<>X^C
		pTmp := CreateResultString(tmp[1] + '<>' + tmp[2] + '<>' + tmp[3] + ' ' + res + '<>'+ tmp[4] + '<>' +tmp[5]);
		Result := string(pTmp);
	finally
		DisposeResultString(pTmp);
	end;

end;

// *************************************************************************
// Xbh̃wb_ html vꂽ
// *************************************************************************
function TShitarabaThreadItem.GetHeader(
	inOptionalHeader	: string
) : string;
begin

	// ƎɃtB^OsȂꍇ
	// InternalHeader ɔC邱Ƃo
	Result := InternalHeader(
		'<meta http-equiv="Content-type" content="text/html; charset=Shift_JIS">' +
		inOptionalHeader );


	// GetRes Ă΂邱Ƃ\ẑ FDat 𐶐Ă
	try
		FreeDat;
		LoadDat;
	except
	end;

end;

// *************************************************************************
// Xbh̃tb^ html vꂽ
// *************************************************************************
function TShitarabaThreadItem.GetFooter(
	inOptionalFooter : string
) : string;
begin

	// ƎɃtB^OsȂꍇ
	// InternalFooter ɔC邱Ƃo
	Result := InternalFooter( inOptionalFooter );

	//  GetRes ͌Ă΂ȂƎv̂ FDat JĂ
	try
		FreeDat;
	except
	end;

end;

// *************************************************************************
//  ThreadItem  URL vꂽ
// *************************************************************************
function	TShitarabaThreadItem.GetBoardURL : string;
var
	uri						: TIdURI;
	uriList				: TStringList;
begin

	uri			:= TIdURI.Create( ReadURL );
	uriList := TStringList.Create;
	try
		ExtractHttpFields( ['/', '?'], [], uri.Path, uriList );
		FileName := uriList[ 5 ] + '.dat';
		// http://jbbs.shitaraba.com/bbs/read.cgi/game/1578/1067968274/l100
		// http://jbbs.shitaraba.com/game/1000/subject.txt
		Result		:= CreateResultString(
			uri.Protocol + '://' + uri.Host + '/' + uriList[ 3 ] + '/' + uriList[ 4 ] + '/' );
	finally
		uri.Free;
		uriList.Free;
	end;

end;

// *************************************************************************
// FDat ̐
// *************************************************************************
procedure	TShitarabaThreadItem.LoadDat;
begin

	if FDat = nil then begin
		if IsLogFile then begin
			// dat ̓ǂݍ
			FDat := TStringList.Create;
			FDat.LoadFromFile( FilePath );
		end;
	end;

end;

// *************************************************************************
// FDat ̊J
// *************************************************************************
procedure	TShitarabaThreadItem.FreeDat;
begin

	if FDat <> nil then begin
		FDat.Free;
		FDat := nil;
	end;

end;

// *************************************************************************
// SȃuEU\p URL
// *************************************************************************
function	TShitarabaThreadItem.BrowsableURL : string;
var
	uri				: TIdURI;
	uriList		: TStringList;
	foundPos	: Integer;
	dir				: string;
begin

	foundPos := AnsiPos( '?', URL );
	if foundPos > 0 then begin
		// 
		uri := TIdURI.Create( URL );
		uriList := TStringList.Create;
		try
			ExtractHttpFields( ['/'], [], uri.Path, uriList );
			dir := uriList[ 1 ];
			ExtractHttpFields( ['&'], [], Copy( URL, foundPos + 1, MaxInt ), uriList );
			Result :=
				uri.Protocol + '://' + uri.Host + '/bbs/read.cgi/' +
				dir + '/' + uriList.Values[ 'BBS' ] + '/' + uriList.Values[ 'KEY' ] + '/l100';
		finally
			uri.Free;
			uriList.Free;
		end;
	end else begin
		if Copy( URL, Length( URL ), 1 ) = '/' then
			uri := TIdURI.Create( URL )
		else
			uri := TIdURI.Create( URL + '/' );
		uriList := TStringList.Create;
		try
			ExtractHttpFields( ['/'], [], uri.Path, uriList );
			Result :=
				uri.Protocol + '://' + uri.Host + '/bbs/read.cgi/' +
				uriList[ 3 ] + '/' + uriList[ 4 ] + '/' + uriList[ 5 ] + '/l100';
		finally
			uri.Free;
			uriList.Free;
		end;
	end;

end;

// *************************************************************************
// S( '/' ŏI )ǂݍ݂ URL
// *************************************************************************
function	TShitarabaThreadItem.ReadURL : string;
var
	uri				: TIdURI;
	uriList		: TStringList;
	foundPos	: Integer;
	dir				: string;
begin

	foundPos := AnsiPos( '?', URL );
	if foundPos > 0 then begin
		// 
		uri := TIdURI.Create( URL );
		uriList := TStringList.Create;
		try
			ExtractHttpFields( ['/'], [], uri.Path, uriList );
			dir := uriList[ 1 ];
			ExtractHttpFields( ['&'], [], Copy( URL, foundPos + 1, MaxInt ), uriList );
			// http://jbbs.shitaraba.com/bbs/read.cgi?DIR=game&BBS=1578&KEY=1067968274
			Result :=
				uri.Protocol + '://' + uri.Host + '/bbs/rawmode.cgi/' +
				dir + '/' + uriList.Values[ 'BBS' ] + '/' + uriList.Values[ 'KEY' ] + '/';
		finally
			uri.Free;
			uriList.Free;
		end;
	end else begin
		if Copy( URL, Length( URL ), 1 ) = '/' then
			uri := TIdURI.Create( URL )
		else
			uri := TIdURI.Create( URL + '/' );
		uriList := TStringList.Create;
		try
			ExtractHttpFields( ['/'], [], uri.Path, uriList );
			// http://jbbs.shitaraba.com/bbs/read.cgi/game/1578/1067968274/l100
			Result :=
				uri.Protocol + '://' + uri.Host + '/bbs/rawmode.cgi/' +
				uriList[ 3 ] + '/' + uriList[ 4 ] + '/' + uriList[ 5 ] + '/';
		finally
			uri.Free;
			uriList.Free;
		end;
	end;

end;

// *************************************************************************
// S( '/' ŏI )݂ URL
// *************************************************************************
function	TShitarabaThreadItem.WriteURL : string;
var
	uri			: TIdURI;
	uriList	: TStringList;
begin

	if Copy( URL, Length( URL ), 1 ) = '/' then
		uri := TIdURI.Create( URL )
	else
		uri := TIdURI.Create( URL + '/' );
	uriList := TStringList.Create;
	try
		ExtractHttpFields( ['/', '?'], [], uri.Path, uriList );
		// http://jbbs.shitaraba.com/bbs/read.cgi/game/1578/1067968274/l100
		Result		:=
			uri.Protocol + '://' + uri.Host + '/bbs/write.cgi/' +
			uriList[ 3 ] + '/' + uriList[ 4 ] + '/' + uriList[ 5 ] + '/';
	finally
		uri.Free;
		uriList.Free;
	end;

end;

// *************************************************************************
// TThreadItem ꂽꍇ̏u(TShitarabaThreadItem 𐶐)
// *************************************************************************
procedure ThreadItemOnCreateOfTShitarabaThreadItem(
	inInstance : DWORD
);
var
	threadItem : TShitarabaThreadItem;
begin

	threadItem := TShitarabaThreadItem.Create( inInstance );
	ThreadItemSetLong( inInstance, tipContext, DWORD( threadItem ) );

end;

// *************************************************************************
// TThreadItem jꂽꍇ̏u(TShitarabaThreadItem j)
// *************************************************************************
procedure ThreadItemOnDisposeOfTShitarabaThreadItem(
	inInstance : DWORD
);
var
	threadItem : TShitarabaThreadItem;
begin

	threadItem := TShitarabaThreadItem( ThreadItemGetLong( inInstance, tipContext ) );
	threadItem.Free;

end;

// =========================================================================
// TShitarabaBoardItem
// =========================================================================

// *************************************************************************
// RXgN^
// *************************************************************************
constructor TShitarabaBoardItem.Create(
	inInstance	: DWORD
);
var
	uri					: TIdURI;
	uriList			: TStringList;
begin

	inherited;

	OnDownload						:= Download;
	OnCreateThread				:= CreateThread;
	OnEnumThread					:= EnumThread;
	OnFileName2ThreadURL	:= ToThreadURL;

	FilePath			:= '';
	FIsTemporary	:= False;
	FDat					:= nil;

	uri			:= TIdURI.Create( SubjectURL );
	uriList	:= TStringList.Create;
	try
		ExtractHttpFields( ['/', '?'], [], uri.Path, uriList );
		// http://jbbs.shitaraba.com/game/1000/subject.txt
		FilePath	:= MyLogFolder + uriList[ 1 ] + '\' + uriList[ 2 ] + '\' + uri.Document;
		IsLogFile	:= FileExists( FilePath );
	finally
		uri.Free;
		uriList.Free;
	end;

end;
 
// *************************************************************************
// fXgN^
// *************************************************************************
destructor TShitarabaBoardItem.Destroy;
begin

	if FDat <> nil then begin
		try
			FDat.Free;
			FDat := nil;
		except
		end;
	end;

	// ꎞt@C̏ꍇ͍폜
	if FIsTemporary then
		DeleteFile( FilePath );

	inherited;

end;

// *************************************************************************
// w肵Xꗗ̃_E[hvꂽ
// *************************************************************************
function TShitarabaBoardItem.Download : TDownloadState;
var
	modified			: Double;
	downResult		: PChar;
	responseCode	: Longint;
	uri						: TIdURI;
	uriList				: TStringList;
	i							: Integer;
		tmpText : String;
begin

	Result := dsError;

	if FDat <> nil then begin
		try
			FDat.Free;
			FDat := nil;
		except
		end;
	end;
	FDat	 	:= TStringList.Create;
	uri		 	:= TIdURI.Create( SubjectURL );
	uriList	:= TStringList.Create;
	// ƎɃ_E[htB^OsȂꍇ
	// InternalDownload ɔC邱Ƃo
	modified			:= LastModified;
	responseCode	:= InternalDownload( PChar( uri.URI ), modified, downResult );
	try
		if responseCode = 200 then begin
			try
				// pXZo
				ExtractHttpFields( ['/', '?'], [], uri.Path, uriList );
				if MyLogFolder = '' then begin
					// ǂɕۑĂ̂Ȃ̂ňꎞt@Cɕۑ
					FilePath 			:= TemporaryFile;
					FIsTemporary	:= True;
				end else begin
					FilePath			:= MyLogFolder + uriList[ 1 ] + '\' + uriList[ 2 ] + '\' + uri.Document;
					FIsTemporary	:= False
				end;

				// ۑp̃fBNg@
				ForceDirectoriesEx( Copy( FilePath, 1, LastDelimiter( '\', FilePath ) ) );

				// EUC  Shift_JIS 
								tmpText := CustomStringReplace( string( downResult ), '', ',');
				FDat.Text := EUCtoSJIS( tmpText );
				//  JBBS ̓`FbNpɐ擪ƍŏIs
				i := FDat.Count - 1;
				if i > 0 then	// 1 ㉺ 0 ͊܂܂
					if FDat[ 0 ] = FDat[ i ] then
						FDat.Delete( i );
				// ۑ
				FDat.SaveToFile( FilePath );

				IsLogFile			:= True;
				RoundDate			:= Now;
				LastModified	:= modified;
				LastGetTime		:= Now;
			finally
				uri.Free;
				uriList.Free;
			end;
			Result := dsComplete;
		end;
	finally
		DisposeResultString( downResult );
	end;

end;

// *************************************************************************
// XĂwꂽ
// *************************************************************************
function	TShitarabaBoardItem.CreateThread(
	inSubject			: string;	// X^C
	inName				: string;	// O(nh)
	inMail				: string;	// [AhX
	inMessage			: string	// {
) : TDownloadState;				// ݂ǂ
var
	postURL				: string;
	postData			: string;
	postResult		: PChar;
	uri						: TIdURI;
	uriList				: TStringList;
	responseCode	: Integer;
begin

	uri			:= TIdURI.Create( URL );
	uriList	:= TStringList.Create;
	try
		ExtractHttpFields( ['/', '?'], [], uri.Path, uriList );

		// http://jbbs.shitaraba.com/bbs/write.cgi/game/1578/new/
		// http://jbbs.shitaraba.com/game/1000/subject.txt
		postURL		:=
			uri.Protocol + '://' + uri.Host + '/bbs/write.cgi/' +
			uriList[ 1 ] + '/' + uriList[ 2 ] + '/new/';
		postData	:=
			'SUBJECT='	+ HttpEncode( SJIStoEUC( inSubject ) ) +
			'&NAME='		+ HttpEncode( SJIStoEUC( inName ) ) +
			'&MAIL='		+ HttpEncode( SJIStoEUC( inMail ) ) +
			'&MESSAGE='	+ HttpEncode( SJIStoEUC( inMessage ) ) +
			'&BBS='			+ uriList[ 4 ] +
			'&DIR='			+ uriList[ 3 ] +
			'&TIME='		+ IntToStr( DateTimeToUnix( Now ) ) +
			'&submit='	+ HttpEncode( SJIStoEUC( 'VK' ) );

		// ƎɒʐMȂꍇ InternalPost ɔC邱Ƃo
		responseCode := InternalPost( PChar( postURL ), PChar( postData ), postResult );
		try
			if (responseCode = 200) or
				((responseCode = 302) and (Length( Trim( postResult ) ) = 0)) then begin
				Result := dsComplete
			end else begin
				Result := dsError;
				if Assigned( InternalPrint ) then
					InternalPrint( postResult );
			end;
		finally
			DisposeResultString( postResult );
		end;
	finally
		uri.Free;
		uriList.Free;
	end;

end;

// *************************************************************************
// Xꗗ URL Xbh URL 𓱂o
// *************************************************************************
function TShitarabaBoardItem.ToThreadURL(
	inFileName	: string	// Xbht@C
) : string;							// Xbh URL
var
	threadURL		: string;
	uri					: TIdURI;
	uriList			: TStringList;
	found				: Integer;
begin

	found := AnsiPos( '.', inFileName );
	if found > 0 then
		inFileName := Copy( inFileName, 1, found - 1 );

	uri			:= TIdURI.Create( SubjectURL );
	uriList	:= TStringList.Create;
	try
		try
			ExtractHttpFields( ['/', '?'], [], uri.Path, uriList );
			threadURL	:= uri.Protocol + '://' + uri.Host + '/bbs/read.cgi/' +
				uriList[ 1 ] + '/' + uriList[ 2 ] + '/' + inFileName + '/l100';
			Result		:= threadURL;
		finally
			uri.Free;
			uriList.Free;
		end;
	except
		Result := '';
	end;

end;

// *************************************************************************
// ̔ɂ̃X邩vꂽ
// *************************************************************************
procedure	TShitarabaBoardItem.EnumThread(
	inCallBack	: TBoardItemEnumThreadCallBack
);
var
	uri		 			: TIdURI;
	uriList			: TStringList;
begin

	try
		if FDat = nil then begin
			FDat		:= TStringList.Create;
			uri			:= TIdURI.Create( SubjectURL );
			uriList	:= TStringList.Create;
			try
				// pXZo
				ExtractHttpFields( ['/', '?'], [], uri.Path, uriList );
				// http://jbbs.shitaraba.com/game/1000/subject.txt
				FilePath	:= MyLogFolder + uriList[ 1 ] + '\' + uriList[ 2 ] + '\' + uri.Document;
				if FileExists( FilePath ) then
					// ǂݍ
					FDat.LoadFromFile( FilePath );
			finally
				uri.Free;
				uriList.Free;
			end;
		end;

		// ƎɃtB^OsȂꍇ EnumThread ɔC邱Ƃo
		inherited EnumThread( inCallBack, CustomStringReplace( FDat.Text, ',', '<>' ) );
	except
	end;

end;

// *************************************************************************
// Xꗗ URL ߂
// *************************************************************************
function	TShitarabaBoardItem.SubjectURL : string;
var
	uri		 	: TIdURI;
	uriList	: TStringList;
begin

	uri			:= TIdURI.Create( URL );
	uriList	:= TStringList.Create;
	try
		if uri.Document <> SUBJECT_NAME then begin
			if Copy( URL, Length( URL ), 1 ) = '/' then
				Result := URL + SUBJECT_NAME
			else
				Result := URL + '/' + SUBJECT_NAME;
		end else begin
			// ɂ͗ȂƎv
			Result := URL;
		end;
	finally
		uri.Free;
		uriList.Free;
	end;

end;

// *************************************************************************
// TBoardItem ꂽꍇ̏u(TShitarabaBoardItem 𐶐)
// *************************************************************************
procedure BoardItemOnCreateOfTShitarabaBoardItem(
	inInstance : DWORD
);
var
	boardItem : TShitarabaBoardItem;
begin

	boardItem := TShitarabaBoardItem.Create( inInstance );
	BoardItemSetLong( inInstance, bipContext, DWORD( boardItem ) );

end;

// *************************************************************************
// TBoardItem jꂽꍇ̏u(TShitarabaBoardItem j)
// *************************************************************************
procedure BoardItemOnDisposeOfTShitarabaBoardItem(
	inInstance : DWORD
);
var
	boardItem : TShitarabaBoardItem;
begin

	boardItem := TShitarabaBoardItem( BoardItemGetLong( inInstance, bipContext ) );
	boardItem.Free;

end;



// =========================================================================
// Gg|Cg
// =========================================================================
procedure DLLEntry(
	ul_reason_for_call : DWORD
);
var
	module : HMODULE;
begin

	case ul_reason_for_call of
		DLL_PROCESS_ATTACH:
		begin
			Randomize;

			module := GetModuleHandle( nil );

			LoadInternalAPI( module );
			LoadInternalFilePathAPI( module );
			LoadInternalThreadItemAPI( module );
			LoadInternalBoardItemAPI( module );

			// ===== CX^X̎舵 TThreadItem  TShitarabaThreadItem ɕύX
			ThreadItemOnCreate	:= ThreadItemOnCreateOfTShitarabaThreadItem;
			ThreadItemOnDispose	:= ThreadItemOnDisposeOfTShitarabaThreadItem;
			// ===== CX^X̎舵 TBoardItem  TShitarabaBoardItem ɕύX
			BoardItemOnCreate		:= BoardItemOnCreateOfTShitarabaBoardItem;
			BoardItemOnDispose	:= BoardItemOnDisposeOfTShitarabaBoardItem;
		end;
		DLL_PROCESS_DETACH:
		begin
			RemovePlugInMenu( SyncronizeMenu );
		end;
		DLL_THREAD_ATTACH:
			;
		DLL_THREAD_DETACH:
			;
	end;

end;

exports
	OnLoad,
	OnVersionInfo,
	OnAcceptURL,
	OnPlugInMenu;

begin

	try
		DllProc := @DLLEntry;
		DLLEntry( DLL_PROCESS_ATTACH );
	except end;

end.
