unit GikoXMLDoc;

{
	XMLIntf, XMLDoc ̃N[
	Delphi 6 Personal p
}
interface

//==================================================
uses
//==================================================

	Classes, SysUtils,
	YofUtils;

//==================================================
type
//==================================================

	// 킯킩炸Ă邩oO炯
	XMLDictionary = Record
		Name : string;
		Value : string;
	end;

	IXMLNode = class
	private
		FNodeName : string;
		FCount : Integer;
		FAttributeCount : Integer;
		FChildNodes : IXMLNode;
		FNodes : array of IXMLNode;
		FAttributes : array of XMLDictionary;
		function GetAttribute( const Name : string ) : string;
		function GetNode( Index : Integer ) : IXMLNode;
	public
		constructor	Create;
		destructor	Destroy; override;

		property NodeName : string read FNodeName write FNodeName;
		property Attributes[ const Name : string ] : string read GetAttribute;
		property Node[ Index : Integer ] : IXMLNode read GetNode; default;
		property ChildNodes : IXMLNode read FChildNodes write FChildNodes;
		property Count : Integer read FCount write FCount;
		procedure Add( node : IXMLNode );
		procedure AddAttribute( const Name : string; const Value : string );
	end;

	IXMLDocument = class( IXMLNode )
	private
		function GetDocumentElement() : IXMLNode;
	public
		property DocumentElement : IXMLNode read GetDocumentElement;
	end;

function XMLCloseCheck(
	var f : TFileStream;
	var node : IXMLNode;
	ch : char;
	out tag : string;
	out closed : boolean // Ăяo[` node ׂȂ true
) : boolean; // ch ̃[`Ȃ true

function XMLReadNode(
	var f : TFileStream;
	var node : IXMLNode
) : string; // node ȊÕm[hꂽꍇ̃m[h

procedure LoadXMLDocument(
	const fileName : string;
    var doc : IXMLDocument
);

//==================================================
const
//==================================================
	kXMLWhite : TSysCharSet = [#0..#$20];
	kXMLDQuote : TSysCharSet = ['"'];
	kXMLTagStart : TSysCharSet = ['<'];
	kXMLTagEnd : TSysCharSet = ['>'];
	kXMLKanji : TSysCharSet = [#$80..#$A0, #$E0..#$ff];

//==================================================
implementation
//==================================================

// Constructor
constructor	IXMLNode.Create;
begin

	inherited;

	FCount := 0;

end;

// Destructor
destructor	IXMLNode.Destroy;
var
	i : Integer;
begin

	for i := FCount - 1 downto 0 do
		FNodes[ i ].Free;
	FChildNodes.Free;

	inherited;

end;

function IXMLNode.GetAttribute( const Name : string ) : string;
var
	i : Integer;
begin

	i := 0;
	while i < FAttributeCount do
	begin
		if Name = FAttributes[ i ].Name then
		begin
			Result := FAttributes[ i ].Value;
			exit;
		end;

		Inc( i );
	end;

end;

function IXMLNode.GetNode( Index : Integer ) : IXMLNode;
begin

	Result := FNodes[ Index ];

end;

procedure IXMLNode.Add( node : IXMLNode );
begin

	Inc( FCount );
	SetLength( FNodes, FCount );
	FNodes[ FCount - 1 ] := node;

end;

procedure IXMLNode.AddAttribute(
	const Name : string;
	const Value : string
);
var
	index : Integer;
begin

	index := FAttributeCount;
	Inc( FAttributeCount );
	SetLength( FAttributes, FAttributeCount );
	FAttributes[ index ].Name := Name;
	FAttributes[ index ].Value := Value;

end;

function IXMLDocument.GetDocumentElement() : IXMLNode;
begin

	Result := FChildNodes[ 0 ];

end;

// untilSet ɂȂ܂Ŕ΂
procedure FileThruUntil(
	var f : TFileStream;
	const untilSet : TSysCharSet
);
var
	ch : char;
begin

	while f.Position < f.Size do
	begin
		f.ReadBuffer( ch, 1 );
		if ch in untilSet then
		begin
			f.Seek( -1, soFromCurrent );
			exit;
		end else if ch in kXMLKanji then
			f.Seek( 1, soFromCurrent );
	end;

end;

// whileSet ̊Ԕ΂
procedure FileThruWhile(
	var f : TFileStream;
	const whileSet : TSysCharSet
);
var
	ch : char;
begin

	while f.Position < f.Size do
	begin
		f.ReadBuffer( ch, 1 );
		if ch in whileSet then
		begin
			if ch in kXMLKanji then
				f.ReadBuffer( ch, 1 );
		end else begin
			f.Seek( -1, soFromCurrent );
			exit;
		end;
	end;

end;

function XMLCloseCheck(
	var f : TFileStream;
	var node : IXMLNode;
	ch : char;
	out tag : string;
	out closed : boolean
) : boolean; // ch ̃[`Ȃ true
var
	last : Integer;
	tagLen : Integer;
begin

	closed := false;
	Result := false;
	tag := '';

	if ch = '>' then
	begin
		// Jn^O̍Ō܂œǂ
		Result := true;
	end else if ch = '?' then
	begin
		// <?xml?> ݂ȂBĖ
		FileThruUntil( f, kXMLTagEnd );
		FileThruUntil( f, kXMLTagStart );
		f.Seek( 1, soFromCurrent );
		FileThruWhile( f, kXMLWhite );
		//closed := true;
		Result := true;
	end else if ch = '/' then
	begin
		// ^OǂݍŕԂ
		last := f.Position;
		FileThruUntil( f, kXMLTagEnd );
		tagLen := f.Position - last;
		SetLength( tag, tagLen );

		f.Seek( last, soFromBeginning );
		f.ReadBuffer( PChar( tag )^, tagLen );

		f.Seek( f.Position + 1, soFromBeginning ); // '>' ΂
		closed := true;
		Result := true;
	end;

end;

function XMLReadNode(
	var f : TFileStream;
	var node : IXMLNode
) : string; // node ȊÕm[hꂽꍇ̃m[h
var
	child : IXMLNode;

	last : Integer;
	tag : string;
	tagLen : Integer;

	isClosed : boolean;

	attributeName : string;
	attributeValue : string;

	ch : char;
label
	NextNode;
begin
	try
		// node ̓ǂݍ(1 [vɂ 1 m[h)
		node.ChildNodes := IXMLNode.Create;

		while f.Position < f.Size do
		begin
			// NodeName ǂݍ
			FileThruWhile( f, kXMLWhite );

			while f.Position < f.Size do
			begin
				f.ReadBuffer( ch, 1 );

				if XMLCloseCheck( f, node, ch, tag, isClosed ) then
				begin
					if isClosed then
					begin
						Result := tag;
						exit;
					end;

					goto NextNode;
				end else if ch = '<' then
				begin
					// VKm[h
					child := IXMLNode.Create;
					tag := XMLReadNode( f, child );
					node.ChildNodes.Add( child );

					// ^Oꂽ
					if Length( tag ) > 0 then
					begin
						// ̂̂`FbNāAႦΐeɕԂ
						if tag <> node.NodeName then
							Result := tag;
						exit;
					end;

					goto NextNode;
				end else if ch in kXMLWhite then
				begin
					// NodeName 
					break;
				end else begin
					node.NodeName := node.NodeName + ch;

					if ch in kXMLKanji then
					begin
						f.ReadBuffer( ch, 1 );
						node.NodeName := node.NodeName + ch;
					end;
				end;
			end;

			// Attribute ̓ǂݍ
			while f.Position < f.Size do
			begin
				// Attribute ̖Oǂݍ
				attributeName := '';
				attributeValue := '';

				FileThruWhile( f, kXMLWhite );

				while f.Position < f.Size do
				begin
					f.ReadBuffer( ch, 1 );

					if XMLCloseCheck( f, node, ch, tag, isClosed ) then
					begin
						if isClosed then
						begin
							// ^Oꂽ̂Ń^[
							// NodeName ʉ߂Ă̂œrŕĂ邱ƂɂȂB
							// ēƗm[hB
							exit;
						end;

						// ̃m[h
						goto NextNode;
					end else if ch = '=' then
					begin
						// ͒ln܂̂ŖO͏I
						break;
					end else if ch in kXMLWhite then
					begin
						// Value ݂Ȃ(KiO)̂Ŏ̃m[h
						goto NextNode;
					end else begin
						attributeName := attributeName + ch;

						if ch in kXMLKanji then
						begin
							f.ReadBuffer( ch, 1 );
							attributeName := attributeName + ch;
						end;
					end;
				end;

				// Attribute ̒lǂݍ
				FileThruWhile( f, kXMLWhite );

				while f.Position < f.Size do
				begin
					f.ReadBuffer( ch, 1 );

					if XMLCloseCheck( f, node, ch, tag, isClosed ) then
					begin
						if isClosed then
						begin
							if Length( attributeName ) > 0 then
								// KiOǂ
								node.AddAttribute( attributeName, attributeValue );

							// ^Oꂽ̂Ń^[
							// NodeName ʉ߂Ă̂œrŕĂ邱ƂɂȂB
							// ēƗm[hB
							exit;
						end;

						// ̃m[h
						goto NextNode;
					end else if ch = '"' then
					begin
						// l "" ŊĂ̂(ĂĂȂႢȂ񂾂)
						// lꊇǂݍ
						last := f.Position;
						FileThruUntil( f, kXMLDQuote );
						tagLen := f.Position - last;
						SetLength( attributeValue, tagLen );

						f.Seek( last, soFromBeginning );
						f.ReadBuffer( PChar( attributeValue )^, tagLen );

						node.AddAttribute( attributeName, HtmlDecode( attributeValue ) );

						// lǂݏÎŏI
						f.Seek( f.Position + 1, soFromBeginning ); // '"' ΂
						break;
					end else if ch in kXMLWhite then
					begin
						// KiOǂ
						node.AddAttribute( attributeName, HtmlDecode( attributeValue ) );

						goto NextNode;
					end else begin
						// KiOǈꉞĂ
						attributeValue := attributeValue + ch;

						if ch in kXMLKanji then
						begin
							f.ReadBuffer( ch, 1 );
							attributeValue := attributeValue + ch;
						end;
					end;
				end;
			end; // Attribute ̓ǂݍ

			NextNode:;
		end; // // node ̓ǂݍ(1 [vɂ 1 m[h)
	finally
	end;
end;

procedure LoadXMLDocument(
	const fileName : string;
	var doc : IXMLDocument
);
type
	xmlMode = ( xmlHoge );
var
	xmlFile : TFileStream;
begin
    //Result := IXMLDocument.Create;
	//doc := IXMLDocument.Create;

	xmlFile := TFileStream.Create( fileName, fmOpenRead );

    try
        XMLReadNode( xmlFile, IXMLNode( doc ) );
    	//XMLReadNode( xmlFile, IXMLNode( Result ) );
    finally
		xmlFile.Free;
    end;

	//Result := doc;

end;

end.
