unit Option;

interface

uses
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
	ComCtrls, StdCtrls, ExtCtrls, Dialogs, FileCtrl, MMSystem,
	GikoSystem, GikoUtil, Buttons, UrlMon, Menus, ImgList;

type
	TOptionDialog = class(TForm)
		OkBotton: TButton;
		CancelBotton: TButton;
		OptionTab: TPageControl;
		ConnectSheet: TTabSheet;
		Font1Sheet: TTabSheet;
    ApplyButton: TButton;
		FontDialog: TFontDialog;
		ColorDialog: TColorDialog;
    ReadProxyGroupBox: TGroupBox;
    ReadAddressLabel: TLabel;
		ReadPortLabel: TLabel;
    ReadProxyCheck: TCheckBox;
    ReadProxyAddressEdit: TEdit;
    ReadPortEdit: TEdit;
    ReadProxyUserIDEdit: TEdit;
    ReadProxyPasswordEdit: TEdit;
		ReadUserIDLabel: TLabel;
		ReadPasswordLabel: TLabel;
		FolderSheet: TTabSheet;
    FolderGroupBox: TGroupBox;
		LogFolderEdit: TEdit;
    LogFolderButton: TButton;
    Label1: TLabel;
		Label2: TLabel;
    ThreadSheet: TTabSheet;
    SoundSheet: TTabSheet;
    SoundEventGroupBox: TGroupBox;
		SoundListView: TListView;
    SoundReferButton: TButton;
    SoundFileEdit: TEdit;
    OpenDialog: TOpenDialog;
    WriteProxyGroupBox: TGroupBox;
    WriteAddressLabel: TLabel;
    WritePortLabel: TLabel;
    WriteUserIDLabel: TLabel;
    WritePasswordLabel: TLabel;
    WriteProxyCheck: TCheckBox;
    WriteProxyAddressEdit: TEdit;
    WritePortEdit: TEdit;
    WriteProxyUserIDEdit: TEdit;
    WriteProxyPasswordEdit: TEdit;
    BoardSheet: TTabSheet;
    GroupBox4: TGroupBox;
    BoardURL2chEdit: TEdit;
    Label13: TLabel;
    UserIDSheet: TTabSheet;
		GroupBox3: TGroupBox;
    Label9: TLabel;
		Label10: TLabel;
    UserIDEdit: TEdit;
    PasswordEdit: TEdit;
    SoundPlayButton: TBitBtn;
		AutoLoginCheckBox: TCheckBox;
    Tora3URLLabel: TLabel;
    Label12: TLabel;
    Label5: TLabel;
    GroupBox5: TGroupBox;
    ComboBox1: TComboBox;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    ComboBox2: TComboBox;
    ComboBox3: TComboBox;
    Label4: TLabel;
    Edit1: TEdit;
    Button1: TButton;
    CabinetFontBotton: TButton;
    CabinetColorBotton: TButton;
    CabinetDefaultButton: TButton;
    CabinetMemo: TMemo;
    ListMemo: TMemo;
    ListFontBotton: TButton;
    ListColorBotton: TButton;
    ListDefaultBotton: TButton;
    HintFontButton: TButton;
    HintBackButton: TButton;
    HintDefaultButton: TButton;
    HintMemo: TMemo;
		EditorMemo: TMemo;
    EditorFontBotton: TButton;
    EditorColorBotton: TButton;
    EditorDefaultBotton: TButton;
		BrowserTabMemo: TMemo;
    BruwserTabFontButton: TButton;
    BrowserTabDefaultButton: TButton;
    Bevel1: TBevel;
    Bevel2: TBevel;
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    URLAppCheckBox: TCheckBox;
    AppFolderLabel: TLabel;
    AppFolderEdit: TEdit;
    AppFolderButton: TButton;
    OpenMailerCheckBox: TCheckBox;
    TabSheet1: TTabSheet;
    PopupPositionRadioGroup: TRadioGroup;
    TabAddRadioGroup: TRadioGroup;
    TabSheet2: TTabSheet;
    GroupBox7: TGroupBox;
    URLDisplayCheckBox: TCheckBox;
    Label3: TLabel;
    Label11: TLabel;
    TabStopAddressBarCheckBox: TCheckBox;
    AddressHistoryCountEdit: TEdit;
    LinkAddCheckBox: TCheckBox;
    GroupBox8: TGroupBox;
    PreviewVisibleCheckBox: TCheckBox;
    PreviewSizeComboBox: TComboBox;
    Label14: TLabel;
    Label15: TLabel;
    PreviewWaitEdit: TEdit;
    Label16: TLabel;
    ShowMailCheckBox: TCheckBox;
    TabSheet3: TTabSheet;
    GroupBox9: TGroupBox;
    ThreadListIconCheckBox: TCheckBox;
    GroupBox6: TGroupBox;
    LogDeleteMessageCheckBox: TCheckBox;
    GroupBox10: TGroupBox;
    UnActivePopupCheckBox: TCheckBox;
    GroupBox11: TGroupBox;
    RecvBufferSize: TEdit;
    Label17: TLabel;
    ProxyProtocolCheckBox: TCheckBox;
    ProtocolCheckBox: TCheckBox;
    Label18: TLabel;
    Label19: TLabel;
    Bevel5: TBevel;
    Label20: TLabel;
    Label21: TLabel;
    Label22: TLabel;
    Label23: TLabel;
    TabSheet4: TTabSheet;
    lblSFont: TLabel;
    GroupBox12: TGroupBox;
    CSSCheckBox: TCheckBox;
    CSSListLabel: TLabel;
    CSSListView: TListView;
    GroupBox13: TGroupBox;
    PostTimeCheckBox: TCheckBox;
    Label24: TLabel;
    Label25: TLabel;
    PostTimeEdit: TEdit;
    PostTimeLabel: TLabel;
    Label27: TLabel;
    PutPostTimeRadioButton: TRadioButton;
    BackPostTimeRadioButton: TRadioButton;
    ResPopupBoldCheckBox: TCheckBox;
    NGwordSheet: TTabSheet;
    GroupBox14: TGroupBox;
    RloCheckBox: TCheckBox;
    ReplaceulCheckBox: TCheckBox;
    PopUpAbonCheckBox: TCheckBox;
    CutOffLabeledEdit: TLabeledEdit;
    Label26: TLabel;
    Label28: TLabel;
		procedure FormCreate(Sender: TObject);
		procedure FormDestroy(Sender: TObject);
		procedure ApplyButtonClick(Sender: TObject);
		procedure CabinetFontBottonClick(Sender: TObject);
		procedure CabinetColorBottonClick(Sender: TObject);
		procedure EditorFontBottonClick(Sender: TObject);
		procedure OkBottonClick(Sender: TObject);
		procedure ReadProxyCheckClick(Sender: TObject);
		procedure ListFontBottonClick(Sender: TObject);
		procedure ListColorBottonClick(Sender: TObject);
		procedure EditorColorBottonClick(Sender: TObject);
		procedure CabinetDefaultButtonClick(Sender: TObject);
		procedure ReadPortEditExit(Sender: TObject);
		procedure ListDefaultBottonClick(Sender: TObject);
		procedure EditorDefaultBottonClick(Sender: TObject);
		procedure HintFontButtonClick(Sender: TObject);
		procedure HintBackButtonClick(Sender: TObject);
		procedure HintDefaultButtonClick(Sender: TObject);
		procedure LogFolderButtonClick(Sender: TObject);
		procedure FormClose(Sender: TObject; var Action: TCloseAction);
		procedure SoundReferButtonClick(Sender: TObject);
		procedure SoundPlayButtonClick(Sender: TObject);
		procedure SoundListViewChanging(Sender: TObject; Item: TListItem;
      Change: TItemChange; var AllowChange: Boolean);
		procedure SoundFileEditChange(Sender: TObject);
		procedure OptionTabChange(Sender: TObject);
		procedure AppFolderButtonClick(Sender: TObject);
		procedure WriteProxyCheckClick(Sender: TObject);
		procedure WritePortEditExit(Sender: TObject);
		procedure Tora3URLLabelClick(Sender: TObject);
		procedure HotKeyEnter(Sender: TObject);
		procedure HotKeyExit(Sender: TObject);
		procedure URLAppCheckBoxClick(Sender: TObject);
		procedure BruwserTabFontButtonClick(Sender: TObject);
		procedure BrowserTabDefaultButtonClick(Sender: TObject);
    procedure AddressHistoryCountEditExit(Sender: TObject);
    procedure PreviewWaitEditExit(Sender: TObject);
		procedure RecvBufferSizeExit(Sender: TObject);
    procedure CSSCheckBoxClick(Sender: TObject);
    procedure PostTimeEditExit(Sender: TObject);
    procedure PostTimeCheckBoxClick(Sender: TObject);
	private
		{ Private 錾 }
		FClose: Boolean;
		function GetMemoText(font: TFont; text: string): string;
//		function GetFontText(Font: TFont; Text: string): string;
		procedure SetValue;
		procedure SaveSetting;
		procedure SettingApply;
		function CheckFolder: Boolean;
        procedure SetAbonpropertys;
	public
		{ Public 錾 }
	end;

var
	OptionDialog: TOptionDialog;

implementation

uses
	Giko, Editor, Setting, ActnList;

const
	FONT_TEXT: string = '%s %d pt';
	MEMO_CABINET: string = 'Lrlbg';
	MEMO_THREAD: string = 'XbhXg';
	MEMO_BROWSERPOPUP: string = 'uEU|bvAbv';
	MEMO_BROWSERTAB: string = 'uEU^u';
	MEMO_EDITOR: string = 'GfB^eLXg';
	DEFAULT_FONT_NAME: string = 'lr oSVbN';
	DEFAULT_FONT_SIZE: Integer = 9;
	DEFAULT_TABFONT_NAME: string = 'lr oSVbN';
	DEFAULT_TABFONT_SIZE: Integer = 9;
	URL_TORA3: WideString = 'http://2ch.tora3.net/';

{$R *.DFM}

procedure TOptionDialog.FormCreate(Sender: TObject);
begin
	FClose := True;

	OptionTab.ActivePage := ConnectSheet;
	SetValue;

	CabinetMemo.Text := GetMemoText(CabinetMemo.Font, MEMO_CABINET);
	ListMemo.Text := GetMemoText(ListMemo.Font, MEMO_THREAD);
	HintMemo.Text := GetMemoText(HintMemo.Font, MEMO_BROWSERPOPUP);
	BrowserTabMemo.Text := GetMemoText(BrowserTabMemo.Font, MEMO_BROWSERTAB);
	EditorMemo.Text := GetMemoText(EditorMemo.Font, MEMO_EDITOR);

	Tora3URLLabel.Cursor := 5;
	lblSFont.Caption := 'dv'#13#10#13#10
										+ 'Xbh\GÃtHgύX́A'#13#10
										+ 'uX^CV[gv^uŐݒo܂';
	CSSCheckBoxClick(Sender);
	PostTimeCheckBoxClick(Sender);
end;

procedure TOptionDialog.FormDestroy(Sender: TObject);
begin
	sndPlaySound(nil, SND_ASYNC);
end;

procedure TOptionDialog.OkBottonClick(Sender: TObject);
begin
	FClose := True;
	RecvBufferSizeExit(Sender);
	ReadPortEditExit(Sender);
	WritePortEditExit(Sender);
	AddressHistoryCountEditExit(Sender);
	PreviewWaitEditExit(Sender);
	PostTimeEditExit(Sender);

	if not CheckFolder then begin
		FClose := False;
		Exit;
	end;
	SaveSetting;
	SettingApply;
    SetAbonpropertys;
end;

procedure TOptionDialog.ApplyButtonClick(Sender: TObject);
begin
	RecvBufferSizeExit(Sender);
	ReadPortEditExit(Sender);
	WritePortEditExit(Sender);
	AddressHistoryCountEditExit(Sender);
	PreviewWaitEditExit(Sender);
	PostTimeEditExit(Sender);

	if not CheckFolder then begin
		FClose := False;
		Exit;
	end;
	SaveSetting;
	SettingApply;
    SetAbonpropertys;
	FClose := False;
end;

//function TOptionDialog.GetFontText(Font: TFont; Text: string): string;
//begin
//	result := Format(Text, [Font.Name, Font.Size]);
//end;

function TOptionDialog.GetMemoText(font: TFont; text: string): string;
var
	s: string;
begin
	s := '';
	if font <> nil then
		s := Format(FONT_TEXT, [Font.Name, Font.Size]) + #13#10;
	Result := s + text;
end;

//LrlbgtHg{^
procedure TOptionDialog.CabinetFontBottonClick(Sender: TObject);
begin
	FontDialog.Options := [fdAnsiOnly, fdEffects];
	FontDialog.Font.Assign(CabinetMemo.Font);
	if FontDialog.Execute then begin
		FontDialog.Font.Style := FontDialog.Font.Style - [fsUnderline] - [fsStrikeout];
		CabinetMemo.Font.Assign(FontDialog.Font);
		CabinetMemo.Text := GetMemoText(CabinetMemo.Font, MEMO_CABINET);
		CabinetMemo.Font.Charset := SHIFTJIS_CHARSET;
	end;
end;

//LrlbgwiF{^
procedure TOptionDialog.CabinetColorBottonClick(Sender: TObject);
begin
	ColorDialog.Color := CabinetMemo.Color;
	if ColorDialog.Execute then begin
		CabinetMemo.Color := ColorDialog.Color;
	end;
end;

//LrlbgftHg{^
procedure TOptionDialog.CabinetDefaultButtonClick(Sender: TObject);
begin
	CabinetMemo.Font.Name := DEFAULT_FONT_NAME;
	CabinetMemo.Font.Size := DEFAULT_FONT_SIZE;
	CabinetMemo.Font.Color := clWindowText;
	CabinetMemo.Font.Style := [];
	CabinetMemo.Color := clWindow;
	CabinetMemo.Text := GetMemoText(CabinetMemo.Font, MEMO_CABINET);
end;

//XbhXgtHg{^
procedure TOptionDialog.ListFontBottonClick(Sender: TObject);
begin
	FontDialog.Options := [fdAnsiOnly, fdEffects];
	FontDialog.Font.Assign(ListMemo.Font);
	if FontDialog.Execute then begin
		ListMemo.Font.Assign(FontDialog.Font);
		ListMemo.Text := GetMemoText(ListMemo.Font, MEMO_THREAD);
		ListMemo.Font.Charset := SHIFTJIS_CHARSET;
	end;
end;

//XbhXgwiF{^
procedure TOptionDialog.ListColorBottonClick(Sender: TObject);
begin
	ColorDialog.Color := ListMemo.Color;
	if ColorDialog.Execute then begin
		ListMemo.Color := ColorDialog.Color;
	end;
end;

//XbhXgftHg{^
procedure TOptionDialog.ListDefaultBottonClick(Sender: TObject);
begin
	ListMemo.Font.Name := DEFAULT_FONT_NAME;
	ListMemo.Font.Size := DEFAULT_FONT_SIZE;
	ListMemo.Font.Color := clWindowText;
	ListMemo.Font.Style := [];
	ListMemo.Color := clWindow;
	ListMemo.Text := GetMemoText(ListMemo.Font, MEMO_THREAD);
end;

//uEU|bvAbvtHg{^
procedure TOptionDialog.HintFontButtonClick(Sender: TObject);
begin
	FontDialog.Options := [fdAnsiOnly, fdEffects];
	FontDialog.Font.Assign(HintMemo.Font);
	if FontDialog.Execute then begin
		HintMemo.Font.Assign(FontDialog.Font);
		HintMemo.Text := GetMemoText(HintMemo.Font, MEMO_BROWSERPOPUP);
		HintMemo.Font.Charset := SHIFTJIS_CHARSET;
	end;
end;

//uEU|bvAbvwiF{^
procedure TOptionDialog.HintBackButtonClick(Sender: TObject);
begin
	ColorDialog.Color := HintMemo.Color;
	if ColorDialog.Execute then begin
		HintMemo.Color := ColorDialog.Color;
	end;
end;

//uEU|bvAbvftHg{^
procedure TOptionDialog.HintDefaultButtonClick(Sender: TObject);
begin
	HintMemo.Font.Name := DEFAULT_FONT_NAME;
	HintMemo.Font.Size := DEFAULT_FONT_SIZE;
	HintMemo.Font.Color := clWindowText;
	HintMemo.Font.Style := [];
	HintMemo.Color := clInfoBk;
	HintMemo.Text := GetMemoText(HintMemo.Font, MEMO_BROWSERPOPUP);
end;

//uEU^utHg{^
procedure TOptionDialog.BruwserTabFontButtonClick(Sender: TObject);
begin
	FontDialog.Options := [fdAnsiOnly];
	FontDialog.Font.Assign(BrowserTabMemo.Font);
	if FontDialog.Execute then begin
		BrowserTabMemo.Font.Assign(FontDialog.Font);
		BrowserTabMemo.Text := GetMemoText(FontDialog.Font, MEMO_BROWSERTAB);
		BrowserTabMemo.Font.Charset := SHIFTJIS_CHARSET;
	end;
end;

//uEU^uftHg{^
procedure TOptionDialog.BrowserTabDefaultButtonClick(Sender: TObject);
begin
	BrowserTabMemo.Font.Name := DEFAULT_TABFONT_NAME;
	BrowserTabMemo.Font.Size := DEFAULT_TABFONT_SIZE;
	BrowserTabMemo.Font.Color := clWindowText;
	BrowserTabMemo.Font.Style := [];
	BrowserTabMemo.Color := clBtnFace;
	BrowserTabMemo.Text := GetMemoText(BrowserTabMemo.Font, MEMO_BROWSERTAB);
end;

//GfB^tHg{^
procedure TOptionDialog.EditorFontBottonClick(Sender: TObject);
begin
	FontDialog.Options := [fdAnsiOnly, fdEffects];
	FontDialog.Font.Assign(EditorMemo.Font);
	if FontDialog.Execute then begin
		EditorMemo.Font.Assign(FontDialog.Font);
		EditorMemo.Text := GetMemoText(EditorMemo.Font, MEMO_EDITOR);
		EditorMemo.Font.Charset := SHIFTJIS_CHARSET;
	end;
end;

//GfB^wiF{^
procedure TOptionDialog.EditorColorBottonClick(Sender: TObject);
begin
	ColorDialog.Color := EditorMemo.Font.Color;
	if ColorDialog.Execute then begin
		EditorMemo.Color := ColorDialog.Color;
	end;
end;

//GfB^ftHg{^
procedure TOptionDialog.EditorDefaultBottonClick(Sender: TObject);
begin
	EditorMemo.Font.Name := DEFAULT_FONT_NAME;
	EditorMemo.Font.Size := DEFAULT_FONT_SIZE;
	EditorMemo.Font.Color := clWindowText;
	EditorMemo.Font.Style := [];
	EditorMemo.Color := clWindow;
	EditorMemo.Text := GetMemoText(EditorMemo.Font, MEMO_EDITOR);
end;

procedure TOptionDialog.SetValue;
var
	i: Integer;
	Item: TListItem;
	s: string;
	idx: Integer;
	FileList: TStringList;
begin
	//Mobt@TCY
	RecvBufferSize.Text := IntToStr(Gikosys.Setting.RecvBufferSize);
	//HTTP1.1gp
	ProtocolCheckBox.Checked := GikoSys.Setting.Protocol;
	//vLVڑHTTP1.1gp
	ProxyProtocolCheckBox.Checked := Gikosys.Setting.ProxyProtocol;

	//ǂݍݗpvLV
	ReadProxyCheck.Checked := GikoSys.Setting.ReadProxy;
	ReadProxyCheckClick(nil);
	ReadProxyAddressEdit.Text := GikoSys.Setting.ReadProxyAddress;
	ReadPortEdit.Text := IntToStr(GikoSys.Setting.ReadProxyPort);
	ReadProxyUserIDEdit.Text := GikoSys.Setting.ReadProxyUserID;
	ReadProxyPasswordEdit.Text := GikoSys.Setting.ReadProxyPassword;
	//ݗpvLV
	WriteProxyCheck.Checked := GikoSys.Setting.WriteProxy;
	WriteProxyCheckClick(nil);
	WriteProxyAddressEdit.Text := GikoSys.Setting.WriteProxyAddress;
	WritePortEdit.Text := IntToStr(GikoSys.Setting.WriteProxyPort);
	WriteProxyUserIDEdit.Text := GikoSys.Setting.WriteProxyUserID;
	WriteProxyPasswordEdit.Text := GikoSys.Setting.WriteProxyPassword;
	//LrlbgtHg
	CabinetMemo.Font.Name := GikoSys.Setting.CabinetFontName;
	CabinetMemo.Font.Size := GikoSys.Setting.CabinetFontSize;
	CabinetMemo.Font.Color := GikoSys.Setting.CabinetFontColor;
	CabinetMemo.Color := GikoSys.Setting.CabinetBackColor;
	//XbhXgtHg
	ListMemo.Font.Name := GikoSys.Setting.ListFontName;
	ListMemo.Font.Size := GikoSys.Setting.ListFontSize;
	ListMemo.Font.Color := GikoSys.Setting.ListFontColor;
	ListMemo.Color := GikoSys.Setting.ListBackColor;
	//uEU|bvAbvtHg
	HintMemo.Font.Name := GikoSys.Setting.HintFontName;
	HintMemo.Font.Size := GikoSys.Setting.HintFontSize;
	HintMemo.Font.Color := GikoSys.Setting.HintFontColor;
	HintMemo.Color := GikoSys.Setting.HintBackColor;
	//uEU^utHg
	BrowserTabMemo.Font.Name := GikoSys.Setting.BrowserTabFontName;
	BrowserTabMemo.Font.Size := GikoSys.Setting.BrowserTabFontSize;
	BrowserTabMemo.Font.Style := [];
	if GikoSys.Setting.BrowserTabFontBold then
		BrowserTabMemo.Font.Style := BrowserTabMemo.Font.Style + [fsBold];
	if GikoSys.Setting.BrowserTabFontItalic then
		BrowserTabMemo.Font.Style := BrowserTabMemo.Font.Style + [fsItalic];
	//GfB^tHg
	EditorMemo.Font.Name := GikoSys.Setting.EditorFontName;
	EditorMemo.Font.Size := GikoSys.Setting.EditorFontSize;
	EditorMemo.Font.Color := GikoSys.Setting.EditorFontColor;
	EditorMemo.Color := GikoSys.Setting.EditorBackColor;
	//CSS\
	CSSCheckBox.Checked := GikoSys.Setting.UseCSS;
	//
	//X^CV[gt@Cꗗ
	FileList := TStringList.Create;
	try
		GikoSys.GetFileList(GikoSys.GetStyleSheetDir, '*.css', FileList, True, True);

		Idx := Length(GikoSys.GetStyleSheetDir);
		for i := 0 to FileList.Count - 1 do
			FileList[i] := Copy(FileList[i], Idx + 1, Length(FileList[i]));
		FileList.Sort;
		for i := 0 to FileList.Count - 1 do begin
			//s := ExtractFileName(FileList[i]);
			if LowerCase(FileList[i]) = 'default.css' then
				Item := CSSListView.Items.Insert(0)
			else
				Item := CSSListView.Items.Add;
			Item.Caption := ChangeFileExt(FileList[i], '');
			if LowerCase(FileList[i]) = LowerCase(GikoSys.Setting.CSSFileName) then
				Item.Selected := True;
		end;
	finally
		FileList.Free;
	end;
	if (CSSListView.ItemIndex = -1) and (CSSListView.Items.Count > 0) then
		CSSListView.Items[0].Selected := True;		

	//Mail\
	ShowMailCheckBox.Checked := GikoSys.Setting.ShowMail;
	//^uǉʒu
	TabAddRadioGroup.ItemIndex := Ord(GikoSys.Setting.BrowserTabAppend);
	//XVURL
	BoardURL2chEdit.Text := GikoSys.Setting.BoardURL2ch;
	//F
	UserIDEdit.Text := GikoSys.Setting.UserID;
	PasswordEdit.Text := GikoSys.Setting.Password;
	AutoLoginCheckBox.Checked := GikoSys.Setting.AutoLogin;
	//OtH_
	if GikoSys.Setting.NewLogFolder = '' then
		LogFolderEdit.Text := GikoSys.Setting.LogFolder
	else
		LogFolderEdit.Text := GikoSys.Setting.NewLogFolder;
	//TEh
	for i := 0 to GikoSys.Setting.GetSoundCount - 1 do begin
		Item := SoundListView.Items.Add;
		Item.Caption := GikoSys.Setting.SoundViewName[i];
		if FileExists(GikoSys.Setting.SoundFileName[i]) then
			Item.SubItems.Add(GikoSys.Setting.SoundFileName[i])
		else
			Item.SubItems.Add('');
	end;
	//URLNbN
	URLAppCheckBox.Checked := GikoSys.Setting.URLApp;
	URLAppCheckBoxClick(nil);
	AppFolderEdit.Text := GikoSys.Setting.URLAppFile;

	//mailtoNbN
	OpenMailerCheckBox.Checked := GikoSys.Setting.OpenMailer;

	//O폜bZ[W
	LogDeleteMessageCheckBox.Checked := GikoSys.Setting.DeleteMsg;

	//|bvAbvʒu
	case GikoSys.Setting.PopupPosition of
		gppRightTop: 		PopupPositionRadioGroup.ItemIndex := 0;
		gppRight: 			PopupPositionRadioGroup.ItemIndex := 1;
		gppRightBottom: PopupPositionRadioGroup.ItemIndex := 2;
		gppTop: 				PopupPositionRadioGroup.ItemIndex := 3;
		gppCenter: 			PopupPositionRadioGroup.ItemIndex := 4;
		gppBottom: 			PopupPositionRadioGroup.ItemIndex := 5;
		gppLeftTop: 		PopupPositionRadioGroup.ItemIndex := 6;
		gppLeft: 				PopupPositionRadioGroup.ItemIndex := 7;
		gppLeftBottom: 	PopupPositionRadioGroup.ItemIndex := 8;
	end;

	//ANeBu|bvAbv\
	UnActivePopupCheckBox.Checked := GikoSys.Setting.UnActivePopup;
	//X|bvAbv{[h\
	ResPopupBoldCheckBox.Checked := GikoSys.Setting.ResPopupHeaderBold;

	//AhXo[
	URLDisplayCheckBox.Checked := GikoSys.Setting.URLDisplay;
	TabStopAddressBarCheckBox.Checked := GikoSys.Setting.AddressBarTabStop;
	LinkAddCheckBox.Checked := GikoSys.Setting.LinkAddAddressBar;
	AddressHistoryCountEdit.Text := IntToStr(GikoSys.Setting.AddressHistoryCount);

	//HTMLvr[
	PreviewVisibleCheckBox.Checked := GikoSys.Setting.PreviewVisible;
	PreviewWaitEdit.Text := IntToStr(GikoSys.Setting.PreviewWait);
	PreviewSizeComboBox.ItemIndex := 2;
	case GikoSys.Setting.PreviewSize of
		gpsXLarge: PreviewSizeComboBox.ItemIndex := 4;
		gpsLarge: PreviewSizeComboBox.ItemIndex := 3;
		gpsMedium: PreviewSizeComboBox.ItemIndex := 2;
		gpsSmall: PreviewSizeComboBox.ItemIndex := 1;
		gpsXSmall: PreviewSizeComboBox.ItemIndex := 0;
	end;

	//XbhꗗXVACR
	ThreadListIconCheckBox.Checked := GikoSys.Setting.ListIconVisible;

	//ݎ}VԎgpݒ
	PostTimeCheckBox.Checked := GikoSys.Setting.UseMachineTime;
	PostTimeEdit.Text := IntToStr(GikoSys.Setting.TimeAdjustSec);
	if GikoSys.Setting.TimeAdjust then
		PutPostTimeRadioButton.Checked := True
	else
		BackPostTimeRadioButton.Checked := True;
    //ځ`
    RloCheckBox.Checked := GikoSys.Setting.AbonDeleterlo;
    ReplaceulCheckBox.Checked := GikoSys.Setting.AbonReplaceul;
    PopUpAbonCheckBox.Checked := GikoSys.Setting.PopUpAbon;
    CutOfflabeledEdit.Text := IntToStr(GikoSys.Setting.AbonCutoffNum);

end;

procedure TOptionDialog.SaveSetting;
var
	i: Integer;
//	Item: TListItem;
begin
	//Mobt@TCY
	Gikosys.Setting.RecvBufferSize := StrToInt(RecvBufferSize.Text);
	//HTTP1.1gp
	GikoSys.Setting.Protocol := ProtocolCheckBox.Checked;
	//vLVڑHTTP1.1gp
	Gikosys.Setting.ProxyProtocol := ProxyProtocolCheckBox.Checked;

	GikoSys.Setting.ReadProxy := ReadProxyCheck.Checked;
	GikoSys.Setting.ReadProxyAddress := ReadProxyAddressEdit.Text;
	GikoSys.Setting.ReadProxyPort := StrToInt(ReadPortEdit.Text);
	GikoSys.Setting.ReadProxyUserID := ReadProxyUserIDEdit.Text;
	GikoSys.Setting.ReadProxyPassword := ReadProxyPasswordEdit.Text;

	GikoSys.Setting.WriteProxy := WriteProxyCheck.Checked;
	GikoSys.Setting.WriteProxyAddress := WriteProxyAddressEdit.Text;
	GikoSys.Setting.WriteProxyPort := StrToInt(WritePortEdit.Text);
	GikoSys.Setting.WriteProxyUserID := WriteProxyUserIDEdit.Text;
	GikoSys.Setting.WriteProxyPassword := WriteProxyPasswordEdit.Text;

	GikoSys.Setting.CabinetFontName := CabinetMemo.Font.Name;
	GikoSys.Setting.CabinetFontSize := CabinetMemo.Font.Size;
	GikoSys.Setting.CabinetFontColor := CabinetMemo.Font.Color;
	GikoSys.Setting.CabinetBackColor := CabinetMemo.Color;

	GikoSys.Setting.ListFontName := ListMemo.Font.Name;
	GikoSys.Setting.ListFontSize := ListMemo.Font.Size;
	GikoSys.Setting.ListFontColor := ListMemo.Font.Color;
	GikoSys.Setting.ListBackColor := ListMemo.Color;

	GikoSys.Setting.HintFontName := HintMemo.Font.Name;
	GikoSys.Setting.HintFontSize := HintMemo.Font.Size;
	GikoSys.Setting.HintFontColor := HintMemo.Font.Color;
	GikoSys.Setting.HintBackColor := HintMemo.Color;

	GikoSys.Setting.BrowserTabFontName := BrowserTabMemo.Font.Name;
	GikoSys.Setting.BrowserTabFontSize := BrowserTabMemo.Font.Size;

	GikoSys.Setting.EditorFontName := EditorMemo.Font.Name;
	GikoSys.Setting.EditorFontSize := EditorMemo.Font.Size;
	GikoSys.Setting.EditorFontColor := EditorMemo.Font.Color;
	GikoSys.Setting.EditorBackColor := EditorMemo.Color;
	//CSS\
	GikoSys.Setting.UseCSS := CSSCheckBox.Checked;
	//CSSt@C
	GikoSys.Setting.CSSFileName := 'default.css';
	if CSSListView.Items.Count > 0 then begin
		try
			GikoSys.Setting.CSSFileName := CSSListView.Items[CSSListView.ItemIndex].Caption + '.css'
		except
		end;
	end;

	//Mail\
	GikoSys.Setting.ShowMail := ShowMailCheckBox.Checked;

	GikoSys.Setting.BrowserTabAppend := TGikoTabAppend(TabAddRadioGroup.ItemIndex);

	GikoSys.Setting.BoardURL2ch := BoardURL2chEdit.Text;

	GikoSys.Setting.UserID := UserIDEdit.Text;
	GikoSys.Setting.Password := PasswordEdit.Text;
	GikoSys.Setting.AutoLogin := AutoLoginCheckBox.Checked;

	GikoSys.Setting.URLApp := URLAppCheckBox.Checked;
	GikoSys.Setting.URLAppFile := AppFolderEdit.Text;

	GikoSys.Setting.OpenMailer := OpenMailerCheckBox.Checked;
	GikoSys.Setting.DeleteMsg := LogDeleteMessageCheckBox.Checked;

	//|bvAbvʒu
	case PopupPositionRadioGroup.ItemIndex of
		0: GikoSys.Setting.PopupPosition := gppRightTop;
		1: GikoSys.Setting.PopupPosition := gppRight;
		2: GikoSys.Setting.PopupPosition := gppRightBottom;
		3: GikoSys.Setting.PopupPosition := gppTop;
		4: GikoSys.Setting.PopupPosition := gppCenter;
		5: GikoSys.Setting.PopupPosition := gppBottom;
		6: GikoSys.Setting.PopupPosition := gppLeftTop;
		7: GikoSys.Setting.PopupPosition := gppLeft;
		8: GikoSys.Setting.PopupPosition := gppLeftBottom;
	end;

	//ANeBu|bvAbv\
	GikoSys.Setting.UnActivePopup := UnActivePopupCheckBox.Checked;
	//X|bvAbv{[h\
	GikoSys.Setting.ResPopupHeaderBold := ResPopupBoldCheckBox.Checked;

	//AhXo[
	GikoSys.Setting.URLDisplay := URLDisplayCheckBox.Checked;
	GikoSys.Setting.AddressBarTabStop := TabStopAddressBarCheckBox.Checked;
	GikoSys.Setting.LinkAddAddressBar := LinkAddCheckBox.Checked;
	if GikoSys.IsNumeric(AddressHistoryCountEdit.Text) then
		GikoSys.Setting.AddressHistoryCount := StrToInt(AddressHistoryCountEdit.Text)
	else
		GikoSys.Setting.AddressHistoryCount := 100;

	//HTMLvr[
	GikoSys.Setting.PreviewVisible := PreviewVisibleCheckBox.Checked;
	if GikoSys.IsNumeric(PreviewWaitEdit.Text) then
		GikoSys.Setting.PreviewWait := StrToInt(PreviewWaitEdit.Text)
	else
		GikoSys.Setting.PreviewWait := 500;
	case PreviewSizeComboBox.ItemIndex of
		0: GikoSys.Setting.PreviewSize := gpsXSmall;
		1: GikoSys.Setting.PreviewSize := gpsSmall;
		2: GikoSys.Setting.PreviewSize := gpsMedium;
		3: GikoSys.Setting.PreviewSize := gpsLarge;
		4: GikoSys.Setting.PreviewSize := gpsXLarge;
	end;

	//XbhꗗXVACR
	GikoSys.Setting.ListIconVisible := ThreadListIconCheckBox.Checked;

	//ݎ}VԎgpݒ
	GikoSys.Setting.UseMachineTime := PostTimeCheckBox.Checked;
	if GikoSys.IsNumeric(PostTimeEdit.Text) then
		GikoSys.Setting.TimeAdjustSec := StrToInt(PostTimeEdit.Text)
	else
		GikoSys.Setting.TimeAdjustSec := 0;
	GikoSys.Setting.TimeAdjust := PutPostTimeRadioButton.Checked;


	GikoSys.Setting.WriteSystemSettingFile;
//	GikoForm.SetBrowserTabState;

	if LogFolderEdit.Text <> '' then begin
		GikoSys.Setting.NewLogFolder := LogFolderEdit.Text;
		GikoSys.Setting.WriteFolderSettingFile;
	end;

	for i := 0 to SoundListView.Items.Count - 1 do begin
		if FileExists(SoundListView.Items[i].SubItems[0]) then
			GikoSys.Setting.SoundFileName[i] := SoundListView.Items[i].SubItems[0]
		else
			GikoSys.Setting.SoundFileName[i] := '';
	end;

    //ځ`
    GikoSys.Setting.AbonDeleterlo := RloCheckBox.Checked;
    GikoSys.Setting.AbonReplaceul := ReplaceulCheckBox.Checked;
    GikoSys.Setting.PopUpAbon := PopUpAbonCheckBox.Checked;
    try
        if StrToInt(CutOfflabeledEdit.Text) > 0 then begin
            GikoSys.Setting.AbonCutoffNum := StrToInt(CutOfflabeledEdit.Text);
        end else begin
            GikoSys.Setting.AbonCutoffNum := 0;
        end;
    except
        GikoSys.Setting.AbonCutoffNum := 0;
    end;
end;

procedure TOptionDialog.SettingApply;
var
	i: Integer;
begin
	GikoForm.TreeView.Items.BeginUpdate;
	GikoForm.ListView.Items.BeginUpdate;
	try
		GikoForm.TreeView.Font.Name := GikoSys.Setting.CabinetFontName;
		GikoForm.TreeView.Font.Size := GikoSys.Setting.CabinetFontSize;
		GikoForm.TreeView.Font.Color := GikoSys.Setting.CabinetFontColor;
		GikoForm.TreeView.Color := GikoSys.Setting.CabinetBackColor;

		GikoForm.ListView.Font.Name := GikoSys.Setting.ListFontName;
		GikoForm.ListView.Font.Size := GikoSys.Setting.ListFontSize;
		GikoForm.ListView.Font.Color := GikoSys.Setting.ListFontColor;
		GikoForm.ListView.Color := GikoSys.Setting.ListBackColor;

		GikoForm.BrowserTab.Font.Name := GikoSys.Setting.BrowserTabFontName;
		GikoForm.BrowserTab.Font.Size := GikoSys.Setting.BrowserTabFontSize;
//		GikoForm.BrowserTab.Height := (GikoSys.Setting.BrowserTabFontSize * 2) + 1;
//		GikoForm.BrowserBottomPanel.Height := GikoForm.BrowserTab.Height;

		for i := 0 to Screen.CustomFormCount - 1 do begin
			if TObject(Screen.CustomForms[i]) is TEditorForm then begin
				TEditorForm(Screen.CustomForms[i]).SetFont;
			end;
		end;

	finally
		GikoForm.TreeView.Items.EndUpdate;
		GikoForm.ListView.Items.EndUpdate;
	end;

	//AhXo[
	for i := GikoForm.AddressComboBox.Items.Count - 1 downto 0 do begin
		if GikoSys.Setting.AddressHistoryCount >= GikoForm.AddressComboBox.Items.Count then
			Break;
		GikoForm.AddressComboBox.Items.Delete(i);
	end;
	GikoForm.AddressComboBox.TabStop := GikoSys.Setting.AddressBarTabStop;
end;

procedure TOptionDialog.ReadProxyCheckClick(Sender: TObject);
begin
	ReadProxyAddressEdit.Enabled := ReadProxyCheck.Checked;
	ReadPortEdit.Enabled := ReadProxyCheck.Checked;
	ReadProxyUserIDEdit.Enabled := ReadProxyCheck.Checked;
	ReadProxyPasswordEdit.Enabled := ReadProxyCheck.Checked;

	ReadAddressLabel.Enabled := ReadProxyCheck.Checked;
	ReadPortLabel.Enabled := ReadProxyCheck.Checked;
	ReadUserIDLabel.Enabled := ReadProxyCheck.Checked;
	ReadPasswordLabel.Enabled := ReadProxyCheck.Checked;
end;

procedure TOptionDialog.ReadPortEditExit(Sender: TObject);
begin
	if not GikoSys.IsNumeric(ReadPortEdit.Text) then
		ReadPortEdit.Text := '0';
end;

procedure TOptionDialog.LogFolderButtonClick(Sender: TObject);
var
	Root: WideString;
	Dir: string;
begin
	Root := '';
	if SelectDirectory('OtH_I', Root, Dir) then begin
		LogFolderEdit.Text := Dir;
	end;
end;

function TOptionDialog.CheckFolder: Boolean;
begin
	if Trim(LogFolderEdit.Text) = '' then
		LogFolderEdit.Text := ExtractFilePath(Application.ExeName) + 'Log';

	if DirectoryExists(LogFolderEdit.Text) then begin
		Result := True;
	end else begin
		if MsgBox(Handle, 'OtH_݂܂B쐬܂H', 'MRir', MB_YESNO or MB_ICONQUESTION) = IDYES	then begin
			//tH_쐬
			try
				GikoSys.ForceDirectoriesEx(LogFolderEdit.Text);
				Result := True
			except
				MsgBox(Handle, 'OtH_̎w肪słB', 'G[', MB_OK or MB_ICONSTOP);
				OptionTab.ActivePage := FolderSheet;
				LogFolderEdit.SetFocus;
				Result := False;
			end;
		end else
			Result := False;
	end;
end;

procedure TOptionDialog.FormClose(Sender: TObject; var Action: TCloseAction);
begin
	if not FClose then
		Action := caNone;
	FClose := True;
end;

procedure TOptionDialog.SoundReferButtonClick(Sender: TObject);
begin
	OpenDialog.Filter := 'TEh (*.wav)|*.wav|ׂẴt@C (*.*)|*.*';
	sndPlaySound(nil, SND_ASYNC);
	if OpenDialog.Execute then begin
		SoundFileEdit.Text := OpenDialog.FileName;
	end;
end;

procedure TOptionDialog.SoundPlayButtonClick(Sender: TObject);
begin
	if not FileExists(SoundFileEdit.Text) then begin
		MsgBox(Handle, '݂Ȃt@Cł', 'G[', MB_ICONSTOP or MB_OK);
		SoundFileEdit.Text := '';
		Exit;
	end;
	if not sndPlaySound(PChar(SoundFileEdit.Text), SND_ASYNC or SND_NOSTOP) then begin
		sndPlaySound(nil, SND_ASYNC);
	end;
end;

procedure TOptionDialog.SoundListViewChanging(Sender: TObject;
  Item: TListItem; Change: TItemChange; var AllowChange: Boolean);
begin
	if Item.SubItems.Count > 0 then
		SoundFileEdit.Text := Item.SubItems[0];
end;

procedure TOptionDialog.SoundFileEditChange(Sender: TObject);
var
	Item: TListItem;
begin
	sndPlaySound(nil, SND_ASYNC);
	Item := SoundListView.Selected;
	if Item = nil then Exit;

	if FileExists(SoundFileEdit.Text) then
		Item.SubItems[0] := SoundFileEdit.Text;
	if Trim(SoundFileEdit.Text) = '' then
		Item.SubItems[0] := '';
end;

procedure TOptionDialog.OptionTabChange(Sender: TObject);
begin
	sndPlaySound(nil, SND_ASYNC);
end;

procedure TOptionDialog.AppFolderButtonClick(Sender: TObject);
begin
	OpenDialog.Filter := 'st@C (*.exe)|*.exe|ׂẴt@C (*.*)|*.*';
	if OpenDialog.Execute then
		AppFolderEdit.Text := OpenDialog.FileName;
end;

procedure TOptionDialog.WriteProxyCheckClick(Sender: TObject);
begin
	WriteProxyAddressEdit.Enabled := WriteProxyCheck.Checked;
	WritePortEdit.Enabled := WriteProxyCheck.Checked;
	WriteProxyUserIDEdit.Enabled := WriteProxyCheck.Checked;
	WriteProxyPasswordEdit.Enabled := WriteProxyCheck.Checked;

	WriteAddressLabel.Enabled := WriteProxyCheck.Checked;
	WritePortLabel.Enabled := WriteProxyCheck.Checked;
	WriteUserIDLabel.Enabled := WriteProxyCheck.Checked;
	WritePasswordLabel.Enabled := WriteProxyCheck.Checked;
end;

procedure TOptionDialog.WritePortEditExit(Sender: TObject);
begin
	if not GikoSys.IsNumeric(WritePortEdit.Text) then
		WritePortEdit.Text := '0';
end;

procedure TOptionDialog.Tora3URLLabelClick(Sender: TObject);
begin
	GikoSys.OpenBrowser(URL_TORA3, gbtAuto);
end;

procedure TOptionDialog.HotKeyEnter(Sender: TObject);
begin
	OkBotton.Default := False;
	CancelBotton.Cancel := False;
end;

procedure TOptionDialog.HotKeyExit(Sender: TObject);
begin
	OkBotton.Default := True;
	CancelBotton.Cancel := True;
end;

procedure TOptionDialog.URLAppCheckBoxClick(Sender: TObject);
begin
	AppFolderLabel.Enabled := URLAppCheckBox.Checked;
	AppFolderEdit.Enabled := URLAppCheckBox.Checked;
	AppFolderButton.Enabled := URLAppCheckBox.Checked;
end;

procedure TOptionDialog.AddressHistoryCountEditExit(Sender: TObject);
begin
	if not GikoSys.IsNumeric(AddressHistoryCountEdit.Text) then
		AddressHistoryCountEdit.Text := '100';
end;

procedure TOptionDialog.PreviewWaitEditExit(Sender: TObject);
begin
	if not GikoSys.IsNumeric(PreviewWaitEdit.Text) then
		PreviewWaitEdit.Text := '500';
	if StrToInt(PreviewWaitEdit.Text) < 500 then
		PreviewWaitEdit.Text := '500';
	if StrToInt(PreviewWaitEdit.Text) > 9999 then
		PreviewWaitEdit.Text := '9999';
end;

procedure TOptionDialog.RecvBufferSizeExit(Sender: TObject);
begin
	if not GikoSys.IsNumeric(RecvBufferSize.Text) then
		RecvBufferSize.Text := '4096';
	if StrToInt(RecvBufferSize.Text) < 256 then
		RecvBufferSize.Text := '4096';
end;

procedure TOptionDialog.CSSCheckBoxClick(Sender: TObject);
begin
	CSSListLabel.Enabled := CSSCheckBox.Checked;
	CSSListView.Enabled := CSSCheckBox.Checked;
end;

procedure TOptionDialog.PostTimeEditExit(Sender: TObject);
begin
	if not GikoSys.IsNumeric(PostTimeEdit.Text) then
		PostTimeEdit.Text := '0';
end;

procedure TOptionDialog.PostTimeCheckBoxClick(Sender: TObject);
begin
	PostTimeLabel.Enabled := PostTimeCheckBox.Checked;
	PostTimeEdit.Enabled := PostTimeCheckBox.Checked;
	PutPostTimeRadioButton.Enabled := PostTimeCheckBox.Checked;
	BackPostTimeRadioButton.Enabled := PostTimeCheckBox.Checked;
end;
procedure TOptionDialog.SetAbonpropertys;
begin
    //ځ`
    GikoSys.FAbon.Deleterlo := RloCheckBox.Checked;
    GikoSys.FAbon.Replaceul := ReplaceulCheckBox.Checked;
    GikoSys.FAbon.AbonPopupRes := PopUpAbonCheckBox.Checked;
    try
        if StrToInt(CutOfflabeledEdit.Text) > 0 then begin
            GikoSys.FAbon.SetCutoffNum(StrToInt(CutOfflabeledEdit.Text));
        end else begin
            GikoSys.FAbon.SetCutoffNum(0);
        end;
    except
        GikoSys.FAbon.SetCutoffNum(0);
    end;

end;
end.

