unit Favorite;

interface

uses
	Messages, SysUtils, Classes, Contnrs, ComCtrls, {HttpApp,} YofUtils,
	GikoSystem{, XMLIntf, XMLDoc};
	{SAX, SAXHelpers, SAXComps, SAXKW;}

type
	TFavoriteFolder = class
	end;

	TFavoriteBoardItem = class
	private
		FBBSID: string;
		FBoardName: string;
	public
		property BBSID: string read FBBSID write FBBSID;
		property BoardName: string read FBoardName write FBoardName;
	end;

	TFavoriteThreadItem = class
	private
		FBBSID: string;
		FThreadID: string;
		FThreadName: string;
	public
		property BBSID: string read FBBSID write FBBSID;
		property ThreadID: string read FThreadID write FThreadID;
		property ThreadName: string read FThreadName write FThreadName;
	end;

	TFavoriteDM = class(TDataModule)
		procedure DataModuleCreate(Sender: TObject);
		procedure DataModuleDestroy(Sender: TObject);
	private
		{ Private 錾 }
		FStack: TStack;
		FTreeView: TTreeView;

		procedure ReadNode(Node: IXMLNode);
		procedure AddSaveString(Node: TTreeNode; SaveList: TStringList);
//		procedure AddSaveString(Node: TTreeNode; XMLNode: IXMLNode);
//		procedure SAXStartDocument(Sender: TObject);
//		procedure SAXEndDocument(Sender: TObject);
//		procedure SAXStartElement(Sender: TObject; const NamespaceURI, LocalName, QName: SAXString; const Atts: IAttributes);
//		procedure SAXEndElement(Sender: TObject; const NamespaceURI, LocalName, QName: SAXString);
//		procedure SAXCharacters(Sender: TObject; const PCh: SAXString);
	public
		{ Public 錾 }
		procedure SetFavTreeView(TreeView: TTreeView);
		procedure ReadFavorite;
		procedure WriteFavorite;
		property TreeView: TTreeView read FTreeView;
	end;

var
	FavoriteDM: TFavoriteDM;
const
	FAVORITE_LINK_NAME = 'N';

implementation

const
	FAVORITE_ROOT_NAME = 'Cɓ';
	FAVORITE_FILE_NAME = 'Favorite.xml';

{$R *.dfm}

procedure TFavoriteDM.DataModuleCreate(Sender: TObject);
begin
	//FTreeView := TreeView;
	//FTreeView := GikoForm.FavoriteTreeView;
end;

procedure TFavoriteDM.DataModuleDestroy(Sender: TObject);
var
	i: Integer;
begin
	for i := 0 to TreeView.Items.Count - 1 do begin
		TObject(TreeView.Items[i].Data).Free;
	end;
end;

procedure TFavoriteDM.SetFavTreeView(TreeView: TTreeView);
begin
	FTreeView := TreeView;
end;

procedure TFavoriteDM.ReadFavorite;
var
	FileName: string;
	XMLDoc: IXMLDocument;
	XMLNode: IXMLNode;
	Node: TTreeNode;
	i: Integer;
	FavFolder: TFavoriteFolder;
	LinkExists: Boolean;
begin

	FileName := GikoSys.GetConfigDir + FAVORITE_FILE_NAME;

	FavFolder := TFavoriteFolder.Create;
	Node := FTreeView.Items.AddChildObject(nil, FAVORITE_ROOT_NAME, FavFolder);
	Node.ImageIndex := 14;
	Node.SelectedIndex := 14;

	if FileExists(FileName) then begin
		try
			XMLDoc := LoadXMLDocument(FileName);
			XMLNode := XMLDoc.DocumentElement;

			FStack := TStack.Create;
			try
				FStack.Push(Node);
				LinkExists := False;
				if XMLNode.NodeName = 'favorite' then begin
					for i := 0 to XMLNode.ChildNodes.Count - 1 do begin
						ReadNode(XMLNode.ChildNodes[i]);
						if (XMLNode.ChildNodes[i].NodeName = 'folder') and
							 (XMLNode.ChildNodes[i].Attributes['title'] = FAVORITE_LINK_NAME) then begin
							LinkExists := True;
						end;
					end;
				end;
				if not LinkExists then begin
					FavFolder := TFavoriteFolder.Create;
					Node := FTreeView.Items.AddChildObject(Node, FAVORITE_LINK_NAME, FavFolder);
					Node.ImageIndex := 14;
					Node.SelectedIndex := 14;
				end;
			finally
				FStack.Free;
			end;
		except
		end;
	end;

{
	FavFolder := TFavoriteFolder.Create;
	Node := FTreeView.Items.AddChildObject(nil, FAVORITE_ROOT_NAME, FavFolder);
	Node.ImageIndex := 12;
	Node.SelectedIndex := 13;

	FileName := GikoSys.GetConfigDir + FAVORITE_FILE_NAME;
	if not FileExists(FileName) then
		Exit;

		FavSAXHandler.OnStartDocument := SAXStartDocument;
		FavSAXHandler.OnEndDocument := SAXEndDocument;
		FavSAXHandler.OnStartElement := SAXStartElement;
		FavSAXHandler.OnStartElement := SAXStartElement;
		FavSAXHandler.OnEndElement := SAXEndElement;
		FavSAXHandler.OnCharacters := SAXCharacters;

		FavSAXReader.Vendor := 'Keith Wood';
		FavSAXReader.URL := FileName;
		FavSAXReader.Parse;}
end;

procedure TFavoriteDM.ReadNode(Node: IXMLNode);
var
	i: Integer;

	ParentNode: TTreeNode;
	CurrentNode: TTreeNode;
	FavFolder: TFavoriteFolder;
	FavBoard: TFavoriteBoardItem;
	FavThread: TFavoriteThreadItem;
begin
	if Node.NodeName = 'folder' then begin
		ParentNode := FStack.Peek;
		if TObject(ParentNode.Data) is TFavoriteFolder then begin
			FavFolder := TFavoriteFolder.Create;
			CurrentNode := FTreeView.Items.AddChildObject(ParentNode, Node.Attributes['title'], FavFolder);
			CurrentNode.ImageIndex := 14;
			CurrentNode.SelectedIndex := 14;
			FStack.Push(CurrentNode);
		end;
		for i := 0 to Node.ChildNodes.Count - 1 do begin
			ReadNode(Node.ChildNodes[i]);
		end;
		if FStack.Count <> 0 then
			FStack.Pop;
	end else if Node.NodeName = 'favitem' then begin
		ParentNode := FStack.Peek;
		if TObject(ParentNode.Data) is TFavoriteFolder then begin
			if Node.Attributes['favtype'] = 'board' then begin
				FavBoard := TFavoriteBoardItem.Create;
				FavBoard.BBSID := Node.Attributes['bbs'];
				FavBoard.BoardName := Node.Attributes['boardname'];
				CurrentNode := FTreeView.Items.AddChildObject(ParentNode, Node.Attributes['title'], FavBoard);
				CurrentNode.ImageIndex := 15;
				CurrentNode.SelectedIndex := 15;
			end else if Node.Attributes['favtype'] = 'thread' then begin
				FavThread := TFavoriteThreadItem.Create;
				FavThread.BBSID := Node.Attributes['bbs'];
				FavThread.ThreadID := Node.Attributes['thread'];
				FavThread.ThreadName := Node.Attributes['threadname'];
				CurrentNode := FTreeView.Items.AddChildObject(ParentNode, Node.Attributes['title'], FavThread);
				CurrentNode.ImageIndex := 16;
				CurrentNode.SelectedIndex := 16;
			end;
		end;
	end;
end;

procedure TFavoriteDM.WriteFavorite;
{
var
	FileName: string;
//	SaveList: TStringList;
//	i: Integer;
//	Count: Integer;

	XMLDoc: IXMLDocument;
	XMLNode: IXMLNode;
//	FavoNode: IXMLNode;
begin
	XMLDoc :=  NewXMLDocument;
	XMLDoc.Encoding := 'Shift_JIS';
	XMLDoc.StandAlone := 'yes';
	XMLNode := XMLDoc.AddChild('favorite');
	FileName := GikoSys.GetConfigDir + FAVORITE_FILE_NAME;
	AddSaveString(TreeView.Items.GetFirstNode, XMLNode);
	XMLDoc.SaveToFile(FileName);
}
var
	FileName: string;
	SaveList: TStringList;
begin
	FileName := GikoSys.GetConfigDir + FAVORITE_FILE_NAME;
	SaveList := TStringList.Create;
	try
		SaveList.Add('<?xml version="1.0" encoding="Shift_JIS" standalone="yes"?>');
		SaveList.Add('<favorite>');
		AddSaveString(TreeView.Items.GetFirstNode, SaveList);
		SaveList.Add('</favorite>');
		SaveList.SaveToFile(FileName);
	finally
		SaveList.Free;
	end;
end;

{
procedure TFavoriteDM.AddSaveString(Node: TTreeNode; XMLNode: IXMLNode);
var
	i: Integer;
//	s: string;
	FavBoard: TFavoriteBoardItem;
	FavThread: TFavoriteThreadItem;
	FavNode: IXMLNode;
begin
	for i := 0 to Node.Count - 1 do begin
		if TObject(Node.Item[i].Data) is TFavoriteFolder then begin
			FavNode := XMLNode.AddChild('folder');
			FavNode.Attributes['title'] := Node.Item[i].Text;
			AddSaveString(Node.Item[i], FavNode);
		end else if TObject(Node.Item[i].Data) is TFavoriteBoardItem then begin
			FavBoard := TFavoriteBoardItem(Node.Item[i].Data);
			FavNode := XMLNode.AddChild('favitem');
			FavNode.Attributes['type'] := '2ch';
			FavNode.Attributes['favtype'] := 'board';
			FavNode.Attributes['bbs'] := FavBoard.BBSID;
			FavNode.Attributes['title'] := Node.Item[i].Text;
			FavNode.Attributes['boardname'] := FavBoard.BoardName;
		end else if TObject(Node.Item[i].Data) is TFavoriteThreadItem then begin
			FavThread := TFavoriteThreadItem(Node.Item[i].Data);
			FavNode := XMLNode.AddChild('favitem');
			FavNode.Attributes['type'] := '2ch';
			FavNode.Attributes['favtype'] := 'thread';
			FavNode.Attributes['bbs'] := FavThread.BBSID;
			FavNode.Attributes['thread'] := FavThread.ThreadID;
			FavNode.Attributes['title'] := Node.Item[i].Text;
			FavNode.Attributes['threadname'] := FavThread.ThreadName;
		end;
	end;
end;
}

procedure TFavoriteDM.AddSaveString(Node: TTreeNode; SaveList: TStringList);
var
	i: Integer;
	s: string;
	FavBoard: TFavoriteBoardItem;
	FavThread: TFavoriteThreadItem;
begin
	for i := 0 to Node.Count - 1 do begin
		if TObject(Node.Item[i].Data) is TFavoriteFolder then begin
			s := Format('<folder title="%s">', [HtmlEncode(Node.Item[i].Text)]);
			SaveList.Add(s);
			AddSaveString(Node.Item[i], SaveList);
			SaveList.Add('</folder>');
		end else if TObject(Node.Item[i].Data) is TFavoriteBoardItem then begin
			FavBoard := TFavoriteBoardItem(Node.Item[i].Data);
			s := Format('<favitem type="2ch" favtype="board" bbs="%s" title="%s" boardname="%s"/>',
									[FavBoard.BBSID, HtmlEncode(Node.Item[i].Text), HtmlEncode(FavBoard.BoardName)]);
			SaveList.Add(s);
		end else if TObject(Node.Item[i].Data) is TFavoriteThreadItem then begin
			FavThread := TFavoriteThreadItem(Node.Item[i].Data);
			s := Format('<favitem type="2ch" favtype="thread" bbs="%s" thread="%s" title="%s" threadname="%s"/>',
									[FavThread.BBSID, FavThread.ThreadID, HtmlEncode(Node.Item[i].Text), HtmlEncode(FavThread.ThreadName)]);
			SaveList.Add(s);
		end;
	end;
end;

{
procedure TFavoriteDM.SAXStartDocument(Sender: TObject);
begin
	FStack := TStack.Create;
	FStack.Push(FTreeView.Items.GetFirstNode);
end;

procedure TFavoriteDM.SAXEndDocument(Sender: TObject);
begin
	FStack.Free;
end;

procedure TFavoriteDM.SAXStartElement(Sender: TObject; const NamespaceURI, LocalName, QName: SAXString;
	const Atts: IAttributes);
var
	FavType: string;
	ParentNode: TTreeNode;
	CurrentNode: TTreeNode;
	FavFolder: TFavoriteFolder;
	FavBoard: TFavoriteBoardItem;
	FavThread: TFavoriteThreadItem;
begin
	if QName = 'folder' then begin
		ParentNode := FStack.Peek;
		if TObject(ParentNode.Data) is TFavoriteFolder then begin
			FavFolder := TFavoriteFolder.Create;
			CurrentNode := FTreeView.Items.AddChildObject(ParentNode, Atts.getValue('title'), FavFolder);
			CurrentNode.ImageIndex := 12;
			CurrentNode.SelectedIndex := 13;
			FStack.Push(CurrentNode);
		end;
	end else if QName = 'favitem' then begin
		ParentNode := FStack.Peek;
		if TObject(ParentNode.Data) is TFavoriteFolder then begin
			FavType := Atts.getValue('favtype');
			if FavType = 'board' then begin
				FavBoard := TFavoriteBoardItem.Create;
				FavBoard.BBSID := Atts.getValue('bbs');
				FavBoard.BoardName := Atts.getValue('boardname');
				CurrentNode := FTreeView.Items.AddChildObject(ParentNode, Atts.getValue('title'), FavBoard);
				CurrentNode.ImageIndex := 14;
				CurrentNode.SelectedIndex := 15;
			end else if FavType = 'thread' then begin
				FavThread := TFavoriteThreadItem.Create;
				FavThread.BBSID := Atts.getValue('bbs');
				FavThread.ThreadID := Atts.getValue('thread');
				FavThread.ThreadName := Atts.getValue('threadname');
				CurrentNode := FTreeView.Items.AddChildObject(ParentNode, Atts.getValue('title'), FavThread);
				CurrentNode.ImageIndex := 16;
				CurrentNode.SelectedIndex := 17;
			end;
		end;
	end;
end;

procedure TFavoriteDM.SAXEndElement(Sender: TObject; const NamespaceURI, LocalName, QName: SAXString);
begin
	if QName = 'folder' then begin
		if FStack.Count <> 0 then
			FStack.Pop;
	end;
end;

procedure TFavoriteDM.SAXCharacters(Sender: TObject; const PCh: SAXString);
begin
//
end;
}
end.
