package com.rogerfgm;

import java.util.*;

public class Sikou {
	private final int INF = Integer.MAX_VALUE - 10;
	private static final int TANSAKU_FUKUSA = 3; // T[

	public Kyokumen sikou(Kyokumen kyokumen, boolean b) throws Exception{
		List<Kyokumen> sasiteList = Sasite.createSasiteList(kyokumen, b);
		Kyokumen maxKyokumen = null;
		int maxscore = 0;
		if(b){
			maxscore = -INF;
			for(Kyokumen k : sasiteList){
				if(k.isOu_b()) continue;
				int ret = tansaku(k, !b, TANSAKU_FUKUSA);
				if(ret > maxscore){
					maxscore = ret;
					maxKyokumen = k;
				}
			}
		}
		else{
			maxscore = INF;
			for(Kyokumen k : sasiteList){
				if(k.isOu_b()) continue;
				int ret = tansaku(k, !b, TANSAKU_FUKUSA);
				if(ret < maxscore){
					maxscore = ret;
					maxKyokumen = k;
				}
			}
		}
		if(b && maxscore == -INF){
			return null;
		}
		else if(!b && maxscore == INF){
			return null;
		}
		
		
		return maxKyokumen;
	}
	
	/**
	 * 
	 * @param k ݂̋ǖʁitɂKvj
	 * @param t Tc[
	 * @return
	 * @throws Exception 
	 */
	private int tansaku(Kyokumen k, boolean b, int t) throws Exception{
		if(t == 0){
			return k.hyouka;
		}
		if(b && k.isOu_w()){
			return -INF;
		}
		if(!b && k.isOu_b()){
			return INF;
		}
		t--;

		if(b){
			int maxscore = -INF;
			List<Kyokumen> list = Sasite.createSasiteList(k, b);
			
			for(Kyokumen nk : list){
				int ret = tansaku(nk, !b, t);
				maxscore = Math.max(maxscore, ret);
			}		
			return maxscore;
		}
		else{
			int minscore = INF;
			List<Kyokumen> list = Sasite.createSasiteList(k, b);
			for(Kyokumen nk : list){
				int ret = tansaku(nk, !b, t);
				minscore = Math.min(minscore, ret);
			}		
			return minscore;
		}
	}
	

}
