package com.rogerfgm;

public class Resources {
	public static int Fu_ban = 87;
	public static int Fu_tegoma = 87;
	public static int To_ban = 534;
	public static int Kyo_ban = 232;
	public static int Kyo_tegoma = 232;
	public static int NariKyo_ban = 489;

	
	public static int Kei_ban = 257;
	public static int Kei_tegoma = 257;
	public static int NariKei_ban = 510;
	public static int Gin_ban = 369;
	public static int Gin_tegoma = 369;
	public static int NariGin_ban = 495;
	public static int Kin_ban = 550;
	public static int Kin_tegoma = 550;
	public static int Kaku_ban = 650;
	public static int Kaku_tegoma = 650;
	public static int Uma_ban = 800;
	public static int Hisha_ban = 750;
	public static int Hisha_tegoma = 750;
	public static int Ryu_ban = 900;
	public static int Oh = 400000;
	
	public static final int KomaNum_FU = 0;
	public static final int KomaNum_TO = 1;
	public static final int KomaNum_KYO = 2;
	public static final int KomaNum_NARIKYO = 3;
	public static final int KomaNum_KEI = 4;
	public static final int KomaNum_NARIKEI = 5;
	public static final int KomaNum_GIN = 6;
	public static final int KomaNum_NARIGIN = 7;
	public static final int KomaNum_KIN = 8;
	public static final int KomaNum_KAKU = 10;
	public static final int KomaNum_UMA = 11;
	public static final int KomaNum_HISHA = 12;
	public static final int KomaNum_RYU = 13;
	public static final int KomaNum_OU = 14;
	
	public static int getTegomaNumber(int koma){
		if(koma % 2 == 1){
			koma--;
		}
		return koma;
	}
	
	public static int getTegomaValue(int koma) throws Exception{
		if(koma == KomaNum_FU){
			return Fu_tegoma;
		}
		if(koma == KomaNum_KYO){
			return Kyo_tegoma;
		}
		if(koma == KomaNum_KEI){
			return Kei_tegoma;
		}
		if(koma == KomaNum_GIN){
			return Gin_tegoma;
		}
		if(koma == KomaNum_KIN){
			return Kin_tegoma;
		}
		if(koma == KomaNum_KAKU){
			return Kaku_tegoma;
		}
		if(koma == KomaNum_HISHA){
			return Hisha_tegoma;
		}
		if(koma == KomaNum_OU){
			return Oh;
		}
		throw new Exception("Invalid tegoma value : " + koma);
	}
	
	public static int getKomaValue(int koma) throws Exception{
		if(koma == KomaNum_FU){
			return Fu_ban;
		}
		if(koma == KomaNum_TO){
			return To_ban;
		}
		if(koma == KomaNum_KYO){
			return Kyo_ban;
		}
		if(koma == KomaNum_NARIKYO){
			return NariKyo_ban;
		}
		if(koma == KomaNum_KEI){
			return Kei_ban;
		}
		if(koma == KomaNum_NARIKEI){
			return NariKei_ban;
		}
		if(koma == KomaNum_GIN){
			return Gin_ban;
		}
		if(koma == KomaNum_NARIGIN){
			return NariGin_ban;
		}
		if(koma == KomaNum_KIN){
			return Kin_ban;
		}
		if(koma == KomaNum_KAKU){
			return Kaku_ban;
		}
		if(koma == KomaNum_UMA){
			return Uma_ban;
		}
		if(koma == KomaNum_HISHA){
			return Hisha_ban;
		}
		if(koma == KomaNum_RYU){
			return Ryu_ban;
		}
		if(koma == KomaNum_OU){
			return Oh;
		}
		throw new Exception("Invalid koma value " + koma);
	}
	
}
