public class swap {
	public static int swap(tree_t ptree, int move, int root_alpha,
			int root_beta, int turn) {
		bitboard_t bb = new bitboard_t(), bb_temp = new bitboard_t(), bb_attack = new bitboard_t();
		int attacked_piece, from, to, nc;
		int piece_cap, piece, value, xvalue, alpha, beta, is_promo;

		from = (int) bitop.I2From(move);
		to = (int) bitop.I2To(move);

		if (from >= def.nsquare) {
			value = 0;
			piece = bitop.From2Drop(from);
			attacked_piece = data.p_value_ex[15 + piece];
		} else {
			piece = (int) bitop.I2PieceMove(move);
			piece_cap = (int) bitop.UToCap(move);
			is_promo = (int) bitop.I2IsPromote(move);

			value = data.p_value_ex[15 + piece_cap];
			attacked_piece = data.p_value_ex[15 + piece];
			if (is_promo > 0) {
				value += data.p_value_pm[7 + piece];
				attacked_piece += data.p_value_pm[7 + piece];
			}
			xvalue = value - attacked_piece - data.p_value_pm[7 + def.pawn];
			if (xvalue >= root_beta) {
				return xvalue;
			}
		}

		bb_attack = attack.attacks_to_piece(ptree, to);
		alpha = Integer.MIN_VALUE;
		beta = value;
		for (nc = 1;; nc++) {
			/* remove an attacker, and add a hidden piece to bb_attack */
			if (from < def.nsquare) {
				bitop.Xor(from, bb_attack);
				if ((int) data.adirec[to][from] == def.direc_rank) {
					bb = new bitboard_t(bitop.AttackRank(from, ptree));
					if (from > to) {
						bitop.BBAnd(bb, bb, data.abb_plus_rays[from]);
					} else {
						bitop.BBAnd(bb, bb, data.abb_minus_rays[from]);
					}
					bitop.BBOr(bb_temp, ptree.posi.b_rd, ptree.posi.w_rd);
					bitop.BBAndOr(bb_attack, bb, bb_temp);
				}

				else if ((int) data.adirec[to][from] == def.direc_file) {
					bb = new bitboard_t(bitop.AttackFile(from, ptree));
					bitop.BBOr(bb_temp, ptree.posi.b_rd, ptree.posi.w_rd);
					if (from > to) {
						bitop.BBOr(bb_temp, bb_temp, ptree.posi.b_lance);
						bitop.BBAnd(bb, bb, data.abb_plus_rays[from]);
					} else {
						bitop.BBOr(bb_temp, bb_temp, ptree.posi.w_lance);
						bitop.BBAnd(bb, bb, data.abb_minus_rays[from]);
					}
					bitop.BBAnd(bb, bb, bb_temp);
					bitop.BBOr(bb_attack, bb_attack, bb);
				}

				else if ((int) data.adirec[to][from] == def.direc_diag1) {
					bb = new bitboard_t(bitop.AttackDiag1(from, ptree));
					if (from > to) {
						bitop.BBAnd(bb, bb, data.abb_plus_rays[from]);
					} else {
						bitop.BBAnd(bb, bb, data.abb_minus_rays[from]);
					}
					bitop.BBOr(bb_temp, ptree.posi.b_bh, ptree.posi.w_bh);
					bitop.BBAnd(bb, bb, bb_temp);
					bitop.BBOr(bb_attack, bb_attack, bb);
				}

				else if ((int) data.adirec[to][from] == def.direc_diag2) {
					bb = new bitboard_t(bitop.AttackDiag2(from, ptree));
					if (from > to) {
						bitop.BBAnd(bb, bb, data.abb_plus_rays[from]);
					} else {
						bitop.BBAnd(bb, bb, data.abb_minus_rays[from]);
					}
					bitop.BBOr(bb_temp, ptree.posi.b_bh, ptree.posi.w_bh);
					bitop.BBAnd(bb, bb, bb_temp);
					bitop.BBOr(bb_attack, bb_attack, bb);
				}
			}

			/* find the cheapest piece attacks the target */
			ab_cut: {
				if (turn > 0) {
					if (!(bitop.BBContract(bb_attack, ptree.posi.b_occupied) > 0)) {
						break;
					}
					value = attacked_piece - value;

					if (bitop.BBContract(bb_attack, ptree.posi.b_pawn) > 0) {
						from = to + def.nfile;
						attacked_piece = data.p_value_ex[15 + def.pawn];
						if (to < 27) {
							value += data.p_value_pm[7 + def.pawn];
							attacked_piece += data.p_value_pm[7 + def.pawn];
						}
						break ab_cut;
					}
					bitop.BBAnd(bb, ptree.posi.b_lance, bb_attack);
					if (bitop.BBTest(bb)) {
						from = bitop.FirstOne(bb);
						attacked_piece = data.p_value_ex[15 + def.lance];
						if (to < 27) {
							value += data.p_value_pm[7 + def.lance];
							attacked_piece += data.p_value_pm[7 + def.lance];
						}
						break ab_cut;
					}
					bitop.BBAnd(bb, ptree.posi.b_knight, bb_attack);
					if (bitop.BBTest(bb)) {
						from = bitop.FirstOne(bb);
						attacked_piece = data.p_value_ex[15 + def.knight];
						if (to < 27) {
							value += data.p_value_pm[7 + def.knight];
							attacked_piece += data.p_value_pm[7 + def.knight];
						}
						break ab_cut;
					}
					bitop.BBAnd(bb, ptree.posi.b_pro_pawn, bb_attack);
					if (bitop.BBTest(bb)) {
						from = bitop.FirstOne(bb);
						attacked_piece = data.p_value_ex[15 + def.pro_pawn];
						break ab_cut;
					}
					bitop.BBAnd(bb, ptree.posi.b_pro_lance, bb_attack);
					if (bitop.BBTest(bb)) {
						from = bitop.FirstOne(bb);
						attacked_piece = data.p_value_ex[15 + def.pro_lance];
						break ab_cut;
					}
					bitop.BBAnd(bb, ptree.posi.b_pro_knight, bb_attack);
					if (bitop.BBTest(bb)) {
						from = bitop.FirstOne(bb);
						attacked_piece = data.p_value_ex[15 + def.pro_knight];
						break ab_cut;
					}
					bitop.BBAnd(bb, ptree.posi.b_silver, bb_attack);
					if (bitop.BBTest(bb)) {
						from = bitop.FirstOne(bb);
						attacked_piece = data.p_value_ex[15 + def.silver];
						if (from < 27 || to < 27) {
							value += data.p_value_pm[7 + def.silver];
							attacked_piece += data.p_value_pm[7 + def.silver];
						}
						break ab_cut;
					}
					bitop.BBAnd(bb, ptree.posi.b_pro_silver, bb_attack);
					if (bitop.BBTest(bb)) {
						from = bitop.FirstOne(bb);
						attacked_piece = data.p_value_ex[15 + def.pro_silver];
						break ab_cut;
					}
					bitop.BBAnd(bb, ptree.posi.b_gold, bb_attack);
					if (bitop.BBTest(bb)) {
						from = bitop.FirstOne(bb);
						attacked_piece = data.p_value_ex[15 + def.gold];
						break ab_cut;
					}
					bitop.BBAnd(bb, ptree.posi.b_bishop, bb_attack);
					if (bitop.BBTest(bb)) {
						from = bitop.FirstOne(bb);
						attacked_piece = data.p_value_ex[15 + def.bishop];
						if (from < 27 || to < 27) {
							value += data.p_value_pm[7 + def.bishop];
							attacked_piece += data.p_value_pm[7 + def.bishop];
						}
						break ab_cut;
					}
					bitop.BBAnd(bb, ptree.posi.b_horse, bb_attack);
					if (bitop.BBTest(bb)) {
						from = bitop.FirstOne(bb);
						attacked_piece = data.p_value_ex[15 + def.horse];
						break ab_cut;
					}
					bitop.BBAnd(bb, ptree.posi.b_rook, bb_attack);
					if (bitop.BBTest(bb)) {
						from = bitop.FirstOne(bb);
						attacked_piece = data.p_value_ex[15 + def.rook];
						if (from < 27 || to < 27) {
							value += data.p_value_pm[7 + def.rook];
							attacked_piece += data.p_value_pm[7 + def.rook];
						}
						break ab_cut;
					}
					bitop.BBAnd(bb, ptree.posi.b_dragon, bb_attack);
					if (bitop.BBTest(bb)) {
						from = bitop.FirstOne(bb);
						attacked_piece = data.p_value_ex[15 + def.dragon];
						break ab_cut;
					}

					assert (bitop.BBContract(bb_attack,
							data.abb_mask[ptree.posi.isquare_b_king]) > 0);

					from = ptree.posi.isquare_b_king;
					attacked_piece = def.DKing + def.DKing;

				} else {

					if (!(bitop.BBContract(bb_attack, ptree.posi.w_occupied) > 0)) {
						break;
					}

					value = attacked_piece - value;

					if (bitop.BBContract(bb_attack, ptree.posi.w_pawn) > 0) {
						from = to - def.nfile;
						attacked_piece = data.p_value_ex[15 + def.pawn];
						if (to > 53) {
							value += data.p_value_pm[7 + def.pawn];
							attacked_piece += data.p_value_pm[7 + def.pawn];
						}
						break ab_cut;
					}
					bitop.BBAnd(bb, ptree.posi.w_lance, bb_attack);
					if (bitop.BBTest(bb)) {
						from = bitop.FirstOne(bb);
						attacked_piece = data.p_value_ex[15 + def.lance];
						if (to > 53) {
							value += data.p_value_pm[7 + def.lance];
							attacked_piece += data.p_value_pm[7 + def.lance];
						}
						break ab_cut;
					}
					bitop.BBAnd(bb, ptree.posi.w_knight, bb_attack);
					if (bitop.BBTest(bb)) {
						from = bitop.FirstOne(bb);
						attacked_piece = data.p_value_ex[15 + def.knight];
						if (to > 53) {
							value += data.p_value_pm[7 + def.knight];
							attacked_piece += data.p_value_pm[7 + def.knight];
						}
						break ab_cut;
					}
					bitop.BBAnd(bb, ptree.posi.w_pro_pawn, bb_attack);
					if (bitop.BBTest(bb)) {
						from = bitop.FirstOne(bb);
						attacked_piece = data.p_value_ex[15 + def.pro_pawn];
						break ab_cut;
					}
					bitop.BBAnd(bb, ptree.posi.w_pro_lance, bb_attack);
					if (bitop.BBTest(bb)) {
						from = bitop.FirstOne(bb);
						attacked_piece = data.p_value_ex[15 + def.pro_lance];
						break ab_cut;
					}
					bitop.BBAnd(bb, ptree.posi.w_pro_knight, bb_attack);
					if (bitop.BBTest(bb)) {
						from = bitop.FirstOne(bb);
						attacked_piece = data.p_value_ex[15 + def.pro_knight];
						break ab_cut;
					}
					bitop.BBAnd(bb, ptree.posi.w_silver, bb_attack);
					if (bitop.BBTest(bb)) {
						from = bitop.FirstOne(bb);
						attacked_piece = data.p_value_ex[15 + def.silver];
						if (from > 53 || to > 53) {
							value += data.p_value_pm[7 + def.silver];
							attacked_piece += data.p_value_pm[7 + def.silver];
						}
						break ab_cut;
					}
					bitop.BBAnd(bb, ptree.posi.w_pro_silver, bb_attack);
					if (bitop.BBTest(bb)) {
						from = bitop.FirstOne(bb);
						attacked_piece = data.p_value_ex[15 + def.pro_silver];
						break ab_cut;
					}
					bitop.BBAnd(bb, ptree.posi.w_gold, bb_attack);
					if (bitop.BBTest(bb)) {
						from = bitop.FirstOne(bb);
						attacked_piece = data.p_value_ex[15 + def.gold];
						break ab_cut;
					}
					bitop.BBAnd(bb, ptree.posi.w_bishop, bb_attack);
					if (bitop.BBTest(bb)) {
						from = bitop.FirstOne(bb);
						attacked_piece = data.p_value_ex[15 + def.bishop];
						if (from > 53 || to > 53) {
							value += data.p_value_pm[7 + def.bishop];
							attacked_piece += data.p_value_pm[7 + def.bishop];
						}
						break ab_cut;
					}
					bitop.BBAnd(bb, ptree.posi.w_horse, bb_attack);
					if (bitop.BBTest(bb)) {
						from = bitop.FirstOne(bb);
						attacked_piece = data.p_value_ex[15 + def.horse];
						break ab_cut;
					}
					bitop.BBAnd(bb, ptree.posi.w_rook, bb_attack);
					if (bitop.BBTest(bb)) {
						from = bitop.FirstOne(bb);
						attacked_piece = data.p_value_ex[15 + def.rook];
						if (from > 53 || to > 53) {
							value += data.p_value_pm[7 + def.rook];
							attacked_piece += data.p_value_pm[7 + def.rook];
						}
						break ab_cut;
					}
					bitop.BBAnd(bb, ptree.posi.w_dragon, bb_attack);
					if (bitop.BBTest(bb)) {
						from = bitop.FirstOne(bb);
						attacked_piece = data.p_value_ex[15 + def.dragon];
						break ab_cut;
					}

					assert (bitop.BBContract(bb_attack,
							data.abb_mask[ptree.posi.isquare_w_king]) > 0);
					from = ptree.posi.isquare_w_king;
					attacked_piece = def.DKing + def.DKing;
				}
			}
			turn = bitop.Flip(turn);
			if ((nc & 1) > 0) {
				if (-value > alpha) {
					if (-value >= beta) {
						return beta;
					}
					if (-value >= root_beta) {
						return -value;
					}
					alpha = -value;
				} else {
					xvalue = attacked_piece + data.p_value_pm[7 + def.pawn]
							- value;
					if (xvalue <= alpha) {
						return alpha;
					}
					if (xvalue <= root_alpha) {
						return xvalue;
					}
				}
			} else {
				if (value < beta) {
					if (value <= alpha) {
						return alpha;
					}
					if (value <= root_alpha) {
						return value;
					}
					beta = value;
				} else {
					xvalue = value - attacked_piece
							- data.p_value_pm[7 + def.pawn];
					if (xvalue >= beta) {
						return beta;
					}
					if (xvalue >= root_beta) {
						return xvalue;
					}
				}
			}
		}

		if ((nc & 1) > 0) {
			return beta;
		} else {
			return alpha;
		}
	}
}
