public class quiesrch {
	public static int search_quies(tree_t ptree, int alpha, int beta, int turn,
			int ply, int qui_ply) {
		int value, alpha_old, stand_pat;

		{
			data.node_last_check += 1;
		}
		ptree.node_searched += 1;
		ptree.nquies_called += 1;
		alpha_old = alpha;

		stand_pat = evaluate.evaluate(ptree, ply, turn);

		if (alpha < stand_pat) {
			if (beta <= stand_pat) {

				ptree.current_move[ply] = def.MOVE_PASS;
				return stand_pat;
			}
			alpha = stand_pat;
		}

		if (ply >= def.PLY_MAX - 1) {
			if (alpha_old != alpha) {
				search.pv_close(ptree, ply, def.no_rep);
			}
			ptree.current_move[ply] = def.MOVE_NA;
			return stand_pat;
		}

		if (mate3.is_mate_in3ply(ptree, turn, ply) > 0) {
			value = def.score_mate1ply + 1 - ply;

			if (alpha < value && value < beta) {
				search.pv_close(ptree, ply, def.mate_search);
			}

			assert (valid.is_move_valid(ptree, ptree.current_move[ply], turn) > 0);
			return value;
		}

		ptree.anext_move[ply].next_phase = def.next_quies_gencap;
		while (gen_next_quies(ptree, alpha, turn, ply, qui_ply) > 0) {

			bitop.MakeMove(ptree, turn, ptree.current_move[ply], ply);
			if (bitop.InCheck(turn, ptree)) {
				bitop.UnMakeMove(ptree, turn, ptree.current_move[ply], ply);
				continue;
			}

			value = -search_quies(ptree, -beta, -alpha, bitop.Flip(turn),
					ply + 1, qui_ply + 1);

			bitop.UnMakeMove(ptree, turn, ptree.current_move[ply], ply);

			if (alpha < value) {
				evaldiff.check_futile_score_quies(ptree,
						ptree.current_move[ply], ptree.save_eval[ply],
						-ptree.save_eval[ply + 1], turn);
				if (beta <= value) {

					assert (!bitop.IsMove(ptree.current_move[ply]) || valid
							.is_move_valid(ptree, ptree.current_move[ply], turn) > 0);
					return value;
				}

				alpha = value;
			}
		}

		if (alpha_old != alpha) {
			if (alpha == stand_pat) {
				search.pv_close(ptree, ply, def.no_rep);
			} else {
				search.pv_copy(ptree, ply);
			}
		}

		return alpha;
	}

	private static int gen_next_quies(tree_t ptree, int alpha, int turn,
			int ply, int qui_ply) {
		switch (ptree.anext_move[ply].next_phase) {
		case def.next_quies_gencap: {
			int moveidx;
			int[] psortv;
			int i, j, n, nqmove, value, min_score, diff;
			int move;

			ptree.move_last[ply] = bitop.GenCaptures(turn,
					ptree.move_last[ply - 1], ptree);

			/* set sort values */
			moveidx = ptree.move_last[ply - 1];
			psortv = ptree.sort_value;
			nqmove = 0;
			n = (int) (ptree.move_last[ply] - moveidx);

			for (i = 0; i < n; i++) {
				move = ptree.amove[moveidx + i];

				if (qui_ply >= def.QUIES_PLY_LIMIT
						&& ((bitop.UToCap(move) == def.pawn && !(bitop
								.I2IsPromote(move) > 0)) || (!(bitop
								.UToCap(move) > 0) && bitop.I2PieceMove(move) != def.pawn))) {
					continue;
				}

				diff = evaldiff.estimate_score_diff(ptree, move, turn);
				min_score = evaldiff.eval_max_score(ptree, move,
						ptree.save_eval[ply], turn, diff);

				if (alpha < min_score) {
					value = swap.swap(ptree, move, -1,
							data.p_value_ex[15 + def.silver], turn);
					if (-1 < value) {
						psortv[nqmove] = value + diff;
						ptree.amove[moveidx + nqmove++] = move;
					}
				}
			}

			/* insertion sort */
			psortv[nqmove] = Integer.MIN_VALUE;
			for (i = nqmove - 2; i >= 0; i--) {
				value = psortv[i];
				move = ptree.amove[moveidx + i];
				for (j = i + 1; psortv[j] > value; j++) {
					psortv[j - 1] = psortv[j];
					ptree.amove[moveidx + j - 1] = ptree.amove[moveidx + j];
				}
				psortv[j - 1] = value;
				ptree.amove[moveidx + j - 1] = move;
			}

			ptree.move_last[ply] = ptree.move_last[ply - 1] + nqmove;
			ptree.anext_move[ply].move_last = moveidx;
			ptree.anext_move[ply].next_phase = def.next_quies_captures;
		}

		case def.next_quies_captures:
			if (ptree.anext_move[ply].move_last != ptree.move_last[ply]) {

				ptree.current_move[ply] = ptree.amove[ptree.anext_move[ply].move_last];
				ptree.anext_move[ply].move_last++;
				return 1;
			}
		}

		return 0;
	}

}
