public class makemove {

	// ł
	private static void DropBPAWN(int to, tree_t ptree) {
		bitop.Xor(to, ptree.posi.b_pawn);
		ptree.posi.hash_key ^= data.b_pawn_rand[to];
		ptree.posi.hand_black -= def.flag_hand_pawn;
		ptree.posi.asquare[to] = def.pawn;
	}

	private static void DropBLANCE(int to, tree_t ptree) {
		bitop.Xor(to, ptree.posi.b_lance);
		ptree.posi.hash_key ^= data.b_lance_rand[to];
		ptree.posi.hand_black -= def.flag_hand_lance;
		ptree.posi.asquare[to] = def.lance;
	}

	private static void DropBKNIGHT(int to, tree_t ptree) {
		bitop.Xor(to, ptree.posi.b_knight);
		ptree.posi.hash_key ^= data.b_knight_rand[to];
		ptree.posi.hand_black -= def.flag_hand_knight;
		ptree.posi.asquare[to] = def.knight;
	}

	private static void DropBSILVER(int to, tree_t ptree) {
		bitop.Xor(to, ptree.posi.b_silver);
		ptree.posi.hash_key ^= data.b_silver_rand[to];
		ptree.posi.hand_black -= def.flag_hand_silver;
		ptree.posi.asquare[to] = def.silver;
	}

	private static void DropBGOLD(int to, tree_t ptree) {
		bitop.Xor(to, ptree.posi.b_gold);
		ptree.posi.hash_key ^= data.b_gold_rand[to];
		ptree.posi.hand_black -= def.flag_hand_gold;
		ptree.posi.asquare[to] = def.gold;
	}

	private static void DropBBISHOP(int to, tree_t ptree) {
		bitop.Xor(to, ptree.posi.b_bishop);
		ptree.posi.hash_key ^= data.b_bishop_rand[to];
		ptree.posi.hand_black -= def.flag_hand_bishop;
		ptree.posi.asquare[to] = def.bishop;
	}

	private static void DropBROOK(int to, tree_t ptree) {
		bitop.Xor(to, ptree.posi.b_rook);
		ptree.posi.hash_key ^= data.b_rook_rand[to];
		ptree.posi.hand_black -= def.flag_hand_rook;
		ptree.posi.asquare[to] = def.rook;
	}

	// 
	private static void NocapProBPAWN(int from, int to, tree_t ptree) {
		bitop.Xor(from, ptree.posi.b_pawn);
		bitop.Xor(to, ptree.posi.b_pro_pawn);
		ptree.posi.hash_key ^= data.b_pro_pawn_rand[to]
				^ data.b_pawn_rand[from];
		ptree.posi.material += data.p_value_pm[7 + def.pawn];
		ptree.posi.asquare[to] = def.pro_pawn;
	}

	private static void NocapProBLANCE(int from, int to, tree_t ptree) {
		bitop.Xor(from, ptree.posi.b_lance);
		bitop.Xor(to, ptree.posi.b_pro_lance);
		ptree.posi.hash_key ^= data.b_pro_lance_rand[to]
				^ data.b_lance_rand[from];
		ptree.posi.material += data.p_value_pm[7 + def.lance];
		ptree.posi.asquare[to] = def.pro_lance;
	}

	private static void NocapProBKNIGHT(int from, int to, tree_t ptree) {
		bitop.Xor(from, ptree.posi.b_knight);
		bitop.Xor(to, ptree.posi.b_pro_knight);
		ptree.posi.hash_key ^= data.b_pro_knight_rand[to]
				^ data.b_knight_rand[from];
		ptree.posi.material += data.p_value_pm[7 + def.knight];
		ptree.posi.asquare[to] = def.pro_knight;
	}

	private static void NocapProBSILVER(int from, int to, tree_t ptree) {
		bitop.Xor(from, ptree.posi.b_silver);
		bitop.Xor(to, ptree.posi.b_pro_silver);
		ptree.posi.hash_key ^= data.b_pro_silver_rand[to]
				^ data.b_silver_rand[from];
		ptree.posi.material += data.p_value_pm[7 + def.silver];
		ptree.posi.asquare[to] = def.pro_silver;
	}

	private static void NocapProBBISHOP(int from, int to, tree_t ptree) {
		bitop.Xor(from, ptree.posi.b_bishop);
		bitop.Xor(to, ptree.posi.b_horse);
		ptree.posi.hash_key ^= data.b_horse_rand[to] ^ data.b_bishop_rand[from];
		ptree.posi.material += data.p_value_pm[7 + def.bishop];
		ptree.posi.asquare[to] = def.horse;
	}

	private static void NocapProBROOK(int from, int to, tree_t ptree) {
		bitop.Xor(from, ptree.posi.b_rook);
		bitop.Xor(to, ptree.posi.b_dragon);
		ptree.posi.hash_key ^= data.b_dragon_rand[to] ^ data.b_rook_rand[from];
		ptree.posi.material += data.p_value_pm[7 + def.rook];
		ptree.posi.asquare[to] = def.dragon;
	}

	private static void NocapNoproBPAWN(int from, int to, tree_t ptree,
			bitboard_t bb_set_clear) {
		bitop.SetClear(ptree.posi.b_pawn, bb_set_clear);
		ptree.posi.hash_key ^= (data.b_pawn_rand)[to] ^ data.b_pawn_rand[from];
		ptree.posi.asquare[to] = def.pawn;
	}

	private static void NocapNoproBPRO_PAWN(int from, int to, tree_t ptree,
			bitboard_t bb_set_clear) {
		bitop.SetClear(ptree.posi.b_pro_pawn, bb_set_clear);
		ptree.posi.hash_key ^= (data.b_pro_pawn_rand)[to]
				^ data.b_pro_pawn_rand[from];
		ptree.posi.asquare[to] = def.pro_pawn;
	}

	private static void NocapNoproBLANCE(int from, int to, tree_t ptree,
			bitboard_t bb_set_clear) {
		bitop.SetClear(ptree.posi.b_lance, bb_set_clear);
		ptree.posi.hash_key ^= (data.b_lance_rand)[to]
				^ data.b_lance_rand[from];
		ptree.posi.asquare[to] = def.lance;
	}

	private static void NocapNoproBPRO_LANCE(int from, int to, tree_t ptree,
			bitboard_t bb_set_clear) {
		bitop.SetClear(ptree.posi.b_pro_lance, bb_set_clear);
		ptree.posi.hash_key ^= (data.b_pro_lance_rand)[to]
				^ data.b_pro_lance_rand[from];
		ptree.posi.asquare[to] = def.pro_lance;
	}

	private static void NocapNoproBKNIGHT(int from, int to, tree_t ptree,
			bitboard_t bb_set_clear) {
		bitop.SetClear(ptree.posi.b_knight, bb_set_clear);
		ptree.posi.hash_key ^= (data.b_knight_rand)[to]
				^ data.b_knight_rand[from];
		ptree.posi.asquare[to] = def.knight;
	}

	private static void NocapNoproBPRO_KNIGHT(int from, int to, tree_t ptree,
			bitboard_t bb_set_clear) {
		bitop.SetClear(ptree.posi.b_pro_knight, bb_set_clear);
		ptree.posi.hash_key ^= (data.b_pro_knight_rand)[to]
				^ data.b_pro_knight_rand[from];
		ptree.posi.asquare[to] = def.pro_knight;
	}

	private static void NocapNoproBSILVER(int from, int to, tree_t ptree,
			bitboard_t bb_set_clear) {
		bitop.SetClear(ptree.posi.b_silver, bb_set_clear);
		ptree.posi.hash_key ^= (data.b_silver_rand)[to]
				^ data.b_silver_rand[from];
		ptree.posi.asquare[to] = def.silver;
	}

	private static void NocapNoproBPRO_SILVER(int from, int to, tree_t ptree,
			bitboard_t bb_set_clear) {
		bitop.SetClear(ptree.posi.b_pro_silver, bb_set_clear);
		ptree.posi.hash_key ^= (data.b_pro_silver_rand)[to]
				^ data.b_pro_silver_rand[from];
		ptree.posi.asquare[to] = def.pro_silver;
	}

	private static void NocapNoproBGOLD(int from, int to, tree_t ptree,
			bitboard_t bb_set_clear) {
		bitop.SetClear(ptree.posi.b_gold, bb_set_clear);
		ptree.posi.hash_key ^= (data.b_gold_rand)[to] ^ data.b_gold_rand[from];
		ptree.posi.asquare[to] = def.gold;
	}

	private static void NocapNoproBBISHOP(int from, int to, tree_t ptree,
			bitboard_t bb_set_clear) {
		bitop.SetClear(ptree.posi.b_bishop, bb_set_clear);
		ptree.posi.hash_key ^= (data.b_bishop_rand)[to]
				^ data.b_bishop_rand[from];
		ptree.posi.asquare[to] = def.bishop;
	}

	private static void NocapNoproBHORSE(int from, int to, tree_t ptree,
			bitboard_t bb_set_clear) {
		bitop.SetClear(ptree.posi.b_horse, bb_set_clear);
		ptree.posi.hash_key ^= (data.b_horse_rand)[to]
				^ data.b_horse_rand[from];
		ptree.posi.asquare[to] = def.horse;
	}

	private static void NocapNoproBROOK(int from, int to, tree_t ptree,
			bitboard_t bb_set_clear) {
		bitop.SetClear(ptree.posi.b_rook, bb_set_clear);
		ptree.posi.hash_key ^= (data.b_rook_rand)[to] ^ data.b_rook_rand[from];
		ptree.posi.asquare[to] = def.rook;
	}

	private static void NocapNoproBDRAGON(int from, int to, tree_t ptree,
			bitboard_t bb_set_clear) {
		bitop.SetClear(ptree.posi.b_dragon, bb_set_clear);
		ptree.posi.hash_key ^= (data.b_dragon_rand)[to]
				^ data.b_dragon_rand[from];
		ptree.posi.asquare[to] = def.dragon;
	}

	// 
	private static void CapWPAWN(int to, tree_t ptree) {
		bitop.Xor(to, ptree.posi.w_pawn);
		ptree.posi.hash_key ^= data.w_pawn_rand[to];
		ptree.posi.hand_black += def.flag_hand_pawn;
		ptree.posi.material += data.p_value_ex[15 + def.pawn];
	}

	private static void CapWPRO_PAWN(int to, tree_t ptree) {
		bitop.Xor(to, ptree.posi.w_pro_pawn);
		ptree.posi.hash_key ^= data.w_pro_pawn_rand[to];
		ptree.posi.hand_black += def.flag_hand_pawn;
		ptree.posi.material += data.p_value_ex[15 + def.pro_pawn];
	}

	private static void CapWLANCE(int to, tree_t ptree) {
		bitop.Xor(to, ptree.posi.w_lance);
		ptree.posi.hash_key ^= data.w_lance_rand[to];
		ptree.posi.hand_black += def.flag_hand_lance;
		ptree.posi.material += data.p_value_ex[15 + def.lance];
	}

	private static void CapWPRO_LANCE(int to, tree_t ptree) {
		bitop.Xor(to, ptree.posi.w_pro_lance);
		ptree.posi.hash_key ^= data.w_pro_lance_rand[to];
		ptree.posi.hand_black += def.flag_hand_lance;
		ptree.posi.material += data.p_value_ex[15 + def.pro_lance];
	}

	private static void CapWKNIGHT(int to, tree_t ptree) {
		bitop.Xor(to, ptree.posi.w_knight);
		ptree.posi.hash_key ^= data.w_knight_rand[to];
		ptree.posi.hand_black += def.flag_hand_knight;
		ptree.posi.material += data.p_value_ex[15 + def.knight];
	}

	private static void CapWPRO_KNIGHT(int to, tree_t ptree) {
		bitop.Xor(to, ptree.posi.w_pro_knight);
		ptree.posi.hash_key ^= data.w_pro_knight_rand[to];
		ptree.posi.hand_black += def.flag_hand_knight;
		ptree.posi.material += data.p_value_ex[15 + def.pro_knight];
	}

	private static void CapWSILVER(int to, tree_t ptree) {
		bitop.Xor(to, ptree.posi.w_silver);
		ptree.posi.hash_key ^= data.w_silver_rand[to];
		ptree.posi.hand_black += def.flag_hand_silver;
		ptree.posi.material += data.p_value_ex[15 + def.silver];
	}

	private static void CapWPRO_SILVER(int to, tree_t ptree) {
		bitop.Xor(to, ptree.posi.w_pro_silver);
		ptree.posi.hash_key ^= data.w_pro_silver_rand[to];
		ptree.posi.hand_black += def.flag_hand_silver;
		ptree.posi.material += data.p_value_ex[15 + def.pro_silver];
	}

	private static void CapWGOLD(int to, tree_t ptree) {
		bitop.Xor(to, ptree.posi.w_gold);
		ptree.posi.hash_key ^= data.w_gold_rand[to];
		ptree.posi.hand_black += def.flag_hand_gold;
		ptree.posi.material += data.p_value_ex[15 + def.gold];
	}

	private static void CapWBISHOP(int to, tree_t ptree) {
		bitop.Xor(to, ptree.posi.w_bishop);
		ptree.posi.hash_key ^= data.w_bishop_rand[to];
		ptree.posi.hand_black += def.flag_hand_bishop;
		ptree.posi.material += data.p_value_ex[15 + def.bishop];
	}

	private static void CapWHORSE(int to, tree_t ptree) {
		bitop.Xor(to, ptree.posi.w_horse);
		ptree.posi.hash_key ^= data.w_horse_rand[to];
		ptree.posi.hand_black += def.flag_hand_bishop;
		ptree.posi.material += data.p_value_ex[15 + def.horse];
	}

	private static void CapWROOK(int to, tree_t ptree) {
		bitop.Xor(to, ptree.posi.w_rook);
		ptree.posi.hash_key ^= data.w_rook_rand[to];
		ptree.posi.hand_black += def.flag_hand_rook;
		ptree.posi.material += data.p_value_ex[15 + def.rook];
	}

	private static void CapWDRAGON(int to, tree_t ptree) {
		bitop.Xor(to, ptree.posi.w_dragon);
		ptree.posi.hash_key ^= data.w_dragon_rand[to];
		ptree.posi.hand_black += def.flag_hand_rook;
		ptree.posi.material += data.p_value_ex[15 + def.dragon];
	}

	// ł
	private static void DropWPawn(int to, tree_t ptree) {
		bitop.Xor(to, ptree.posi.b_pawn);
		ptree.posi.hash_key ^= data.w_pawn_rand[to];
		ptree.posi.hand_white -= def.flag_hand_pawn;
		ptree.posi.material = (char) -(def.DPawn + def.DPawn);
	}

	private static void DropWLANCE(int to, tree_t ptree) {
		bitop.Xor(to, ptree.posi.b_lance);
		ptree.posi.hash_key ^= data.w_lance_rand[to];
		ptree.posi.hand_white -= def.flag_hand_lance;
		ptree.posi.material = (char) -(def.DLance + def.DLance);
	}

	private static void DropWKNIGHT(int to, tree_t ptree) {
		bitop.Xor(to, ptree.posi.b_knight);
		ptree.posi.hash_key ^= data.w_knight_rand[to];
		ptree.posi.hand_white -= def.flag_hand_knight;
		ptree.posi.material = (char) -(def.DKnight + def.DKnight);
	}

	private static void DropWSILVER(int to, tree_t ptree) {
		bitop.Xor(to, ptree.posi.b_silver);
		ptree.posi.hash_key ^= data.w_silver_rand[to];
		ptree.posi.hand_white -= def.flag_hand_silver;
		ptree.posi.material = (char) -(def.DSilver + def.DSilver);
	}

	private static void DropWGOLD(int to, tree_t ptree) {
		bitop.Xor(to, ptree.posi.b_gold);
		ptree.posi.hash_key ^= data.w_gold_rand[to];
		ptree.posi.hand_white -= def.flag_hand_gold;
		ptree.posi.material = (char) -(def.DGold + def.DGold);
	}

	private static void DropWBISHOP(int to, tree_t ptree) {
		bitop.Xor(to, ptree.posi.b_bishop);
		ptree.posi.hash_key ^= data.w_bishop_rand[to];
		ptree.posi.hand_white -= def.flag_hand_bishop;
		ptree.posi.material = (char) -(def.DBishop + def.DBishop);
	}

	private static void DropWROOK(int to, tree_t ptree) {
		bitop.Xor(to, ptree.posi.b_rook);
		ptree.posi.hash_key ^= data.w_rook_rand[to];
		ptree.posi.hand_white -= def.flag_hand_rook;
		ptree.posi.material = (char) -(def.DRook + def.DRook);
	}

	// Ȃ
	private static void NocapProWPAWN(int from, int to, tree_t ptree) {
		bitop.Xor(from, ptree.posi.w_pawn);
		bitop.Xor(to, ptree.posi.w_pro_pawn);
		ptree.posi.hash_key ^= data.w_pro_pawn_rand[to]
				^ data.w_pawn_rand[from];
		ptree.posi.material -= data.p_value_pm[7 + def.pawn];
		ptree.posi.asquare[to] = (char) -def.pro_pawn;
	}

	private static void NocapProWLANCE(int from, int to, tree_t ptree) {
		bitop.Xor(from, ptree.posi.w_lance);
		bitop.Xor(to, ptree.posi.w_pro_lance);
		ptree.posi.hash_key ^= data.w_pro_lance_rand[to]
				^ data.w_lance_rand[from];
		ptree.posi.material -= data.p_value_pm[7 + def.lance];
		ptree.posi.asquare[to] = (char) -def.pro_lance;
	}

	private static void NocapProWKNIGHT(int from, int to, tree_t ptree) {
		bitop.Xor(from, ptree.posi.w_knight);
		bitop.Xor(to, ptree.posi.w_pro_knight);
		ptree.posi.hash_key ^= data.w_pro_knight_rand[to]
				^ data.w_knight_rand[from];
		ptree.posi.material -= data.p_value_pm[7 + def.knight];
		ptree.posi.asquare[to] = (char) -def.pro_knight;
	}

	private static void NocapProWSILVER(int from, int to, tree_t ptree) {
		bitop.Xor(from, ptree.posi.w_silver);
		bitop.Xor(to, ptree.posi.w_pro_silver);
		ptree.posi.hash_key ^= data.w_pro_silver_rand[to]
				^ data.w_silver_rand[from];
		ptree.posi.material -= data.p_value_pm[7 + def.silver];
		ptree.posi.asquare[to] = (char) -def.pro_silver;
	}

	private static void NocapProWBISHOP(int from, int to, tree_t ptree) {
		bitop.Xor(from, ptree.posi.w_bishop);
		bitop.Xor(to, ptree.posi.w_horse);
		ptree.posi.hash_key ^= data.w_horse_rand[to] ^ data.w_bishop_rand[from];
		ptree.posi.material -= data.p_value_pm[7 + def.bishop];
		ptree.posi.asquare[to] = (char) -def.horse;
	}

	private static void NocapProWROOK(int from, int to, tree_t ptree) {
		bitop.Xor(from, ptree.posi.w_rook);
		bitop.Xor(to, ptree.posi.w_dragon);
		ptree.posi.hash_key ^= data.w_dragon_rand[to] ^ data.w_rook_rand[from];
		ptree.posi.material -= data.p_value_pm[7 + def.rook];
		ptree.posi.asquare[to] = (char) -def.dragon;
	}

	// ȂȂ
	private static void NocapNoproWPAWN(int from, int to, tree_t ptree,
			bitboard_t bb_set_clear) {
		bitop.SetClear(ptree.posi.w_pawn, bb_set_clear);
		ptree.posi.hash_key ^= data.w_pawn_rand[to] ^ data.w_pawn_rand[from];
		ptree.posi.asquare[to] = (char) -def.pawn;
	}

	private static void NocapNoproWPROPAWN(int from, int to, tree_t ptree,
			bitboard_t bb_set_clear) {
		bitop.SetClear(ptree.posi.w_pro_pawn, bb_set_clear);
		ptree.posi.hash_key ^= data.w_pro_pawn_rand[to]
				^ data.w_pro_pawn_rand[from];
		ptree.posi.asquare[to] = (char) -def.pro_pawn;
	}

	private static void NocapNoproWLANCE(int from, int to, tree_t ptree,
			bitboard_t bb_set_clear) {
		bitop.SetClear(ptree.posi.w_lance, bb_set_clear);
		ptree.posi.hash_key ^= data.w_lance_rand[to] ^ data.w_lance_rand[from];
		ptree.posi.asquare[to] = (char) -def.lance;
	}

	private static void NocapNoproWPROLANCE(int from, int to, tree_t ptree,
			bitboard_t bb_set_clear) {
		bitop.SetClear(ptree.posi.w_pro_lance, bb_set_clear);
		ptree.posi.hash_key ^= data.w_pro_lance_rand[to]
				^ data.w_pro_lance_rand[from];
		ptree.posi.asquare[to] = (char) -def.pro_lance;
	}

	private static void NocapNoproWKNIGHT(int from, int to, tree_t ptree,
			bitboard_t bb_set_clear) {
		bitop.SetClear(ptree.posi.w_knight, bb_set_clear);
		ptree.posi.hash_key ^= data.w_knight_rand[to]
				^ data.w_knight_rand[from];
		ptree.posi.asquare[to] = (char) -def.knight;
	}

	private static void NocapNoproWPROKNIGHT(int from, int to, tree_t ptree,
			bitboard_t bb_set_clear) {
		bitop.SetClear(ptree.posi.w_pro_knight, bb_set_clear);
		ptree.posi.hash_key ^= data.w_pro_knight_rand[to]
				^ data.w_pro_knight_rand[from];
		ptree.posi.asquare[to] = (char) -def.pro_knight;
	}

	private static void NocapNoproWSILVER(int from, int to, tree_t ptree,
			bitboard_t bb_set_clear) {
		bitop.SetClear(ptree.posi.w_silver, bb_set_clear);
		ptree.posi.hash_key ^= data.w_silver_rand[to]
				^ data.w_silver_rand[from];
		ptree.posi.asquare[to] = (char) -def.silver;
	}

	private static void NocapNoproWPROSILVER(int from, int to, tree_t ptree,
			bitboard_t bb_set_clear) {
		bitop.SetClear(ptree.posi.w_pro_silver, bb_set_clear);
		ptree.posi.hash_key ^= data.w_pro_silver_rand[to]
				^ data.w_pro_silver_rand[from];
		ptree.posi.asquare[to] = (char) -def.pro_silver;
	}

	private static void NocapNoproWGOLD(int from, int to, tree_t ptree,
			bitboard_t bb_set_clear) {
		bitop.SetClear(ptree.posi.w_gold, bb_set_clear);
		ptree.posi.hash_key ^= data.w_gold_rand[to] ^ data.w_gold_rand[from];
		ptree.posi.asquare[to] = (char) -def.gold;
	}

	private static void NocapNoproWBISHOP(int from, int to, tree_t ptree,
			bitboard_t bb_set_clear) {
		bitop.SetClear(ptree.posi.w_bishop, bb_set_clear);
		ptree.posi.hash_key ^= data.w_bishop_rand[to]
				^ data.w_bishop_rand[from];
		ptree.posi.asquare[to] = (char) -def.bishop;
	}

	private static void NocapNoproWHORSE(int from, int to, tree_t ptree,
			bitboard_t bb_set_clear) {
		bitop.SetClear(ptree.posi.w_horse, bb_set_clear);
		ptree.posi.hash_key ^= data.w_horse_rand[to] ^ data.w_horse_rand[from];
		ptree.posi.asquare[to] = (char) -def.horse;
	}

	private static void NocapNoproWROOK(int from, int to, tree_t ptree,
			bitboard_t bb_set_clear) {
		bitop.SetClear(ptree.posi.w_rook, bb_set_clear);
		ptree.posi.hash_key ^= data.w_rook_rand[to] ^ data.w_rook_rand[from];
		ptree.posi.asquare[to] = (char) -def.rook;
	}

	private static void NocapNoproWDRAGON(int from, int to, tree_t ptree,
			bitboard_t bb_set_clear) {
		bitop.SetClear(ptree.posi.w_dragon, bb_set_clear);
		ptree.posi.hash_key ^= data.w_dragon_rand[to]
				^ data.w_dragon_rand[from];
		ptree.posi.asquare[to] = (char) -def.dragon;
	}

	// B遁邩R}iptree.posi.material)B
	private static void CapBPAWN(int to, tree_t ptree) {
		bitop.Xor(to, ptree.posi.b_pawn); // 
		ptree.posi.hash_key ^= data.b_pawn_rand[to];// 
		ptree.posi.hand_white += def.flag_hand_pawn;
		ptree.posi.material -= data.p_value_ex[15 + def.pawn];
	}

	private static void CapBPRO_PAWN(int to, tree_t ptree) {
		bitop.Xor(to, ptree.posi.b_pro_pawn); // 
		ptree.posi.hash_key ^= data.b_pro_pawn_rand[to];// 
		ptree.posi.hand_white += def.flag_hand_pawn;
		ptree.posi.material -= data.p_value_ex[15 + def.pro_pawn];
	}

	private static void CapBLANCE(int to, tree_t ptree) {
		bitop.Xor(to, ptree.posi.b_lance); // 
		ptree.posi.hash_key ^= data.b_lance_rand[to];// 
		ptree.posi.hand_white += def.flag_hand_lance;
		ptree.posi.material -= data.p_value_ex[15 + def.lance];
	}

	private static void CapBPRO_LANCE(int to, tree_t ptree) {
		bitop.Xor(to, ptree.posi.b_pro_lance); // 
		ptree.posi.hash_key ^= data.b_pro_lance_rand[to];// 
		ptree.posi.hand_white += def.flag_hand_lance;
		ptree.posi.material -= data.p_value_ex[15 + def.pro_lance];
	}

	private static void CapBKNIGHT(int to, tree_t ptree) {
		bitop.Xor(to, ptree.posi.b_knight); // 
		ptree.posi.hash_key ^= data.b_knight_rand[to];// 
		ptree.posi.hand_white += def.flag_hand_knight;
		ptree.posi.material -= data.p_value_ex[15 + def.knight];
	}

	private static void CapBPRO_KNIGHT(int to, tree_t ptree) {
		bitop.Xor(to, ptree.posi.b_pro_knight); // 
		ptree.posi.hash_key ^= data.b_pro_knight_rand[to];// 
		ptree.posi.hand_white += def.flag_hand_knight;
		ptree.posi.material -= data.p_value_ex[15 + def.pro_knight];
	}

	private static void CapBSILVER(int to, tree_t ptree) {
		bitop.Xor(to, ptree.posi.b_silver); // 
		ptree.posi.hash_key ^= data.b_silver_rand[to];// 
		ptree.posi.hand_white += def.flag_hand_silver;
		ptree.posi.material -= data.p_value_ex[15 + def.silver];
	}

	private static void CapBPRO_SILVER(int to, tree_t ptree) {
		bitop.Xor(to, ptree.posi.b_pro_silver); // 
		ptree.posi.hash_key ^= data.b_pro_silver_rand[to];// 
		ptree.posi.hand_white += def.flag_hand_silver;
		ptree.posi.material -= data.p_value_ex[15 + def.pro_silver];
	}

	private static void CapBGOLD(int to, tree_t ptree) {
		bitop.Xor(to, ptree.posi.b_gold); // 
		ptree.posi.hash_key ^= data.b_gold_rand[to];// 
		ptree.posi.hand_white += def.flag_hand_gold;
		ptree.posi.material -= data.p_value_ex[15 + def.gold];
	}

	private static void CapBBISHOP(int to, tree_t ptree) {
		bitop.Xor(to, ptree.posi.b_bishop); // 
		ptree.posi.hash_key ^= data.b_bishop_rand[to];// 
		ptree.posi.hand_white += def.flag_hand_bishop;
		ptree.posi.material -= data.p_value_ex[15 + def.bishop];
	}

	private static void CapBHORSE(int to, tree_t ptree) {
		bitop.Xor(to, ptree.posi.b_horse); // 
		ptree.posi.hash_key ^= data.b_horse_rand[to];// 
		ptree.posi.hand_white += def.flag_hand_bishop;
		ptree.posi.material -= data.p_value_ex[15 + def.horse];
	}

	private static void CapBROOK(int to, tree_t ptree) {
		bitop.Xor(to, ptree.posi.b_rook); // 
		ptree.posi.hash_key ^= data.b_rook_rand[to];// 
		ptree.posi.hand_white += def.flag_hand_rook;
		ptree.posi.material -= data.p_value_ex[15 + def.rook];
	}

	private static void CapBDRAGON(int to, tree_t ptree) {
		bitop.Xor(to, ptree.posi.b_dragon); // 
		ptree.posi.hash_key ^= data.b_dragon_rand[to];// 
		ptree.posi.hand_white += def.flag_hand_rook;
		ptree.posi.material -= data.p_value_ex[15 + def.dragon];
	}

	public static void make_move_b(tree_t ptree, int move, int ply) {
		final int from = (int) bitop.I2From(move);
		final int to = (int) bitop.I2To(move);
		final int nrep = ptree.nrep + ply - 1;

		assert (bitop.UToCap(move) != def.king);
		assert (move > 0);
		assert (valid.is_move_valid(ptree, move, def.black) > 0);

		ptree.rep_board_list[nrep] = ptree.posi.hash_key;
		ptree.rep_hand_list[nrep] = ptree.posi.hand_black;
		ptree.save_material[ply] = (short) ptree.posi.material;
		ptree.save_eval[ply + 1] = Integer.MAX_VALUE;

		if (from >= def.nsquare) {
			switch (bitop.From2Drop(from)) {
			case def.pawn:
				bitop.Xor(to - def.nfile, ptree.posi.b_pawn_attacks);
				DropBPAWN(to, ptree);
				break;
			case def.lance:
				DropBLANCE(to, ptree);
				break;
			case def.knight:
				DropBKNIGHT(to, ptree);
				break;
			case def.silver:
				DropBSILVER(to, ptree);
				break;
			case def.gold:
				DropBGOLD(to, ptree);
				bitop.Xor(to, ptree.posi.b_tgold);
				break;
			case def.bishop:
				DropBBISHOP(to, ptree);
				bitop.Xor(to, ptree.posi.b_bh);
				break;
			default:
				assert (bitop.From2Drop(from) == def.rook);
				DropBROOK(to, ptree);
				bitop.Xor(to, ptree.posi.b_rd);
				break;
			}
			bitop.Xor(to, ptree.posi.b_occupied);
			bitop.XorFile(to, ptree.posi.occupied_rl90);
			bitop.XorDiag2(to, ptree.posi.occupied_rl45);
			bitop.XorDiag1(to, ptree.posi.occupied_rr45);
		} else {
			final int ipiece_move = (int) bitop.I2PieceMove(move);
			final int ipiece_cap = (int) bitop.UToCap(move);
			final int is_promote = (int) bitop.I2IsPromote(move);
			bitboard_t bb_set_clear = new bitboard_t();

			bitop.BBOr(bb_set_clear, data.abb_mask[from], data.abb_mask[to]);
			bitop.SetClear(ptree.posi.b_occupied, bb_set_clear);
			ptree.posi.asquare[from] = def.empty;

			if (is_promote > 0)
				switch (ipiece_move) {
				case def.pawn:
					bitop.Xor(to, ptree.posi.b_pawn_attacks);
					bitop.Xor(to, ptree.posi.b_tgold);
					NocapProBPAWN(from, to, ptree);
					break;
				case def.lance:
					bitop.Xor(to, ptree.posi.b_tgold);
					NocapProBLANCE(from, to, ptree);
					break;
				case def.knight:
					bitop.Xor(to, ptree.posi.b_tgold);
					NocapProBKNIGHT(from, to, ptree);
					break;
				case def.silver:
					bitop.Xor(to, ptree.posi.b_tgold);
					NocapProBSILVER(from, to, ptree);
					break;
				case def.bishop:
					bitop.Xor(to, ptree.posi.b_hdk);
					bitop.SetClear(ptree.posi.b_bh, bb_set_clear);
					NocapProBBISHOP(from, to, ptree);
					break;
				default:
					assert (ipiece_move == def.rook);
					bitop.Xor(to, ptree.posi.b_hdk);
					bitop.SetClear(ptree.posi.b_rd, bb_set_clear);
					NocapProBROOK(from, to, ptree);
					break;
				}
			else
				switch (ipiece_move) {
				case def.pawn:
					bitop.Xor(to - def.nfile, ptree.posi.b_pawn_attacks);
					bitop.Xor(to, ptree.posi.b_pawn_attacks);
					NocapNoproBPAWN(from, to, ptree, bb_set_clear);
					break;
				case def.lance:
					NocapNoproBLANCE(from, to, ptree, bb_set_clear);
					break;
				case def.knight:
					NocapNoproBKNIGHT(from, to, ptree, bb_set_clear);
					break;
				case def.silver:
					NocapNoproBSILVER(from, to, ptree, bb_set_clear);
					break;
				case def.gold:
					NocapNoproBGOLD(from, to, ptree, bb_set_clear);
					bitop.SetClear(ptree.posi.b_tgold, bb_set_clear);
					break;
				case def.bishop:
					bitop.SetClear(ptree.posi.b_bh, bb_set_clear);
					NocapNoproBBISHOP(from, to, ptree, bb_set_clear);
					break;
				case def.rook:
					NocapNoproBROOK(from, to, ptree, bb_set_clear);
					bitop.SetClear(ptree.posi.b_rd, bb_set_clear);
					break;
				case def.king:
					ptree.posi.hash_key ^= data.b_king_rand[to]
							^ data.b_king_rand[from];
					bitop.SetClear(ptree.posi.b_hdk, bb_set_clear);
					ptree.posi.asquare[to] = def.king;
					ptree.posi.isquare_b_king = (char) to;
					break;
				case def.pro_pawn:
					NocapNoproBPRO_PAWN(from, to, ptree, bb_set_clear);
					bitop.SetClear(ptree.posi.b_tgold, bb_set_clear);
					break;
				case def.pro_lance:
					NocapNoproBPRO_LANCE(from, to, ptree, bb_set_clear);
					bitop.SetClear(ptree.posi.b_tgold, bb_set_clear);
					break;
				case def.pro_knight:
					NocapNoproBPRO_KNIGHT(from, to, ptree, bb_set_clear);
					bitop.SetClear(ptree.posi.b_tgold, bb_set_clear);
					break;
				case def.pro_silver:
					NocapNoproBPRO_SILVER(from, to, ptree, bb_set_clear);
					bitop.SetClear(ptree.posi.b_tgold, bb_set_clear);
					break;
				case def.horse:
					NocapNoproBHORSE(from, to, ptree, bb_set_clear);
					bitop.SetClear(ptree.posi.b_hdk, bb_set_clear);
					bitop.SetClear(ptree.posi.b_bh, bb_set_clear);
					break;
				default:
					assert (ipiece_move == def.dragon);
					NocapNoproBDRAGON(from, to, ptree, bb_set_clear);
					bitop.SetClear(ptree.posi.b_hdk, bb_set_clear);
					bitop.SetClear(ptree.posi.b_rd, bb_set_clear);
					break;
				}

			if (ipiece_cap > 0) {
				switch (ipiece_cap) {
				case def.pawn:
					CapWPAWN(to, ptree);
					bitop.Xor(to + def.nfile, ptree.posi.w_pawn_attacks);
					break;
				case def.lance:
					CapWLANCE(to, ptree);
					break;
				case def.knight:
					CapWKNIGHT(to, ptree);
					break;
				case def.silver:
					CapWSILVER(to, ptree);
					break;
				case def.gold:
					CapWGOLD(to, ptree);
					bitop.Xor(to, ptree.posi.w_tgold);
					break;
				case def.bishop:
					CapWBISHOP(to, ptree);
					bitop.Xor(to, ptree.posi.w_bh);
					break;
				case def.rook:
					CapWROOK(to, ptree);
					bitop.Xor(to, ptree.posi.w_rd);
					break;
				case def.pro_pawn:
					CapWPRO_PAWN(to, ptree);
					bitop.Xor(to, ptree.posi.w_tgold);
					break;
				case def.pro_lance:
					CapWPRO_LANCE(to, ptree);
					bitop.Xor(to, ptree.posi.w_tgold);
					break;
				case def.pro_knight:
					CapWPRO_KNIGHT(to, ptree);
					bitop.Xor(to, ptree.posi.w_tgold);
					break;
				case def.pro_silver:
					CapWPRO_SILVER(to, ptree);
					bitop.Xor(to, ptree.posi.w_tgold);
					break;
				case def.horse:
					CapWHORSE(to, ptree);
					bitop.Xor(to, ptree.posi.w_hdk);
					bitop.Xor(to, ptree.posi.w_bh);
					break;
				default:
					assert (ipiece_cap == def.dragon);
					CapWDRAGON(to, ptree);
					bitop.Xor(to, ptree.posi.w_hdk);
					bitop.Xor(to, ptree.posi.w_rd);
					break;
				}
				bitop.Xor(to, ptree.posi.w_occupied);
				bitop.XorFile(from, ptree.posi.occupied_rl90);
				bitop.XorDiag2(from, ptree.posi.occupied_rl45);
				bitop.XorDiag1(from, ptree.posi.occupied_rr45);
			} else {
				bitop.SetClearFile(from, to, ptree.posi.occupied_rl90);
				bitop.SetClearDiag1(from, to, ptree.posi.occupied_rr45);
				bitop.SetClearDiag2(from, to, ptree.posi.occupied_rl45);
			}
		}

		// assert( exam_bb( ptree ) ); // TODO: Ŏ
	}

	public static void make_move_w(tree_t ptree, int move, int ply) {
		final int from = (int) bitop.I2From(move);
		final int to = (int) bitop.I2To(move);
		final int nrep = ptree.nrep + ply - 1;

		assert (bitop.UToCap(move) != def.king);
		assert (move > 0);
		assert (valid.is_move_valid(ptree, move, def.white) > 0);

		ptree.rep_board_list[nrep] = ptree.posi.hash_key;
		ptree.rep_hand_list[nrep] = ptree.posi.hand_black;
		ptree.save_material[ply] = (short) ptree.posi.material;
		ptree.save_eval[ply + 1] = Integer.MAX_VALUE;

		if (from >= def.nsquare) {
			switch (bitop.From2Drop(from)) {
			case def.pawn:
				bitop.Xor(to + def.nfile, ptree.posi.w_pawn_attacks);
				DropWPawn(to, ptree);
				break;
			case def.lance:
				DropWLANCE(to, ptree);
				break;
			case def.knight:
				DropWKNIGHT(to, ptree);
				break;
			case def.silver:
				DropWSILVER(to, ptree);
				break;
			case def.gold:
				DropWGOLD(to, ptree);
				bitop.Xor(to, ptree.posi.w_tgold);
				break;
			case def.bishop:
				DropWBISHOP(to, ptree);
				bitop.Xor(to, ptree.posi.w_bh);
				break;
			default:
				DropWROOK(to, ptree);
				bitop.Xor(to, ptree.posi.w_rd);
				break;
			}
			bitop.Xor(to, ptree.posi.w_occupied);
			bitop.XorFile(to, ptree.posi.occupied_rl90);
			bitop.XorDiag2(to, ptree.posi.occupied_rl45);
			bitop.XorDiag1(to, ptree.posi.occupied_rr45);
		} else {
			final int ipiece_move = (int) bitop.I2PieceMove(move);
			final int ipiece_cap = (int) bitop.UToCap(move);
			final int is_promote = (int) bitop.I2IsPromote(move);
			bitboard_t bb_set_clear = new bitboard_t();

			bitop.BBOr(bb_set_clear, data.abb_mask[from], data.abb_mask[to]);
			bitop.SetClear(ptree.posi.w_occupied, bb_set_clear);
			ptree.posi.asquare[from] = def.empty;

			if (is_promote > 0)
				switch (ipiece_move) {
				case def.pawn:
					NocapProWPAWN(from, to, ptree);
					bitop.Xor(to, ptree.posi.w_pawn_attacks);
					bitop.Xor(to, ptree.posi.w_tgold);
					break;
				case def.lance:
					NocapProWLANCE(from, to, ptree);
					bitop.Xor(to, ptree.posi.w_tgold);
					break;
				case def.knight:
					NocapProWKNIGHT(from, to, ptree);
					bitop.Xor(to, ptree.posi.w_tgold);
					break;
				case def.silver:
					NocapProWSILVER(from, to, ptree);
					bitop.Xor(to, ptree.posi.w_tgold);
					break;
				case def.bishop:
					NocapProWBISHOP(from, to, ptree);
					bitop.Xor(to, ptree.posi.w_hdk);
					bitop.SetClear(ptree.posi.w_bh, bb_set_clear);
					break;
				default:
					NocapProWROOK(from, to, ptree);
					bitop.Xor(to, ptree.posi.w_hdk);
					bitop.SetClear(ptree.posi.w_rd, bb_set_clear);
					break;
				}
			else
				switch (ipiece_move) {
				case def.pawn:
					NocapNoproWPAWN(from, to, ptree, bb_set_clear);
					bitop.Xor(to + def.nfile, ptree.posi.w_pawn_attacks);
					bitop.Xor(to, ptree.posi.w_pawn_attacks);
					break;
				case def.lance:
					NocapNoproWLANCE(from, to, ptree, bb_set_clear);
					break;
				case def.knight:
					NocapNoproWKNIGHT(from, to, ptree, bb_set_clear);
					break;
				case def.silver:
					NocapNoproWSILVER(from, to, ptree, bb_set_clear);
					break;
				case def.gold:
					NocapNoproWGOLD(from, to, ptree, bb_set_clear);
					bitop.SetClear(ptree.posi.w_tgold, bb_set_clear);
					break;
				case def.bishop:
					NocapNoproWBISHOP(from, to, ptree, bb_set_clear);
					bitop.SetClear(ptree.posi.w_bh, bb_set_clear);
					break;
				case def.rook:
					NocapNoproWROOK(from, to, ptree, bb_set_clear);
					bitop.SetClear(ptree.posi.w_rd, bb_set_clear);
					break;
				case def.king:
					ptree.posi.hash_key ^= data.w_king_rand[to]
							^ data.w_king_rand[from];
					ptree.posi.asquare[to] -= def.king;
					ptree.posi.isquare_w_king = (char) to;
					bitop.SetClear(ptree.posi.w_hdk, bb_set_clear);
					break;
				case def.pro_pawn:
					NocapNoproWPROPAWN(from, to, ptree, bb_set_clear);
					bitop.SetClear(ptree.posi.w_tgold, bb_set_clear);
					break;
				case def.pro_lance:
					NocapNoproWPROLANCE(from, to, ptree, bb_set_clear);
					bitop.SetClear(ptree.posi.w_tgold, bb_set_clear);
					break;
				case def.pro_knight:
					NocapNoproWPROKNIGHT(from, to, ptree, bb_set_clear);
					bitop.SetClear(ptree.posi.w_tgold, bb_set_clear);
					break;
				case def.pro_silver:
					NocapNoproWPROSILVER(from, to, ptree, bb_set_clear);
					bitop.SetClear(ptree.posi.w_tgold, bb_set_clear);
					break;
				case def.horse:
					NocapNoproWHORSE(from, to, ptree, bb_set_clear);
					bitop.SetClear(ptree.posi.w_hdk, bb_set_clear);
					bitop.SetClear(ptree.posi.w_bh, bb_set_clear);
					break;
				default:
					NocapNoproWDRAGON(from, to, ptree, bb_set_clear);
					bitop.SetClear(ptree.posi.w_hdk, bb_set_clear);
					bitop.SetClear(ptree.posi.w_rd, bb_set_clear);
					break;
				}

			if (ipiece_cap > 0) {
				switch (ipiece_cap) {
				case def.pawn:
					CapBPAWN(to, ptree);
					bitop.Xor(to - def.nfile, ptree.posi.b_pawn_attacks);
					break;
				case def.lance:
					CapBLANCE(to, ptree);
					break;
				case def.knight:
					CapBKNIGHT(to, ptree);
					break;
				case def.silver:
					CapBSILVER(to, ptree);
					break;
				case def.gold:
					CapBGOLD(to, ptree);
					bitop.Xor(to, ptree.posi.b_tgold);
					break;
				case def.bishop:
					CapBBISHOP(to, ptree);
					bitop.Xor(to, ptree.posi.b_bh);
					break;
				case def.rook:
					CapBROOK(to, ptree);
					bitop.Xor(to, ptree.posi.b_rd);
					break;
				case def.pro_pawn:
					CapBPRO_PAWN(to, ptree);
					bitop.Xor(to, ptree.posi.b_tgold);
					break;
				case def.pro_lance:
					CapBPRO_LANCE(to, ptree);
					bitop.Xor(to, ptree.posi.b_tgold);
					break;
				case def.pro_knight:
					CapBPRO_KNIGHT(to, ptree);
					bitop.Xor(to, ptree.posi.b_tgold);
					break;
				case def.pro_silver:
					CapBPRO_SILVER(to, ptree);
					bitop.Xor(to, ptree.posi.b_tgold);
					break;
				case def.horse:
					CapBHORSE(to, ptree);
					bitop.Xor(to, ptree.posi.b_hdk);
					bitop.Xor(to, ptree.posi.b_bh);
					break;
				default:
					CapBDRAGON(to, ptree);
					bitop.Xor(to, ptree.posi.b_hdk);
					bitop.Xor(to, ptree.posi.b_rd);
					break;
				}
				bitop.Xor(to, ptree.posi.b_occupied);
				bitop.XorFile(from, ptree.posi.occupied_rl90);
				bitop.XorDiag1(from, ptree.posi.occupied_rr45);
				bitop.XorDiag2(from, ptree.posi.occupied_rl45);
			} else {
				bitop.SetClearFile(from, to, ptree.posi.occupied_rl90);
				bitop.SetClearDiag1(from, to, ptree.posi.occupied_rr45);
				bitop.SetClearDiag2(from, to, ptree.posi.occupied_rl45);
			}
		}

		// assert( bitop.exam_bb( ptree ) ); // TODO:ƂŎ
	}

	public static int make_move_root(tree_t ptree, int move, int flag) {
		int check, drawn, iret, i, n;

		bitop.MakeMove(ptree, data.root_turn, move, 1);

		/* detect hang-king */
		if ((flag & def.flag_detect_hang) > 0
				&& bitop.InCheck(data.root_turn, ptree)) {
			// "The king is hang.";
			// str_error = def.str_king_hang;
			// UnMakeMove( root_turn, move, 1 );
			return -2;
		}

		drawn = 0;
		check = bitop.InCheck(bitop.Flip(data.root_turn), ptree) ? 1 : 0;
		ptree.move_last[1] = ptree.move_last[0];
		if (check > 0) {
			ptree.nsuc_check[2] = (char) (ptree.nsuc_check[0] + 1);
		} else {
			ptree.nsuc_check[2] = 0;
		}

		/* detect repetitions */
		if ((flag & def.flag_rep) > 0) {
			switch (utility.detect_repetition(ptree, 2,
					bitop.Flip(data.root_turn), 3)) {
			case def.perpetual_check:
				// fukuda str_error = str_perpet_check;
				bitop.UnMakeMove(ptree, data.root_turn, move, 1);
				return -2;

			case def.four_fold_rep:
				drawn = 1;
				break;
			}
		}

		/* return, since all of rule-checks were done */
		if ((flag & def.flag_nomake_move) > 0) {
			bitop.UnMakeMove(ptree, data.root_turn, move, 1);
			return drawn > 0 ? 2 : 1;
		}

		if (drawn > 0) {
			data.game_status |= def.flag_drawn;
		}

		/* update time */
		if ((flag & def.flag_time) > 0) {
			iret = time.update_time(data.root_turn);
			if (iret < 0) {
				return -1;
			}
		}

		data.root_turn = bitop.Flip(data.root_turn);

		/* detect checkmate */
		if (check > 0 && utility.is_mate(ptree, 1) > 0) {
			data.game_status |= def.flag_mated;
		}

		/* save history */
		// fukuda if ( flag & flag_history ) { out_CSA( ptree, &record_game,
		// move ); }

		/* renew repetition table */
		n = ptree.nrep;
		if (n >= def.REP_HIST_LEN - def.PLY_MAX - 1) {
			for (i = 0; i < n; i++) {
				ptree.rep_board_list[i] = ptree.rep_board_list[i + 1];
				ptree.rep_hand_list[i] = ptree.rep_hand_list[i + 1];
			}
		} else {
			ptree.nrep++;
		}

		for (i = 1; i < def.NUM_UNMAKE; i += 1) {
			data.amove_save[i - 1] = data.amove_save[i];
			data.amaterial_save[i - 1] = data.amaterial_save[i];
			data.ansuc_check_save[i - 1] = data.ansuc_check_save[i];
			data.alast_root_value_save[i - 1] = data.alast_root_value_save[i];
			data.alast_pv_save[i - 1] = data.alast_pv_save[i];
		}
		data.amove_save[def.NUM_UNMAKE - 1] = move;
		data.amaterial_save[def.NUM_UNMAKE - 1] = ptree.save_material[1];
		data.ansuc_check_save[def.NUM_UNMAKE - 1] = ptree.nsuc_check[0];
		ptree.nsuc_check[0] = ptree.nsuc_check[1];
		ptree.nsuc_check[1] = ptree.nsuc_check[2];

		/* update pv */
		data.alast_root_value_save[def.NUM_UNMAKE - 1] = data.last_root_value;
		data.alast_pv_save[def.NUM_UNMAKE - 1] = data.last_pv;

		if (data.last_pv.a[1] == move && data.last_pv.length >= 2) {
			if (data.last_pv.depth > 0) {

				data.last_pv.depth--;
			}
			data.last_pv.length--;
			for (int f = 0; f < data.last_pv.length; f++) {
				data.last_pv.a[1 + f] = data.last_pv.a[2 + f];
			}
		} else {
			data.last_pv.a[0] = 0;
			data.last_pv.a[1] = 0;
			data.last_pv.depth = 0;
			data.last_pv.length = 0;
			data.last_root_value = 0;
		}

		return 1;
	}

}
