import java.util.*;

public class hash {

	trans_table_t[] ptrans_table;
	trans_table_t ptrans_table_orig;

	int ini_trans_table() {

		int ntrans_table;

		ntrans_table = 1 << data.log2_ntrans_table;

		data.hash_mask = ntrans_table - 1;

		return clear_trans_table();
	}

	private int clear_trans_table() {

		int ntrans_table;

		data.trans_table_age = 1;
		ntrans_table = 1 << data.log2_ntrans_table;
		ptrans_table_orig = new trans_table_t();

		ptrans_table = new trans_table_t[ntrans_table];
		for (int i = 0; i < ntrans_table; i++) {
			ptrans_table[i] = new trans_table_t();
			ptrans_table[i].prefer.word1 = 0;
			ptrans_table[i].prefer.word2 = 0;
			ptrans_table[i].always[0].word1 = 0;
			ptrans_table[i].always[0].word2 = 0;
			ptrans_table[i].always[1].word1 = 0;
			ptrans_table[i].always[1].word2 = 0;
		}

		return 1;
	}
	
	public static void hash_store(  tree_t ptree, int ply, int depth, int turn,
		    int value_type, int value, int move,
		    int state_node )
	{
	  long word1, word2, hash_word1, hash_word2;
	  int index, slot;
	  int depth_hash, age_hash;

	  if ( (data.game_status & def.flag_learning) > 0 ) { return; }

	  assert( depth <= 0xff );

	  if ( depth < 0 ) { depth = 0; }
	  if ( Math.abs(value) > def.score_max_eval )
	    {
	      if ( Math.abs(value) > def.score_mate1ply ) { return; }
	      if ( value > 0 ) { value += ply-1; }
	      else             { value -= ply-1; }


	    }
	  word2 = ( ( ptree.posi.hash_key & ~(long)0x7f )
		    | (long)( (turn<<6) | ( state_node & def.node_mate_threat )
				  | (value_type<<3) | data.trans_table_age ) );
	  word1 = ( ( (long)( depth<<16 | (value+32768) ) << 40 )
		    | ( (long)( move & 0x7ffff ) << 21 )
		    | ptree.posi.hand_black );

	  index = (int)ptree.posi.hash_key & data.hash_mask;
	  hash_word1 = data.ptrans_table_orig[data.ptrans_table + index].prefer.word1;
	  hash_word2 = data.ptrans_table_orig[data.ptrans_table + index].prefer.word2;
	  // SignKey( hash_word2, hash_word1 ); // TLPȂƂ͉Ȃ
	  age_hash   = (int)((int)(hash_word2    ) & 0x07);
	  depth_hash = (int)((int)(hash_word1>>56) & 0xff);

	  //SignKey( word2, word1 );

	  if ( age_hash != data.trans_table_age || depth_hash <= depth )
	    {
		  data.ptrans_table_orig[data.ptrans_table + index].prefer.word1 = word1;
		  data.ptrans_table_orig[data.ptrans_table + index].prefer.word2 = word2;
	    }
	  else {
	    slot = (int)ptree.posi.hash_key >> 31;
	  data.ptrans_table_orig[data.ptrans_table + index].always[slot].word1 = word1;
	  data.ptrans_table_orig[data.ptrans_table + index].always[slot].word2 = word2;
	  }
	}


	public static void hash_store_pv( tree_t ptree, int move, int turn )
	{
	  long key_turn_pv, word1, word2;
	  int index;

	  key_turn_pv = ( ptree.posi.hash_key & ~(long)0x7f ) | (int)( turn << 6 );
	  index       = (int)ptree.posi.hash_key & data.hash_mask;

	  word1 = data.ptrans_table_orig[data.ptrans_table + index].prefer.word1;
	  word2 = data.ptrans_table_orig[data.ptrans_table + index].prefer.word2;
	  //SignKey( word2, word1 );

	  if ( ( (int)word1 & 0x1fffff ) == ptree.posi.hand_black
	       && ( word2 & ~(long)0x3f ) == key_turn_pv )
	    {
	      if ( ( (int)(word1>>21) & 0x7ffff ) != ( move & 0x7ffff ) )
		{
		  word1 &= ~((long)0x7ffff << 21);
		  word1 |= (long)( move & 0x7ffff ) << 21;
		  word2 &= ~((long)0x3 << 3);
		  //SignKey( word2, word1 );
		  data.ptrans_table_orig[data.ptrans_table + index].prefer.word1 = word1;
		  data.ptrans_table_orig[data.ptrans_table + index].prefer.word2 = word2;
		}
	    }
	  else {
	    int slot;

	    slot = (int)ptree.posi.hash_key >> 31;
	    word1 = data.ptrans_table_orig[data.ptrans_table + index].always[slot].word1;
	    word2 = data.ptrans_table_orig[data.ptrans_table + index].always[slot].word2;
	    //SignKey( word2, word1 );
	    if ( ( (int)word1 & 0x1fffff ) == ptree.posi.hand_black
		 && ( word2 & ~(long)0x3f ) == key_turn_pv )
	      {
		if ( ( (int)(word1>>21) & 0x7ffff )
		     != ( move & 0x7ffff ) )
		  {
		    word1 &= ~((long)0x7ffff << 21);
		    word1 |= (long)( move & 0x7ffff ) << 21;
		    word2 &= ~((long)0x3 << 3);
		    //SignKey( word2, word1 );
		    data.ptrans_table_orig[data.ptrans_table + index].always[slot].word1 = word1;
		    data.ptrans_table_orig[data.ptrans_table + index].always[slot].word2 = word2;
		  }
	      }
	    else {
	      word1  = (long)32768 << 40;
	      word1 |= (long)( move & 0x7ffff ) << 21;
	      word1 |= ptree.posi.hand_black;
	      word2  = key_turn_pv | data.trans_table_age;
	      //SignKey( word2, word1 );
	      data.ptrans_table_orig[data.ptrans_table + index].prefer.word1 = word1;
	      data.ptrans_table_orig[data.ptrans_table + index].prefer.word2 = word2;
	    }
	  }
	}


	public static int[] hash_probe( tree_t ptree, int ply, int depth_current,
		    int turn_current, int alpha, int beta, int pstate_node ){
	  long word1, word2, key_current, key_hash;
	  int hand_hash, move_hash, move_supe, slot, utemp;
	  int state_node_hash, index;
	  int null_depth, value_hash, ifrom;
	  int turn_hash, depth_hash, type_hash, is_superior;

	  ptree.ntrans_probe++;
	  move_supe   = 0;
	  
	  int[] ret = new int[2];

	  if ( depth_current < 0 ) { depth_current = 0; }
	  null_depth  = bitop.NullDepth( depth_current );
	  if ( null_depth < def.PLY_INC ) { null_depth = 0; }

	  key_current = ptree.posi.hash_key & ~(long)0x7f;

	  index = (int)ptree.posi.hash_key & data.hash_mask;
	  word1 = data.ptrans_table_orig[data.ptrans_table + index].prefer.word1;
	  word2 = data.ptrans_table_orig[data.ptrans_table + index].prefer.word2;
	  //SignKey( word2, word1 );
	  key_hash = word2 & ~(long)0x7f;

	  if ( key_hash == key_current ) {

	    ptree.ntrans_prefer_hit++;
	    
	    depth_hash  = (int)((int)(word1>>56) & 0x00ff);
	    value_hash  = (int)((int)(word1>>40) & 0xffff) - 32768;
	    move_hash   = (int)(word1>>21) & 0x7ffff;
	    hand_hash   = (int)word1 & 0x1fffff;
	    
	    utemp           = (int)word2;
	    state_node_hash = utemp & def.node_mate_threat;
	    turn_hash       = (int)((utemp>>6) & 0x1);
	    type_hash       = (int)((utemp>>3) & 0x3);
	    
	    if ( Math.abs(value_hash) > def.score_max_eval )
	      {
		if ( value_hash > 0 ) { value_hash -= ply-1; }
		else                  { value_hash += ply-1; }


	      }

	    if ( def.RecursionThreshold <= depth_current
		 && depth_hash < bitop.RecursionDepth(depth_current) ) { move_hash = 0; }
	    else if ( move_hash > 0)
	      {
		move_hash |= turn_current > 0 ? bitop.Cap2Move( ptree.posi.asquare[bitop.I2To(move_hash)])
	                                  : bitop.Cap2Move(-ptree.posi.asquare[bitop.I2To(move_hash)]);
	      }

	    if ( turn_hash == turn_current && hand_hash == ptree.posi.hand_black ) {

	      assert( ! (move_hash> 0) || valid.is_move_valid( ptree, move_hash, turn_current ) > 0 );
	      ptree.amove_hash[ply] = move_hash;

	      pstate_node |= state_node_hash;
	      
	      if ( value_hash <= def.score_max_eval ) { pstate_node &= ~def.node_do_mate; }

	      if ( ( type_hash & def.flag_value_up_exact ) > 0
		   && value_hash < beta
		   && null_depth <= depth_hash )
		{
		  pstate_node &= ~def.node_do_null;
		}

	      if ( ( type_hash & def.flag_value_up_exact ) > 0
		   && value_hash <= alpha
		   && bitop.RecursionDepth(depth_current) <= depth_hash )
		{
		  pstate_node &= ~def.node_do_recursion;
		}

	      if ( type_hash == def.value_lower
		   && beta <= value_hash
		   && ( depth_hash >= depth_current || value_hash > def.score_max_eval ) )
		{
		  ptree.sort_value[0] = value_hash;
		  ptree.ntrans_lower++;
		  ret[0] = def.value_lower;
		  ret[1] = pstate_node;
		  return ret;
		}

	      if ( type_hash == def.value_upper
		   && value_hash <= alpha
		   && ( depth_hash >= depth_current || value_hash < -def.score_max_eval ) )
		{
		  ptree.sort_value[0] = value_hash;
		  ptree.ntrans_upper++;
		  ret[0] = def.value_upper;
		  ret[1] = pstate_node;
		  return ret;
		}

	      if ( type_hash == def.value_exact
		   && ( depth_hash >= depth_current
			|| Math.abs(value_hash) > def.score_max_eval ) )
		{
		  ptree.sort_value[0] = value_hash;
		  ptree.ntrans_upper++;
		  
		  ret[0] = def.value_exact;
		  ret[1] = pstate_node;
		  return ret;
		}

	      if ( ( type_hash & def.flag_value_low_exact ) > 0
		   && ! (ptree.nsuc_check[ply] > 0)
		   && ! (ptree.nsuc_check[ply-1] > 0)
		   && ( ( depth_current < 2*def.PLY_INC
			  && beta+( ( data.p_value_ex[ 15 + def.dragon ] * 2 ) /  8 ) <= value_hash )
			|| ( depth_current < 3*def.PLY_INC
			     && beta+( ( data.p_value_ex[ 15 + def.dragon ] * 2 ) /  8 ) <= value_hash ) ) )
		{
		  ptree.sort_value[0] = beta;
		  ptree.ntrans_lower++;
		  
		  ret[0] = def.value_lower;
		  ret[1] = pstate_node;
		  return ret;
		}

	    } else {
	    	int[] ret2 = eval_supe( ptree.posi.hand_black, hand_hash, turn_current, turn_hash,
				       value_hash, type_hash );
	    	is_superior = ret2[0];
	    	value_hash = ret2[1];
	    	type_hash = ret2[2];
	      if ( is_superior == 1 ) {

		if ( turn_hash == turn_current ) { move_supe = move_hash; }

		if ( (type_hash & def.flag_value_low_exact) > 0 )
		  {
		    if ( ! (ptree.nsuc_check[ply] > 0)
			 && ! (ptree.nsuc_check[ply-1] > 0)
			 && ( ( depth_current < 2*def.PLY_INC
				&& beta+( ( data.p_value_ex[ 15 + def.dragon ] * 2 ) /  8 ) <= value_hash )
			      || ( depth_current < 3*def.PLY_INC
				   && beta+( ( data.p_value_ex[ 15 + def.dragon ] * 2 ) /  8 ) <= value_hash ) ) )
		      {
			ptree.sort_value[0] = beta;
			ptree.ntrans_lower++;
			

		      }
		    
		    if ( beta <= value_hash
			 && ( depth_current <= depth_hash
			      || def.score_max_eval < value_hash
			      || ( (turn_current > 0!= turn_hash > 0)
				   && depth_hash >= null_depth
				   && ( pstate_node & def.node_do_null ) > 0 ) ) )
		      {
			ptree.sort_value[0] = value_hash;
			ptree.ntrans_superior_hit++;
			  ret[0] = def.value_lower;
			  ret[1] = pstate_node;
			  return ret;
		      }
		  }

	      }	else if ( is_superior == -1 ) {

		pstate_node |= state_node_hash;
		
		if ( value_hash <= def.score_max_eval )
		  {
		    pstate_node &= ~def.node_do_mate;
		  }
		
		if ( ( type_hash & def.flag_value_up_exact ) > 0
		     && value_hash <= alpha
		     && bitop.RecursionDepth(depth_current) <= depth_hash )
		  {
		    pstate_node &= ~def.node_do_recursion;
		  }
		
		if ( (type_hash & def.flag_value_up_exact) > 0 )
		  {
		    if ( value_hash < beta && null_depth <= depth_hash )
		      {
			pstate_node &= ~def.node_do_null;
		      }
		    if ( value_hash <= alpha
			 && ( depth_current <= depth_hash
			      || value_hash < -def.score_max_eval ) )
		      {
			ptree.sort_value[0] = value_hash;
			ptree.ntrans_inferior_hit++;
			
			  ret[0] = def.value_upper;
			  ret[1] = pstate_node;
			  return ret;
		      }
		  }
	      }
	    }
	  }
	  
	  slot  = (int)ptree.posi.hash_key >> 31;
	  word1 = data.ptrans_table_orig[data.ptrans_table + index].always[slot].word1;
	  word2 = data.ptrans_table_orig[data.ptrans_table + index].always[slot].word2;
	  
	  //SignKey( word2, word1 );
	  key_hash = word2 & ~(long)0x7f;
	  
	  if ( key_hash == key_current ) {

	    ptree.ntrans_always_hit++;

	    depth_hash  = (int)((int)(word1>>56) & 0x00ff);
	    value_hash  = (int)((int)(word1>>40) & 0xffff) - 32768;
	    move_hash   = (int)(word1>>21) & 0x7ffff;
	    hand_hash   = (int)word1 & 0x1fffff;
	    
	    utemp           = (int)word2;
	    state_node_hash = utemp & def.node_mate_threat;
	    turn_hash       = (int)((utemp>>6) & 0x1);
	    type_hash       = (int)((utemp>>3) & 0x3);
	    
	    if ( Math.abs(value_hash) > def.score_max_eval )
	      {
		if ( value_hash > 0 ) { value_hash -= ply-1; }
		else                  { value_hash += ply-1; }



	      }
	    
	    if ( def.RecursionThreshold <= depth_current
		 && depth_hash < bitop.RecursionDepth(depth_current) ) { move_hash = 0; }
	    else if ( move_hash > 0)
	      {
		move_hash |= turn_current > 0 ? bitop.Cap2Move( ptree.posi.asquare[bitop.I2To(move_hash)])
	                                  : bitop.Cap2Move(-ptree.posi.asquare[bitop.I2To(move_hash)]);
	      }

	    if ( turn_hash == turn_current && hand_hash == ptree.posi.hand_black ) {
	      
	      if ( ! (ptree.amove_hash[ply] > 0) )
		{
		  assert( ! (move_hash > 0)
			  || valid.is_move_valid( ptree, move_hash, turn_current ) > 0);
		  ptree.amove_hash[ply] = move_hash;
		}

	      pstate_node |= state_node_hash;

	      if ( value_hash <= def.score_max_eval ) { pstate_node &= ~def.node_do_mate; }
	      
	      if ( ( type_hash & def.flag_value_up_exact ) > 0
		   && value_hash <= alpha
		   && bitop.RecursionDepth(depth_current) <= depth_hash )
		{
		  pstate_node &= ~def.node_do_recursion;
		}

	      if ( ( type_hash & def.flag_value_up_exact ) > 0
		   && value_hash < beta
		   && null_depth <= depth_hash )
		{
		  pstate_node &= ~def.node_do_null;
		}

	      if ( type_hash == def.value_lower
		   && value_hash >= beta
		   && ( depth_hash >= depth_current || value_hash > def.score_max_eval ) )
		{
		  ptree.sort_value[0] = value_hash;
		  ptree.ntrans_lower++;
		  
		  ret[0] = def.value_lower;
		  ret[1] = pstate_node;
		  return ret;
		}

	      if ( type_hash == def.value_upper
		   && value_hash <= alpha
		   && ( depth_hash >= depth_current || value_hash < -def.score_max_eval ) )
		{
		  ptree.sort_value[0] = value_hash;
		  ptree.ntrans_upper++;
		  
		  ret[0] = def.value_upper;
		  ret[1] = pstate_node;
		  return ret;
	
		}

	      if ( type_hash == def.value_exact
		   && ( depth_hash >= depth_current
			|| Math.abs(value_hash) > def.score_max_eval ) )
		{
		  ptree.sort_value[0] = value_hash;
		  ptree.ntrans_upper++;

		  
		  ret[0] = def.value_exact;
		  ret[1] = pstate_node;
		  return ret;
		}


	      if ( ( type_hash & def.flag_value_low_exact ) > 0
		   && ! (ptree.nsuc_check[ply] > 0)
		   && ! (ptree.nsuc_check[ply-1] > 0)
		   && ( ( depth_current < 2*def.PLY_INC
			  && beta+( ( data.p_value_ex[ 15 + def.dragon ] * 2 ) /  8 ) <= value_hash )
			|| ( depth_current < 3*def.PLY_INC
			     && beta+( ( data.p_value_ex[ 15 + def.dragon ] * 2 ) /  8 ) <= value_hash ) ) )
		{
		  ptree.sort_value[0] = beta;
		  ptree.ntrans_lower++;
		  ret[0] = def.value_lower;
		  ret[1] = pstate_node;
		  return ret;
		}

	    } else {

	    	int[] ret2 = eval_supe( ptree.posi.hand_black, hand_hash, turn_current, turn_hash,
					 value_hash, type_hash );
		is_superior = ret2[0];
		value_hash = ret2[1];
		type_hash = ret2[1];

		if ( is_superior == 1 ) {

		  if ( ( turn_hash == turn_current ) && ! (move_supe > 0) )
		    {
		      move_supe = move_hash;
		    }
		  
		  if ( (type_hash & def.flag_value_low_exact ) > 0)
		    {
		      if ( ! (ptree.nsuc_check[ply] > 0)
			   && ! (ptree.nsuc_check[ply-1] > 0)
			   && ( ( depth_current < 2*def.PLY_INC
				  && beta+( ( data.p_value_ex[ 15 + def.dragon ] * 2 ) /  8 ) <= value_hash )
				|| ( depth_current < 3*def.PLY_INC
				     && beta+( ( data.p_value_ex[ 15 + def.dragon ] * 2 ) /  8 ) <= value_hash ) ) )
			{
			  ptree.sort_value[0] = beta;
			  ptree.ntrans_lower++;
		
			  
			  ret[0] = def.value_lower;
			  ret[1] = pstate_node;
			  return ret;
			}
		      
		      if ( value_hash >= beta
			   && ( depth_hash >= depth_current
				|| def.score_max_eval < value_hash
				|| ( (turn_current > 0 != turn_hash > 0)
				     && depth_hash >= null_depth
				     && ( pstate_node & def.node_do_null ) > 0 ) ) )
			{
			  ptree.sort_value[0] = value_hash;
			  ptree.ntrans_superior_hit++;
			  ret[0] = def.value_lower;
			  ret[1] = pstate_node;
			  return ret;
			}
		    }

		} else if ( is_superior == -1 ) {

		  pstate_node |= state_node_hash;
		  
		  if ( value_hash <= def.score_max_eval )
		    {
		      pstate_node &= ~def.node_do_mate;
		    }
		  
		  if ( ( type_hash & def.flag_value_up_exact ) > 0
		       && value_hash <= alpha
		       && bitop.RecursionDepth(depth_current) <= depth_hash )
		    {
		      pstate_node &= ~def.node_do_recursion;
		    }
		  
		  if ( (type_hash & def.flag_value_up_exact ) > 0)
		    {
		      if ( value_hash < beta && null_depth <= depth_hash )
			{
			  pstate_node &= ~def.node_do_null;
			}
		      if ( value_hash <= alpha
			   && ( depth_hash >= depth_current
				|| value_hash < -def.score_max_eval ) )
			{
			  ptree.sort_value[0] = value_hash;
			  ptree.ntrans_inferior_hit++;
		
			  
			  ret[0] = def.value_upper;
			  ret[1] = pstate_node;
			  return ret;
			}
		    }
		}
	    }
	  }
	  
	  if ( ! (ptree.amove_hash[ply] > 0) )
	    {
	      if ( move_supe > 0)
		{
		  ifrom = (int)bitop.I2From(move_supe);
		  if ( ifrom >= def.nsquare )
		    {
		      int hand = turn_current > 0? ptree.posi.hand_white : ptree.posi.hand_black;
		      switch( bitop.From2Drop(ifrom) )
			{
			case def.pawn:
			  if ( ! (bitop.IsHandPawn(hand) > 0) ) {
			    move_supe = bitop.To2Move(bitop.I2To(move_supe));
			    if ( bitop.IsHandLance(hand) > 0)
			      {
				move_supe |= bitop.Drop2Move(def.lance);
			      }
			    else if ( bitop.IsHandSilver(hand) > 0)
			      {
				move_supe |= bitop.Drop2Move(def.silver);
			      }
			    else if ( bitop.IsHandGold(hand)  > 0)
			      {
				move_supe |= bitop.Drop2Move(def.gold);
			      }
			    else { move_supe |= bitop.Drop2Move(def.rook); }
			  }
			  break;
			
			case def.lance:
			  if ( ! (bitop.IsHandLance(hand) > 0) )
			    {
			      move_supe = bitop.To2Move(bitop.I2To(move_supe)) | bitop.Drop2Move(def.rook);
			    }
			  break;
			}
		    }

		  assert( valid.is_move_valid( ptree, move_supe, turn_current )> 0);
		  ptree.amove_hash[ply] = move_supe;
		}
	    }
	  
	  
	  ret[0] = def.value_null;
	  ret[1] = pstate_node;
	  return ret;

	}


private static int[] eval_supe(int hand_current, int hand_hash,
	   int turn_current, int turn_hash,
	   int pvalue_hash, int ptype_hash )
{
	int[] ret = new int[3];
	int is_superior;

  if ( hand_current == hand_hash ) { is_superior = 0; }
  else if ( utility.is_hand_eq_supe( hand_current, hand_hash ) > 0)
    {
      is_superior = turn_current > 0? -1 : 1;
    }
  else if ( utility.is_hand_eq_supe( hand_hash, hand_current ) > 0)
    {
      is_superior = turn_current > 0? 1 : -1;
    }
  else {
	  ret[1] = pvalue_hash;
	  ret[2] = ptype_hash;
	  return ret; }
  
  if ( turn_hash != turn_current ){
      if ( is_superior == -1 ) {
    	  is_superior = 0; 
      }
      else {
		is_superior   = 1;
		pvalue_hash = -1;
		if(ptype_hash == def.value_lower){  ptype_hash=def.value_upper;}
		else if(ptype_hash == def.value_upper){  ptype_hash=def.value_lower;}
      }
	}
    
ret[0] = is_superior;
ret[1] = pvalue_hash;
ret[2] = ptype_hash;
  return ret;
}

	
//	public static final void Xor(int index, bitboard_t bb){
//		
//		if(index <= 26){
//			int p = 26 - index;
//			p = 1 << p;
//			bb.p[0] ^= p;
//		}
//		else if(index <= 53){
//			int p = 53 - index;
//			p = 1 << p;
//			bb.p[1] ^= p;
//		}
//		else{
//			int p = 80 - index;
//			p = 1 << p;
//			bb.p[2] ^= p;
//		}
//	}
	

	
	
	

	
	long Foo(tree_t ptree, long key, bitboard_t b_tree, bitboard_t w_tree, long[] b_rand, long[] w_rand){
		bitboard_t bb;
		 int sq;
		 bb = new bitboard_t(b_tree);
		 while(bitop.BBTest(bb)){
			 sq = bitop.FirstOne(bb);
			 bitop.Xor(sq, bb);
			 key ^= b_rand[sq];
		 }
		 
		 
		 bb = new bitboard_t(w_tree);
		 while(bitop.BBTest(bb)){
			 sq = bitop.FirstOne(bb);
			 bitop.Xor(sq, bb);
			 key ^= w_rand[sq];
		 }
	
		 return key;
	}
	
	
	long hash_func(tree_t ptree )
	{
	  long key = 0;

	  key ^= data.b_king_rand[ptree.posi.isquare_b_king];
	  key ^= data.w_king_rand[ptree.posi.isquare_w_king];

	  key = Foo(ptree, key, ptree.posi.b_pawn, ptree.posi.w_pawn, data.b_pawn_rand, data.w_pawn_rand);
	  key = Foo(ptree, key, ptree.posi.b_lance, ptree.posi.w_lance, data.b_lance_rand, data.w_lance_rand);
	  key = Foo(ptree, key, ptree.posi.b_knight, ptree.posi.w_knight, data.b_knight_rand, data.w_knight_rand);
	  key = Foo(ptree, key, ptree.posi.b_silver, ptree.posi.w_silver, data.b_silver_rand, data.w_silver_rand);
	  key = Foo(ptree, key, ptree.posi.b_gold, ptree.posi.w_gold, data.b_gold_rand, data.w_gold_rand);
	  key = Foo(ptree, key, ptree.posi.b_bishop, ptree.posi.w_bishop, data.b_bishop_rand, data.w_bishop_rand);
	  key = Foo(ptree, key, ptree.posi.b_rook, ptree.posi.w_rook, data.b_rook_rand, data.w_rook_rand);
	  key = Foo(ptree, key, ptree.posi.b_pro_pawn, ptree.posi.w_pro_pawn, data.b_pro_pawn_rand, data.w_pro_pawn_rand);
	  key = Foo(ptree, key, ptree.posi.b_pro_lance, ptree.posi.w_pro_lance, data.b_pro_lance_rand, data.w_pro_lance_rand);
	  key = Foo(ptree, key, ptree.posi.b_pro_knight, ptree.posi.w_pro_knight, data.b_pro_knight_rand, data.w_pro_knight_rand);
	  key = Foo(ptree, key, ptree.posi.b_pro_silver, ptree.posi.w_pro_silver, data.b_pro_silver_rand, data.w_pro_silver_rand);
	  key = Foo(ptree, key, ptree.posi.b_horse, ptree.posi.w_horse, data.b_horse_rand, data.w_horse_rand);
	  key = Foo(ptree, key, ptree.posi.b_dragon, ptree.posi.w_dragon, data.b_dragon_rand, data.w_dragon_rand);

	  return key;
	}


	class trans_entry_t {
		public long word1, word2;
	}

	class trans_table_t {
		public trans_entry_t prefer;
		public trans_entry_t[] always = new trans_entry_t[2];
	}

	class rand_work_t {
		public int count;
		public int[] cnst = new int[2];
		public List<Integer> vec = new ArrayList<Integer>();
	}

}
