public class genevasn {

	public static int b_gen_evasion(tree_t ptree, int moveidx) {
		bitboard_t bb_desti = new bitboard_t(), bb_checker = new bitboard_t(), bb_inter = new bitboard_t(), bb_target = new bitboard_t(), bb_piece = new bitboard_t();
		int hand, ubb_target0a, ubb_target0b, ubb_pawn_cmp, utemp;
		int[] ais_pawn = new int[def.nfile];
		int nchecker, sq_bk, to, sq_check, idirec;
		int nhand, i, nolance, noknight, from;
		int[] ahand = new int[6];

		/* move the king */
		sq_bk = ptree.posi.isquare_b_king;

		bitop.Xor(sq_bk, ptree.posi.b_occupied);
		bitop.XorFile(sq_bk, ptree.posi.occupied_rl90);
		bitop.XorDiag2(sq_bk, ptree.posi.occupied_rl45);
		bitop.XorDiag1(sq_bk, ptree.posi.occupied_rr45);

		bitop.BBNotAnd(bb_desti, data.abb_king_attacks[sq_bk],
				ptree.posi.b_occupied);
		utemp = bitop.From2Move(sq_bk) | bitop.Piece2Move(def.king);
		while (bitop.BBTest(bb_desti)) {
			to = bitop.LastOne(bb_desti);
			if (!attack.is_black_attacked(ptree, to)) {
				ptree.amove[moveidx++] = bitop.To2Move(to)
						| bitop.Cap2Move(-ptree.posi.asquare[to]) | utemp;
			}
			bitop.Xor(to, bb_desti);
		}

		bitop.Xor(sq_bk, ptree.posi.b_occupied);
		bitop.XorFile(sq_bk, ptree.posi.occupied_rl90);
		bitop.XorDiag2(sq_bk, ptree.posi.occupied_rl45);
		bitop.XorDiag1(sq_bk, ptree.posi.occupied_rr45);

		bb_checker = new bitboard_t(attack.w_attacks_to_piece(ptree, sq_bk));
		nchecker = bitop.PopuCount(bb_checker);
		if (nchecker == 2) {
			return moveidx;
		}

		sq_check = bitop.LastOne(bb_checker);
		bb_inter = new bitboard_t(data.abb_obstacle[sq_bk][sq_check]);

		/* move other pieces */
		bitop.BBOr(bb_target, bb_inter, bb_checker);

		bitop.BBAnd(bb_desti, bb_target, ptree.posi.b_pawn_attacks);
		while (bitop.BBTest(bb_desti)) {
			to = bitop.LastOne(bb_desti);
			bitop.Xor(to, bb_desti);

			from = to + 9;
			idirec = (int) data.adirec[sq_bk][from];
			if (!(idirec > 0)
					|| !(attack.is_pinned_on_black_king(ptree, from, idirec) > 0)) {
				utemp = (bitop.To2Move(to) | bitop.From2Move(from)
						| bitop.Piece2Move(def.pawn) | bitop
						.Cap2Move(-ptree.posi.asquare[to]));
				if (to < def.A6) {
					utemp |= def.FLAG_PROMO;
				}
				ptree.amove[moveidx++] = utemp;
			}
		}

		bb_piece = new bitboard_t(ptree.posi.b_lance);
		while (bitop.BBTest(bb_piece)) {
			from = bitop.LastOne(bb_piece);
			bitop.Xor(from, bb_piece);

			bb_desti = bitop.AttackFile(from, ptree);
			bitop.BBAnd(bb_desti, bb_desti, data.abb_minus_rays[from]);
			bitop.BBAnd(bb_desti, bb_desti, bb_target);
			if (!bitop.BBTest(bb_desti)) {
				continue;
			}

			idirec = (int) data.adirec[sq_bk][from];
			if (!(idirec > 0)
					|| !(attack.is_pinned_on_black_king(ptree, from, idirec) > 0)) {
				to = bitop.LastOne(bb_desti);

				utemp = (bitop.To2Move(to) | bitop.From2Move(from)
						| bitop.Piece2Move(def.lance) | bitop
						.Cap2Move(-ptree.posi.asquare[to]));
				if (to < def.A6) {
					ptree.amove[moveidx++] = utemp | def.FLAG_PROMO;
				}
				if (to >= def.A7) {
					ptree.amove[moveidx++] = utemp;
				}
			}
		}

		bb_piece = new bitboard_t(ptree.posi.b_knight);
		while (bitop.BBTest(bb_piece)) {
			from = bitop.LastOne(bb_piece);
			bitop.Xor(from, bb_piece);

			bitop.BBAnd(bb_desti, bb_target, data.abb_b_knight_attacks[from]);
			if (!bitop.BBTest(bb_desti)) {
				continue;
			}

			idirec = (int) data.adirec[sq_bk][from];
			if (!(idirec > 0)
					|| !(attack.is_pinned_on_black_king(ptree, from, idirec) > 0))
				do {
					to = bitop.LastOne(bb_desti);
					bitop.Xor(to, bb_desti);

					utemp = (bitop.To2Move(to) | bitop.From2Move(from)
							| bitop.Piece2Move(def.knight) | bitop
							.Cap2Move(-ptree.posi.asquare[to]));
					if (to < def.A6) {
						ptree.amove[moveidx++] = utemp | def.FLAG_PROMO;
					}
					if (to >= def.A7) {
						ptree.amove[moveidx++] = utemp;
					}

				} while (bitop.BBTest(bb_desti));
		}

		bb_piece = new bitboard_t(ptree.posi.b_silver);
		while (bitop.BBTest(bb_piece)) {
			from = bitop.LastOne(bb_piece);
			bitop.Xor(from, bb_piece);

			bitop.BBAnd(bb_desti, bb_target, data.abb_b_silver_attacks[from]);
			if (!bitop.BBTest(bb_desti)) {
				continue;
			}

			idirec = (int) data.adirec[sq_bk][from];
			if (!(idirec > 0)
					|| !(attack.is_pinned_on_black_king(ptree, from, idirec) > 0))
				do {
					to = bitop.LastOne(bb_desti);
					bitop.Xor(to, bb_desti);
					utemp = (bitop.To2Move(to) | bitop.From2Move(from)
							| bitop.Piece2Move(def.silver) | bitop
							.Cap2Move(-ptree.posi.asquare[to]));
					if (from < def.A6 || to < def.A6) {
						ptree.amove[moveidx++] = utemp | def.FLAG_PROMO;
					}
					ptree.amove[moveidx++] = utemp;
				} while (bitop.BBTest(bb_desti));
		}

		bb_piece = new bitboard_t(ptree.posi.b_tgold);
		while (bitop.BBTest(bb_piece)) {
			from = bitop.LastOne(bb_piece);
			bitop.Xor(from, bb_piece);

			bitop.BBAnd(bb_desti, bb_target, data.abb_b_gold_attacks[from]);
			if (!bitop.BBTest(bb_desti)) {
				continue;
			}

			idirec = (int) data.adirec[sq_bk][from];
			if (!(idirec > 0)
					|| !(attack.is_pinned_on_black_king(ptree, from, idirec) > 0))
				do {
					to = bitop.LastOne(bb_desti);
					bitop.Xor(to, bb_desti);
					ptree.amove[moveidx++] = (bitop.To2Move(to)
							| bitop.From2Move(from)
							| bitop.Piece2Move(ptree.posi.asquare[from]) | bitop
							.Cap2Move(-ptree.posi.asquare[to]));
				} while (bitop.BBTest(bb_desti));
		}

		bb_piece = new bitboard_t(ptree.posi.b_bishop);
		while (bitop.BBTest(bb_piece)) {
			from = bitop.LastOne(bb_piece);
			bitop.Xor(from, bb_piece);

			bitop.AttackBishop(bb_desti, from, ptree);
			bitop.BBAnd(bb_desti, bb_desti, bb_target);
			if (!bitop.BBTest(bb_desti)) {
				continue;
			}
			idirec = (int) data.adirec[sq_bk][from];
			if (!(idirec > 0)
					|| !(attack.is_pinned_on_black_king(ptree, from, idirec) > 0))
				do {
					to = bitop.LastOne(bb_desti);
					bitop.Xor(to, bb_desti);

					utemp = (bitop.To2Move(to) | bitop.From2Move(from)
							| bitop.Piece2Move(def.bishop) | bitop
							.Cap2Move(-ptree.posi.asquare[to]));
					if (from < def.A6 || to < def.A6) {
						utemp |= def.FLAG_PROMO;
					}
					ptree.amove[moveidx++] = utemp;
				} while (bitop.BBTest(bb_desti));
		}

		bb_piece = new bitboard_t(ptree.posi.b_rook);
		while (bitop.BBTest(bb_piece)) {
			from = bitop.LastOne(bb_piece);
			bitop.Xor(from, bb_piece);

			bitop.AttackRook(bb_desti, from, ptree);
			bitop.BBAnd(bb_desti, bb_desti, bb_target);
			if (!bitop.BBTest(bb_desti)) {
				continue;
			}
			idirec = (int) data.adirec[sq_bk][from];
			if (!(idirec > 0)
					|| !(attack.is_pinned_on_black_king(ptree, from, idirec) > 0))
				do {
					to = bitop.LastOne(bb_desti);
					bitop.Xor(to, bb_desti);

					utemp = (bitop.To2Move(to) | bitop.From2Move(from)
							| bitop.Piece2Move(def.rook) | bitop
							.Cap2Move(-ptree.posi.asquare[to]));
					if (from < def.A6 || to < def.A6) {
						utemp |= def.FLAG_PROMO;
					}
					ptree.amove[moveidx++] = utemp;
				} while (bitop.BBTest(bb_desti));
		}

		bb_piece = new bitboard_t(ptree.posi.b_horse);
		while (bitop.BBTest(bb_piece)) {
			from = bitop.LastOne(bb_piece);
			bitop.Xor(from, bb_piece);

			bitop.AttackHorse(bb_desti, from, ptree);
			bitop.BBAnd(bb_desti, bb_desti, bb_target);
			if (!bitop.BBTest(bb_desti)) {
				continue;
			}

			idirec = (int) data.adirec[sq_bk][from];
			if (!(idirec > 0)
					|| !(attack.is_pinned_on_black_king(ptree, from, idirec) > 0))
				do {
					to = bitop.LastOne(bb_desti);
					bitop.Xor(to, bb_desti);
					ptree.amove[moveidx++] = (bitop.To2Move(to)
							| bitop.From2Move(from)
							| bitop.Piece2Move(def.horse) | bitop
							.Cap2Move(-ptree.posi.asquare[to]));
				} while (bitop.BBTest(bb_desti));
		}

		bb_piece = new bitboard_t(ptree.posi.b_dragon);
		while (bitop.BBTest(bb_piece)) {
			from = bitop.LastOne(bb_piece);
			bitop.Xor(from, bb_piece);

			bitop.AttackDragon(bb_desti, from, ptree);
			bitop.BBAnd(bb_desti, bb_desti, bb_target);
			if (!bitop.BBTest(bb_desti)) {
				continue;
			}

			idirec = (int) data.adirec[sq_bk][from];
			if (!(idirec > 0)
					|| !(attack.is_pinned_on_black_king(ptree, from, idirec) > 0))
				do {
					to = bitop.LastOne(bb_desti);
					bitop.Xor(to, bb_desti);
					ptree.amove[moveidx++] = (bitop.To2Move(to)
							| bitop.From2Move(from)
							| bitop.Piece2Move(def.dragon) | bitop
							.Cap2Move(-ptree.posi.asquare[to]));
				} while (bitop.BBTest(bb_desti));
		}

		if (!(ptree.posi.hand_black > 0)) {
			return moveidx;
		}
		if (!(bitop.BBTest(bb_inter))) {
			return moveidx;
		}

		/* drops */
		bb_target = new bitboard_t(bb_inter);
		ubb_target0a = bb_target.p[0] & 0x7fc0000;
		ubb_target0b = bb_target.p[0] & 0x003fe00;
		bb_target.p[0] &= 0x00001ff;
		bb_target.p[1] &= 0x7ffffff;
		bb_target.p[2] &= 0x7ffffff;

		hand = ptree.posi.hand_black;
		nhand = 0;
		if (bitop.IsHandKnight(hand) > 0) {
			ahand[nhand++] = bitop.Drop2Move(def.knight);
		}
		noknight = nhand;
		if (bitop.IsHandLance(hand) > 0) {
			ahand[nhand++] = bitop.Drop2Move(def.lance);
		}
		nolance = nhand;
		if (bitop.IsHandSilver(hand) > 0) {
			ahand[nhand++] = bitop.Drop2Move(def.silver);
		}
		if (bitop.IsHandGold(hand) > 0) {
			ahand[nhand++] = bitop.Drop2Move(def.gold);
		}
		if (bitop.IsHandBishop(hand) > 0) {
			ahand[nhand++] = bitop.Drop2Move(def.bishop);
		}
		if (bitop.IsHandRook(hand) > 0) {
			ahand[nhand++] = bitop.Drop2Move(def.rook);
		}

		if (bitop.IsHandPawn(hand) > 0) {
			ubb_pawn_cmp = bitop.BBToU(ptree.posi.b_pawn_attacks);
			ais_pawn[0] = ubb_pawn_cmp & (def.mask_file1 >> 0);
			ais_pawn[1] = ubb_pawn_cmp & (def.mask_file1 >> 1);
			ais_pawn[2] = ubb_pawn_cmp & (def.mask_file1 >> 2);
			ais_pawn[3] = ubb_pawn_cmp & (def.mask_file1 >> 3);
			ais_pawn[4] = ubb_pawn_cmp & (def.mask_file1 >> 4);
			ais_pawn[5] = ubb_pawn_cmp & (def.mask_file1 >> 5);
			ais_pawn[6] = ubb_pawn_cmp & (def.mask_file1 >> 6);
			ais_pawn[7] = ubb_pawn_cmp & (def.mask_file1 >> 7);
			ais_pawn[8] = ubb_pawn_cmp & (def.mask_file1 >> 8);

			while (bitop.BBTest(bb_target)) {
				to = bitop.LastOne(bb_target);
				utemp = bitop.To2Move(to);
				if (!(ais_pawn[def.aifile[to]] > 0)
						&& !bitop.IsMateBPawnDrop(ptree, to)) {
					ptree.amove[moveidx++] = utemp | bitop.Drop2Move(def.pawn);
				}
				for (i = 0; i < nhand; i++) {
					ptree.amove[moveidx++] = utemp | ahand[i];
				}
				bitop.Xor(to, bb_target);
			}

			while (ubb_target0b > 0) {
				to = bitop.last_one0(ubb_target0b);
				utemp = bitop.To2Move(to);
				if (!(ais_pawn[def.aifile[to]] > 0)
						&& !bitop.IsMateBPawnDrop(ptree, to)) {
					ptree.amove[moveidx++] = utemp | bitop.Drop2Move(def.pawn);
				}
				for (i = noknight; i < nhand; i++) {
					ptree.amove[moveidx++] = utemp | ahand[i];
				}
				ubb_target0b ^= data.abb_mask[to].p[0];
			}
		} else {
			while (bitop.BBTest(bb_target)) {
				to = bitop.LastOne(bb_target);
				utemp = bitop.To2Move(to);
				for (i = 0; i < nhand; i++) {
					ptree.amove[moveidx++] = utemp | ahand[i];
				}
				bitop.Xor(to, bb_target);
			}

			while (ubb_target0b > 0) {
				to = bitop.last_one0(ubb_target0b);
				utemp = bitop.To2Move(to);
				for (i = noknight; i < nhand; i++) {
					ptree.amove[moveidx++] = utemp | ahand[i];
				}
				ubb_target0b ^= data.abb_mask[to].p[0];
			}
		}

		while (ubb_target0a > 0) {
			to = bitop.last_one0(ubb_target0a);
			utemp = bitop.To2Move(to);
			for (i = nolance; i < nhand; i++) {
				ptree.amove[moveidx++] = utemp | ahand[i];
			}
			ubb_target0a ^= data.abb_mask[to].p[0];
		}

		return moveidx;
	}

	public static int w_gen_evasion(tree_t ptree, int moveidx) {
		bitboard_t bb_desti = new bitboard_t(), bb_checker = new bitboard_t(), bb_inter = new bitboard_t(), bb_target = new bitboard_t(), bb_piece = new bitboard_t();
		int hand, ubb_target2a, ubb_target2b, ubb_pawn_cmp, utemp;
		int[] ais_pawn = new int[def.nfile];
		int nchecker, sq_wk, to, sq_check, idirec;
		int nhand, i, nolance, noknight, from;
		int[] ahand = new int[6];

		/* move the king */
		sq_wk = ptree.posi.isquare_w_king;

		bitop.Xor(sq_wk, ptree.posi.w_occupied);
		bitop.XorFile(sq_wk, ptree.posi.occupied_rl90);
		bitop.XorDiag2(sq_wk, ptree.posi.occupied_rl45);
		bitop.XorDiag1(sq_wk, ptree.posi.occupied_rr45);

		bitop.BBNotAnd(bb_desti, data.abb_king_attacks[sq_wk],
				ptree.posi.w_occupied);
		utemp = bitop.From2Move(sq_wk) | bitop.Piece2Move(def.king);
		while (bitop.BBTest(bb_desti)) {
			to = bitop.FirstOne(bb_desti);
			if (!attack.is_white_attacked(ptree, to)) {
				ptree.amove[moveidx++] = bitop.To2Move(to)
						| bitop.Cap2Move(ptree.posi.asquare[to]) | utemp;
			}
			bitop.Xor(to, bb_desti);
		}

		bitop.Xor(sq_wk, ptree.posi.w_occupied);
		bitop.XorFile(sq_wk, ptree.posi.occupied_rl90);
		bitop.XorDiag2(sq_wk, ptree.posi.occupied_rl45);
		bitop.XorDiag1(sq_wk, ptree.posi.occupied_rr45);

		bb_checker = new bitboard_t(attack.b_attacks_to_piece(ptree, sq_wk));
		nchecker = bitop.PopuCount(bb_checker);
		if (nchecker == 2) {
			return moveidx;
		}

		sq_check = bitop.FirstOne(bb_checker);
		bb_inter = data.abb_obstacle[sq_wk][sq_check];

		/* move other pieces */
		bitop.BBOr(bb_target, bb_inter, bb_checker);

		bitop.BBAnd(bb_desti, bb_target, ptree.posi.w_pawn_attacks);
		while (bitop.BBTest(bb_desti)) {
			to = bitop.FirstOne(bb_desti);
			bitop.Xor(to, bb_desti);

			from = to - 9;
			idirec = (int) data.adirec[sq_wk][from];
			if (!(idirec > 0)
					|| !(attack.is_pinned_on_white_king(ptree, from, idirec) > 0)) {
				utemp = (bitop.To2Move(to) | bitop.From2Move(from)
						| bitop.Piece2Move(def.pawn) | bitop
						.Cap2Move(ptree.posi.asquare[to]));
				if (to > def.I4) {
					utemp |= def.FLAG_PROMO;
				}
				ptree.amove[moveidx++] = utemp;
			}
		}

		bb_piece = new bitboard_t(ptree.posi.w_lance);
		while (bitop.BBTest(bb_piece)) {
			from = bitop.FirstOne(bb_piece);
			bitop.Xor(from, bb_piece);

			bb_desti = bitop.AttackFile(from, ptree);
			bitop.BBAnd(bb_desti, bb_desti, data.abb_plus_rays[from]);
			bitop.BBAnd(bb_desti, bb_desti, bb_target);
			if (!bitop.BBTest(bb_desti)) {
				continue;
			}

			idirec = (int) data.adirec[sq_wk][from];
			if (!(idirec > 0)
					|| !(attack.is_pinned_on_white_king(ptree, from, idirec) > 0)) {
				to = bitop.FirstOne(bb_desti);

				utemp = (bitop.To2Move(to) | bitop.From2Move(from)
						| bitop.Piece2Move(def.lance) | bitop
						.Cap2Move(ptree.posi.asquare[to]));
				if (to > def.I4) {
					ptree.amove[moveidx++] = utemp | def.FLAG_PROMO;
				}
				if (to <= def.I3) {
					ptree.amove[moveidx++] = utemp;
				}
			}
		}

		bb_piece = new bitboard_t(ptree.posi.w_knight);
		while (bitop.BBTest(bb_piece)) {
			from = bitop.FirstOne(bb_piece);
			bitop.Xor(from, bb_piece);

			bitop.BBAnd(bb_desti, bb_target, data.abb_w_knight_attacks[from]);
			if (!bitop.BBTest(bb_desti)) {
				continue;
			}

			idirec = (int) data.adirec[sq_wk][from];
			if (!(idirec > 0)
					|| !(attack.is_pinned_on_white_king(ptree, from, idirec) > 0))
				do {
					to = bitop.FirstOne(bb_desti);
					bitop.Xor(to, bb_desti);

					utemp = (bitop.To2Move(to) | bitop.From2Move(from)
							| bitop.Piece2Move(def.knight) | bitop
							.Cap2Move(ptree.posi.asquare[to]));
					if (to > def.I4) {
						ptree.amove[moveidx++] = utemp | def.FLAG_PROMO;
					}
					if (to <= def.I3) {
						ptree.amove[moveidx++] = utemp;
					}
				} while (bitop.BBTest(bb_desti));
		}

		bb_piece = new bitboard_t(ptree.posi.w_silver);
		while (bitop.BBTest(bb_piece)) {
			from = bitop.FirstOne(bb_piece);
			bitop.Xor(from, bb_piece);

			bitop.BBAnd(bb_desti, bb_target, data.abb_w_silver_attacks[from]);
			if (!bitop.BBTest(bb_desti)) {
				continue;
			}

			idirec = (int) data.adirec[sq_wk][from];
			if (!(idirec > 0)
					|| !(attack.is_pinned_on_white_king(ptree, from, idirec) > 0))
				do {
					to = bitop.FirstOne(bb_desti);
					bitop.Xor(to, bb_desti);
					utemp = (bitop.To2Move(to) | bitop.From2Move(from)
							| bitop.Piece2Move(def.silver) | bitop
							.Cap2Move(ptree.posi.asquare[to]));
					if (from > def.I4 || to > def.I4) {
						ptree.amove[moveidx++] = utemp | def.FLAG_PROMO;
					}
					ptree.amove[moveidx++] = utemp;
				} while (bitop.BBTest(bb_desti));
		}

		bb_piece = new bitboard_t(ptree.posi.w_tgold);
		while (bitop.BBTest(bb_piece)) {
			from = bitop.FirstOne(bb_piece);
			bitop.Xor(from, bb_piece);

			bitop.BBAnd(bb_desti, bb_target, data.abb_w_gold_attacks[from]);
			if (!bitop.BBTest(bb_desti)) {
				continue;
			}

			idirec = (int) data.adirec[sq_wk][from];
			if (!(idirec > 0)
					|| !(attack.is_pinned_on_white_king(ptree, from, idirec) > 0))
				do {
					to = bitop.FirstOne(bb_desti);
					bitop.Xor(to, bb_desti);
					ptree.amove[moveidx++] = (bitop.To2Move(to)
							| bitop.From2Move(from)
							| bitop.Piece2Move(-ptree.posi.asquare[from]) | bitop
							.Cap2Move(ptree.posi.asquare[to]));
				} while (bitop.BBTest(bb_desti));
		}

		bb_piece = new bitboard_t(ptree.posi.w_bishop);
		while (bitop.BBTest(bb_piece)) {
			from = bitop.FirstOne(bb_piece);
			bitop.Xor(from, bb_piece);

			bitop.AttackBishop(bb_desti, from, ptree);
			bitop.BBAnd(bb_desti, bb_desti, bb_target);
			if (!bitop.BBTest(bb_desti)) {
				continue;
			}

			idirec = (int) data.adirec[sq_wk][from];
			if (!(idirec > 0)
					|| !(attack.is_pinned_on_white_king(ptree, from, idirec) > 0))
				do {
					to = bitop.FirstOne(bb_desti);
					bitop.Xor(to, bb_desti);

					utemp = (bitop.To2Move(to) | bitop.From2Move(from)
							| bitop.Piece2Move(def.bishop) | bitop
							.Cap2Move(ptree.posi.asquare[to]));
					if (from > def.I4 || to > def.I4) {
						utemp |= def.FLAG_PROMO;
					}
					ptree.amove[moveidx++] = utemp;
				} while (bitop.BBTest(bb_desti));
		}

		bb_piece = new bitboard_t(ptree.posi.w_rook);
		while (bitop.BBTest(bb_piece)) {
			from = bitop.FirstOne(bb_piece);
			bitop.Xor(from, bb_piece);

			bitop.AttackRook(bb_desti, from, ptree);
			bitop.BBAnd(bb_desti, bb_desti, bb_target);
			if (!bitop.BBTest(bb_desti)) {
				continue;
			}
			idirec = (int) data.adirec[sq_wk][from];
			if (!(idirec > 0)
					|| !(attack.is_pinned_on_white_king(ptree, from, idirec) > 0))
				do {
					to = bitop.FirstOne(bb_desti);
					bitop.Xor(to, bb_desti);

					utemp = (bitop.To2Move(to) | bitop.From2Move(from)
							| bitop.Piece2Move(def.rook) | bitop
							.Cap2Move(ptree.posi.asquare[to]));
					if (from > def.I4 || to > def.I4) {
						utemp |= def.FLAG_PROMO;
					}
					ptree.amove[moveidx++] = utemp;
				} while (bitop.BBTest(bb_desti));
		}

		bb_piece = new bitboard_t(ptree.posi.w_horse);
		while (bitop.BBTest(bb_piece)) {
			from = bitop.FirstOne(bb_piece);
			bitop.Xor(from, bb_piece);

			bitop.AttackHorse(bb_desti, from, ptree);
			bitop.BBAnd(bb_desti, bb_desti, bb_target);
			if (!bitop.BBTest(bb_desti)) {
				continue;
			}

			idirec = (int) data.adirec[sq_wk][from];
			if (!(idirec > 0)
					|| !(attack.is_pinned_on_white_king(ptree, from, idirec) > 0))
				do {
					to = bitop.FirstOne(bb_desti);
					bitop.Xor(to, bb_desti);
					ptree.amove[moveidx++] = (bitop.To2Move(to)
							| bitop.From2Move(from)
							| bitop.Piece2Move(def.horse) | bitop
							.Cap2Move(ptree.posi.asquare[to]));
				} while (bitop.BBTest(bb_desti));
		}

		bb_piece = new bitboard_t(ptree.posi.w_dragon);
		while (bitop.BBTest(bb_piece)) {
			from = bitop.FirstOne(bb_piece);
			bitop.Xor(from, bb_piece);

			bitop.AttackDragon(bb_desti, from, ptree);
			bitop.BBAnd(bb_desti, bb_desti, bb_target);
			if (!bitop.BBTest(bb_desti)) {
				continue;
			}

			idirec = (int) data.adirec[sq_wk][from];
			if (!(idirec > 0)
					|| !(attack.is_pinned_on_white_king(ptree, from, idirec) > 0))
				do {
					to = bitop.FirstOne(bb_desti);
					bitop.Xor(to, bb_desti);
					ptree.amove[moveidx++] = (bitop.To2Move(to)
							| bitop.From2Move(from)
							| bitop.Piece2Move(def.dragon) | bitop
							.Cap2Move(ptree.posi.asquare[to]));
				} while (bitop.BBTest(bb_desti));
		}

		if (!(ptree.posi.hand_white > 0)) {
			return moveidx;
		}
		if (!bitop.BBTest(bb_inter)) {
			return moveidx;
		}

		/* drop */
		bb_target = bb_inter;
		ubb_target2a = bb_target.p[2] & 0x00001ff;
		ubb_target2b = bb_target.p[2] & 0x003fe00;
		bb_target.p[0] &= 0x7ffffff;
		bb_target.p[1] &= 0x7ffffff;
		bb_target.p[2] &= 0x7fc0000;

		hand = ptree.posi.hand_white;
		nhand = 0;
		if (bitop.IsHandKnight(hand) > 0) {
			ahand[nhand++] = bitop.Drop2Move(def.knight);
		}
		noknight = nhand;
		if (bitop.IsHandLance(hand) > 0) {
			ahand[nhand++] = bitop.Drop2Move(def.lance);
		}
		nolance = nhand;
		if (bitop.IsHandSilver(hand) > 0) {
			ahand[nhand++] = bitop.Drop2Move(def.silver);
		}
		if (bitop.IsHandGold(hand) > 0) {
			ahand[nhand++] = bitop.Drop2Move(def.gold);
		}
		if (bitop.IsHandBishop(hand) > 0) {
			ahand[nhand++] = bitop.Drop2Move(def.bishop);
		}
		if (bitop.IsHandRook(hand) > 0) {
			ahand[nhand++] = bitop.Drop2Move(def.rook);
		}

		if (bitop.IsHandPawn(hand) > 0) {
			ubb_pawn_cmp = bitop.BBToU(ptree.posi.w_pawn_attacks);
			ais_pawn[0] = ubb_pawn_cmp & (def.mask_file1 >> 0);
			ais_pawn[1] = ubb_pawn_cmp & (def.mask_file1 >> 1);
			ais_pawn[2] = ubb_pawn_cmp & (def.mask_file1 >> 2);
			ais_pawn[3] = ubb_pawn_cmp & (def.mask_file1 >> 3);
			ais_pawn[4] = ubb_pawn_cmp & (def.mask_file1 >> 4);
			ais_pawn[5] = ubb_pawn_cmp & (def.mask_file1 >> 5);
			ais_pawn[6] = ubb_pawn_cmp & (def.mask_file1 >> 6);
			ais_pawn[7] = ubb_pawn_cmp & (def.mask_file1 >> 7);
			ais_pawn[8] = ubb_pawn_cmp & (def.mask_file1 >> 8);

			while (bitop.BBTest(bb_target)) {
				to = bitop.FirstOne(bb_target);
				utemp = bitop.To2Move(to);
				if (!(ais_pawn[def.aifile[to]] > 0)
						&& !bitop.IsMateWPawnDrop(ptree, to)) {
					ptree.amove[moveidx++] = utemp | bitop.Drop2Move(def.pawn);
				}
				for (i = 0; i < nhand; i++) {
					ptree.amove[moveidx++] = utemp | ahand[i];
				}
				bitop.Xor(to, bb_target);
			}

			while (ubb_target2b > 0) {
				to = bitop.first_one2(ubb_target2b);
				utemp = bitop.To2Move(to);
				if (!(ais_pawn[def.aifile[to]] > 0)
						&& !bitop.IsMateWPawnDrop(ptree, to)) {
					ptree.amove[moveidx++] = utemp | bitop.Drop2Move(def.pawn);
				}
				for (i = noknight; i < nhand; i++) {
					ptree.amove[moveidx++] = utemp | ahand[i];
				}
				ubb_target2b ^= data.abb_mask[to].p[2];
			}
		} else {
			while (bitop.BBTest(bb_target)) {
				to = bitop.FirstOne(bb_target);
				utemp = bitop.To2Move(to);
				for (i = 0; i < nhand; i++) {
					ptree.amove[moveidx++] = utemp | ahand[i];
				}
				bitop.Xor(to, bb_target);
			}

			while (ubb_target2b > 0) {
				to = bitop.first_one2(ubb_target2b);
				utemp = bitop.To2Move(to);
				for (i = noknight; i < nhand; i++) {
					ptree.amove[moveidx++] = utemp | ahand[i];
				}
				ubb_target2b ^= data.abb_mask[to].p[2];
			}
		}

		while (ubb_target2a > 0) {
			to = bitop.first_one2(ubb_target2a);
			utemp = bitop.To2Move(to);
			for (i = nolance; i < nhand; i++) {
				ptree.amove[moveidx++] = utemp | ahand[i];
			}
			ubb_target2a ^= data.abb_mask[to].p[2];
		}

		return moveidx;
	}

	public static int b_have_evasion(tree_t ptree) {
		bitboard_t bb_desti = new bitboard_t(), bb_checker = new bitboard_t(), bb_inter = new bitboard_t(), bb_target = new bitboard_t(), bb_piece = new bitboard_t();
		int ubb_pawn_cmp;
		int[] ais_pawn = new int[def.nfile];
		int nchecker, sq_bk, to, sq_check, idirec, flag, from;

		/* move the king */
		flag = 0;
		sq_bk = ptree.posi.isquare_b_king;

		bitop.Xor(sq_bk, ptree.posi.b_occupied);
		bitop.XorFile(sq_bk, ptree.posi.occupied_rl90);
		bitop.XorDiag2(sq_bk, ptree.posi.occupied_rl45);
		bitop.XorDiag1(sq_bk, ptree.posi.occupied_rr45);

		bitop.BBNotAnd(bb_desti, data.abb_king_attacks[sq_bk],
				ptree.posi.b_occupied);

		while (bitop.BBTest(bb_desti)) {
			to = bitop.LastOne(bb_desti);
			bitop.Xor(to, bb_desti);

			if (!attack.is_black_attacked(ptree, to)) {
				flag = 1;
				break;
			}
		}

		bitop.Xor(sq_bk, ptree.posi.b_occupied);
		bitop.XorFile(sq_bk, ptree.posi.occupied_rl90);
		bitop.XorDiag2(sq_bk, ptree.posi.occupied_rl45);
		bitop.XorDiag1(sq_bk, ptree.posi.occupied_rr45);

		if (flag > 0) {
			return 1;
		}

		bb_checker = attack.w_attacks_to_piece(ptree, sq_bk);
		nchecker = bitop.PopuCount(bb_checker);
		if (nchecker == 2) {
			return 0;
		}

		sq_check = bitop.LastOne(bb_checker);
		bb_inter = data.abb_obstacle[sq_bk][sq_check];

		/* move other pieces */
		bitop.BBOr(bb_target, bb_inter, bb_checker);

		bitop.BBAnd(bb_desti, bb_target, ptree.posi.b_pawn_attacks);
		while (bitop.BBTest(bb_desti)) {
			to = bitop.LastOne(bb_desti);
			bitop.Xor(to, bb_desti);

			from = to + 9;
			idirec = (int) data.adirec[sq_bk][from];
			if (!(idirec > 0)
					|| !(attack.is_pinned_on_black_king(ptree, from, idirec) > 0)) {
				return 1;
			}
		}

		bb_piece = ptree.posi.b_lance;
		while (bitop.BBTest(bb_piece)) {
			from = bitop.LastOne(bb_piece);
			bitop.Xor(from, bb_piece);

			bb_desti = bitop.AttackFile(from, ptree);
			bitop.BBAnd(bb_desti, bb_desti, data.abb_minus_rays[from]);
			bitop.BBAnd(bb_desti, bb_desti, bb_target);
			if (!bitop.BBTest(bb_desti)) {
				continue;
			}

			idirec = (int) data.adirec[sq_bk][from];
			if (!(idirec > 0)
					|| !(attack.is_pinned_on_black_king(ptree, from, idirec) > 0)) {
				return 1;
			}
		}

		bb_piece = ptree.posi.b_knight;
		while (bitop.BBTest(bb_piece)) {
			from = bitop.LastOne(bb_piece);
			bitop.Xor(from, bb_piece);

			bitop.BBAnd(bb_desti, bb_target, data.abb_b_knight_attacks[from]);
			if (!bitop.BBTest(bb_desti)) {
				continue;
			}

			idirec = (int) data.adirec[sq_bk][from];
			if (!(idirec > 0)
					|| !(attack.is_pinned_on_black_king(ptree, from, idirec) > 0)) {
				return 1;
			}
		}

		bb_piece = ptree.posi.b_silver;
		while (bitop.BBTest(bb_piece)) {
			from = bitop.LastOne(bb_piece);
			bitop.Xor(from, bb_piece);

			bitop.BBAnd(bb_desti, bb_target, data.abb_b_silver_attacks[from]);
			if (!bitop.BBTest(bb_desti)) {
				continue;
			}

			idirec = (int) data.adirec[sq_bk][from];
			if (!(idirec > 0)
					|| !(attack.is_pinned_on_black_king(ptree, from, idirec) > 0)) {
				return 1;
			}
		}

		bb_piece = ptree.posi.b_tgold;
		while (bitop.BBTest(bb_piece)) {
			from = bitop.LastOne(bb_piece);
			bitop.Xor(from, bb_piece);

			bitop.BBAnd(bb_desti, bb_target, data.abb_b_gold_attacks[from]);
			if (!bitop.BBTest(bb_desti)) {
				continue;
			}

			idirec = (int) data.adirec[sq_bk][from];
			if (!(idirec > 0)
					|| !(attack.is_pinned_on_black_king(ptree, from, idirec) > 0)) {
				return 1;
			}
		}

		bb_piece = ptree.posi.b_bishop;
		while (bitop.BBTest(bb_piece)) {
			from = bitop.LastOne(bb_piece);
			bitop.Xor(from, bb_piece);

			bitop.AttackBishop(bb_desti, from, ptree);
			bitop.BBAnd(bb_desti, bb_desti, bb_target);
			if (!bitop.BBTest(bb_desti)) {
				continue;
			}

			idirec = (int) data.adirec[sq_bk][from];
			if (!(idirec > 0)
					|| !(attack.is_pinned_on_black_king(ptree, from, idirec) > 0)) {
				return 1;
			}
		}

		bb_piece = ptree.posi.b_rook;
		while (bitop.BBTest(bb_piece)) {
			from = bitop.LastOne(bb_piece);
			bitop.Xor(from, bb_piece);

			bitop.AttackRook(bb_desti, from, ptree);
			bitop.BBAnd(bb_desti, bb_desti, bb_target);
			if (!bitop.BBTest(bb_desti)) {
				continue;
			}

			idirec = (int) data.adirec[sq_bk][from];
			if (!(idirec > 0)
					|| !(attack.is_pinned_on_black_king(ptree, from, idirec) > 0)) {
				return 1;
			}
		}

		bb_piece = ptree.posi.b_horse;
		while (bitop.BBTest(bb_piece)) {
			from = bitop.LastOne(bb_piece);
			bitop.Xor(from, bb_piece);

			bitop.AttackHorse(bb_desti, from, ptree);
			bitop.BBAnd(bb_desti, bb_desti, bb_target);
			if (!bitop.BBTest(bb_desti)) {
				continue;
			}

			idirec = (int) data.adirec[sq_bk][from];
			if (!(idirec > 0)
					|| !(attack.is_pinned_on_black_king(ptree, from, idirec) > 0)) {
				return 1;
			}
		}

		bb_piece = ptree.posi.b_dragon;
		while (bitop.BBTest(bb_piece)) {
			from = bitop.LastOne(bb_piece);
			bitop.Xor(from, bb_piece);

			bitop.AttackDragon(bb_desti, from, ptree);
			bitop.BBAnd(bb_desti, bb_desti, bb_target);
			if (!bitop.BBTest(bb_desti)) {
				continue;
			}

			idirec = (int) data.adirec[sq_bk][from];
			if (!(idirec > 0)
					|| !(attack.is_pinned_on_black_king(ptree, from, idirec) > 0)) {
				return 1;
			}
		}

		/* drops */
		if (!bitop.BBTest(bb_inter)) {
			return 0;
		}

		if (bitop.IsHandSGBR(ptree.posi.hand_black) > 0) {
			return 1;
		}

		bb_inter.p[0] &= 0x003ffff;
		if (!bitop.BBTest(bb_inter)) {
			return 0;
		}

		if (bitop.IsHandLance(ptree.posi.hand_black) > 0) {
			return 1;
		}

		if (bitop.IsHandKnight(ptree.posi.hand_black) > 0) {
			bb_target = bb_inter;
			bb_target.p[0] &= 0x00001ff;
			if (bitop.BBTest(bb_target)) {
				return 1;
			}
		}

		if (bitop.IsHandPawn(ptree.posi.hand_black) > 0) {
			bb_target = bb_inter;
			ubb_pawn_cmp = bitop.BBToU(ptree.posi.b_pawn_attacks);
			ais_pawn[0] = ubb_pawn_cmp & (def.mask_file1 >> 0);
			ais_pawn[1] = ubb_pawn_cmp & (def.mask_file1 >> 1);
			ais_pawn[2] = ubb_pawn_cmp & (def.mask_file1 >> 2);
			ais_pawn[3] = ubb_pawn_cmp & (def.mask_file1 >> 3);
			ais_pawn[4] = ubb_pawn_cmp & (def.mask_file1 >> 4);
			ais_pawn[5] = ubb_pawn_cmp & (def.mask_file1 >> 5);
			ais_pawn[6] = ubb_pawn_cmp & (def.mask_file1 >> 6);
			ais_pawn[7] = ubb_pawn_cmp & (def.mask_file1 >> 7);
			ais_pawn[8] = ubb_pawn_cmp & (def.mask_file1 >> 8);

			while (bitop.BBTest(bb_target)) {
				to = bitop.LastOne(bb_target);
				bitop.Xor(to, bb_target);

				if (!(ais_pawn[def.aifile[to]] > 0)
						&& !bitop.IsMateBPawnDrop(ptree, to)) {
					return 1;
				}
			}
		}

		return 0;
	}

	public static int w_have_evasion(tree_t ptree) {
		bitboard_t bb_desti = new bitboard_t(), bb_checker = new bitboard_t(), bb_inter = new bitboard_t(), bb_target = new bitboard_t(), bb_piece = new bitboard_t();
		int ubb_pawn_cmp;
		int[] ais_pawn = new int[def.nfile];
		int nchecker, sq_wk, to, sq_check, idirec, flag, from;

		/* move the king */
		flag = 0;
		sq_wk = ptree.posi.isquare_w_king;

		bitop.Xor(sq_wk, ptree.posi.w_occupied);
		bitop.XorFile(sq_wk, ptree.posi.occupied_rl90);
		bitop.XorDiag2(sq_wk, ptree.posi.occupied_rl45);
		bitop.XorDiag1(sq_wk, ptree.posi.occupied_rr45);

		bitop.BBNotAnd(bb_desti, data.abb_king_attacks[sq_wk],
				ptree.posi.w_occupied);
		while (bitop.BBTest(bb_desti)) {
			to = bitop.FirstOne(bb_desti);
			bitop.Xor(to, bb_desti);

			if (!attack.is_white_attacked(ptree, to)) {
				flag = 1;
				break;
			}
		}

		bitop.Xor(sq_wk, ptree.posi.w_occupied);
		bitop.XorFile(sq_wk, ptree.posi.occupied_rl90);
		bitop.XorDiag2(sq_wk, ptree.posi.occupied_rl45);
		bitop.XorDiag1(sq_wk, ptree.posi.occupied_rr45);

		if (flag > 0) {
			return 1;
		}

		bb_checker = attack.b_attacks_to_piece(ptree, sq_wk);
		nchecker = bitop.PopuCount(bb_checker);
		if (nchecker == 2) {
			return 0;
		}

		sq_check = bitop.FirstOne(bb_checker);
		bb_inter = data.abb_obstacle[sq_wk][sq_check];

		/* move other pieces */
		bitop.BBOr(bb_target, bb_inter, bb_checker);

		bitop.BBAnd(bb_desti, bb_target, ptree.posi.w_pawn_attacks);
		while (bitop.BBTest(bb_desti)) {
			to = bitop.FirstOne(bb_desti);
			bitop.Xor(to, bb_desti);

			from = to - 9;
			idirec = (int) data.adirec[sq_wk][from];
			if (!(idirec > 0)
					|| !(attack.is_pinned_on_white_king(ptree, from, idirec) > 0)) {
				return 1;
			}
		}

		bb_piece = ptree.posi.w_lance;
		while (bitop.BBTest(bb_piece)) {
			from = bitop.FirstOne(bb_piece);
			bitop.Xor(from, bb_piece);

			bb_desti = bitop.AttackFile(from, ptree);
			bitop.BBAnd(bb_desti, bb_desti, data.abb_plus_rays[from]);
			bitop.BBAnd(bb_desti, bb_desti, bb_target);
			if (!bitop.BBTest(bb_desti)) {
				continue;
			}

			idirec = (int) data.adirec[sq_wk][from];
			if (!(idirec > 0)
					|| !(attack.is_pinned_on_white_king(ptree, from, idirec) > 0)) {
				return 1;
			}
		}

		bb_piece = ptree.posi.w_knight;
		while (bitop.BBTest(bb_piece)) {
			from = bitop.FirstOne(bb_piece);
			bitop.Xor(from, bb_piece);

			bitop.BBAnd(bb_desti, bb_target, data.abb_w_knight_attacks[from]);
			if (!bitop.BBTest(bb_desti)) {
				continue;
			}

			idirec = (int) data.adirec[sq_wk][from];
			if (!(idirec > 0)
					|| !(attack.is_pinned_on_white_king(ptree, from, idirec) > 0)) {
				return 1;
			}
		}

		bb_piece = ptree.posi.w_silver;
		while (bitop.BBTest(bb_piece)) {
			from = bitop.FirstOne(bb_piece);
			bitop.Xor(from, bb_piece);

			bitop.BBAnd(bb_desti, bb_target, data.abb_w_silver_attacks[from]);
			if (!bitop.BBTest(bb_desti)) {
				continue;
			}

			idirec = (int) data.adirec[sq_wk][from];
			if (!(idirec > 0)
					|| !(attack.is_pinned_on_white_king(ptree, from, idirec) > 0)) {
				return 1;
			}
		}

		bb_piece = ptree.posi.w_tgold;
		while (bitop.BBTest(bb_piece)) {
			from = bitop.FirstOne(bb_piece);
			bitop.Xor(from, bb_piece);

			bitop.BBAnd(bb_desti, bb_target, data.abb_w_gold_attacks[from]);
			if (!bitop.BBTest(bb_desti)) {
				continue;
			}

			idirec = (int) data.adirec[sq_wk][from];
			if (!(idirec > 0)
					|| !(attack.is_pinned_on_white_king(ptree, from, idirec) > 0)) {
				return 1;
			}
		}

		bb_piece = ptree.posi.w_bishop;
		while (bitop.BBTest(bb_piece)) {
			from = bitop.FirstOne(bb_piece);
			bitop.Xor(from, bb_piece);

			bitop.AttackBishop(bb_desti, from, ptree);
			bitop.BBAnd(bb_desti, bb_desti, bb_target);
			if (!bitop.BBTest(bb_desti)) {
				continue;
			}

			idirec = (int) data.adirec[sq_wk][from];
			if (!(idirec > 0)
					|| !(attack.is_pinned_on_white_king(ptree, from, idirec) > 0)) {
				return 1;
			}
		}

		bb_piece = ptree.posi.w_rook;
		while (bitop.BBTest(bb_piece)) {
			from = bitop.FirstOne(bb_piece);
			bitop.Xor(from, bb_piece);

			bitop.AttackRook(bb_desti, from, ptree);
			bitop.BBAnd(bb_desti, bb_desti, bb_target);
			if (!bitop.BBTest(bb_desti)) {
				continue;
			}

			idirec = (int) data.adirec[sq_wk][from];
			if (!(idirec > 0)
					|| !(attack.is_pinned_on_white_king(ptree, from, idirec) > 0)) {
				return 1;
			}
		}

		bb_piece = ptree.posi.w_horse;
		while (bitop.BBTest(bb_piece)) {
			from = bitop.FirstOne(bb_piece);
			bitop.Xor(from, bb_piece);

			bitop.AttackHorse(bb_desti, from, ptree);
			bitop.BBAnd(bb_desti, bb_desti, bb_target);
			if (!bitop.BBTest(bb_desti)) {
				continue;
			}

			idirec = (int) data.adirec[sq_wk][from];
			if (!(idirec > 0)
					|| !(attack.is_pinned_on_white_king(ptree, from, idirec) > 0)) {
				return 1;
			}
		}

		bb_piece = ptree.posi.w_dragon;
		while (bitop.BBTest(bb_piece)) {
			from = bitop.FirstOne(bb_piece);
			bitop.Xor(from, bb_piece);

			bitop.AttackDragon(bb_desti, from, ptree);
			bitop.BBAnd(bb_desti, bb_desti, bb_target);
			if (!bitop.BBTest(bb_desti)) {
				continue;
			}

			idirec = (int) data.adirec[sq_wk][from];
			if (!(idirec > 0)
					|| !(attack.is_pinned_on_white_king(ptree, from, idirec) > 0)) {
				return 1;
			}
		}

		/* drop */
		if (!bitop.BBTest(bb_inter)) {
			return 0;
		}

		if (bitop.IsHandSGBR(ptree.posi.hand_white) > 0) {
			return 1;
		}

		bb_inter.p[2] &= 0x7fffe00;
		if (!bitop.BBTest(bb_inter)) {
			return 0;
		}

		if (bitop.IsHandLance(ptree.posi.hand_white) > 0) {
			return 1;
		}

		if (bitop.IsHandKnight(ptree.posi.hand_white) > 0) {
			bb_target = bb_inter;
			bb_target.p[2] &= 0x7fc0000;
			if (bitop.BBTest(bb_target)) {
				return 1;
			}
		}

		if (bitop.IsHandPawn(ptree.posi.hand_white) > 0) {
			bb_target = bb_inter;
			ubb_pawn_cmp = bitop.BBToU(ptree.posi.w_pawn_attacks);
			ais_pawn[0] = ubb_pawn_cmp & (def.mask_file1 >> 0);
			ais_pawn[1] = ubb_pawn_cmp & (def.mask_file1 >> 1);
			ais_pawn[2] = ubb_pawn_cmp & (def.mask_file1 >> 2);
			ais_pawn[3] = ubb_pawn_cmp & (def.mask_file1 >> 3);
			ais_pawn[4] = ubb_pawn_cmp & (def.mask_file1 >> 4);
			ais_pawn[5] = ubb_pawn_cmp & (def.mask_file1 >> 5);
			ais_pawn[6] = ubb_pawn_cmp & (def.mask_file1 >> 6);
			ais_pawn[7] = ubb_pawn_cmp & (def.mask_file1 >> 7);
			ais_pawn[8] = ubb_pawn_cmp & (def.mask_file1 >> 8);

			while (bitop.BBTest(bb_target)) {
				to = bitop.FirstOne(bb_target);
				bitop.Xor(to, bb_target);

				if (!(ais_pawn[def.aifile[to]] > 0)
						&& !bitop.IsMateWPawnDrop(ptree, to)) {
					return 1;
				}
			}
		}

		return 0;
	}

}
