public class bitop {

	public static final int I2HandPawn(int hand) {
		return (((hand) >> 0) & 0x1f);
	}

	public static final int I2HandLance(int hand) {
		return (((hand) >> 5) & 0x07);
	}

	public static final int I2HandKnight(int hand) {
		return (((hand) >> 8) & 0x07);
	}

	public static final int I2HandSilver(int hand) {
		return (((hand) >> 11) & 0x07);
	}

	public static final int I2HandGold(int hand) {
		return (((hand) >> 14) & 0x07);
	}

	public static final int I2HandBishop(int hand) {
		return (((hand) >> 17) & 0x03);
	}

	public static final int I2HandRook(int hand) {
		return ((hand) >> 19);
	}

	public static final int I2PieceMove(int move) {
		return (((move) >> 15) & 0x000f);
	}

	public static final boolean IsMove(int move) {
		return ((move) & 0xffffff) > 0;
	}

	public static final boolean IsDiscoverWK(int from, int to, tree_t ptree) {
		int idirec = (int) data.adirec[ptree.posi.isquare_w_king][from];
		return (idirec > 0
				&& (idirec != (int) data.adirec[ptree.posi.isquare_w_king][to]) && attack
				.is_pinned_on_white_king(ptree, from, idirec) > 0);
	}

	public static final int IsHandPawn(int hand) {
		return ((hand) & 0x000001f);
	}

	public static final int IsHandLance(int hand) {
		return ((hand) & 0x00000e0);
	}

	public static final int IsHandKnight(int hand) {
		return ((hand) & 0x0000700);
	}

	public static final int IsHandSilver(int hand) {
		return ((hand) & 0x0003800);
	}

	public static final int IsHandGold(int hand) {
		return ((hand) & 0x001c000);
	}

	public static final int IsHandBishop(int hand) {
		return ((hand) & 0x0060000);
	}

	public static final int IsHandRook(int hand) {
		return ((hand) & 0x0180000);
	}

	public static final int IsHandSGBR(int hand) {
		return ((hand) & 0x01ff800);
	}

	public static final int BBToU(bitboard_t b) {
		return ((b).p[0] | (b).p[1] | (b).p[2]);
	}

	public static final int BBToUShift(bitboard_t b) {
		return ((b).p[0] << 2 | (b).p[1] << 1 | (b).p[2]);
	}

	public static int GenNoCaptures(int turn, int moveidx, tree_t ptree) {
		if (turn > 0) {
			return gennocap.w_gen_nocaptures(ptree, moveidx);
		} else {
			return gennocap.b_gen_nocaptures(ptree, moveidx);
		}
	}

	public static int GenDrop(int turn, int moveidx, tree_t ptree) {
		if (turn > 0)
			return gendrop.w_gen_drop(ptree, moveidx);
		else
			return gendrop.b_gen_drop(ptree, moveidx);
	}
	
	public static int IsMoveCheck( tree_t ptree, int turn, int move ){
        if (turn > 0) return attack.is_move_check_w( ptree, move );
        else return attack.is_move_check_b( ptree, move );
	}

	public static int GenCaptures(int turn, int moveidx, tree_t ptree) {
		if (turn > 0) {
			return gencap.w_gen_captures(ptree, moveidx);
		} else {
			return gencap.b_gen_captures(ptree, moveidx);
		}
	}

	public static int GenEvasion(int turn, int pmove, tree_t ptree) {
		if (turn > 0) {
			return genevasn.w_gen_evasion(ptree, pmove);
		} else {
			return genevasn.b_gen_evasion(ptree, pmove);
		}
	}

	public static final int To2Move(int to) {
		return to << 0;
	} // ړ恨wɕϊ

	public static final int From2Move(int from) {
		return from << 7;
	} // ړwɕϊ

	public static final int Drop2Move(int piece) {
		return ((def.nsquare - 1 + (piece)) << 7);
	} // (ړ)wɕϊ

	public static final int Drop2From(int piece) {
		return (def.nsquare - 1 + (piece));
	} // ()ړɕϊ

	public static final int FLAG_PROMO() {
		return (1 << 14);
	}

	public static final int Piece2Move(int piece) {
		return ((piece) << 15);
	} // ̎ށwɕϊB Piece͐̋ʂȂ̂Ő̒lnKvB

	public static final int Cap2Move(int piece) {
		return ((piece) << 19);
	} // ̎ށwɕϊBPiece͐̋ʂȂ̂Ő̒lnKvB

	public static final int I2To(int move) {
		return (((move) >> 0) & 0x007f);
	}

	public static final int I2From(int move) {
		return (((move) >> 7) & 0x007f);
	}

	public static final int I2FromTo(int move) {
		return (((move) >> 0) & 0x3fff);
	}

	public static final int I2IsPromote(int move) {
		return ((move) & def.FLAG_PROMO);
	}

	public static final int UToFromToPromo(int u) {
		return ((u) & 0x7ffff);
	}

	public static final int UToCap(int u) {
		return (((u) >> 19) & 0x000f);
	}

	public static final int From2Drop(int from) {
		return ((from) - def.nsquare + 1);
	} // ړ(Move.From)ł ϊ

	public static boolean BBTest(bitboard_t bb) {
		return bb.p[0] > 0 || bb.p[1] > 0 || bb.p[2] > 0;
	}

	public static int GenCheck(int turn, tree_t ptree, int[] pmove, int moveidx) {
		if (turn > 0) {
			return genchk.w_gen_checks(ptree, pmove, moveidx);
		} else {
			return genchk.b_gen_checks(ptree, pmove, moveidx);
		}
	}

	public static int NullDepth(int d) {
		return ((d) < def.PLY_INC * 26 / 4 ? (d) - def.PLY_INC * 12 / 4
				: ((d) <= def.PLY_INC * 30 / 4 ? def.PLY_INC * 14 / 4 : (d)
						- def.PLY_INC * 16 / 4));
	}

	public static int RecursionDepth(int d) {
		return ((d) < def.PLY_INC * 18 / 4 ? def.PLY_INC * 6 / 4 : (d)
				- def.PLY_INC * 12 / 4);
	}

	public static void SetClear(bitboard_t b, bitboard_t bb_set_clear) {
		(b).p[0] ^= (bb_set_clear.p[0]);
		(b).p[1] ^= (bb_set_clear.p[1]);
		(b).p[2] ^= (bb_set_clear.p[2]);
	}

	public static void SetClearFile(int sq1, int sq2, bitboard_t b) {
		(b).p[0] ^= (data.abb_mask_rl90[sq1].p[0] | data.abb_mask_rl90[sq2].p[0]);
		(b).p[1] ^= (data.abb_mask_rl90[sq1].p[1] | data.abb_mask_rl90[sq2].p[1]);
		(b).p[2] ^= (data.abb_mask_rl90[sq1].p[2] | data.abb_mask_rl90[sq2].p[2]);
	}

	public static void SetClearDiag1(int sq1, int sq2, bitboard_t b) {
		(b).p[0] ^= ((data.abb_mask_rr45[sq1].p[0]) | (data.abb_mask_rr45[sq2].p[0]));
		(b).p[1] ^= ((data.abb_mask_rr45[sq1].p[1]) | (data.abb_mask_rr45[sq2].p[1]));
		(b).p[2] ^= ((data.abb_mask_rr45[sq1].p[2]) | (data.abb_mask_rr45[sq2].p[2]));
	}

	public static void SetClearDiag2(int sq1, int sq2, bitboard_t b) {
		(b).p[0] ^= ((data.abb_mask_rl45[sq1].p[0]) | (data.abb_mask_rl45[sq2].p[0]));
		(b).p[1] ^= ((data.abb_mask_rl45[sq1].p[1]) | (data.abb_mask_rl45[sq2].p[1]));
		(b).p[2] ^= ((data.abb_mask_rl45[sq1].p[2]) | (data.abb_mask_rl45[sq2].p[2]));
	}

	public static void MakeMove(tree_t ptree, int turn, int move, int ply) {
		if (turn > 0) {
			makemove.make_move_w(ptree, move, ply);
		} else {
			makemove.make_move_b(ptree, move, ply);
		}
	}

	public static boolean IsMateIn1Ply(int turn, tree_t ptree) {
		if (turn > 0) {
			return mate1ply.is_w_mate_in_1ply(ptree) > 0;
		} else {
			return mate1ply.is_b_mate_in_1ply(ptree);
		}

	}

	public static final int Flip(int turn) {
		return turn ^ 1;
	}

	public static void UnMakeMove(tree_t ptree, int turn, int move, int ply) {
		if (turn > 0) {
			unmake.unmake_move_w(ptree, move, ply);
		} else {
			unmake.unmake_move_b(ptree, move, ply);
		}
	}

	public static boolean InCheck(int turn, tree_t ptree) {
		if (turn > 0) {
			return attack.is_white_attacked(ptree, ptree.posi.isquare_w_king);
		} else {
			return attack.is_black_attacked(ptree, ptree.posi.isquare_b_king);
		}
	}

	public static boolean IsMateBPawnDrop(tree_t ptree, int to) {
		return (ptree.posi.asquare[(to) - 9] == -def.king && attack
				.is_mate_b_pawn_drop(ptree, to) > 0);
	}

	public static boolean IsMateWPawnDrop(tree_t ptree, int to) {
		return (ptree.posi.asquare[(to) + 9] == def.king && attack
				.is_mate_w_pawn_drop(ptree, to) > 0);
	}

	public static bitboard_t AttackFile(int i, tree_t ptree) {
		return data.abb_file_attacks[i][((ptree.posi.occupied_rl90.p[data.aslide[i].irl90]) >> data.aslide[i].srl90) & 0x7f];
	}

	public static bitboard_t AttackRank(int i, tree_t ptree) {
		return data.abb_rank_attacks[i][((ptree.posi.b_occupied.p[data.aslide[i].ir0] | ptree.posi.w_occupied.p[data.aslide[i].ir0]) >> data.aslide[i].sr0) & 0x7f];
	}

	public static bitboard_t AttackDiag1(int i, tree_t ptree) {
		return data.abb_bishop_attacks_rr45[i][((ptree.posi.occupied_rr45.p[data.aslide[i].irr45]) >> data.aslide[i].srr45) & 0x7f];
	}

	public static bitboard_t AttackDiag2(int i, tree_t ptree) {
		return data.abb_bishop_attacks_rl45[i][((ptree.posi.occupied_rl45.p[data.aslide[i].irl45]) >> data.aslide[i].srl45) & 0x7f];
	}

	public static void AttackDragon(bitboard_t bb, int i, tree_t ptree) {
		AttackRook(bb, i, ptree);
		BBOr(bb, bb, data.abb_king_attacks[i]);
	}

	public static void AttackRook(bitboard_t bb, int i, tree_t ptree) {
		BBOr(bb, AttackFile(i, ptree), AttackRank(i, ptree));
	}

	public static void AttackHorse(bitboard_t bb, int i, tree_t ptree) {
		AttackBishop(bb, i, ptree);
		BBOr(bb, bb, data.abb_king_attacks[i]);
	}

	public static void AttackBishop(bitboard_t bb, int i, tree_t ptree) {
		BBOr(bb, AttackDiag1(i, ptree), AttackDiag2(i, ptree));
	}
	
	public static void AttackBLance(bitboard_t bb,int i, tree_t ptree){
		BBAnd( bb, data.abb_minus_rays[i], bitop.AttackFile(i, ptree) );
	}
	public static void AttackWLance(bitboard_t bb,int i, tree_t ptree){
		BBAnd( bb, data.abb_plus_rays[i], bitop.AttackFile(i, ptree) );
	}

	public static boolean IsDiscoverBK(int from, int to, tree_t ptree) {
		int idirec = (int) data.adirec[ptree.posi.isquare_b_king][from];
		return idirec > 0
				&& (idirec != (int) data.adirec[ptree.posi.isquare_b_king][to])
				&& attack.is_pinned_on_black_king(ptree, from, idirec) > 0;
	}

	public static int FirstOne(bitboard_t bb) {
		int index;

		if (bb.p[0] > 0) {
			index = Integer.highestOneBit(bb.p[0]);
			return 26 - getPos(index);
		}

		if (bb.p[1] > 0) {
			index = Integer.highestOneBit(bb.p[1]);
			return 53 - getPos(index);
		}
		index = Integer.highestOneBit(bb.p[2]);
		return 80 - getPos(index);
	}

	public static int first_one01(int u0, int u1) {
		int index;

		if (u0 > 0) {
			index = Integer.highestOneBit(u0);
			return 26 - getPos(index);
		}
		index = Integer.highestOneBit(u1);
		return 53 - getPos(index);

	}

	public static int first_one12(int u1, int u2) {
		int index;
		if (u1 > 0) {
			index = Integer.highestOneBit(u1);
			return 53 - getPos(index);
		}
		index = Integer.highestOneBit(u2);
		return 80 - getPos(index);

	}

	public static int first_one1(int u1) {
		int index;
		index = Integer.highestOneBit(u1);
		return 53 - getPos(index);
	}

	public static int first_one2(int u2) {
		int index;
		index = Integer.highestOneBit(u2);
		return 80 - getPos(index);
	}

	public static int LastOne(bitboard_t bb) {
		int index;
		if (bb.p[2] > 0) {
			index = Integer.lowestOneBit(bb.p[2]);
			return 80 - getPos(index);
		}
		if (bb.p[1] > 0) {
			index = Integer.lowestOneBit(bb.p[1]);
			return 53 - getPos(index);
		}
		index = Integer.lowestOneBit(bb.p[0]);
		return 26 - getPos(index);
	}

	public static int last_one1(int u1) {
		int index;
		index = Integer.lowestOneBit(u1);
		return 53 - getPos(index);
	}

	public static int last_one12(int u1, int u2) {
		int index;
		if (u2 > 0) {
			index = Integer.lowestOneBit(u2);
			return 80 - getPos(index);
		}
		index = Integer.lowestOneBit(u1);
		return 53 - getPos(index);
	}

	public static int last_one01(int u0, int u1) {
		int index;
		if (u1 > 0) {
			index = Integer.lowestOneBit(u1);
			return 53 - getPos(index);
		}
		index = Integer.lowestOneBit(u0);
		return 26 - getPos(index);
	}

	public static int last_one0(int u0) {
		int index;
		index = Integer.lowestOneBit(u0);
		return 26 - getPos(index);
	}

	public static int Inv(int sq) {
		return def.nsquare - 1 - sq;
	}

	public static int PcOnSq(int k, int i) {
		return data.pc_on_sq[k][(i) * ((i) + 3) / 2];
	}

	public static int PcPcOnSq(int k, int i, int j) {
		return data.pc_on_sq[k][(i) * ((i) + 1) / 2 + (j)];
	}

	public static int PcPcOnSqAny(int k, int i, int j) {
		return (i >= j ? PcPcOnSq(k, i, j) : PcPcOnSq(k, j, i));
	}

	/**
	 * Ărbg̈ʒuԂB TODO:[v27̂,̂mapɓƂƂBo(1)
	 * 
	 * @param p
	 * @return
	 */
	public static final int getPos(int p) {
		int idx = 0;
		while (true) {
			if (p == 1 << idx) {
				return idx;
			}
			idx++;
		}
	}

	public static final void BBIni(bitboard_t b) {
		b.p[0] = 0;
		b.p[1] = 0;
		b.p[2] = 0;
	}

	public static final void BBAnd(bitboard_t b, bitboard_t b1, bitboard_t b2) {
		b.p[0] = b1.p[0] & b2.p[0];
		b.p[1] = b1.p[1] & b2.p[1];
		b.p[2] = b1.p[2] & b2.p[2];
	}

	public static final void BBAndOr(bitboard_t b, bitboard_t b1, bitboard_t b2) {
		b.p[0] |= b1.p[0] & b2.p[0];
		b.p[1] |= b1.p[1] & b2.p[1];
		b.p[2] |= b1.p[2] & b2.p[2];
	}

	public static final void BBNot(bitboard_t b, bitboard_t b1) {
		b.p[0] = ~b1.p[0];
		b.p[1] = ~b1.p[1];
		b.p[2] = ~b1.p[2];
	}

	public static final void BBOr(bitboard_t b, bitboard_t b1, bitboard_t b2) {
		b.p[0] = b1.p[0] | b2.p[0];
		b.p[1] = b1.p[1] | b2.p[1];
		b.p[2] = b1.p[2] | b2.p[2];
	}

	public static final void Xor(int sq, bitboard_t b) {
		b.p[0] ^= data.abb_mask[sq].p[0];
		b.p[1] ^= data.abb_mask[sq].p[1];
		b.p[2] ^= data.abb_mask[sq].p[2];
	}

	public static final void BBNotAnd(bitboard_t b, bitboard_t b1, bitboard_t b2) {
		b.p[0] = (b1).p[0] & ~(b2).p[0];
		b.p[1] = (b1).p[1] & ~(b2).p[1];
		b.p[2] = (b1).p[2] & ~(b2).p[2];
	}

	public static final void XorFile(int sq, bitboard_t b) {
		(b).p[0] ^= data.abb_mask_rl90[sq].p[0];

		(b).p[1] ^= data.abb_mask_rl90[sq].p[1];
		(b).p[2] ^= data.abb_mask_rl90[sq].p[2];
	}

	public static final void XorDiag1(int sq, bitboard_t b) {
		(b).p[0] ^= data.abb_mask_rr45[sq].p[0];
		(b).p[1] ^= data.abb_mask_rr45[sq].p[1];
		(b).p[2] ^= data.abb_mask_rr45[sq].p[2];
	}

	public static final void XorDiag2(int sq, bitboard_t b) {
		(b).p[0] ^= data.abb_mask_rl45[sq].p[0];

		(b).p[1] ^= data.abb_mask_rl45[sq].p[1];
		(b).p[2] ^= data.abb_mask_rl45[sq].p[2];
	}

	public static final int BBContract(bitboard_t b1, bitboard_t b2) {
		return (((b1).p[0] & (b2).p[0]) | ((b1).p[1] & (b2).p[1]) | ((b1).p[2] & (b2).p[2]));
	}

	public static final int PopuCount(bitboard_t bb) {
		int cnt = 0;
		int p;
		p = bb.p[0];
		while (p > 0) {
			int b = Integer.highestOneBit(p);
			p ^= b;
			cnt++;
		}
		p = bb.p[1];
		while (p > 0) {
			int b = Integer.highestOneBit(p);
			p ^= b;
			cnt++;
		}
		p = bb.p[2];
		while (p > 0) {
			int b = Integer.highestOneBit(p);
			p ^= b;
			cnt++;
		}
		return cnt;
	}
	
	public static int LimitExtension(int e,int ply){ 
		if ( (e) > 0 && (ply) > 2 * data.iteration_depth ) {
        if ( (ply) < 4 * data.iteration_depth ) {   
            e *= 4 * data.iteration_depth - (ply); 
            e /= 2 * data.iteration_depth; 
          } else { e = 0; } }
		return e;
}
}
