public class attack {
	
	public static bitboard_t attacks_to_piece( tree_t ptree, int sq )
	{
	  bitboard_t bb_ret = new bitboard_t(), bb_attacks = new bitboard_t(), bb = new bitboard_t();

	  bitop.BBIni( bb_ret );
	  if ( sq < def.rank9*def.nfile && ptree.posi.asquare[sq+def.nfile] == def.pawn )
	    {
	      bb_ret = data.abb_mask[sq+def.nfile];
	    }
	  if ( sq >= def.nfile && ptree.posi.asquare[sq-def.nfile] == -def.pawn )
	    {
	      bitop.BBOr( bb_ret, bb_ret, data.abb_mask[sq-def.nfile] );
	    }

	  bitop.BBAndOr( bb_ret, ptree.posi.b_knight, data.abb_w_knight_attacks[sq] );
	  bitop.BBAndOr( bb_ret, ptree.posi.w_knight, data.abb_b_knight_attacks[sq] );
	  bitop.BBAndOr( bb_ret, ptree.posi.b_silver, data.abb_w_silver_attacks[sq] );
	  bitop.BBAndOr( bb_ret, ptree.posi.w_silver, data.abb_b_silver_attacks[sq] );
	  bitop.BBAndOr( bb_ret, ptree.posi.b_tgold,  data.abb_w_gold_attacks[sq] );
	  bitop.BBAndOr( bb_ret, ptree.posi.w_tgold,  data.abb_b_gold_attacks[sq] );

	  bitop.BBOr( bb, ptree.posi.b_hdk, ptree.posi.w_hdk );
	  bitop.BBAndOr( bb_ret, bb, data.abb_king_attacks[sq] );

	  bitop.BBOr( bb, ptree.posi.b_bh, ptree.posi.w_bh );
	  bitop.AttackBishop( bb_attacks, sq , ptree);
	  bitop.BBAndOr( bb_ret, bb, bb_attacks );

	  bitop.BBOr( bb, ptree.posi.b_rd, ptree.posi.w_rd );
	  bitop.BBAndOr( bb_ret, bb, bitop.AttackRank( sq, ptree ) );
	  bitop.BBAndOr( bb, ptree.posi.b_lance, data.abb_plus_rays[sq] );
	  bitop.BBAndOr( bb, ptree.posi.w_lance, data.abb_minus_rays[sq] );
	  bitop.BBAndOr( bb_ret, bb, bitop.AttackFile( sq, ptree ) );
	  
	  return bb_ret;
	}
	
	
	public static bitboard_t b_attacks_to_piece( tree_t ptree, int sq )
	{
	  bitboard_t bb_ret = new bitboard_t(), bb_attacks = new bitboard_t(), bb = new bitboard_t();

	  bitop.BBIni( bb_ret );
	  if ( sq < def.rank9*def.nfile && ptree.posi.asquare[sq+def.nfile] == def.pawn )
	    {
	      bb_ret = data.abb_mask[sq+def.nfile];
	    }

	  bitop.BBAndOr( bb_ret, ptree.posi.b_knight, data.abb_w_knight_attacks[sq] );
	  bitop.BBAndOr( bb_ret, ptree.posi.b_silver, data.abb_w_silver_attacks[sq] );
	  bitop.BBAndOr( bb_ret, ptree.posi.b_tgold,  data.abb_w_gold_attacks[sq] );
	  bitop.BBAndOr( bb_ret, ptree.posi.b_hdk,   data.abb_king_attacks[sq] );

	  bitop.AttackBishop( bb_attacks, sq , ptree);
	  bitop.BBAndOr( bb_ret, ptree.posi.b_bh, bb_attacks );

	  bb = ptree.posi.b_rd;
	  bitop.BBAndOr( bb_ret, bb, bitop.AttackRank(sq, ptree) );
	  bitop.BBAndOr( bb, ptree.posi.b_lance, data.abb_plus_rays[sq] );
	  bitop.BBAndOr( bb_ret, bb, bitop.AttackFile(sq, ptree) );
	  
	  return bb_ret;
	}
	public static bitboard_t w_attacks_to_piece( tree_t ptree, int sq )
	{
	  bitboard_t bb_ret = new bitboard_t(), bb_attacks = new bitboard_t(), bb = new bitboard_t();

	  bitop.BBIni( bb_ret );
	  if ( def.nfile <= sq && ptree.posi.asquare[sq-def.nfile] == -def.pawn )
	    {
	      bb_ret = new bitboard_t(data.abb_mask[sq-def.nfile]);
	    }

	  bitop.BBAndOr( bb_ret, ptree.posi.w_knight, data.abb_b_knight_attacks[sq] );
	  bitop.BBAndOr( bb_ret, ptree.posi.w_silver, data.abb_b_silver_attacks[sq] );
	  bitop.BBAndOr( bb_ret, ptree.posi.w_tgold,  data.abb_b_gold_attacks[sq] );
	  bitop.BBAndOr( bb_ret, ptree.posi.w_hdk,   data.abb_king_attacks[sq] );

	  bitop.AttackBishop( bb_attacks, sq , ptree);
	  bitop.BBAndOr( bb_ret, ptree.posi.w_bh, bb_attacks );

	  bb = ptree.posi.w_rd;
	  bitop.BBAndOr( bb_ret, bb, bitop.AttackRank(sq, ptree) );
	  bitop.BBAndOr( bb, ptree.posi.w_lance, data.abb_minus_rays[sq] );
	  bitop.BBAndOr( bb_ret, bb, bitop.AttackFile(sq, ptree) );
	  
	  return bb_ret;
	}

	
	public static int is_pinned_on_black_king(tree_t ptree, int isquare,
			int idirec) {
		bitboard_t bb_attacks;
		bitboard_t bb_attacker = new bitboard_t();

		if (idirec == def.direc_rank) {
			bb_attacks = new bitboard_t(bitop.AttackRank(isquare, ptree));
			if (bitop.BBContract(bb_attacks,
					data.abb_mask[ptree.posi.isquare_b_king]) > 0) {
				return bitop.BBContract(bb_attacks, ptree.posi.w_rd);
			}

		} else if (idirec == def.direc_file) {
			bb_attacks = new bitboard_t(bitop.AttackFile(isquare, ptree));
			if (bitop.BBContract(bb_attacks,
					data.abb_mask[ptree.posi.isquare_b_king]) > 0) {
				bitop.BBAnd(bb_attacker, ptree.posi.w_lance,
						data.abb_minus_rays[isquare]);
				bitop.BBOr(bb_attacker, bb_attacker, ptree.posi.w_rd);
				return bitop.BBContract(bb_attacks, bb_attacker); /* return! */
			}

		} else if (idirec == def.direc_diag1) {
			bb_attacks = new bitboard_t(bitop.AttackDiag1(isquare, ptree));
			if (bitop.BBContract(bb_attacks,
					data.abb_mask[ptree.posi.isquare_b_king]) > 0) {
				return bitop.BBContract(bb_attacks, ptree.posi.w_bh); /* return! */
			}

		} else {
			assert (idirec == def.direc_diag2);
			bb_attacks = new bitboard_t(bitop.AttackDiag2(isquare, ptree));
			if (bitop.BBContract(bb_attacks,
					data.abb_mask[ptree.posi.isquare_b_king]) > 0) {
				return bitop.BBContract(bb_attacks, ptree.posi.w_bh); /* return! */
			}
		}

		return 0;
	}
	
	public static int is_mate_b_pawn_drop(tree_t ptree, int sq_drop) {
		bitboard_t bb = new bitboard_t(), bb_sum = new bitboard_t(), bb_move = new bitboard_t();
		  int iwk, ito, iret, ifrom, idirec;

		  bitop.BBAnd( bb_sum, ptree.posi.w_knight, data.abb_b_knight_attacks[sq_drop] );

		  bitop.BBAndOr( bb_sum, ptree.posi.w_silver, data.abb_b_silver_attacks[sq_drop] );
		  bitop.BBAndOr( bb_sum, ptree.posi.w_tgold, data.abb_b_gold_attacks[sq_drop] );

		  bitop.AttackBishop( bb, sq_drop , ptree);
		  bitop.BBAndOr( bb_sum, ptree.posi.w_bh, bb );

		  bitop.AttackRook( bb, sq_drop, ptree);
		  bitop.BBAndOr( bb_sum, ptree.posi.w_rd, bb );

		  bitop.BBOr( bb, ptree.posi.w_horse, ptree.posi.w_dragon );
		  bitop.BBAndOr( bb_sum, bb, data.abb_king_attacks[sq_drop] );

		  while ( bitop.BBTest( bb_sum ) )
		    {
		      ifrom  = bitop.FirstOne( bb_sum );
		      bitop.Xor( ifrom, bb_sum );

		      if ( bitop.IsDiscoverWK( ifrom, sq_drop, ptree ) ) { continue; }
		      return 0;
		    }

		  iwk  = ptree.posi.isquare_w_king;
		  iret = 1;
		  bitop.Xor( sq_drop, ptree.posi.b_occupied );
		  bitop.XorFile( sq_drop, ptree.posi.occupied_rl90 );
		  bitop.XorDiag2( sq_drop, ptree.posi.occupied_rl45 );
		  bitop.XorDiag1( sq_drop, ptree.posi.occupied_rr45 );
		  
		  bitop.BBNotAnd( bb_move, data.abb_king_attacks[iwk], ptree.posi.w_occupied );
		  while ( bitop.BBTest( bb_move ) )
		    {
		      ito = bitop.FirstOne( bb_move );
		      if ( ! is_white_attacked( ptree, ito ) )
			{
			  iret = 0;
			  break;
			}
		      bitop.Xor( ito, bb_move );
		    }

		  bitop.Xor( sq_drop, ptree.posi.b_occupied );
		  bitop.XorFile( sq_drop, ptree.posi.occupied_rl90 );
		  bitop.XorDiag2( sq_drop, ptree.posi.occupied_rl45 );
		  bitop.XorDiag1( sq_drop, ptree.posi.occupied_rr45 );

		  return iret;
		
	}

	public static int is_mate_w_pawn_drop(tree_t ptree, int sq_drop) {
		bitboard_t bb = new bitboard_t(), bb_sum = new bitboard_t(), bb_move = new bitboard_t();
		int ibk, ito, ifrom, iret, idirec;

		bitop.BBAnd(bb_sum, ptree.posi.b_knight,
				data.abb_w_knight_attacks[sq_drop]);

		bitop.BBAndOr(bb_sum, ptree.posi.b_silver,
				data.abb_w_silver_attacks[sq_drop]);
		bitop.BBAndOr(bb_sum, ptree.posi.b_tgold,
				data.abb_w_gold_attacks[sq_drop]);

		bitop.AttackBishop(bb, sq_drop, ptree);
		bitop.BBAndOr(bb_sum, ptree.posi.b_bh, bb);

		bitop.AttackRook(bb, sq_drop, ptree);
		bitop.BBAndOr(bb_sum, ptree.posi.b_rd, bb);

		bitop.BBOr(bb, ptree.posi.b_horse, ptree.posi.b_dragon);
		bitop.BBAndOr(bb_sum, bb, data.abb_king_attacks[sq_drop]);

		while (bitop.BBTest(bb_sum)) {
			ifrom = bitop.FirstOne(bb_sum);
			bitop.Xor(ifrom, bb_sum);

			if (bitop.IsDiscoverBK(ifrom, sq_drop, ptree)) {
				continue;
			}
			return 0;
		}

		ibk = ptree.posi.isquare_b_king;
		iret = 1;
		bitop.Xor(sq_drop, ptree.posi.w_occupied);
		bitop.XorFile(sq_drop, ptree.posi.occupied_rl90);
		bitop.XorDiag2(sq_drop, ptree.posi.occupied_rl45);
		bitop.XorDiag1(sq_drop, ptree.posi.occupied_rr45);

		bitop.BBNotAnd(bb_move, data.abb_king_attacks[ibk],
				ptree.posi.b_occupied);
		while (bitop.BBTest(bb_move)) {
			ito = bitop.FirstOne(bb_move);
			if (!(is_black_attacked(ptree, ito))) {
				iret = 0;
				break;
			}
			bitop.Xor(ito, bb_move);
		}

		bitop.Xor(sq_drop, ptree.posi.w_occupied);
		bitop.XorFile(sq_drop, ptree.posi.occupied_rl90);
		bitop.XorDiag2(sq_drop, ptree.posi.occupied_rl45);
		bitop.XorDiag1(sq_drop, ptree.posi.occupied_rr45);

		return iret;
	}

	public static boolean is_black_attacked(tree_t ptree, int sq) {
		bitboard_t bb = new bitboard_t(), bb1 = new bitboard_t(), bb_atk = new bitboard_t();

		bitop.BBAnd(bb, ptree.posi.w_pawn_attacks, data.abb_mask[sq]);
		bitop.BBAndOr(bb, ptree.posi.w_knight, data.abb_b_knight_attacks[sq]);
		bitop.BBAndOr(bb, ptree.posi.w_silver, data.abb_b_silver_attacks[sq]);
		bitop.BBAndOr(bb, ptree.posi.w_tgold, data.abb_b_gold_attacks[sq]);
		bitop.BBAndOr(bb, ptree.posi.w_hdk, data.abb_king_attacks[sq]);

		bitop.AttackBishop(bb_atk, sq, ptree);
		bitop.BBAndOr(bb, ptree.posi.w_bh, bb_atk);

		bb1 = ptree.posi.w_rd;
		bitop.BBAndOr(bb1, ptree.posi.w_lance, data.abb_minus_rays[sq]);
		bitop.BBAndOr(bb, bb1, bitop.AttackFile(sq, ptree));
		bitop.BBAndOr(bb, ptree.posi.w_rd, bitop.AttackRank(sq, ptree));

		return bitop.BBTest(bb);
	}
	
	public static boolean is_white_attacked(tree_t ptree, int sq )
	{
		bitboard_t bb = new bitboard_t(), bb1 = new bitboard_t(), bb_atk = new bitboard_t();

		bitop.BBAnd  ( bb, ptree.posi.b_pawn_attacks, data.abb_mask[sq] );
		bitop.BBAndOr( bb, ptree.posi.b_knight,   data.abb_w_knight_attacks[sq] );
		bitop.BBAndOr( bb, ptree.posi.b_silver,   data.abb_w_silver_attacks[sq] );
		bitop.BBAndOr( bb, ptree.posi.b_tgold,    data.abb_w_gold_attacks[sq] );
		bitop.BBAndOr( bb, ptree.posi.b_hdk,     data.abb_king_attacks[sq] );

		bitop.AttackBishop( bb_atk, sq , ptree);
		bitop.BBAndOr( bb, ptree.posi.b_bh, bb_atk );

	  bb1 = ptree.posi.b_rd;
	  bitop.BBAndOr( bb1, ptree.posi.b_lance, data.abb_plus_rays[sq] );
	  bitop.BBAndOr( bb, bb1, bitop.AttackFile( sq , ptree) );
	  bitop.BBAndOr( bb, ptree.posi.b_rd, bitop.AttackRank( sq , ptree) );

	  return bitop.BBToU(bb) > 0;
	}

	public static int is_pinned_on_white_king(tree_t ptree, int isquare, int idirec) {
		bitboard_t bb_attacks = new bitboard_t(), bb_attacker = new bitboard_t();

		if (idirec == def.direc_rank) {
			bb_attacks = bitop.AttackRank(isquare, ptree);
			if (bitop.BBContract(bb_attacks,
					data.abb_mask[ptree.posi.isquare_w_king]) > 0) {
				return bitop.BBContract(bb_attacks, ptree.posi.b_rd);
			}
		}

		else if (idirec == def.direc_file) {
			bb_attacks = bitop.AttackFile(isquare, ptree);
			if (bitop.BBContract(bb_attacks,
					data.abb_mask[ptree.posi.isquare_w_king]) > 0) {
				bitop.BBAnd(bb_attacker, ptree.posi.b_lance,
						data.abb_plus_rays[isquare]);
				bitop.BBOr(bb_attacker, bb_attacker, ptree.posi.b_rd);
				return bitop.BBContract(bb_attacks, bb_attacker); /* return! */
			}

		} else if (idirec == def.direc_diag1) {
			bb_attacks = bitop.AttackDiag1(isquare, ptree);
			if (bitop.BBContract(bb_attacks,
					data.abb_mask[ptree.posi.isquare_w_king]) > 0) {
				return bitop.BBContract(bb_attacks, ptree.posi.b_bh); /* return! */
			}
		}

		else {
			assert (idirec == def.direc_diag2);
			bb_attacks = bitop.AttackDiag2(isquare, ptree);
			if (bitop.BBContract(bb_attacks,
					data.abb_mask[ptree.posi.isquare_w_king]) > 0) {
				return bitop.BBContract(bb_attacks, ptree.posi.b_bh); /* return! */
			}
		}

		return 0;
	}
	
	public static int is_move_check_b( tree_t ptree, int move )
	{
	  final int from = (int)bitop.I2From(move);
	  final int to   = (int)bitop.I2To(move);
	  int ipiece_move, idirec;
	  bitboard_t bb = new bitboard_t();

	  if ( from >= def.nsquare ) { ipiece_move = bitop.From2Drop(from); }
	  else {
	    ipiece_move = (int)bitop.I2PieceMove(move);
	    if ( bitop.I2IsPromote(move) > 0) { ipiece_move += def.promote; }
	    
	    idirec = (int)data.adirec[ptree.posi.isquare_w_king][from];
	    if ( idirec > 0&& idirec != (int)data.adirec[ptree.posi.isquare_w_king][to]
		 && is_pinned_on_white_king( ptree, from, idirec ) > 0) { return 1; }
	  }
	  
	  switch ( ipiece_move )
	    {
	    case def.pawn:
	      return ptree.posi.asquare[to-def.nfile] == -def.king ? 1 : 0;

	    case def.lance:
	    	bitop.AttackBLance( bb, to , ptree);
	      return bitop.BBContract( bb, data.abb_mask[ptree.posi.isquare_w_king] );
	      
	    case def.knight:
	      return bitop.BBContract( data.abb_b_knight_attacks[to], data.abb_mask[ptree.posi.isquare_w_king] );
	      
	    case def.silver:
	      return bitop.BBContract( data.abb_b_silver_attacks[to], data.abb_mask[ptree.posi.isquare_w_king] );
	      
	    case def.bishop:
	    	bitop.AttackBishop( bb, to ,ptree);
	      return bitop.BBContract( bb, data.abb_mask[ptree.posi.isquare_w_king] );
	      
	    case def.rook:
	    	bitop.AttackRook( bb, to ,ptree);
	      return bitop.BBContract( bb, data.abb_mask[ptree.posi.isquare_w_king] );
	      
	    case def.king:
	      return 0;

	    case def.horse:
	    	bitop.AttackHorse( bb, to ,ptree);
	      return bitop.BBContract( bb, data.abb_mask[ptree.posi.isquare_w_king] );
	      
	    case def.dragon:
	      assert( ipiece_move == def.dragon );
	      bitop.AttackDragon( bb, to , ptree);
	      return bitop.BBContract( bb, data.abb_mask[ptree.posi.isquare_w_king] );
	    }
	  /*
	    case gold:	       case pro_pawn:
	    case pro_lance:    case pro_knight:
	    case pro_silver:
	  */
	  return bitop.BBContract( data.abb_b_gold_attacks[to], data.abb_mask[ptree.posi.isquare_w_king] );
	}


	public static int is_move_check_w( tree_t ptree, int move ){
	  final int from = (int)bitop.I2From(move);
	  final int to   = (int)bitop.I2To(move);
	  int ipiece_move, idirec;
	  bitboard_t bb = new bitboard_t();

	  if ( from >= def.nsquare ) { ipiece_move = bitop.From2Drop(from); }
	  else {
	    ipiece_move = (int)bitop.I2PieceMove(move);
	    if ( bitop.I2IsPromote(move) > 0) { ipiece_move += def.promote; }
	    
	    idirec = (int)data.adirec[ptree.posi.isquare_b_king][from];
	    if ( idirec > 0 && idirec != (int)data.adirec[ptree.posi.isquare_b_king][to]
		 && is_pinned_on_black_king( ptree, from, idirec ) > 0 ) { return 1; }
	  }
	  
	  switch ( ipiece_move )
	    {
	    case def.pawn:
	      return ptree.posi.asquare[to+def.nfile] == def.king ? 1 : 0;
	      
	    case def.lance:
	      bitop.AttackWLance( bb, to , ptree);
	      return bitop.BBContract( bb, data.abb_mask[ptree.posi.isquare_b_king] );
	      
	    case def.knight:
	      return bitop.BBContract( data.abb_w_knight_attacks[to], data.abb_mask[ptree.posi.isquare_b_king] );
	      
	    case def.silver:
	      return bitop.BBContract( data.abb_w_silver_attacks[to], data.abb_mask[ptree.posi.isquare_b_king] );
	      
	    case def.bishop:
	    	bitop.AttackBishop( bb, to , ptree);
	      return bitop.BBContract( bb, data.abb_mask[ptree.posi.isquare_b_king] );
	      
	    case def.rook:
	    	bitop.AttackRook( bb, to , ptree);
	      return bitop.BBContract( bb, data.abb_mask[ptree.posi.isquare_b_king] );

	    case def.king:
	      return 0;

	    case def.horse:
	    	bitop.AttackHorse( bb, to , ptree);
	      return bitop.BBContract( bb, data.abb_mask[ptree.posi.isquare_b_king] );
	      
	    case def.dragon:
	    	bitop.AttackDragon( bb, to , ptree);
	      return bitop.BBContract( bb, data.abb_mask[ptree.posi.isquare_b_king] );
	    }

	  /*
	    case gold:        case pro_pawn:
	    case pro_lance:   case pro_knight:
	    case pro_silver:
	  */
	  return bitop.BBContract( data.abb_w_gold_attacks[to], data.abb_mask[ptree.posi.isquare_b_king] );
	}

}
