( Forth code for showing fractions. )
( by Joel Matthew Rees, winter/spring 2017. )
( Copyright 2017, Joel Matthew Rees )

( Permission granted to use for personal entertainment only. )

( http://joel-rees-economics.blogspot.com/2017/04/soc500-03-09-calculating-skip-years.html )

( Using integer math. )
( Forth expression syntax is mostly postfix. )

( Hopefully, some definitions here will make things more readable. )

: PRCH EMIT ;

: COMMA 44 PRCH ;
: COLON 58 PRCH ;

( No trailing space. )
: PSNUM ( number -- )
  0 .R ;


: NUMERATORS ( count -- )
DUP 1+ 0 DO 
   I PSNUM COLON SPACE
   I 1000 * OVER / PSNUM COMMA ( 1000 times I divided by count )
   SPACE LOOP 
DROP ;

: FRACTIONS ( count -- )
CR
1+ 1 DO
   I PSNUM SPACE I NUMERATORS CR
LOOP ;


