

#include "..\..\..\00_HeaderFiles\02_DerivedClasses\Scenes\CConquestScene.h"

#include "..\..\..\00_HeaderFiles\03_OtherClasses\CAllKeysState.h"
#include "..\..\..\00_HeaderFiles\00_ManagementClasses\CImageManager.h"
#include "..\..\..\00_HeaderFiles\00_ManagementClasses\CSceneManager.h"
#include "..\..\..\00_HeaderFiles\00_ManagementClasses\CMapCellManager.h"
#include "..\..\..\00_HeaderFiles\02_DerivedClasses\CProtagonistCharacter.h"

CConquestScene::CConquestScene( void )
{
	m_eFadeType = EFadeType::NOT_FADE;
	m_iFadeOutInCount = 0;
	
	// 
	// eSituationType = ESituationType::BEGIN;
	eSituationType = ESituationType::ACTION;
	eSwitchType = CMapCellManager::ESwitchType::TOP;
	
	m_pinMapCellManager = new CMapCellManager();
	
	// X}[g|C^͕֗AƂėp
	// |C^炵ʋLqɂȂBƂēnȂϐgpB
	m_pinProtagonistCharacter =
		std::unique_ptr<CProtagonistCharacter>( new CProtagonistCharacter() );
}

CConquestScene::~CConquestScene( void )
{
}

void CConquestScene::Run( CImageManager* arg_pinImageManager,
                          CAllKeysState* arg_pinAllKeysState )
{
	arg_pinImageManager->Draw( 
	                           CMapCellManager::COORDINATES_ORIGIN_X,
	                           CMapCellManager::COORDINATES_ORIGIN_Y,
	                           CImageManager::EImageID::CONQUEST_BACK
	                         );
	
	m_pinMapCellManager->Run( arg_pinImageManager,
	                          arg_pinAllKeysState );
	
	m_pinProtagonistCharacter->Run( arg_pinImageManager,
	                                arg_pinAllKeysState,
	                                m_pinMapCellManager );
	
	bool b;
	b = m_pinProtagonistCharacter->GetRequestSituationExistence();
	
	if ( b )
	{
		ESituationType eSttn;
		eSttn = m_pinProtagonistCharacter->GetRequestSituationType();
		
		switch ( eSttn )
		{
		case ESituationType::SWITCH_MAPCELL_FADE_IN:
			m_eFadeType = EFadeType::FADE_IN;
			m_iFadeOutInCount = 0;

			CMapCellManager::ESwitchType eSwtch;
			eSwtch = m_pinProtagonistCharacter->GetRequestSwitchType();
			
			m_pinMapCellManager->SwitchMapCell( eSwtch );
			break;

		case ESituationType::SWITCH_MAPCELL_FADE_OUT:
			m_eFadeType = EFadeType::FADE_OUT;
			m_iFadeOutInCount = 0;
			break;
		}
		
	}

	switch ( m_eFadeType )
	{
	case EFadeType::FADE_OUT:
		FadeOut( arg_pinImageManager );
		break;

	case EFadeType::FADE_IN:
		FadeIn( arg_pinImageManager );
		break;
	}
	
	
	if ( arg_pinAllKeysState->IsKeyPushed( KEY_INPUT_RETURN ) == 1 )
	{
		m_eRequestScene = CSceneManager::ESceneType::TERMINAL;
	}
}


void CConquestScene::FadeOut( CImageManager* arg_pinImageManager )
{

	arg_pinImageManager->DrawAlpha(
	    180,
	      0,
	    CImageManager::EImageID::FADE,
	    FADE_ALPHA[ m_iFadeOutInCount ] );
	
	m_iFadeOutInCount++;

	if ( FADE_OUT_IN_COUNT_TOTAL == m_iFadeOutInCount )
	{
		m_eFadeType = EFadeType::NOT_FADE;
		m_iFadeOutInCount = 0;
	}
}

void CConquestScene::FadeIn( CImageManager* arg_pinImageManager )
{
	arg_pinImageManager->DrawAlpha(
	    180,
	      0,
	    CImageManager::EImageID::FADE,
	    FADE_ALPHA[ FADE_OUT_IN_COUNT_TOTAL - m_iFadeOutInCount - 1 ] );
	
	m_iFadeOutInCount++;

	if ( FADE_OUT_IN_COUNT_TOTAL == m_iFadeOutInCount )
	{
		m_eFadeType = EFadeType::NOT_FADE;
		m_iFadeOutInCount = 0;
	}
	
}

const int CConquestScene::FADE_ALPHA[ CConquestScene::FADE_OUT_IN_COUNT_TOTAL ] = 
                                    { 0, 92, 163, 214, 245, 255 };
