
#ifndef __CMAPCELLMANAGER_H__
#define __CMAPCELLMANAGER_H__

#include "..\CommonIncludes.h"
#include "..\..\00_HeaderFiles\00_ManagementClasses\CImageManager.h"

//==============================================================
//! @class CMapCellManager
//! @brief }bvZ̊ǗNX
//! 
//! y}bvZzc̃Q[ł́Aʂ̒[܂ōs
//!                 ʂ̃}bvɈړVXeɂȂĂ܂B
//!                 S̃}bvɂAʂŕ\͈͂A
//!                 }bvZƌĂԂƂƂĂ܂B
//! 
//! yObhWzcpixelW}bv`bv̒
//!                   ŴƂ܂B
//!                   
//!                   j
//!                       3A5sځi120, 360jipixelWj
//!                                             i  2,   6jiObhWj
//!                   
//!                   z̗vfƑΉĂ܂AYX̏Ԃ
//!                   w肷邱ƂɒӂKv܂B
//!                   
//!                   j
//!                       vveMapCellData[ 2 ][ 6 ];
//! 
//==============================================================
class CMapCellManager
{
public:
	
	//==============================================================
	//! @enum  EMapObjectType
	//! 
	//!     }bvZɔzû̎ނłB
	//==============================================================
	enum EMapObjectType {
		WALL,          //<! Ns\
		EMPTY,         //<! ȂAړ\
		OUTSIDE_TOP,   //<! ʂ
		OUTSIDE_UNDER, //<! ʂ艺
		
		OTHER,
	};
	
	//==============================================================
	//! @enum  ESwitchType
	//! 
	//!     ړ̃}bvZ̎ނłB
	//==============================================================
	enum ESwitchType {
		TOP,
		UNDER,
	};
	
	const static int MAP_CHIP_LENGTH      =  60;
	
	//! xW0`179̓j[ʂȂ̂ŁA}bvxW180
	const static int BEGIN_COLUMN         = 180;
	
	//! }bv`bv͉8ׂ܂B
	const static int TOTAL_COLUMN         =   8;
	
	//! }bv`bv͏c9sׂ܂B
	const static int TOTAL_ROW            =   9;
	
	//! _OXW
	const static int COORDINATES_ORIGIN_X =   0;
	
	//! _OYW
	const static int COORDINATES_ORIGIN_Y =   0;
	
	CMapCellManager( void );
	~CMapCellManager( void );
	
	//==============================================================
	//! @brief     w肵WɔzuĂ镨̃^Cv擾܂B
	//! 
	//!     CMapCellManagerNX̓}bvZ̔z̒
	//!     ݉ʂɕ\Ă}bvZ̓̃o֐ɖ₢킹܂B
	//!     ł̂ŁAۂ̏ŝCMapCellNXłB
	//!     
	//!     pixelWł͂ȂAz̗vfƂĎgObhW
	//!     ƂēnKv܂B
	//!     
	//!     3Ƒ4ɁAψʍWwł܂B
	//!     
	//!     gpj
	//!         琔67sڂ̏ꏊA
	//!         ̃ObhWɔzuĂ镨̃^Cv
	//!         
	//!         GetMapCellDataByGrid( 6, 5, 0, 1);
	//!     
	//==============================================================
	EMapObjectType GetMapCellDataByGrid( 
	                                     int arg_iBase_X_ByGrid,
	                                     int arg_iBase_Y_ByGrid,
	                                     int arg_iVariation_X_ByGrid,
	                                     int arg_iVariation_Y_ByGrid
	                                   );
	
	//! ݉ʂɕ\Ă}bvZs܂B
	void Run( CImageManager* arg_pinImageManager,
	          CAllKeysState* arg_pinAllKeysState );
	
	void SwitchMapCell( ESwitchType arg_eSwitchType );
	
private:
	const static int MAPCELL_TOTAL = 20;
	const static int MAP_STATUS[ MAPCELL_TOTAL ][ TOTAL_ROW ][ TOTAL_COLUMN ];
	
	//! ݉ʂɕ\Ă}bvZB
	int m_iCurrentMapCell;
	
	std::vector< CMapCell > m_vinMapCell;
	
	//! sNZWObhWɕϊ܂B
	int PixelToMapGrid( int arg_pixel ) const ;
	
};

#endif
