
#include "..\..\00_HeaderFiles\03_OtherClasses\CMapCell.h"
#include "..\..\00_HeaderFiles\00_ManagementClasses\CMapCellManager.h"


CMapCell::CMapCell( const int MAP_STATUS[CMapCellManager::TOTAL_ROW ]
                                        [ CMapCellManager::TOTAL_COLUMN ] )
{
	int tmp[ CMapCellManager::TOTAL_ROW ][ CMapCellManager::TOTAL_COLUMN ];

	for ( int i = 0; i < CMapCellManager::TOTAL_ROW; i++ )
	{
		std::copy( std::begin( MAP_STATUS[ i ] ),
		           std::end(   MAP_STATUS[ i ] ),
		           tmp[ CMapCellManager::TOTAL_ROW - i - 1 ] );
	}

	for ( int i = 0; i < CMapCellManager::TOTAL_ROW; i++ )
	{
		std::vector< CMapCellManager::EMapObjectType > ve;
		for ( int j = 0; j < CMapCellManager::TOTAL_COLUMN; j++ )
		{
			ve.push_back( static_cast< CMapCellManager::EMapObjectType >
			              ( tmp[ i ][ j ] ) );
		}
		vveMapCellData.push_back( ve );
	}
}

CMapCell::~CMapCell( void )
{
}

CMapCellManager::EMapObjectType CMapCell::GetMapCellDataByGrid( 
	                                int arg_iBase_X_ByGrid,
	                                int arg_iBase_Y_ByGrid,
	                                int arg_iVariation_X_ByGrid,
	                                int arg_iVariation_Y_ByGrid
	                               )
{
	
	arg_iBase_X_ByGrid += arg_iVariation_X_ByGrid;
	arg_iBase_Y_ByGrid += arg_iVariation_Y_ByGrid;
	
	if ( ( 3 == arg_iBase_X_ByGrid ) || ( 4 == arg_iBase_X_ByGrid ) )
	{
		if ( arg_iBase_Y_ByGrid == -1 )
		{
			return CMapCellManager::EMapObjectType::OUTSIDE_UNDER;
		}
	
		if ( arg_iBase_Y_ByGrid == CMapCellManager::TOTAL_ROW )
		{
			return CMapCellManager::EMapObjectType::OUTSIDE_TOP;
		}
	}
	
	if ( arg_iBase_X_ByGrid < 0 ||
	     CMapCellManager::TOTAL_COLUMN <= arg_iBase_X_ByGrid )
	{
		return CMapCellManager::EMapObjectType::WALL;
	}

	if ( arg_iBase_Y_ByGrid < 0 ||
	     CMapCellManager::TOTAL_ROW <= arg_iBase_Y_ByGrid )
	{
		return CMapCellManager::EMapObjectType::WALL;
	}

	return vveMapCellData[ arg_iBase_Y_ByGrid ][ arg_iBase_X_ByGrid ];
}

void CMapCell::Run( CImageManager* arg_pinImageManager,
                    CAllKeysState* arg_pinAllKeysState )
{
	for ( int iY = 0; iY < CMapCellManager::TOTAL_ROW; iY++ )
	{
		for ( int jX = 0; jX < CMapCellManager::TOTAL_COLUMN; jX++ )
		{
			Draw( arg_pinImageManager, jX, iY );
		}
	}
	
}

void CMapCell::Draw( CImageManager* arg_pinImageManager,
                     int arg_iX_ByGrid,
                     int arg_iY_ByGrid )
{
	int iX = CMapCellManager::MAP_CHIP_LENGTH * arg_iX_ByGrid;
	int iY = CMapCellManager::MAP_CHIP_LENGTH * arg_iY_ByGrid;
	
	CImageManager::EImageID eImageID;

	iX += CMapCellManager::BEGIN_COLUMN;

	switch( vveMapCellData[ arg_iY_ByGrid  ][ arg_iX_ByGrid  ] )
	{
	case 0:
		eImageID = CImageManager::EImageID::NOT_MOVE_AREA; break;

	case 1:
		eImageID = CImageManager::EImageID::MOVE_AREA; break;
	}

	arg_pinImageManager->Draw( iX, iY, eImageID );

}















