
//==============================================================
//! @file      CProtagonistCharacter.h
//! @brief     CProtagonistCharacterNX̐錾
//==============================================================


// oϐ͂ȂׂȂA
// ̂ƂNXɓƁÃNX3B

#ifndef __CPROTAGONISTCHARACTER_H__
#define __CPROTAGONISTCHARACTER_H__

#include "..\CommonIncludes.h"
#include "..\01_BaseClasses\CCharacterBase.h"
#include "..\02_DerivedClasses\Scenes\CConquestScene.h"


// protagonistiӖFlj
// Draw\bhǂŉ摜\Ƃ
// W180pixelEɓ̂ŒӁB
class CProtagonistCharacter : public CCharacterBase
{
public:
	CProtagonistCharacter( void );
	~CProtagonistCharacter( void );
	void Run( CImageManager*   arg_pinImageManager,
	          CAllKeysState*   arg_pinAllKeysState,
	          CMapCellManager* arg_pinMapCellManager );
	
	bool GetRequestSituationExistence();
	
	CConquestScene::ESituationType GetRequestSituationType();
	
	CMapCellManager::ESwitchType GetRequestSwitchType();
	
private:
	enum EFacingDirection {
		FORWARD,
		BACK,
		LEFT, // č
		RIGHT, // ĉE
	};
	
	enum EStepDirection {
		UP_STEP,
		DOWN_STEP,
		LEFT_STEP,
		RIGHT_STEP,
	};
	
	enum ECommand {
		UP_STEP_COMMAND,
		DOWN_STEP_COMMAND,
		LEFT_STEP_COMMAND,
		RIGHT_STEP_COMMAND,
	};
	
	struct tag_ProtagonistState {
		int iX;
		int iY;
		
		// ObhW
		int iGrid_X;
		int iGrid_Y;
		
		// \W
		int iAdvance_X;
		int iAdvance_Y;
		
		// \WiObhj
		int iAdvanceGrid_X;
		int iAdvanceGrid_Y;
		
		// ݉t[ڂB
		int iCurrentStepFrame;
		
		// ݌Ă
		EFacingDirection eFacingDirection;
		
		// Xebv
		EStepDirection eStepMoveDirection;
		
		
		// Xebvړۂ
		bool bStepMoveIdle;
		
		// i݂ꏊis\GA
		bool bEnableStep;
		
		// s͂邩B
		bool bAdvanceInput;
		
		// XebvAxs͂󂯕tB
		std::queue<ECommand> qeCommand;
	};
	
	//const static int WIDTH  = 60;
	//const static int HEIGHT = 60;
	
	// ʒu
	const static int INITIAL_POSITION_X = 3;
	const static int INITIAL_POSITION_Y = 7;
	
	// l͈xL[ƃXebvړB
	// t[|Ĉړ邩`KvB
	const static int STEPMOVE_CYCLE_FRAME = 6;
	
	const static int STEPMOVE_QUANTITY[ STEPMOVE_CYCLE_FRAME ];
	
	// NtO
	bool m_bGenerate;
	
	// V`G[VύXvtO
	bool m_bRequestSituationExistence;
	
	// V`G[VύXve
	CConquestScene::ESituationType m_eRequestSituationType;
	
	// ړ}bvZǂ̕p̂̂B
	CMapCellManager::ESwitchType m_eRequestSwitchType;
	
	
	void StateInitialize( tag_ProtagonistState* arg_SprotagonistState );
	
	void CheckKeys( tag_ProtagonistState* arg_SprotagonistState,
	                CAllKeysState*        arg_pinAllKeysState );
	
	void SetStepMoveDirection( tag_ProtagonistState* arg_SprotagonistState,
	                           CMapCellManager* arg_pinMapCellManager );
	
	CMapCellManager::EMapObjectType CheckDestination(
	                                    tag_ProtagonistState* arg_SprotagonistState,
	                                    CMapCellManager* arg_pinMapCellManager );
	
	void Calculate( tag_ProtagonistState* arg_SprotagonistState,
	                CMapCellManager* arg_pinMapCellManager );
	
	void Draw( CImageManager* arg_pinImageManager,
	           tag_ProtagonistState* arg_SprotagonistState );
	
};


#endif


