/*
 * Copyright (c) Daisuke OKAJIMA    All rights reserved.
 * 
 * $Id$
 */
// This file is modified by panacoran.
// Copyright (c) 2014 panacoran <panacoran@users.sourceforge.jp>
// This program is part of OmegaChart.
// OmegaChart is licensed under the Apache License, Version 2.0.

using System;
using System.IO;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Diagnostics;
using System.Threading;
using SevenZip;

namespace Zanetti.Forms
{
	/// <summary>
	/// InitializeData ̊Tv̐łB
	/// </summary>
	internal class InitializeData : System.Windows.Forms.Form
	{
		private string _filename;
		private Thread _thread;

		private System.Windows.Forms.Label _messageLabel;
		private System.Windows.Forms.LinkLabel _linkLabel;
		private System.Windows.Forms.Button _okButton;
		private System.Windows.Forms.Button _cancelButton;
		/// <summary>
		/// KvȃfUCiϐłB
		/// </summary>
		private System.ComponentModel.Container components = null;

		public InitializeData()
		{
			//
			// Windows tH[ fUCi T|[gɕKvłB
			//
			InitializeComponent();

			//
			// TODO: InitializeComponent ĂяǒɁARXgN^ R[hǉĂB
			//
		}

		/// <summary>
		/// gpĂ郊\[XɌ㏈s܂B
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows tH[ fUCiŐꂽR[h 
		/// <summary>
		/// fUCi T|[gɕKvȃ\bhłB̃\bh̓e
		/// R[h GfB^ŕύXȂłB
		/// </summary>
		private void InitializeComponent()
		{
			this._messageLabel = new System.Windows.Forms.Label();
			this._linkLabel = new System.Windows.Forms.LinkLabel();
			this._okButton = new System.Windows.Forms.Button();
			this._cancelButton = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// _messageLabel
			// 
			this._messageLabel.Location = new System.Drawing.Point(8, 8);
			this._messageLabel.Name = "_messageLabel";
			this._messageLabel.Size = new System.Drawing.Size(352, 112);
			this._messageLabel.TabIndex = 0;
			// 
			// _linkLabel
			// 
			this._linkLabel.Location = new System.Drawing.Point(8, 128);
			this._linkLabel.Name = "_linkLabel";
			this._linkLabel.Size = new System.Drawing.Size(344, 16);
			this._linkLabel.TabIndex = 1;
			this._linkLabel.TabStop = true;
			this._linkLabel.Text = "f[^̓ɂ";
			this._linkLabel.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			this._linkLabel.LinkClicked += new System.Windows.Forms.LinkLabelLinkClickedEventHandler(this.OnLinkClicked);
			// 
			// _okButton
			// 
			this._okButton.DialogResult = System.Windows.Forms.DialogResult.OK;
			this._okButton.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this._okButton.Location = new System.Drawing.Point(176, 168);
			this._okButton.Name = "_okButton";
			this._okButton.TabIndex = 2;
			this._okButton.Text = "Jn(&S)...";
			this._okButton.Click += new System.EventHandler(this.OnOK);
			// 
			// _cancelButton
			// 
			this._cancelButton.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this._cancelButton.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this._cancelButton.Location = new System.Drawing.Point(264, 168);
			this._cancelButton.Name = "_cancelButton";
			this._cancelButton.TabIndex = 3;
			this._cancelButton.Text = "LZ";
			this._cancelButton.Click += new EventHandler(OnCancel);
			// 
			// InitializeData
			// 
			this.AcceptButton = this._okButton;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 12);
			this.CancelButton = this._cancelButton;
			this.ClientSize = new System.Drawing.Size(362, 198);
			this.ControlBox = false;
			this.Controls.Add(this._cancelButton);
			this.Controls.Add(this._okButton);
			this.Controls.Add(this._linkLabel);
			this.Controls.Add(this._messageLabel);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "InitializeData";
			this.ShowInTaskbar = false;
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
			this.Text = "f[^̏";
			this.ResumeLayout(false);

		}
		#endregion

		protected override void OnLoad(EventArgs e) {
			base.OnLoad(e);
			this._messageLabel.Text = "@f[^͎̏OmegaChartCXg[ɍs܂B\n\n@̑sƁAɎgpf[^Ŋ̃f[^㏑邽߁AVf[^茳ɂꍇł͎Ă܂܂BAKvɉĎc̃f[^_E[hĕ[ĂB\n@܂ȀƂɂ͐Ԓx̎Ԃ܂B\n\n@f[^̓ɂĂ͉L̃NB";
		}
		private void OnLinkClicked(object sender, LinkLabelLinkClickedEventArgs args) {
			Process.Start("http://www.omegachart.org/init_data.html");
		}

		private void OnOK(object sender, EventArgs args) {
			this.DialogResult = DialogResult.None;
			OpenFileDialog dlg = new OpenFileDialog();
			dlg.Title = "f[^t@C̑I";
			dlg.Filter = "File(*.zip)|*.zip|All Files|*";
			dlg.Multiselect = false;
			if(dlg.ShowDialog(this)==DialogResult.OK) {
				_okButton.Enabled = false;
				this.Cursor = Cursors.AppStarting;
				this.Text = String.Format("ǂݍł܂...");
				_filename = dlg.FileName;
				_thread = new Thread(new ThreadStart(StartImport));
				_thread.Start();
			}
		}
		private void OnCancel(object sender, EventArgs args) {
			if(_thread!=null) {
				_thread.Abort();
				_thread = null;
			}
		}

		private delegate void ImportResult();
		private int _importCount;

		private void OnImportSucceeded() {
			this.DialogResult = DialogResult.OK;
			this.Close();
		}
		private void OnImportFailed() {
			this.DialogResult = DialogResult.Cancel;
			this.Close();
		}
		private void OnImportProgress() {
			this.Text = String.Format("ǂݍł܂...  {0}", _importCount);
		}

		private void StartImport() {
            var execdir = Path.GetDirectoryName(Application.ExecutablePath) ?? "";
            SevenZipBase.SetLibraryPath(Path.Combine(execdir, IntPtr.Size == 4 ? "7z.dll" : "7z64.dll"));
			try {
			    using (var extractor = new SevenZipExtractor(_filename))
			    {
			        _importCount = 0;
			        foreach (var e in extractor.ArchiveFileData)
			        {
			            var code = Util.ParseInt(e.FileName.Substring(5));
			            using (var s = File.Create(Util.GetDailyDataFileName(code)))
                            extractor.ExtractFile(e.Index, s);
			            if ((++_importCount % 100) == 0)
			                BeginInvoke(new ImportResult(OnImportProgress));
			        }
                }
				BeginInvoke(new ImportResult(OnImportSucceeded));
			}
			catch(Exception ex) {
				Debug.WriteLine(ex.StackTrace);
				Util.Warning(this, ex.Message);
				this.BeginInvoke(new ImportResult(OnImportFailed));
			}
		}

	}
}
